/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.enums;

import javax.baja.bacnet.BacnetConst;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Context;
import javax.baja.sys.InvalidEnumException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class BBacnetReliability
extends BFrozenEnum
implements BacnetConst {
    public static final int NO_FAULT_DETECTED = 0;
    public static final int NO_SENSOR = 1;
    public static final int OVER_RANGE = 2;
    public static final int UNDER_RANGE = 3;
    public static final int OPEN_LOOP = 4;
    public static final int SHORTED_LOOP = 5;
    public static final int NO_OUTPUT = 6;
    public static final int UNRELIABLE_OTHER = 7;
    public static final int PROCESS_ERROR = 8;
    public static final int MULTI_STATE_FAULT = 9;
    public static final int CONFIGURATION_ERROR = 10;
    public static final int COMMUNICATION_FAILURE = 12;
    public static final int MEMBER_FAULT = 13;
    public static final int MONITORED_OBJECT_FAULT = 14;
    public static final int TRIPPED = 15;
    public static final BBacnetReliability noFaultDetected = new BBacnetReliability(0);
    public static final BBacnetReliability noSensor = new BBacnetReliability(1);
    public static final BBacnetReliability overRange = new BBacnetReliability(2);
    public static final BBacnetReliability underRange = new BBacnetReliability(3);
    public static final BBacnetReliability openLoop = new BBacnetReliability(4);
    public static final BBacnetReliability shortedLoop = new BBacnetReliability(5);
    public static final BBacnetReliability noOutput = new BBacnetReliability(6);
    public static final BBacnetReliability unreliableOther = new BBacnetReliability(7);
    public static final BBacnetReliability processError = new BBacnetReliability(8);
    public static final BBacnetReliability multiStateFault = new BBacnetReliability(9);
    public static final BBacnetReliability configurationError = new BBacnetReliability(10);
    public static final BBacnetReliability communicationFailure = new BBacnetReliability(12);
    public static final BBacnetReliability memberFault = new BBacnetReliability(13);
    public static final BBacnetReliability monitoredObjectFault = new BBacnetReliability(14);
    public static final BBacnetReliability tripped = new BBacnetReliability(15);
    public static final Type TYPE = Sys.loadType(BBacnetReliability.class);
    public static final BBacnetReliability DEFAULT = noFaultDetected;
    public static final int MAX_ASHRAE_ID = 14;
    public static final int MAX_RESERVED_ID = 63;
    public static final int MAX_ID = 65535;

    public Type getType() {
        return TYPE;
    }

    public static BBacnetReliability make(int ordinal) {
        return (BBacnetReliability)noFaultDetected.getRange().get(ordinal, false);
    }

    public static BBacnetReliability make(String tag) {
        return (BBacnetReliability)noFaultDetected.getRange().get(tag);
    }

    private BBacnetReliability(int ordinal) {
        super(ordinal);
    }

    public static String tag(int id) {
        if (DEFAULT.getRange().isOrdinal(id)) {
            return DEFAULT.getRange().getTag(id);
        }
        if (BBacnetReliability.isAshrae(id)) {
            return ASHRAE_PREFIX + id;
        }
        if (BBacnetReliability.isProprietary(id)) {
            return PROPRIETARY_PREFIX + id;
        }
        throw new InvalidEnumException(id);
    }

    public static int ordinal(String tag) {
        try {
            return DEFAULT.getRange().tagToOrdinal(tag);
        }
        catch (InvalidEnumException e) {
            if (tag.startsWith(ASHRAE_PREFIX)) {
                return Integer.parseInt(tag.substring(ASHRAE_PREFIX_LENGTH));
            }
            if (tag.startsWith(PROPRIETARY_PREFIX)) {
                return Integer.parseInt(tag.substring(PROPRIETARY_PREFIX_LENGTH));
            }
            throw e;
        }
    }

    public static boolean isProprietary(int id) {
        return id > 63 && id <= 65535;
    }

    public static boolean isAshrae(int id) {
        return id > 14 && id <= 63;
    }

    public static boolean isValid(int id) {
        return id <= 65535;
    }

    public static boolean isFixed(int id) {
        return id <= 14;
    }

    public String toString(Context context) {
        if (context != null && context.equals(BacnetConst.facetsContext)) {
            return this.getTag();
        }
        return this.getDisplayTag(context);
    }
}

