/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.datatypes.access;

import com.tridium.bacnet.BacUtil;
import java.util.List;
import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.datatypes.access.BBacnetAuthenticationPolicyEntry;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class BBacnetAuthenticationPolicy
extends BComponent
implements BIBacnetDataType {
    public static final Property orderEnforced = BBacnetAuthenticationPolicy.newProperty((int)0, (boolean)false, null);
    public static final Property timeout = BBacnetAuthenticationPolicy.newProperty((int)0, (int)3000, null);
    public static final Type TYPE = Sys.loadType(BBacnetAuthenticationPolicy.class);
    public static final int POLICY_TAG = 0;
    public static final int ORDER_ENFORCED_TAG = 0;
    public static final int TIMEOUT_TAG = 0;
    public static int MAX_ENTRIES = 100;

    public boolean getOrderEnforced() {
        return this.getBoolean(orderEnforced);
    }

    public void setOrderEnforced(boolean v) {
        this.setBoolean(orderEnforced, v, null);
    }

    public long getTimeout() {
        return this.getLong(timeout);
    }

    public void setTimeout(long v) {
        this.setLong(timeout, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BBacnetAuthenticationPolicy() {
    }

    public BBacnetAuthenticationPolicy(List<BBacnetAuthenticationPolicyEntry> policyEntries, boolean orderEnforced, int timeout) {
        int i = 0;
        for (BBacnetAuthenticationPolicyEntry entry : policyEntries) {
            BacUtil.setOrAdd(this, "entry" + i++, (BValue)entry, noWrite);
        }
        this.setOrderEnforced(orderEnforced);
        this.setTimeout(timeout);
    }

    public String toString(Context context) {
        StringBuilder sb = new StringBuilder("BacnetAuthenticationPolicy:");
        sb.append(this.getOrderEnforced()).append(":").append(this.getTimeout());
        return sb.toString();
    }

    @Override
    public void writeAsn(AsnOutput out) {
        out.writeOpeningTag(0);
        SlotCursor sc = this.getProperties();
        int i = 0;
        while (sc.next(BBacnetAuthenticationPolicyEntry.class)) {
            BBacnetAuthenticationPolicyEntry entry = (BBacnetAuthenticationPolicyEntry)sc.get();
            entry.setIndex(i);
            entry.writeAsn(out);
        }
        out.writeClosingTag(0);
        out.writeBoolean(0, this.getOrderEnforced());
        out.writeUnsignedInteger(0, this.getTimeout());
    }

    @Override
    public void readAsn(AsnInput in) throws AsnException {
        in.skipOpeningTag(0);
        int i = 0;
        do {
            BBacnetAuthenticationPolicyEntry entry = new BBacnetAuthenticationPolicyEntry();
            entry.readAsn(in);
            entry.setIndex(i++);
            BacUtil.setOrAdd(this, "entry" + i, (BValue)entry, noWrite);
        } while (!in.isClosingTag(0) && i < MAX_ENTRIES);
        in.skipClosingTag(0);
        this.setBoolean(orderEnforced, in.readBoolean(0), noWrite);
        this.setLong(timeout, in.readUnsignedInteger(0), noWrite);
    }
}

