/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.datatypes;

import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.datatypes.BTrendEvent;
import com.tridium.bacnet.history.BBacnetBooleanTrendRecord;
import com.tridium.bacnet.history.BBacnetEnumTrendRecord;
import com.tridium.bacnet.history.BBacnetNumericTrendRecord;
import com.tridium.bacnet.history.BBacnetStringTrendRecord;
import com.tridium.bacnet.history.BBacnetTrendRecord;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.bacnet.datatypes.BBacnetDateTime;
import javax.baja.bacnet.datatypes.BBacnetNull;
import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.history.BHistoryRecord;
import javax.baja.nre.util.Array;
import javax.baja.status.BStatus;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BFloat;
import javax.baja.sys.BNumber;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

public class BBacnetLogMultipleRecord
extends BComponent
implements BIBacnetDataType {
    public static final Property timestamp = BBacnetLogMultipleRecord.newProperty((int)0, (BValue)new BBacnetDateTime(), null);
    public static final Property statusFlags = BBacnetLogMultipleRecord.newProperty((int)0, (BValue)BBacnetNull.DEFAULT, null);
    public static final Property timeChange = BBacnetLogMultipleRecord.newProperty((int)0, (BValue)BBacnetNull.DEFAULT, null);
    public static final Type TYPE = Sys.loadType(BBacnetLogMultipleRecord.class);
    private BTypeSpec[] recType = null;
    private int logDataChoice;
    private static final Logger loggerBacnetDebug = Logger.getLogger("bacnet.debug");
    private static final Logger loggerBacnet = Logger.getLogger("bacnet");
    public static final int TIMESTAMP_TAG = 0;
    public static final int LOG_DATA_TAG = 1;
    public static final int LOG_STATUS_TAG = 0;
    public static final int LOG_DATA_SEQ_TAG = 1;
    public static final int TIME_CHANGE_TAG = 2;
    public static final int BOOLEAN_VALUE_TAG = 0;
    public static final int REAL_VALUE_TAG = 1;
    public static final int ENUM_VALUE_TAG = 2;
    public static final int UNSIGNED_VALUE_TAG = 3;
    public static final int SIGNED_VALUE_TAG = 4;
    public static final int BITSTRING_VALUE_TAG = 5;
    public static final int NULL_VALUE_TAG = 6;
    public static final int FAILURE_TAG = 7;
    public static final int ANY_VALUE_TAG = 8;

    public BBacnetDateTime getTimestamp() {
        return (BBacnetDateTime)this.get(timestamp);
    }

    public void setTimestamp(BBacnetDateTime v) {
        this.set(timestamp, (BValue)v, null);
    }

    public BSimple getStatusFlags() {
        return (BSimple)this.get(statusFlags);
    }

    public void setStatusFlags(BSimple v) {
        this.set(statusFlags, (BValue)v, null);
    }

    public BSimple getTimeChange() {
        return (BSimple)this.get(timeChange);
    }

    public void setTimeChange(BSimple v) {
        this.set(timeChange, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BBacnetLogMultipleRecord() {
    }

    public BBacnetLogMultipleRecord(AsnInput in) throws AsnException {
        this.readAsn(in);
    }

    @Override
    public void writeAsn(AsnOutput out) {
    }

    @Override
    public void readAsn(AsnInput in) throws AsnException {
        this.recType = null;
        int tag = in.peekTag();
        if (!in.isOpeningTag(0)) {
            throw new AsnException("Invalid tag: " + tag);
        }
        in.skipTag();
        this.getTimestamp().readAsn(in);
        in.skipTag();
        tag = in.peekTag();
        if (in.isOpeningTag(1)) {
            in.skipTag();
            this.logDataChoice = in.peekTag();
            switch (this.logDataChoice) {
                case 0: {
                    this.set(statusFlags, (BValue)BTrendEvent.makeLogStatus(in.readBitString(0)), noWrite);
                    break;
                }
                case 1: {
                    in.skipTag();
                    this.processDataSeq(in);
                    in.skipTag();
                    break;
                }
                case 2: {
                    this.set(timeChange, (BValue)BTrendEvent.makeTimeChange((long)in.readReal(2)), noWrite);
                }
            }
        } else {
            throw new AsnException("Invalid tag: " + tag);
        }
        in.skipTag();
    }

    private void processDataSeq(AsnInput in) throws AsnException {
        Array al = new Array(BTypeSpec.class);
        int n = 0;
        int tag = in.peekTag();
        while (!in.isClosingTag(1)) {
            BTypeSpec ts = null;
            switch (tag) {
                case 0: {
                    this.addData((BSimple)BBoolean.make((boolean)in.readBoolean(0)), n);
                    ts = BTypeSpec.make((String)"bacnet", (String)"BacnetBooleanTrendRecord");
                    break;
                }
                case 1: {
                    this.addData((BSimple)BFloat.make((float)in.readReal(1)), n);
                    ts = BTypeSpec.make((String)"bacnet", (String)"BacnetNumericTrendRecord");
                    break;
                }
                case 2: {
                    this.addData((BSimple)BDynamicEnum.make((int)in.readEnumerated(2)), n);
                    ts = BTypeSpec.make((String)"bacnet", (String)"BacnetEnumTrendRecord");
                    break;
                }
                case 3: {
                    this.addData(in.readUnsigned(3), n);
                    ts = BTypeSpec.make((String)"bacnet", (String)"BacnetNumericTrendRecord");
                    break;
                }
                case 4: {
                    this.addData((BSimple)in.readSigned(4), n);
                    ts = BTypeSpec.make((String)"bacnet", (String)"BacnetNumericTrendRecord");
                    break;
                }
                case 5: {
                    this.addData(in.readBitString(5), n);
                    ts = BTypeSpec.make((String)"bacnet", (String)"BacnetStringTrendRecord");
                    break;
                }
                case 7: {
                    in.skipTag();
                    NErrorType failure = new NErrorType();
                    failure.readEncoded(in);
                    in.skipTag();
                    this.addData(BTrendEvent.makeFailure(failure), n);
                    break;
                }
                case 6: {
                    this.addData(in.readNull(6), n);
                    ts = BTypeSpec.make((String)"bacnet", (String)"BacnetNull");
                    break;
                }
                case 8: {
                    loggerBacnetDebug.info(this + ".readAsn:logDataChoice " + tag + " not yet supported");
                    this.addData(BBacnetNull.DEFAULT, n);
                    ts = BTypeSpec.make((String)"bacnet", (String)"BacnetStringTrendRecord");
                    break;
                }
                default: {
                    loggerBacnet.info("Invalid logDatumChoice!");
                }
            }
            al.add(ts);
            ++n;
            tag = in.peekTag();
        }
        this.recType = (BTypeSpec[])al.trim();
    }

    private void addData(BSimple d, int n) {
        this.add(this.getSeqName(n), (BValue)d, noWrite);
    }

    private String getSeqName(int n) {
        return "data" + n;
    }

    public BTypeSpec getNiagaraRecordType(int n) {
        return this.recType[n];
    }

    public BHistoryRecord initializeNiagaraRecord(BHistoryRecord record, long seqNum, int ndx) {
        BBacnetTrendRecord rec = (BBacnetTrendRecord)record;
        rec.setTimestamp(this.getTimestamp().toBAbsTime());
        rec.setSequenceNumber(seqNum);
        if (!this.isLogData()) {
            if (this.isLogStatus()) {
                rec.setLogEvent((BTrendEvent)this.getStatusFlags());
            } else {
                rec.setLogEvent((BTrendEvent)this.getTimeChange());
            }
            rec.setTrendFlags(rec.getTrendFlags().set(4, true));
            return rec;
        }
        BSimple o = (BSimple)this.get(this.getSeqName(ndx));
        rec.setLogEvent(BTrendEvent.DEFAULT);
        Type t = rec.getType();
        if (t == BBacnetBooleanTrendRecord.TYPE) {
            if (o instanceof BBacnetNull) {
                ((BBacnetBooleanTrendRecord)rec).setValue(false);
                rec.setLogEvent(BTrendEvent.DEFAULT);
                rec.setStatus(BStatus.makeNull((BStatus)rec.getStatus(), (boolean)true));
            } else {
                ((BBacnetBooleanTrendRecord)rec).setValue(((BBoolean)o).getBoolean());
            }
        } else if (t == BBacnetNumericTrendRecord.TYPE) {
            if (o instanceof BBacnetNull) {
                ((BBacnetNumericTrendRecord)rec).setValue(0.0);
                rec.setLogEvent(BTrendEvent.DEFAULT);
                rec.setStatus(BStatus.makeNull((BStatus)rec.getStatus(), (boolean)true));
            } else {
                BSimple ld = o;
                if (ld.getType().is(BBacnetUnsigned.TYPE)) {
                    ((BBacnetNumericTrendRecord)rec).setValue(((BBacnetUnsigned)o).getLong());
                } else {
                    ((BBacnetNumericTrendRecord)rec).setValue(((BNumber)o).getDouble());
                }
            }
        } else if (t == BBacnetEnumTrendRecord.TYPE) {
            if (o instanceof BBacnetNull) {
                ((BBacnetEnumTrendRecord)rec).setValue(BDynamicEnum.make((int)0));
                rec.setLogEvent(BTrendEvent.DEFAULT);
                rec.setStatus(BStatus.makeNull((BStatus)rec.getStatus(), (boolean)true));
            } else {
                ((BBacnetEnumTrendRecord)rec).setValue((BDynamicEnum)o);
            }
        } else if (t == BBacnetStringTrendRecord.TYPE) {
            try {
                if (o instanceof BBacnetNull) {
                    ((BBacnetStringTrendRecord)rec).setValue("");
                    rec.setLogEvent(BTrendEvent.DEFAULT);
                    rec.setStatus(BStatus.makeNull((BStatus)rec.getStatus(), (boolean)true));
                } else {
                    ((BBacnetStringTrendRecord)rec).setValue(o.encodeToString());
                }
            }
            catch (Exception e) {
                loggerBacnet.log(Level.INFO, "Error, could not encode logDatum to a string (" + o.toString() + ")", e);
                ((BBacnetStringTrendRecord)rec).setValue("Error, could not encode " + o.toString());
            }
        }
        return rec;
    }

    public boolean isLogStatus() {
        return this.logDataChoice == 0;
    }

    public boolean isLogData() {
        return this.logDataChoice == 1;
    }

    public int getLogDataChoice() {
        return this.logDataChoice;
    }

    public BTypeSpec[] getTypeSpecs() {
        return this.recType;
    }
}

