/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.datatypes;

import javax.baja.bacnet.datatypes.BBacnetChannelValue;
import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.sys.BComponent;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BBacnetGroupChannelValue
extends BComponent
implements BIBacnetDataType {
    public static final Property channel = BBacnetGroupChannelValue.newProperty((int)0, (int)-1, null);
    public static final Property value = BBacnetGroupChannelValue.newProperty((int)0, (BValue)new BBacnetChannelValue(), null);
    public static final Type TYPE = Sys.loadType(BBacnetGroupChannelValue.class);
    public static final int CHANNEL_TAG = 0;
    public static final int OVERRIDING_PRIORITY_TAG = 1;

    public int getChannel() {
        return this.getInt(channel);
    }

    public void setChannel(int v) {
        this.setInt(channel, v, null);
    }

    public BBacnetChannelValue getValue() {
        return (BBacnetChannelValue)this.get(value);
    }

    public void setValue(BBacnetChannelValue v) {
        this.set(value, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BBacnetGroupChannelValue() {
    }

    public BBacnetGroupChannelValue(int channel, Integer overridingPriority, BBacnetChannelValue value) {
        this.setChannel(channel);
        if (overridingPriority != null) {
            this.setOverridingPriority(overridingPriority);
        }
        this.setValue(value);
    }

    @Override
    public void writeAsn(AsnOutput out) {
        out.writeUnsignedInteger(0, this.getChannel());
        Integer oPri = this.getOverridingPriority();
        if (oPri != null) {
            out.writeUnsignedInteger(1, oPri.intValue());
        }
        this.getValue().writeAsn(out);
    }

    @Override
    public void readAsn(AsnInput in) throws AsnException {
        this.set(channel, (BValue)BLong.make((long)in.readUnsignedInteger(0)), noWrite);
        if (in.peekTag() == 1) {
            this.setOverridingPriority(in.readUnsignedInt(1));
        }
        this.getValue().readAsn(in);
    }

    public Integer getOverridingPriority() {
        BInteger priority = (BInteger)this.get("overridingPriority");
        if (priority != null) {
            return priority.getInt();
        }
        return null;
    }

    public void setOverridingPriority(Integer overridingPriority) {
        this.add("overridingPriority", (BValue)BInteger.make((int)overridingPriority));
    }

    public String toString(Context context) {
        StringBuilder sb = new StringBuilder("Channel: ").append(this.getChannel());
        sb.append("\n\tOverridingPriority: ").append(this.getOverridingPriority());
        return sb.toString();
    }
}

