/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.datatypes;

import javax.baja.bacnet.datatypes.BBacnetArray;
import javax.baja.bacnet.datatypes.BBacnetNull;
import javax.baja.bacnet.datatypes.BBacnetTime;
import javax.baja.bacnet.datatypes.BBacnetTimeValue;
import javax.baja.bacnet.datatypes.BIBacnetDataType;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.bacnet.virtual.BBacnetVirtualProperty;
import javax.baja.bacnet.virtual.BacnetVirtualUtil;
import javax.baja.category.BCategoryMask;
import javax.baja.security.BPermissions;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;

public class BBacnetDailySchedule
extends BComponent
implements BIBacnetDataType {
    public static final Action addTimeValue = BBacnetDailySchedule.newAction((int)0, (BValue)new BBacnetTimeValue(), null);
    public static final Action removeTimeValue = BBacnetDailySchedule.newAction((int)0, (BValue)BString.make((String)""), null);
    public static final Topic dailyScheduleChanged = BBacnetDailySchedule.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BBacnetDailySchedule.class);
    public static final int DAY_SCHEDULE_TAG = 0;

    public void addTimeValue(BBacnetTimeValue tv) {
        this.invoke(addTimeValue, (BValue)tv, null);
    }

    public void removeTimeValue(BString name) {
        this.invoke(removeTimeValue, (BValue)name, null);
    }

    public void fireDailyScheduleChanged(BValue event) {
        this.fire(dailyScheduleChanged, event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final void doAddTimeValue(BBacnetTimeValue tv) {
        this.add(null, (BValue)tv);
    }

    public final void doRemoveTimeValue(BString tvName) {
        Property property = this.getProperty(tvName.getString());
        if (property != null) {
            this.remove(property, null);
        }
    }

    @Override
    public final void writeAsn(AsnOutput out) {
        out.writeOpeningTag(0);
        SlotCursor c = this.getProperties();
        while (c.next(BBacnetTimeValue.class)) {
            ((BBacnetTimeValue)c.get()).writeAsn(out);
        }
        out.writeClosingTag(0);
    }

    @Override
    public final void readAsn(AsnInput in) throws AsnException {
        int tag = in.peekTag();
        if (!in.isOpeningTag(0)) {
            throw new AsnException("Invalid tag: " + tag);
        }
        in.skipTag();
        tag = in.peekTag();
        while (!in.isClosingTag(0)) {
            BSimple v;
            if (tag == -1) {
                throw new AsnException("Invalid tag: " + tag);
            }
            BBacnetTime t = in.readTime();
            int asnType = in.peekApplicationTag();
            switch (asnType) {
                case 0: {
                    v = in.readNull();
                    break;
                }
                case 1: {
                    v = BBoolean.make((boolean)in.readBoolean());
                    break;
                }
                case 2: {
                    v = in.readUnsigned();
                    break;
                }
                case 3: {
                    v = BInteger.make((int)in.readSignedInteger());
                    break;
                }
                case 4: {
                    v = BFloat.make((float)in.readReal());
                    break;
                }
                case 5: {
                    v = BDouble.make((double)in.readDouble());
                    break;
                }
                case 6: {
                    v = in.readBacnetOctetString();
                    break;
                }
                case 7: {
                    v = BString.make((String)in.readCharacterString());
                    break;
                }
                case 8: {
                    v = in.readBitString();
                    break;
                }
                case 9: {
                    v = BDynamicEnum.make((int)in.readEnumerated());
                    break;
                }
                case 10: {
                    v = in.readDate();
                    break;
                }
                case 11: {
                    v = in.readTime();
                    break;
                }
                case 12: {
                    v = in.readObjectIdentifier();
                    break;
                }
                default: {
                    throw new AsnException("Invalid tag: " + tag);
                }
            }
            BBacnetTimeValue tv = this.getTV(t);
            if (tv == null) {
                this.add(null, (BValue)new BBacnetTimeValue(t, v), noWrite);
            } else {
                tv.getValue().setAny((BValue)v, noWrite);
            }
            tag = in.peekTag();
        }
        in.skipTag();
    }

    public String toString(Context cx) {
        if (cx != null && cx instanceof BasicContext) {
            return "BacnetDailySchedule{" + this.getPropertyInParent() + "}";
        }
        this.loadSlots();
        StringBuilder sb = new StringBuilder("{");
        SlotCursor sc = this.getProperties();
        while (sc.next()) {
            sb.append(sc.get()).append(',');
        }
        if (sb.length() == 1) {
            return "{}";
        }
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    public void started() {
        if (!BacnetVirtualUtil.isVirtual(this) && this.getParent() instanceof BBacnetArray) {
            ((BBacnetArray)this.getParent()).linkTo(this, (Slot)dailyScheduleChanged, (Slot)BBacnetArray.arrayPropertyChanged);
        }
    }

    public void added(Property p, Context cx) {
        if (!this.isMounted()) {
            return;
        }
        if (!this.isRunning()) {
            return;
        }
        if (cx != noWrite) {
            this.sort();
            this.getParent().asComponent().changed(this.getPropertyInParent(), cx);
            this.fireDailyScheduleChanged(null);
        }
    }

    public void removed(Property p, BValue v, Context cx) {
        if (!this.isMounted()) {
            return;
        }
        if (!this.isRunning()) {
            return;
        }
        if (cx != noWrite) {
            this.sort();
            this.getParent().asComponent().changed(this.getPropertyInParent(), cx);
            this.fireDailyScheduleChanged(null);
        }
    }

    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isMounted()) {
            return;
        }
        if (!this.isRunning()) {
            return;
        }
        if (cx != noWrite) {
            this.sort();
            this.getParent().asComponent().changed(this.getPropertyInParent(), cx);
            this.fireDailyScheduleChanged(null);
        }
    }

    public final void subscribed() {
        BBacnetVirtualProperty vp = BacnetVirtualUtil.getVirtualProperty(this);
        if (vp != null) {
            vp.childSubscribed(this);
        }
    }

    public final void unsubscribed() {
        BBacnetVirtualProperty vp = BacnetVirtualUtil.getVirtualProperty(this);
        if (vp != null) {
            vp.childUnsubscribed(this);
        }
    }

    public BCategoryMask getAppliedCategoryMask() {
        if (BacnetVirtualUtil.isVirtual(this)) {
            return this.getParent().asComponent().getAppliedCategoryMask();
        }
        return super.getAppliedCategoryMask();
    }

    public BCategoryMask getCategoryMask() {
        if (BacnetVirtualUtil.isVirtual(this)) {
            return this.getParent().asComponent().getCategoryMask();
        }
        return super.getCategoryMask();
    }

    public BPermissions getPermissions(Context cx) {
        if (BacnetVirtualUtil.isVirtual(this)) {
            return this.getParent().asComponent().getPermissions(cx);
        }
        return super.getPermissions(cx);
    }

    public final BSimple getValue(BTime at) {
        BBacnetTimeValue tv = null;
        BBacnetTimeValue tvlast = null;
        SlotCursor c = this.getProperties();
        while (c.next(BBacnetTimeValue.class)) {
            tv = (BBacnetTimeValue)c.get();
            if (!tv.getTime().toBTime().isBefore(at) || tvlast != null && !tv.isAfter(tvlast)) continue;
            tvlast = tv;
        }
        if (tvlast == null) {
            tvlast = tv;
        }
        if (tvlast == null) {
            return BBacnetNull.DEFAULT;
        }
        return tvlast.getValue().getAny();
    }

    private BBacnetTimeValue getTV(BBacnetTime t) {
        SlotCursor c = this.getProperties();
        while (c.next(BBacnetTimeValue.class)) {
            if (!((BBacnetTimeValue)c.get()).getTime().equals((Object)t)) continue;
            return (BBacnetTimeValue)c.get();
        }
        return null;
    }

    private void sort() {
        Property[] tvs = this.getPropertiesArray();
        for (int i = 0; i < tvs.length - 1; ++i) {
            int small = i;
            for (int j = i + 1; j < tvs.length; ++j) {
                BBacnetTimeValue tvsmall;
                BBacnetTimeValue tvj = (BBacnetTimeValue)this.get(tvs[j]);
                if (!tvj.isBefore(tvsmall = (BBacnetTimeValue)this.get(tvs[small]))) continue;
                small = j;
            }
            Property temp = tvs[i];
            tvs[i] = tvs[small];
            tvs[small] = temp;
        }
        this.reorder(tvs, null);
    }

    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        out.startProps();
        out.trTitle((Object)"BacnetDailySchedule", 2);
        out.prop((Object)"virtual", BacnetVirtualUtil.isVirtual(this));
        out.endProps();
    }
}

