/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.config;

import com.tridium.bacnet.asn.AsnUtil;
import javax.baja.bacnet.BBacnetObject;
import javax.baja.bacnet.datatypes.BBacnetArray;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.bacnet.enums.BBacnetEventState;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public abstract class BBacnetMultistate
extends BBacnetObject {
    public static final Property presentValue = BBacnetMultistate.newProperty((int)0, (BValue)BDynamicEnum.make((int)0), (BFacets)BBacnetMultistate.makeFacets(85, 2));
    public static final Property facets = BBacnetMultistate.newProperty((int)1, (BValue)BFacets.DEFAULT, null);
    public static final Property statusFlags = BBacnetMultistate.newProperty((int)1, (BValue)BBacnetBitString.emptyBitString(BacnetBitStringUtil.getBitStringLength("BacnetStatusFlags")), (BFacets)BBacnetMultistate.makeFacets(111, 8, BacnetBitStringUtil.BACNET_STATUS_FLAGS_MAP));
    public static final Property eventState = BBacnetMultistate.newProperty((int)1, (BValue)BDynamicEnum.make((int)0, (BEnumRange)BEnumRange.make((Type)BBacnetEventState.TYPE)), (BFacets)BBacnetMultistate.makeFacets(36, 9));
    public static final Property outOfService = BBacnetMultistate.newProperty((int)0, (boolean)false, (BFacets)BBacnetMultistate.makeFacets(81, 1));
    public static final Property numberOfStates = BBacnetMultistate.newProperty((int)0, (BValue)BBacnetUnsigned.DEFAULT, (BFacets)BBacnetMultistate.makeFacets(74, 2));
    public static final Type TYPE = Sys.loadType(BBacnetMultistate.class);

    public BEnum getPresentValue() {
        return (BEnum)this.get(presentValue);
    }

    public void setPresentValue(BEnum v) {
        this.set(presentValue, (BValue)v, null);
    }

    public BFacets getFacets() {
        return (BFacets)this.get(facets);
    }

    public void setFacets(BFacets v) {
        this.set(facets, (BValue)v, null);
    }

    public BBacnetBitString getStatusFlags() {
        return (BBacnetBitString)this.get(statusFlags);
    }

    public void setStatusFlags(BBacnetBitString v) {
        this.set(statusFlags, (BValue)v, null);
    }

    public BEnum getEventState() {
        return (BEnum)this.get(eventState);
    }

    public void setEventState(BEnum v) {
        this.set(eventState, (BValue)v, null);
    }

    public boolean getOutOfService() {
        return this.getBoolean(outOfService);
    }

    public void setOutOfService(boolean v) {
        this.setBoolean(outOfService, v, null);
    }

    public BBacnetUnsigned getNumberOfStates() {
        return (BBacnetUnsigned)this.get(numberOfStates);
    }

    public void setNumberOfStates(BBacnetUnsigned v) {
        this.set(numberOfStates, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public String toString(Context context) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getObjectId().toString(context)).append(" = " + this.getPresentValue().toString(context));
        return sb.toString();
    }

    @Override
    public BFacets getSlotFacets(Slot slot) {
        if (slot == presentValue) {
            return this.getFacets();
        }
        return super.getSlotFacets(slot);
    }

    @Override
    public void setOutputFacets() {
        BBacnetArray stateText = (BBacnetArray)this.get(BBacnetPropertyIdentifier.stateText.getTag());
        if (stateText != null) {
            int[] ords = new int[stateText.getSize()];
            for (int i = 0; i < ords.length; ++i) {
                ords[i] = i + 1;
            }
            String[] tags = new String[ords.length];
            for (int i = 0; i < tags.length; ++i) {
                tags[i] = SlotPath.escape((String)stateText.getElement(i + 1).toString());
            }
            this.setFacets(BFacets.makeEnum((BEnumRange)BEnumRange.make((int[])ords, (String[])tags)));
        }
    }

    @Override
    public Property getPresentValueProperty() {
        return presentValue;
    }

    @Override
    protected byte[] toEncodedValue(BBacnetObject.BacnetPropertyData d, Property p) {
        if (d.getPropertyId() == 85) {
            return AsnUtil.toAsnUnsigned(((BEnum)this.get(p)).getOrdinal());
        }
        return AsnUtil.toAsn(d.getAsnType(), this.get(p));
    }
}

