/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.config;

import javax.baja.bacnet.BBacnetObject;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetObjectPropertyReference;
import javax.baja.bacnet.datatypes.BBacnetSetpointReference;
import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.bacnet.enums.BBacnetAction;
import javax.baja.bacnet.enums.BBacnetEngineeringUnits;
import javax.baja.bacnet.enums.BBacnetEventState;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BNumber;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.InvalidEnumException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

public class BBacnetLoop
extends BBacnetObject {
    public static final Property objectId = BBacnetLoop.newProperty((int)8, (BValue)BBacnetObjectIdentifier.make(12), (BFacets)BBacnetLoop.makeFacets(75, 12));
    public static final Property objectType = BBacnetLoop.newProperty((int)1, (BValue)BDynamicEnum.make((int)12, (BEnumRange)BEnumRange.make((Type)BBacnetObjectType.TYPE)), (BFacets)BBacnetLoop.makeFacets(79, 9));
    public static final Property presentValue = BBacnetLoop.newProperty((int)0, (int)0, (BFacets)BBacnetLoop.makeFacets(85, 4));
    public static final Property facets = BBacnetLoop.newProperty((int)1, (BValue)BFacets.DEFAULT, null);
    public static final Property statusFlags = BBacnetLoop.newProperty((int)1, (BValue)BBacnetBitString.emptyBitString(BacnetBitStringUtil.getBitStringLength("BacnetStatusFlags")), (BFacets)BBacnetLoop.makeFacets(111, 8, BacnetBitStringUtil.BACNET_STATUS_FLAGS_MAP));
    public static final Property eventState = BBacnetLoop.newProperty((int)1, (BValue)BDynamicEnum.make((int)0, (BEnumRange)BEnumRange.make((Type)BBacnetEventState.TYPE)), (BFacets)BBacnetLoop.makeFacets(36, 9));
    public static final Property outOfService = BBacnetLoop.newProperty((int)0, (boolean)false, (BFacets)BBacnetLoop.makeFacets(81, 1));
    public static final Property outputUnits = BBacnetLoop.newProperty((int)0, (BValue)BDynamicEnum.make((int)95, (BEnumRange)BEnumRange.make((Type)BBacnetEngineeringUnits.TYPE)), (BFacets)BBacnetLoop.makeFacets(82, 9));
    public static final Property manipulatedVariableReference = BBacnetLoop.newProperty((int)0, (BValue)new BBacnetObjectPropertyReference(), (BFacets)BBacnetLoop.makeFacets(60, -1));
    public static final Property controlledVariableReference = BBacnetLoop.newProperty((int)0, (BValue)new BBacnetObjectPropertyReference(), (BFacets)BBacnetLoop.makeFacets(19, -1));
    public static final Property controlledVariableValue = BBacnetLoop.newProperty((int)0, (int)0, (BFacets)BBacnetLoop.makeFacets(21, 4));
    public static final Property controlledVariableUnits = BBacnetLoop.newProperty((int)0, (BValue)BDynamicEnum.make((int)95, (BEnumRange)BEnumRange.make((Type)BBacnetEngineeringUnits.TYPE)), (BFacets)BBacnetLoop.makeFacets(20, 9));
    public static final Property setpointReference = BBacnetLoop.newProperty((int)0, (BValue)new BBacnetSetpointReference(), (BFacets)BBacnetLoop.makeFacets(109, -1));
    public static final Property setpoint = BBacnetLoop.newProperty((int)0, (int)0, (BFacets)BBacnetLoop.makeFacets(108, 4));
    public static final Property action = BBacnetLoop.newProperty((int)0, (BValue)BBacnetAction.direct, (BFacets)BBacnetLoop.makeFacets(2, 9));
    public static final Property priorityForWriting = BBacnetLoop.newProperty((int)0, (BValue)BBacnetUnsigned.make(16L), (BFacets)BBacnetLoop.makeFacets(88, 2));
    public static final Type TYPE = Sys.loadType(BBacnetLoop.class);
    private static final String PROPORTIONAL_CONSTANT = "proportionalConstant";
    private static final String INTEGRAL_CONSTANT = "integralConstant";
    private static final String DERIVATIVE_CONSTANT = "derivativeConstant";
    private static final String PROPORTIONAL_CONSTANT_UNITS = "proportionalConstantUnits";
    private static final String INTEGRAL_CONSTANT_UNITS = "integralConstantUnits";
    private static final String DERIVATIVE_CONSTANT_UNITS = "derivativeConstantUnits";
    private BFacets proportionalFacets;
    private BFacets integralFacets;
    private BFacets derivativeFacets;

    public float getPresentValue() {
        return this.getFloat(presentValue);
    }

    public void setPresentValue(float v) {
        this.setFloat(presentValue, v, null);
    }

    public BFacets getFacets() {
        return (BFacets)this.get(facets);
    }

    public void setFacets(BFacets v) {
        this.set(facets, (BValue)v, null);
    }

    public BBacnetBitString getStatusFlags() {
        return (BBacnetBitString)this.get(statusFlags);
    }

    public void setStatusFlags(BBacnetBitString v) {
        this.set(statusFlags, (BValue)v, null);
    }

    public BEnum getEventState() {
        return (BEnum)this.get(eventState);
    }

    public void setEventState(BEnum v) {
        this.set(eventState, (BValue)v, null);
    }

    public boolean getOutOfService() {
        return this.getBoolean(outOfService);
    }

    public void setOutOfService(boolean v) {
        this.setBoolean(outOfService, v, null);
    }

    public BEnum getOutputUnits() {
        return (BEnum)this.get(outputUnits);
    }

    public void setOutputUnits(BEnum v) {
        this.set(outputUnits, (BValue)v, null);
    }

    public BBacnetObjectPropertyReference getManipulatedVariableReference() {
        return (BBacnetObjectPropertyReference)this.get(manipulatedVariableReference);
    }

    public void setManipulatedVariableReference(BBacnetObjectPropertyReference v) {
        this.set(manipulatedVariableReference, (BValue)v, null);
    }

    public BBacnetObjectPropertyReference getControlledVariableReference() {
        return (BBacnetObjectPropertyReference)this.get(controlledVariableReference);
    }

    public void setControlledVariableReference(BBacnetObjectPropertyReference v) {
        this.set(controlledVariableReference, (BValue)v, null);
    }

    public float getControlledVariableValue() {
        return this.getFloat(controlledVariableValue);
    }

    public void setControlledVariableValue(float v) {
        this.setFloat(controlledVariableValue, v, null);
    }

    public BEnum getControlledVariableUnits() {
        return (BEnum)this.get(controlledVariableUnits);
    }

    public void setControlledVariableUnits(BEnum v) {
        this.set(controlledVariableUnits, (BValue)v, null);
    }

    public BBacnetSetpointReference getSetpointReference() {
        return (BBacnetSetpointReference)this.get(setpointReference);
    }

    public void setSetpointReference(BBacnetSetpointReference v) {
        this.set(setpointReference, (BValue)v, null);
    }

    public float getSetpoint() {
        return this.getFloat(setpoint);
    }

    public void setSetpoint(float v) {
        this.setFloat(setpoint, v, null);
    }

    public BBacnetAction getAction() {
        return (BBacnetAction)this.get(action);
    }

    public void setAction(BBacnetAction v) {
        this.set(action, (BValue)v, null);
    }

    public BBacnetUnsigned getPriorityForWriting() {
        return (BBacnetUnsigned)this.get(priorityForWriting);
    }

    public void setPriorityForWriting(BBacnetUnsigned v) {
        this.set(priorityForWriting, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public String toString(Context context) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getObjectId().toString(context)).append(nameContext.equals(context) ? (char)'_' : ':').append(this.getPresentValue());
        return sb.toString();
    }

    @Override
    public void started() throws Exception {
        super.started();
        this.proportionalFacets = this.getFacetsFromUnits(PROPORTIONAL_CONSTANT_UNITS, 2);
        this.integralFacets = this.getFacetsFromUnits(INTEGRAL_CONSTANT_UNITS, 2);
        this.derivativeFacets = this.getFacetsFromUnits(DERIVATIVE_CONSTANT_UNITS, 2);
    }

    @Override
    public void stopped() throws Exception {
        super.stopped();
        this.proportionalFacets = null;
        this.integralFacets = null;
        this.derivativeFacets = null;
    }

    @Override
    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isRunning()) {
            return;
        }
        if (p.getName().equals(PROPORTIONAL_CONSTANT_UNITS)) {
            this.proportionalFacets = this.getFacetsFromUnits(PROPORTIONAL_CONSTANT_UNITS, 2);
        } else if (p.getName().equals(INTEGRAL_CONSTANT_UNITS)) {
            this.integralFacets = this.getFacetsFromUnits(INTEGRAL_CONSTANT_UNITS, 2);
        } else if (p.getName().equals(DERIVATIVE_CONSTANT_UNITS)) {
            this.derivativeFacets = this.getFacetsFromUnits(DERIVATIVE_CONSTANT_UNITS, 2);
        }
    }

    public void added(Property p, Context cx) {
        super.added(p, cx);
        if (!this.isRunning()) {
            return;
        }
        if (p.getName().equals(PROPORTIONAL_CONSTANT_UNITS)) {
            this.proportionalFacets = this.getFacetsFromUnits(PROPORTIONAL_CONSTANT_UNITS, 2);
        } else if (p.getName().equals(INTEGRAL_CONSTANT_UNITS)) {
            this.integralFacets = this.getFacetsFromUnits(INTEGRAL_CONSTANT_UNITS, 2);
        } else if (p.getName().equals(DERIVATIVE_CONSTANT_UNITS)) {
            this.derivativeFacets = this.getFacetsFromUnits(DERIVATIVE_CONSTANT_UNITS, 2);
        }
    }

    public void removed(Property p, BValue oldValue, Context cx) {
        super.removed(p, oldValue, cx);
        if (!this.isRunning()) {
            return;
        }
        if (p.getName().equals(PROPORTIONAL_CONSTANT_UNITS)) {
            this.proportionalFacets = null;
        } else if (p.getName().equals(INTEGRAL_CONSTANT_UNITS)) {
            this.integralFacets = null;
        } else if (p.getName().equals(DERIVATIVE_CONSTANT_UNITS)) {
            this.derivativeFacets = null;
        }
    }

    @Override
    public BFacets getSlotFacets(Slot s) {
        if (s.equals((Object)presentValue)) {
            return this.getFacets();
        }
        if (s.getName().equals(PROPORTIONAL_CONSTANT)) {
            return this.proportionalFacets != null ? this.proportionalFacets : BFacets.DEFAULT;
        }
        if (s.getName().equals(INTEGRAL_CONSTANT)) {
            return this.integralFacets != null ? this.integralFacets : BFacets.DEFAULT;
        }
        if (s.getName().equals(DERIVATIVE_CONSTANT)) {
            return this.derivativeFacets != null ? this.derivativeFacets : BFacets.DEFAULT;
        }
        return super.getSlotFacets(s);
    }

    @Override
    public void setOutputFacets() {
        BUnit u = null;
        try {
            u = BBacnetEngineeringUnits.make(this.getOutputUnits().getOrdinal()).getNiagaraUnits();
        }
        catch (InvalidEnumException e) {
            log.warning("Can't make BUnits from BacnetEngineeringUnits:" + this.getOutputUnits());
        }
        BFloat minPV = (BFloat)this.get("minimumOutput");
        BFloat maxPV = (BFloat)this.get("maximumOutput");
        if (minPV == null) {
            minPV = BFloat.make((float)Float.NEGATIVE_INFINITY);
        }
        if (maxPV == null) {
            maxPV = BFloat.make((float)Float.POSITIVE_INFINITY);
        }
        if (minPV.getFloat() == -3.4028235E38f) {
            minPV = BFloat.make((float)Float.NEGATIVE_INFINITY);
        }
        if (maxPV.getFloat() == Float.MAX_VALUE) {
            maxPV = BFloat.make((float)Float.POSITIVE_INFINITY);
        }
        BFacets f = BFacets.makeNumeric((BUnit)u, (BNumber)minPV, (BNumber)maxPV);
        this.setFacets(f);
    }

    @Override
    public Property getPresentValueProperty() {
        return presentValue;
    }

    private BFacets getFacetsFromUnits(String units, int precision) {
        BEnum u = (BEnum)this.get(units);
        if (u != null) {
            return BFacets.makeNumeric((BUnit)BBacnetEngineeringUnits.getNiagaraUnits(u.getOrdinal()), (int)precision);
        }
        return null;
    }
}

