/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet.config;

import com.tridium.bacnet.job.BBacnetDiscoverConfigJob;
import com.tridium.driver.util.StringUtil;
import java.util.logging.Logger;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BBacnetObject;
import javax.baja.bacnet.BIBacnetObjectContainer;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.config.BBacnetDeviceObject;
import javax.baja.bacnet.config.BIBacnetConfigFolder;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.driver.BDeviceExt;
import javax.baja.driver.loadable.BDownloadParameters;
import javax.baja.driver.loadable.BILoadable;
import javax.baja.driver.loadable.BUploadParameters;
import javax.baja.driver.loadable.LoadUtil;
import javax.baja.naming.BOrd;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

public class BBacnetConfigDeviceExt
extends BDeviceExt
implements BILoadable,
BacnetConst,
BIBacnetObjectContainer,
BIBacnetConfigFolder {
    public static final Property deviceObject = BBacnetConfigDeviceExt.newProperty((int)0, (BValue)new BBacnetDeviceObject(), null);
    public static final Action upload = BBacnetConfigDeviceExt.newAction((int)16, (BValue)new BUploadParameters(), null);
    public static final Action download = BBacnetConfigDeviceExt.newAction((int)16, (BValue)new BDownloadParameters(), null);
    public static final Action submitConfigDiscoveryJob = BBacnetConfigDeviceExt.newAction((int)4, null);
    public static final Action getConfigTypes = BBacnetConfigDeviceExt.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BBacnetConfigDeviceExt.class);
    private static final BIcon icon = BIcon.make((String)"module://bacnet/com/tridium/bacnet/ui/icons/bacObject.png");
    public static final Logger log = Logger.getLogger("bacnet.client");

    public BBacnetDeviceObject getDeviceObject() {
        return (BBacnetDeviceObject)this.get(deviceObject);
    }

    public void setDeviceObject(BBacnetDeviceObject v) {
        this.set(deviceObject, (BValue)v, null);
    }

    public void upload(BUploadParameters parameters) {
        this.invoke(upload, (BValue)parameters, null);
    }

    public void download(BDownloadParameters parameters) {
        this.invoke(download, (BValue)parameters, null);
    }

    public BOrd submitConfigDiscoveryJob() {
        return (BOrd)this.invoke(submitConfigDiscoveryJob, null, null);
    }

    public BString getConfigTypes() {
        return (BString)this.invoke(getConfigTypes, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BBacnetConfigDeviceExt() {
    }

    public BBacnetConfigDeviceExt(BBacnetObjectIdentifier objectId) {
        this.getDeviceObject().setObjectId(objectId);
    }

    @Override
    public BBacnetConfigDeviceExt getConfig() {
        return this;
    }

    public BBacnetObjectIdentifier getObjectId() {
        return this.getDeviceObject().getObjectId();
    }

    public String toString(Context context) {
        return this.getObjectId().toString(context) + " config";
    }

    public final BBacnetNetwork network() {
        return (BBacnetNetwork)this.getNetwork();
    }

    public final BBacnetDevice device() {
        return (BBacnetDevice)this.getDevice();
    }

    public synchronized BBacnetObject[] getObjectList() {
        BBacnetObject[] temp = new BBacnetObject[this.getSlotCount()];
        int count = 0;
        SlotCursor c = this.getProperties();
        while (c.next(BBacnetObject.class)) {
            BValue kid = c.get();
            temp[count] = (BBacnetObject)kid;
            ++count;
        }
        BBacnetObject[] result = new BBacnetObject[count];
        System.arraycopy(temp, 0, result, 0, count);
        return result;
    }

    public final boolean isParentLegal(BComponent parent) {
        return parent instanceof BBacnetDevice;
    }

    public final boolean isChildLegal(BComponent child) {
        return !(child instanceof BBacnetDeviceObject);
    }

    public BBacnetObject lookupBacnetObject(BBacnetObjectIdentifier objectId) {
        try {
            return (BBacnetObject)this.lookupBacnetObject(objectId, -1, -1, null);
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    @Override
    public BObject lookupBacnetObject(BBacnetObjectIdentifier objectId, int propertyId, int propertyArrayIndex, String domain) {
        SlotCursor c = this.getProperties();
        while (c.next(BBacnetObject.class)) {
            if (!((BBacnetObject)c.get()).getObjectId().equals((Object)objectId)) continue;
            return c.get();
        }
        return null;
    }

    public IFuture post(Action action, BValue arg, Context cx) {
        if (action.equals(upload)) {
            return this.postUpload((BUploadParameters)arg, cx);
        }
        if (action.equals(download)) {
            return this.postDownload((BDownloadParameters)arg, cx);
        }
        return super.post(action, arg, cx);
    }

    protected IFuture postUpload(BUploadParameters params, Context cx) {
        return this.postAsync((Runnable)new Invocation((BComponent)this, upload, (BValue)params, cx));
    }

    protected IFuture postDownload(BDownloadParameters params, Context cx) {
        return this.postAsync((Runnable)new Invocation((BComponent)this, download, (BValue)params, cx));
    }

    public IFuture postAsync(Runnable r) {
        return this.network().postAsync(r);
    }

    public BOrd doSubmitConfigDiscoveryJob(Context cx) {
        if (this.device().isFatalFault()) {
            return null;
        }
        return new BBacnetDiscoverConfigJob(this).submit(cx);
    }

    public BString doGetConfigTypes() {
        TypeInfo[] types = Sys.getRegistry().getConcreteTypes(BBacnetObject.TYPE.getTypeInfo());
        String[] infos = new String[types.length];
        for (int i = 0; i < infos.length; ++i) {
            infos[i] = types[i].toString();
        }
        String list = StringUtil.toString((String[])infos, (String)";");
        return BString.make((String)list);
    }

    public void doUpload(BUploadParameters p, Context cx) throws Exception {
        if (p.getRecursive()) {
            LoadUtil.uploadChildren((BComponent)this, (BUploadParameters)p, (Context)cx);
        } else {
            this.getDeviceObject().doUpload(p, cx);
        }
    }

    public void doDownload(BDownloadParameters p, Context cx) throws Exception {
        if (p.getRecursive()) {
            LoadUtil.downloadChildren((BComponent)this, (BDownloadParameters)p, (Context)cx);
        } else {
            this.getDeviceObject().doDownload(p, cx);
        }
    }

    public BIcon getIcon() {
        return icon;
    }
}

