/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bacnet;

import com.tridium.bacnet.BacUtil;
import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.NBacnetPropertyReference;
import com.tridium.bacnet.asn.NReadAccessResult;
import com.tridium.bacnet.asn.NReadAccessSpec;
import com.tridium.bacnet.asn.NReadPropertyResult;
import com.tridium.bacnet.asn.NWriteAccessSpec;
import com.tridium.bacnet.stack.BBacnetPoll;
import com.tridium.bacnet.stack.BBacnetStack;
import com.tridium.bacnet.stack.client.BBacnetClientLayer;
import com.tridium.bacnet.stack.transport.TransactionException;
import java.io.ByteArrayOutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.config.BBacnetConfigDeviceExt;
import javax.baja.bacnet.config.BBacnetConfigFolder;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.bacnet.datatypes.BBacnetArray;
import javax.baja.bacnet.datatypes.BBacnetListOf;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetObjectPropertyReference;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.enums.BExtensibleEnumList;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.ErrorException;
import javax.baja.bacnet.io.PropertyReference;
import javax.baja.bacnet.util.BIBacnetPollable;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.bacnet.util.PollListEntry;
import javax.baja.bacnet.util.PropertyInfo;
import javax.baja.data.BIDataValue;
import javax.baja.driver.loadable.BDownloadParameters;
import javax.baja.driver.loadable.BLoadable;
import javax.baja.driver.loadable.BUploadParameters;
import javax.baja.driver.util.BIPollable;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.registry.TypeInfo;
import javax.baja.space.BComponentSpace;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

public class BBacnetObject
extends BLoadable
implements BacnetConst,
BIBacnetPollable {
    public static final Action download = BBacnetObject.newAction((int)20, (BValue)new BDownloadParameters(), null);
    public static final Property pollFrequency = BBacnetObject.newProperty((int)0, (BValue)BPollFrequency.normal, null);
    public static final Property status = BBacnetObject.newProperty((int)3, (BValue)BStatus.ok, null);
    public static final Property faultCause = BBacnetObject.newProperty((int)3, (String)"", null);
    public static final Property objectId = BBacnetObject.newProperty((int)8, (BValue)BBacnetObjectIdentifier.DEFAULT, (BFacets)BBacnetObject.makeFacets(75, 12));
    public static final Property objectName = BBacnetObject.newProperty((int)0, (String)"", (BFacets)BBacnetObject.makeFacets(77, 7));
    public static final Property objectType = BBacnetObject.newProperty((int)1, (BValue)BDynamicEnum.make((int)0, (BEnumRange)BEnumRange.make((Type)BBacnetObjectType.TYPE)), (BFacets)BBacnetObject.makeFacets(79, 9));
    public static final Action readBacnetProperty = BBacnetObject.newAction((int)4, (BValue)BDynamicEnum.make((BEnum)BBacnetPropertyIdentifier.presentValue), null);
    public static final Action writeBacnetProperty = BBacnetObject.newAction((int)4, (BValue)BDynamicEnum.make((BEnum)BBacnetPropertyIdentifier.presentValue), null);
    public static final Action uploadRequiredProperties = BBacnetObject.newAction((int)4, null);
    public static final Action uploadOptionalProperties = BBacnetObject.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BBacnetObject.class);
    private static final BIcon icon = BIcon.make((String)"module://bacnet/com/tridium/bacnet/ui/icons/bacObject.png");
    protected static final Lexicon lex = Lexicon.make((String)"bacnet");
    public static final Logger log = Logger.getLogger("bacnet.client");
    public static final Logger plog = Logger.getLogger("bacnet.point");
    private static HashMap<Integer, Array<TypeInfo>> byObjectType = new HashMap();
    private static boolean initialized = false;
    private static final BRelTime WPM_DELAY = BRelTime.make((long)20L);
    private static final Object UPLOAD_LOCK = new Object();
    protected volatile ArrayList<PollListEntry> polledProperties = new ArrayList();
    private BBacnetConfigDeviceExt config;
    private HashMap<BFacets, BacnetPropertyData> propDataMap = new HashMap();
    private HashSet<Property> wpmList = new HashSet();
    private Clock.Ticket wpmTkt = null;
    public static final String PID = "pId";
    public static final String ASN_TYPE = "asn";
    private static final BacnetPropertyData NOT_BACNET_PROPERTY = new BacnetPropertyData(-1, 0);

    public BPollFrequency getPollFrequency() {
        return (BPollFrequency)this.get(pollFrequency);
    }

    public void setPollFrequency(BPollFrequency v) {
        this.set(pollFrequency, (BValue)v, null);
    }

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public BBacnetObjectIdentifier getObjectId() {
        return (BBacnetObjectIdentifier)this.get(objectId);
    }

    public void setObjectId(BBacnetObjectIdentifier v) {
        this.set(objectId, (BValue)v, null);
    }

    public String getObjectName() {
        return this.getString(objectName);
    }

    public void setObjectName(String v) {
        this.setString(objectName, v, null);
    }

    public BEnum getObjectType() {
        return (BEnum)this.get(objectType);
    }

    public void setObjectType(BEnum v) {
        this.set(objectType, (BValue)v, null);
    }

    public BValue readBacnetProperty(BEnum propertyId) {
        return this.invoke(readBacnetProperty, (BValue)propertyId, null);
    }

    public void writeBacnetProperty(BEnum propertyId) {
        this.invoke(writeBacnetProperty, (BValue)propertyId, null);
    }

    public void uploadRequiredProperties() {
        this.invoke(uploadRequiredProperties, null, null);
    }

    public void uploadOptionalProperties() {
        this.invoke(uploadOptionalProperties, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public static BBacnetObject make(BBacnetObjectIdentifier id) {
        Array<TypeInfo> o;
        if (!initialized) {
            BBacnetObject.init();
        }
        if ((o = byObjectType.get(id.getObjectType())) != null && o.size() > 0) {
            TypeInfo element = (TypeInfo)o.get(0);
            BBacnetObject bo = (BBacnetObject)element.getInstance();
            bo.setObjectId(id);
            return bo;
        }
        return new BBacnetObject();
    }

    @Deprecated
    public static TypeInfo getTypeInfo(BBacnetObjectIdentifier id) {
        Array<TypeInfo> a;
        if (!initialized) {
            BBacnetObject.init();
        }
        if ((a = byObjectType.get(id.getObjectType())) != null) {
            return (TypeInfo)a.first();
        }
        return TYPE.getTypeInfo();
    }

    public static TypeInfo[] getTypeInfos(BBacnetObjectIdentifier id) {
        Array<TypeInfo> a;
        if (!initialized) {
            BBacnetObject.init();
        }
        if ((a = byObjectType.get(id.getObjectType())) != null) {
            return (TypeInfo[])a.trim();
        }
        return new TypeInfo[]{TYPE.getTypeInfo()};
    }

    public void started() throws Exception {
        this.checkConfig();
        this.buildPolledProperties();
        BBacnetObject obj = this.config().lookupBacnetObject(this.getObjectId());
        if (obj != null && obj != this) {
            log.severe("Duplicate Bacnet Object ID for config object " + this + " in " + this.device() + "; defaulting objectId!");
            this.setObjectId(BBacnetObjectIdentifier.make(this.getObjectType().getOrdinal()));
        }
    }

    public void stopped() throws Exception {
        try {
            this.network().getPollService(this).unsubscribe((BIPollable)this);
        }
        catch (NotRunningException e) {
            log.warning("BBacnetObject.stopped:NotRunningException unsubscribing from polling on " + this);
        }
        this.polledProperties = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isRunning() || cx == noWrite) {
            return;
        }
        if (p.equals(objectId)) {
            this.removeAll(null);
            this.upload(new BUploadParameters());
            if (this.isSubscribed()) {
                BBacnetPoll pollService = (BBacnetPoll)this.network().getPollService(this);
                pollService.unsubscribe(this);
                this.buildPolledProperties();
                pollService.subscribe(this);
            }
            return;
        }
        if (p.equals(pollFrequency) && this.isSubscribed()) {
            BBacnetPoll pollService = (BBacnetPoll)this.network().getPollService(this);
            pollService.unsubscribe(this);
            pollService.subscribe(this);
        }
        if (cx != noWrite && !Flags.isReadonly((BComplex)this, (Slot)p) && p.getFacets().getFacet(PID) != null) {
            BBacnetDevice device = this.device();
            if (device != null && this.device().isServiceSupported("writePropertyMultiple")) {
                HashSet<Property> hashSet = this.wpmList;
                synchronized (hashSet) {
                    this.wpmList.add(p);
                    if (this.wpmTkt == null) {
                        this.wpmTkt = Clock.schedule((BComponent)this, (BRelTime)WPM_DELAY, (Action)download, (BValue)new BDownloadParameters());
                    }
                }
            } else if (device != null) {
                this.network().getWriteWorker().post(() -> {
                    try {
                        BStatus status = device.getStatus();
                        if (status != null && status.isOk()) {
                            this.writeProperty(p);
                        }
                    }
                    catch (BacnetException e) {
                        log.warning("Unable to write BACnet property " + p + " in " + this + ":" + (Object)((Object)e));
                    }
                });
            }
        }
    }

    public BFacets getSlotFacets(Slot slot) {
        BExtensibleEnumList elist;
        BBacnetDevice dev;
        if (slot.equals((Object)objectId)) {
            BExtensibleEnumList elist2;
            if (!this.isMounted()) {
                return super.getSlotFacets(slot);
            }
            BFacets f = BBacnetObjectType.getObjectIdFacets(this.getObjectType().getOrdinal());
            if (f != null) {
                return f;
            }
            BBacnetDevice dev2 = this.device();
            if (dev2 != null && (elist2 = dev2.getEnumerationList()) != null) {
                return elist2.getObjectTypeFacets();
            }
        }
        if (slot.equals((Object)objectType) && (dev = (BBacnetDevice)this.getDevice()) != null && (elist = dev.getEnumerationList()) != null) {
            return elist.getObjectTypeFacets();
        }
        if (slot.getName().equals(BBacnetPropertyIdentifier.statusFlags.getTag())) {
            return BacnetBitStringUtil.BACNET_STATUS_FLAGS_FACETS;
        }
        if (slot.getName().equals(BBacnetPropertyIdentifier.eventEnable.getTag())) {
            return BacnetBitStringUtil.BACNET_EVENT_TRANSITION_BITS_FACETS;
        }
        if (slot.getName().equals(BBacnetPropertyIdentifier.ackedTransitions.getTag())) {
            return BacnetBitStringUtil.BACNET_EVENT_TRANSITION_BITS_FACETS;
        }
        if (slot.getName().equals(BBacnetPropertyIdentifier.limitEnable.getTag())) {
            return BacnetBitStringUtil.BACNET_LIMIT_ENABLE_FACETS;
        }
        return super.getSlotFacets(slot);
    }

    public void subscribed() {
        if (!this.isRunning()) {
            return;
        }
        ((BBacnetPoll)this.network().getPollService(this)).subscribe(this);
        this.upload(new BUploadParameters(false));
    }

    public void unsubscribed() {
        if (!this.isRunning()) {
            return;
        }
        ((BBacnetPoll)this.network().getPollService(this)).unsubscribe(this);
    }

    public void doUpload(BUploadParameters p, Context cx) {
        BStatus status = this.getStatus();
        if (!this.device().getEnabled() || this.device().getStatus().isDown()) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.device().getName() + " is either disabled or status is down, object upload is unsuccessful.");
            }
            return;
        }
        if (!this.getObjectId().isValid()) {
            return;
        }
        this.setStatus(BStatus.make((int)(status.getBits() | 0x10), (BFacets)BFacets.make((String)"upload", (String)"PENDING")));
        if (!this.device().isServiceSupported("readPropertyMultiple")) {
            this.uploadIndividual(new NReadAccessSpec(this.getObjectId(), this.device().getPossibleProperties(this.getObjectId())));
        } else {
            boolean ok;
            block15: {
                ListIterator it;
                Vector vals;
                Vector<NReadAccessSpec> specs;
                block14: {
                    specs = new Vector<NReadAccessSpec>();
                    specs.add(new NReadAccessSpec(this.getObjectId(), 8));
                    vals = null;
                    ok = false;
                    try {
                        vals = BBacnetObject.client().readPropertyMultiple(this.device().getAddress(), specs);
                        if (vals == null) {
                            return;
                        }
                        it = ((NReadAccessResult)vals.elementAt(0)).getResults();
                        this.updateProperties(it);
                        ok = true;
                    }
                    catch (Exception e) {
                        if (!log.isLoggable(Level.FINE)) break block14;
                        log.fine("Exception uploading " + this + " using rpm(ALL):" + e);
                    }
                }
                if (!ok) {
                    try {
                        specs.clear();
                        specs.add(new NReadAccessSpec(this.getObjectId(), 105));
                        vals = BBacnetObject.client().readPropertyMultiple(this.device().getAddress(), specs);
                        it = ((NReadAccessResult)vals.elementAt(0)).getResults();
                        this.updateProperties(it);
                        specs.clear();
                        specs.add(new NReadAccessSpec(this.getObjectId(), 80));
                        vals = BBacnetObject.client().readPropertyMultiple(this.device().getAddress(), specs);
                        it = ((NReadAccessResult)vals.elementAt(0)).getResults();
                        this.updateProperties(it);
                        ok = true;
                    }
                    catch (Exception e) {
                        if (!log.isLoggable(Level.FINE)) break block15;
                        log.fine("Exception uploading " + this + " using rpm(REQ/OPT):" + e);
                    }
                }
            }
            if (!ok) {
                this.uploadIndividual(new NReadAccessSpec(this.getObjectId(), this.device().getPossibleProperties(this.getObjectId())));
            }
        }
        this.setOutputFacets();
        BComponentSpace space = this.getComponentSpace();
        if (space != null) {
            space.update((BComponent)this, 0);
        }
        this.buildPolledProperties();
        this.setStatus(BStatus.ok);
        if (log.isLoggable(Level.FINEST)) {
            log.finest(this.device().getName() + " object upload execution finish.");
        }
    }

    public void doUploadRequiredProperties() {
        this.uploadProperties(BBacnetPropertyIdentifier.required);
    }

    public void doUploadOptionalProperties() {
        this.uploadProperties(BBacnetPropertyIdentifier.optional);
    }

    private void uploadProperties(final BBacnetPropertyIdentifier propertyId) {
        BBacnetNetwork network = BBacnetNetwork.bacnet();
        if (propertyId == null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(lex.get("object.upload.unknown.error"));
            }
        } else {
            network.getWorker().post(new Runnable(){

                @Override
                public void run() {
                    block2: {
                        try {
                            Vector<NReadAccessSpec> specs = new Vector<NReadAccessSpec>();
                            specs.add(new NReadAccessSpec(BBacnetObject.this.getObjectId(), propertyId.getOrdinal()));
                            Vector vals = BBacnetObject.client().readPropertyMultiple(BBacnetObject.this.device().getAddress(), specs);
                            ListIterator it = ((NReadAccessResult)vals.elementAt(0)).getResults();
                            BBacnetObject.this.updateProperties(it);
                        }
                        catch (BacnetException e) {
                            if (!log.isLoggable(Level.FINE)) break block2;
                            log.log(Level.FINE, lex.getText("object.upload." + propertyId.getTag() + ".error"), (Throwable)((Object)e));
                        }
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDownload(BDownloadParameters p, Context cx) {
        Property[] props = null;
        HashSet<Property> hashSet = this.wpmList;
        synchronized (hashSet) {
            if (this.wpmTkt != null) {
                this.wpmTkt.cancel();
            }
            this.wpmTkt = null;
            props = new Property[this.wpmList.size()];
            this.wpmList.toArray(props);
            this.wpmList.clear();
        }
        boolean wpmOk = false;
        int firstFailPropId = -1;
        if (this.device().isServiceSupported("writePropertyMultiple")) {
            try {
                NWriteAccessSpec was = new NWriteAccessSpec(this.getObjectId());
                for (int i = 0; i < props.length; ++i) {
                    BacnetPropertyData d = this.getPropertyData(props[i]);
                    if (d == NOT_BACNET_PROPERTY || d.propertyId == 75 || d.propertyId == 79) continue;
                    was.addPropertyValue(d.propertyId, AsnUtil.toAsn(this.get(props[i])));
                }
                Vector<NWriteAccessSpec> writeSpecs = new Vector<NWriteAccessSpec>();
                writeSpecs.add(was);
                BBacnetObject.client().writePropertyMultiple(this.device().getAddress(), writeSpecs);
                wpmOk = true;
            }
            catch (ErrorException e) {
                String msg = MessageFormat.format("BACnet Error downloading " + this + ":\nFailed write for {0}:", e.getErrorParameters());
                firstFailPropId = ((BBacnetObjectPropertyReference)e.getErrorParameters()[0]).getPropertyId();
                log.info(msg + (Object)((Object)e));
            }
            catch (BacnetException e) {
                log.log(Level.INFO, "BacnetException downloading " + this + ":" + (Object)((Object)e), (Throwable)((Object)e));
            }
        }
        if (!wpmOk) {
            boolean preFailure = true;
            for (int i = 0; i < props.length; ++i) {
                if (preFailure) {
                    if (firstFailPropId != ((BInteger)props[i].getFacets().getFacet(PID)).getInt()) continue;
                    preFailure = false;
                }
                try {
                    this.writeProperty(props[i]);
                    continue;
                }
                catch (Exception e2) {
                    log.warning("Cannot write property " + props[i] + " in " + this + ":" + e2);
                }
            }
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest(this.device().getName() + " object download execution finish.");
        }
    }

    public BValue doReadBacnetProperty(BEnum propId) throws BacnetException {
        Property prop;
        if (!this.device().isDown() && (prop = this.lookupBacnetProperty(propId.getOrdinal())) != null) {
            this.readProperty(prop);
            return this.get(prop);
        }
        return null;
    }

    public void doWriteBacnetProperty(BEnum propId) throws BacnetException {
        Property prop;
        if (!this.device().isDown() && (prop = this.lookupBacnetProperty(propId.getOrdinal())) != null) {
            this.writeProperty(prop);
        }
    }

    protected final BBacnetNetwork network() {
        return this.config != null ? this.config.network() : null;
    }

    @Override
    public final BBacnetDevice device() {
        if (this.config != null) {
            return this.config.device();
        }
        for (BComplex parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof BBacnetDevice)) continue;
            return (BBacnetDevice)parent;
        }
        return null;
    }

    protected final BBacnetConfigDeviceExt config() {
        return this.config;
    }

    private static final BBacnetClientLayer client() {
        return ((BBacnetStack)BBacnetNetwork.bacnet().getBacnetComm()).getClient();
    }

    public String toString(Context context) {
        return this.getName() + " [" + this.getObjectId().toString(context) + "]";
    }

    public Property getPresentValueProperty() {
        return null;
    }

    protected void setOutputFacets() {
    }

    protected boolean shouldPoll(int propertyId) {
        return true;
    }

    protected byte[] toEncodedValue(BacnetPropertyData d, Property p) {
        return AsnUtil.toAsn(d.getAsnType(), this.get(p));
    }

    public boolean isParentLegal(BComponent parent) {
        if (parent instanceof BBacnetConfigFolder && parent.getParent() instanceof BBacnetConfigFolder) {
            return false;
        }
        return super.isParentLegal(parent);
    }

    public void readProperty(Property prop) throws BacnetException {
        BacnetPropertyData d = this.getPropertyData(prop);
        if (d == NOT_BACNET_PROPERTY || this.device().isDown()) {
            return;
        }
        if (prop.getType() == BBacnetArray.TYPE) {
            this.readArrayProperty(prop, d);
        } else {
            byte[] encodedValue = null;
            encodedValue = BBacnetObject.client().readProperty(this.device().getAddress(), this.getObjectId(), d.getPropertyId());
            this.set(prop, AsnUtil.fromAsn(d.getAsnType(), encodedValue, this.get(prop)), noWrite);
        }
    }

    public void writeProperty(Property prop) throws BacnetException {
        BacnetPropertyData d = this.getPropertyData(prop);
        if (d == NOT_BACNET_PROPERTY) {
            return;
        }
        if (!this.device().isServiceSupported("writeProperty")) {
            throw new UnsupportedOperationException(lex.getText("serviceNotSupported.writeProperty"));
        }
        BBacnetObject.client().writeProperty(this.device().getAddress(), this.getObjectId(), d.getPropertyId(), -1, this.toEncodedValue(d, prop), -1);
    }

    public void writeProperty(Property prop, int arrayIndex, byte[] encodedValue) throws BacnetException {
        BacnetPropertyData d = this.getPropertyData(prop);
        if (d == NOT_BACNET_PROPERTY) {
            return;
        }
        if (!this.device().isServiceSupported("writeProperty")) {
            throw new UnsupportedOperationException(lex.getText("serviceNotSupported.writeProperty"));
        }
        BBacnetObject.client().writeProperty(this.device().getAddress(), this.getObjectId(), d.getPropertyId(), arrayIndex, encodedValue);
    }

    public void addListElement(Property prop, BValue listElement) throws BacnetException {
        BacnetPropertyData d = this.getPropertyData(prop);
        if (d == NOT_BACNET_PROPERTY) {
            return;
        }
        if (!this.get(prop).getType().is(BBacnetListOf.TYPE)) {
            return;
        }
        if (!this.device().isServiceSupported("addListElement")) {
            throw new UnsupportedOperationException(lex.getText("serviceNotSupported.addListElement"));
        }
        byte[] encodedListElement = AsnUtil.toAsn(listElement);
        if (this.getObjectId().getInstanceNumber() != -1) {
            BBacnetObject.client().addListElement(this.device().getAddress(), this.getObjectId(), d.getPropertyId(), -1, encodedListElement);
        }
    }

    public void removeListElement(Property prop, BValue listElement) throws BacnetException {
        BacnetPropertyData d = this.getPropertyData(prop);
        if (d == NOT_BACNET_PROPERTY) {
            return;
        }
        if (!this.get(prop).getType().is(BBacnetListOf.TYPE)) {
            return;
        }
        if (!this.device().isServiceSupported("writeProperty")) {
            throw new UnsupportedOperationException(lex.getText("serviceNotSupported.removeListElement"));
        }
        byte[] encodedListElement = AsnUtil.toAsn(listElement);
        BBacnetObject.client().removeListElement(this.device().getAddress(), this.getObjectId(), d.getPropertyId(), -1, encodedListElement);
    }

    @Override
    public final int getPollableType() {
        return 2;
    }

    @Override
    @Deprecated
    public final boolean poll() {
        log.warning("BBacnetObject.poll() is DEPRECATED!!!");
        return false;
    }

    public final void readOk() {
        this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)false));
        this.setFaultCause("");
    }

    @Override
    public final void readFail(String failureMsg) {
        this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
        this.setFaultCause(failureMsg);
    }

    @Override
    public final void fromEncodedValue(byte[] encodedValue, BStatus status, Context cx) {
        try {
            Property prop = this.lookupBacnetProperty(((PollListEntry)cx).getPropertyId());
            BInteger asnType = (BInteger)prop.getFacets().getFacet(ASN_TYPE);
            BValue v = AsnUtil.fromAsn(asnType.getInt(), encodedValue, this.get(prop));
            BacUtil.set((BComponent)this, prop, v, noWrite);
            this.readOk();
        }
        catch (AsnException e) {
            this.readFail(e.toString());
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Exception decoding value for " + this + " [" + cx + "]:" + ByteArrayUtil.toHexString((byte[])encodedValue), (Throwable)((Object)e));
            }
        }
        catch (Exception e) {
            plog.log(Level.SEVERE, "Exception occurred in fromEncodedValue", e);
        }
    }

    @Override
    public final PollListEntry[] getPollListEntries() {
        return this.polledProperties.toArray(new PollListEntry[0]);
    }

    private void checkConfig() {
        BBacnetConfigDeviceExt config = null;
        for (BComplex parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof BBacnetConfigDeviceExt)) continue;
            config = (BBacnetConfigDeviceExt)parent;
            break;
        }
        this.config = config;
    }

    private void readArrayProperty(Property prop, BacnetPropertyData d) throws BacnetException {
        BBacnetAddress address = this.device().getAddress();
        BBacnetObjectIdentifier objectId = this.getObjectId();
        int propertyId = d.getPropertyId();
        byte[] encodedValue = null;
        try {
            encodedValue = BBacnetObject.client().readProperty(address, objectId, propertyId);
            this.set(prop, AsnUtil.fromAsn(d.getAsnType(), encodedValue, this.get(prop)), noWrite);
        }
        catch (Exception e) {
            ByteArrayOutputStream os;
            boolean readOk;
            int arraySize;
            block12: {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Exception reading property " + prop + " in object " + this + ": " + e + "\n building array in groups...");
                }
                arraySize = AsnUtil.fromAsnInteger(BBacnetObject.client().readProperty(address, objectId, propertyId, 0));
                readOk = false;
                os = new ByteArrayOutputStream();
                int index = 1;
                if (this.device().isServiceSupported("readPropertyMultiple")) {
                    try {
                        BBacnetArray arr = (BBacnetArray)this.get(prop);
                        BTypeSpec arrTypeSpec = arr.getArrayTypeSpec();
                        int elemSize = AsnUtil.getSize(arrTypeSpec);
                        int hdrSize = 9;
                        int elemHdr = 8;
                        int maxAPDUSize = this.device().getMaxAPDULengthAccepted();
                        int myMax = BBacnetNetwork.localDevice().getMaxAPDULengthAccepted();
                        if (maxAPDUSize > myMax) {
                            maxAPDUSize = myMax;
                        }
                        int safetyFactor = 10;
                        int elemsPerRead = (maxAPDUSize - hdrSize - safetyFactor) / (elemSize + elemHdr);
                        do {
                            Vector<NBacnetPropertyReference> refs = new Vector<NBacnetPropertyReference>();
                            for (int i = index; i < index + elemsPerRead && i <= arraySize; ++i) {
                                refs.add(new NBacnetPropertyReference(propertyId, i));
                            }
                            Vector results = BBacnetObject.client().readPropertyMultiple(address, objectId, refs);
                            for (int j = 0; j < results.size(); ++j) {
                                NReadPropertyResult rpr = (NReadPropertyResult)results.get(j);
                                byte[] val = rpr.getPropertyValue();
                                os.write(val, 0, val.length);
                                ++index;
                            }
                        } while (index <= arraySize);
                        readOk = true;
                    }
                    catch (Exception e1) {
                        if (!log.isLoggable(Level.FINE)) break block12;
                        log.fine("Exception reading property " + prop + " in object " + this + " in groups: " + e1 + "\n building array element by element...");
                    }
                }
            }
            if (!readOk) {
                for (int i = index; i <= arraySize; ++i) {
                    byte[] encodedElement = BBacnetObject.client().readProperty(address, objectId, propertyId, i);
                    os.write(encodedElement, 0, encodedElement.length);
                }
            }
            byte[] encodedArray = os.toByteArray();
            this.set(prop, AsnUtil.fromAsn(d.getAsnType(), encodedArray, this.get(prop)), noWrite);
        }
    }

    private boolean readArray(BBacnetArray a, int propId, PropertyInfo pi) {
        try {
            BBacnetAddress address = this.device().getAddress();
            BBacnetObjectIdentifier objectId = this.getObjectId();
            int asize = 0;
            try {
                asize = AsnUtil.fromAsnUnsignedInt(BBacnetObject.client().readProperty(address, objectId, propId, 0));
            }
            catch (Exception e) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Cannot get array size", e);
                }
                return false;
            }
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            int i = 1;
            try {
                for (i = 1; i <= asize; ++i) {
                    byte[] encodedElement = BBacnetObject.client().readProperty(address, objectId, propId, i);
                    os.write(encodedElement, 0, encodedElement.length);
                }
                byte[] encodedArray = os.toByteArray();
                AsnInputStream in = new AsnInputStream(encodedArray);
                a.readAsn(in);
                return true;
            }
            catch (Exception e) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Exception reading array element " + i + ":" + e, e);
                }
                return false;
            }
        }
        catch (Throwable t) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Unable to build BacnetArray for property " + propId, t);
            }
            return false;
        }
    }

    protected void buildPolledProperties() {
        BBacnetPoll pollService = (BBacnetPoll)this.network().getPollService(this);
        if (this.isSubscribed()) {
            pollService.unsubscribe(this);
        }
        SlotCursor sc = this.getProperties();
        BInteger pId = null;
        if (this.polledProperties.size() > 0) {
            this.polledProperties.clear();
        }
        while (sc.next()) {
            Property p = sc.property();
            pId = (BInteger)p.getFacets().getFacet(PID);
            if (pId == null || !this.shouldPoll(pId.getInt())) continue;
            this.polledProperties.add(new PollListEntry(this.getObjectId(), pId.getInt(), this.device(), this));
        }
        if (this.isSubscribed()) {
            pollService.subscribe(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void updateProperties(Iterator it) {
        Object object = UPLOAD_LOCK;
        // MONITORENTER : object
        while (true) {
            if (!it.hasNext()) {
                // MONITOREXIT : object
                if (!log.isLoggable(Level.FINEST)) return;
                log.finest(this.device().getName() + " object updateProperties execution finish.");
                return;
            }
            NReadPropertyResult rpr = (NReadPropertyResult)it.next();
            int propId = rpr.getPropertyId();
            Property prop = this.lookupBacnetProperty(propId);
            try {
                if (prop == null) {
                    if (rpr.isError()) continue;
                    PropertyInfo propInfo = this.getPropertyInfo(propId);
                    BValue value = AsnUtil.asnToValue(propInfo, rpr.getPropertyValue());
                    String name = SlotPath.escape((String)propInfo.getName());
                    prop = this.add(name, value, 0, BBacnetObject.makeFacets(propInfo, value), null);
                    if (this.shouldPoll(propId)) {
                        this.polledProperties.add(new PollListEntry(this.getObjectId(), propId, this.device(), this));
                    }
                    if (this.device().getEnumerationList().getPropertyIdRange().isOrdinal(propId)) continue;
                    this.device().getEnumerationList().addNewPropertyId(propInfo.getName(), propId);
                    continue;
                }
                if (rpr.isError()) {
                    if (!log.isLoggable(Level.FINE)) continue;
                    log.fine("Error uploading property " + prop + ":" + rpr.getPropertyAccessError());
                    continue;
                }
                this.set(prop, AsnUtil.fromAsn(((BInteger)prop.getFacets().getFacet(ASN_TYPE)).getInt(), rpr.getPropertyValue(), this.get(prop)), noWrite);
            }
            catch (AsnException e) {
                log.info("Unable to convert encoded value: prop=" + prop + ", id=" + propId + ", val=" + ByteArrayUtil.toHexString((byte[])rpr.getPropertyValue()) + "\n" + (Object)((Object)e));
            }
            catch (Exception e) {
                log.info("Unable to add/update property: prop=" + prop + ", id=" + propId + ", val=" + ByteArrayUtil.toHexString((byte[])rpr.getPropertyValue()) + "\n" + e);
                if (!log.isLoggable(Level.FINE)) continue;
                log.log(Level.FINE, "Stack Trace: ", e);
                continue;
            }
            break;
        }
    }

    private void uploadIndividual(NReadAccessSpec spec) {
        PropertyReference[] refs = spec.getListOfPropertyReferences();
        for (int i = 0; i < refs.length; ++i) {
            int propId = refs[i].getPropertyId();
            try {
                Property prop = this.lookupBacnetProperty(propId);
                if (prop != null) {
                    this.readProperty(prop);
                    continue;
                }
                byte[] encodedValue = null;
                PropertyInfo propInfo = this.getPropertyInfo(propId);
                String name = SlotPath.escape((String)propInfo.getName());
                try {
                    encodedValue = BBacnetObject.client().readProperty(this.device().getAddress(), this.getObjectId(), propId);
                    BValue value = AsnUtil.asnToValue(propInfo, encodedValue);
                    prop = this.add(name, value, 0, BBacnetObject.makeFacets(propInfo, value), noWrite);
                }
                catch (BacnetException e) {
                    if (e instanceof ErrorException && ((ErrorException)e).getErrorType().getErrorCode() == 32) {
                        if (!log.isLoggable(Level.FINE)) continue;
                        log.fine("Unknown Property " + propId + " in object " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)e));
                        continue;
                    }
                    if (propInfo.isArray()) {
                        BBacnetArray a = new BBacnetArray();
                        a.setArrayTypeSpec(BTypeSpec.make((String)propInfo.getType()));
                        this.readArray(a, propId, propInfo);
                        prop = this.add(name, (BValue)a, 0, BBacnetObject.makeFacets(propInfo, (BValue)a), noWrite);
                    }
                    log.info("BacnetException uploading propertyId " + propId + " in object " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)e));
                }
                if (!this.shouldPoll(propId)) continue;
                this.polledProperties.add(new PollListEntry(this.getObjectId(), propId, this.device(), this));
                continue;
            }
            catch (TransactionException e) {
                if (!log.isLoggable(Level.FINE)) break;
                log.fine("TransactionException uploading object " + (Object)((Object)this.getObjectId()) + " in " + this.device() + ": " + e);
                break;
            }
            catch (Exception e) {
                if (!log.isLoggable(Level.FINE)) continue;
                log.fine("Exception uploading propertyId " + propId + " in object " + (Object)((Object)this.getObjectId()) + ": " + e);
            }
        }
    }

    private PropertyInfo getPropertyInfo(int propId) {
        PropertyInfo propInfo = this.device().getPropertyInfo(this.getObjectId().getObjectType(), propId);
        if (propInfo == null) {
            propInfo = new PropertyInfo(BBacnetPropertyIdentifier.tag(propId), propId, -6);
        }
        return propInfo;
    }

    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        out.startProps();
        out.trTitle((Object)"BacnetObject", 2);
        out.prop((Object)"config", (Object)this.config);
        if (this.polledProperties != null) {
            int siz = this.polledProperties.size();
            out.prop((Object)"polledProperties", siz);
            for (int i = 0; i < siz; ++i) {
                out.prop((Object)("polledProperties[" + i + "]:"), (Object)this.polledProperties.get(i).debugString());
            }
        } else {
            out.prop((Object)"polledProperties", (Object)"NULL");
        }
        out.prop((Object)"propDataMap", this.propDataMap.size());
        for (Map.Entry<BFacets, BacnetPropertyData> entry : this.propDataMap.entrySet()) {
            out.prop((Object)entry.getKey(), (Object)entry.getValue());
        }
        out.endProps();
    }

    private Property lookupBacnetProperty(int propId) {
        SlotCursor c = this.getProperties();
        while (c.next()) {
            try {
                if (propId != ((BInteger)c.property().getFacets().getFacet(PID)).getInt()) continue;
                return c.property();
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public BIcon getIcon() {
        return icon;
    }

    static void init() {
        TypeInfo base = TYPE.getTypeInfo();
        TypeInfo[] types = Sys.getRegistry().getConcreteTypes(base);
        for (int i = 0; i < types.length; ++i) {
            if (types[i].equals(base)) continue;
            BBacnetObject o = (BBacnetObject)types[i].getInstance();
            int objTypOrd = o.getObjectType().getOrdinal();
            Array cur = byObjectType.get(objTypOrd);
            if (cur == null) {
                cur = new Array(TypeInfo.class);
            }
            cur.add((Object)types[i]);
            byObjectType.put(objTypOrd, (Array<TypeInfo>)cur);
        }
        initialized = true;
    }

    protected static BFacets makeFacets(int propertyId, int asnType) {
        HashMap<String, BInteger> map = new HashMap<String, BInteger>();
        map.put(PID, BInteger.make((int)propertyId));
        map.put(ASN_TYPE, BInteger.make((int)asnType));
        return BFacets.make(map);
    }

    protected static BFacets makeFacets(int propertyId, int asnType, Map<String, BIDataValue> m) {
        HashMap<String, BIDataValue> map = new HashMap<String, BIDataValue>(m);
        map.put(PID, (BIDataValue)BInteger.make((int)propertyId));
        map.put(ASN_TYPE, (BIDataValue)BInteger.make((int)asnType));
        return BFacets.make(map);
    }

    protected static BFacets makeFacets(int propertyId, int asnType, String[] keys, BIDataValue[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException();
        }
        String[] k = new String[keys.length + 2];
        System.arraycopy(keys, 0, k, 0, keys.length);
        k[keys.length] = PID;
        k[keys.length + 1] = ASN_TYPE;
        BIDataValue[] v = new BIDataValue[values.length + 2];
        System.arraycopy(values, 0, v, 0, values.length);
        v[values.length] = BInteger.make((int)propertyId);
        v[values.length + 1] = BInteger.make((int)asnType);
        return BFacets.make((String[])k, (BIDataValue[])v);
    }

    protected static BFacets makeFacets(PropertyInfo info, BValue value) {
        HashMap<Object, Object> map = info.isBitString() ? new HashMap<String, BIDataValue>(BacnetBitStringUtil.getBitStringMap(info.getBitStringName())) : new HashMap<String, BInteger>();
        map.put(PID, BInteger.make((int)info.getId()));
        map.put(ASN_TYPE, BInteger.make((int)info.getAsnType()));
        return BFacets.make(map);
    }

    protected BacnetPropertyData getPropertyData(Property prop) {
        BacnetPropertyData d;
        BFacets f = prop.getFacets();
        if (f == null) {
            return NOT_BACNET_PROPERTY;
        }
        if (f.geti(PID, -1) == -1) {
            return NOT_BACNET_PROPERTY;
        }
        if (!prop.isDynamic() && (d = this.propDataMap.get(f)) == null) {
            d = BBacnetObject.makePropertyData(f);
            this.propDataMap.put(f, d);
            return d;
        }
        return BBacnetObject.makePropertyData(f);
    }

    private static BacnetPropertyData makePropertyData(BFacets f) {
        int propertyId = -1;
        int asnType = 0;
        BObject s = f.getFacet(PID);
        if (s != null) {
            propertyId = ((BInteger)s).getInt();
        }
        if ((s = f.getFacet(ASN_TYPE)) != null) {
            asnType = ((BInteger)s).getInt();
        }
        return BacnetPropertyData.make(propertyId, asnType);
    }

    public static class BacnetPropertyData {
        int propertyId;
        int asnType;

        private BacnetPropertyData(int propertyId, int asnType) {
            this.propertyId = propertyId;
            this.asnType = asnType;
        }

        static BacnetPropertyData make(int pid, int asn) {
            if (pid == -1 && asn == 0) {
                return NOT_BACNET_PROPERTY;
            }
            return new BacnetPropertyData(pid, asn);
        }

        public int getPropertyId() {
            return this.propertyId;
        }

        public int getAsnType() {
            return this.asnType;
        }
    }
}

