/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.server.cov;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.bacnet.export.Cov;
import javax.baja.nre.util.IntHashMap;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.ICoalesceable;
import javax.baja.util.Queue;
import javax.baja.util.QueueFullException;

public class BBacnetCovWorker
extends BComponent {
    public static final Property maxQueueSize = BBacnetCovWorker.newProperty((int)0, (int)1000, null);
    public static final Property workerThreadName = BBacnetCovWorker.newProperty((int)3, (String)"", null);
    public static final Property numberOfThreads = BBacnetCovWorker.newProperty((int)0, (int)2, null);
    public static final Action removeStaleQueues = BBacnetCovWorker.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BBacnetCovWorker.class);
    private Clock.Ticket cleanupTimer = null;
    private static final int DEVICE_STALE_TIME_TICKS = 3600000;
    private IntHashMap deviceQueueMap = new IntHashMap();
    private List<WorkerThread> threadPool = new ArrayList<WorkerThread>(this.getNumberOfThreads());
    private static Logger logger = Logger.getLogger("bacnet.cov");

    public int getMaxQueueSize() {
        return this.getInt(maxQueueSize);
    }

    public void setMaxQueueSize(int v) {
        this.setInt(maxQueueSize, v, null);
    }

    public String getWorkerThreadName() {
        return this.getString(workerThreadName);
    }

    public void setWorkerThreadName(String v) {
        this.setString(workerThreadName, v, null);
    }

    public int getNumberOfThreads() {
        return this.getInt(numberOfThreads);
    }

    public void setNumberOfThreads(int v) {
        this.setInt(numberOfThreads, v, null);
    }

    public void removeStaleQueues() {
        this.invoke(removeStaleQueues, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        this.startThreads();
    }

    public void stopped() {
        this.stopThreads();
    }

    public void atSteadyState() {
        if (this.cleanupTimer == null) {
            this.cleanupTimer = Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.make((long)3600000L), (Action)removeStaleQueues, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (p == numberOfThreads) {
            if (this.isRunning()) {
                logger.fine("Restarting COV Worker threads.");
                this.stopThreads();
                this.startThreads();
            }
        } else if (p == maxQueueSize && this.isRunning()) {
            IntHashMap intHashMap = this.deviceQueueMap;
            synchronized (intHashMap) {
                IntHashMap.Iterator deviceQueue = this.deviceQueueMap.iterator();
                while (deviceQueue.hasNext()) {
                    LockableQueue oldQueue = (LockableQueue)((Object)deviceQueue.next());
                    LockableQueue newQueue = new LockableQueue(this.getMaxQueueSize());
                    Object[] oldQueueItems = oldQueue.toArray();
                    for (int i = 0; i < oldQueueItems.length; ++i) {
                        newQueue.enqueue(oldQueueItems[i]);
                    }
                    this.deviceQueueMap.put(deviceQueue.key(), (Object)newQueue);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopThreads() {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Stopping COV threads:\t" + this.threadPool.size());
        }
        List<WorkerThread> list = this.threadPool;
        synchronized (list) {
            for (int i = 0; i < this.threadPool.size(); ++i) {
                WorkerThread wt = this.threadPool.get(i);
                wt.kill();
                wt.interrupt();
            }
            this.threadPool.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startThreads() {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Starting COV threads:\t" + this.getNumberOfThreads() + "\t" + this.getMaxQueueSize());
        }
        List<WorkerThread> list = this.threadPool;
        synchronized (list) {
            int threads = this.getNumberOfThreads();
            for (int i = 0; i < threads; ++i) {
                String name = this.getWorkerThreadName();
                if (name.equalsIgnoreCase("")) {
                    name = this.getParent().getName() + ":CovWorker";
                }
                WorkerThread wt = new WorkerThread(name, i);
                this.threadPool.add(wt);
                wt.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRemoveStaleQueues() {
        IntHashMap intHashMap = this.deviceQueueMap;
        synchronized (intHashMap) {
            IntHashMap.Iterator deviceQueue = this.deviceQueueMap.iterator();
            ArrayList<Integer> toRemove = new ArrayList<Integer>();
            while (deviceQueue.hasNext()) {
                LockableQueue queue = (LockableQueue)((Object)deviceQueue.next());
                if (!queue.isStale()) continue;
                toRemove.add(new Integer(deviceQueue.key()));
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Removing stale queues:\t" + toRemove.size());
            }
            for (int i = 0; i < toRemove.size(); ++i) {
                int remove = (Integer)toRemove.get(i);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Remaining queuemap:\t" + remove + "\t" + this.deviceQueueMap.size());
                }
                this.deviceQueueMap.remove(remove);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendCov(Cov cov) {
        BBacnetAddress address = cov.getSub().getRecipient().getRecipient().getAddress();
        LockableQueue queue = null;
        IntHashMap intHashMap = this.deviceQueueMap;
        synchronized (intHashMap) {
            queue = (LockableQueue)((Object)this.deviceQueueMap.get(address.hash()));
            if (queue == null) {
                queue = new LockableQueue(this.getMaxQueueSize());
                this.deviceQueueMap.put(address.hash(), (Object)queue);
            }
        }
        if (queue != null) {
            boolean queued = false;
            LockableQueue lockableQueue = queue;
            synchronized (lockableQueue) {
                block14: {
                    try {
                        queued = queue.enqueue(cov);
                    }
                    catch (QueueFullException qfe) {
                        ICoalesceable existingCov = (ICoalesceable)queue.find(cov);
                        if (existingCov == null) break block14;
                        existingCov.coalesce((ICoalesceable)cov);
                        queued = true;
                    }
                }
            }
            lockableQueue = this.deviceQueueMap;
            synchronized (lockableQueue) {
                this.deviceQueueMap.notify();
            }
            if (!queued) {
                logger.severe("Device COV queue full:\t" + address);
            }
        }
    }

    static class LockableQueue
    extends Queue {
        private long lastAdded;
        private Boolean done = Boolean.TRUE;
        private Object lock = new Object();

        public LockableQueue(int capacity) {
            super(capacity);
            this.lastAdded = Clock.ticks();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean tryLock() {
            Object object = this.lock;
            synchronized (object) {
                if (this.done.booleanValue()) {
                    this.done = Boolean.FALSE;
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unlock() {
            Object object = this.lock;
            synchronized (object) {
                this.done = Boolean.TRUE;
            }
        }

        public boolean enqueue(Object o) {
            this.lastAdded = Clock.ticks();
            return super.enqueue(o);
        }

        public boolean isStale() {
            return this.isEmpty() && Clock.ticks() - this.lastAdded > 3600000L;
        }
    }

    private class WorkerThread
    extends Thread {
        private boolean alive;

        public WorkerThread(String name, int threadId) {
            super(name + threadId);
            this.alive = true;
            this.setDaemon(true);
        }

        public void kill() {
            this.alive = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.alive) {
                LockableQueue device = null;
                try {
                    Object r;
                    device = this.getNextDevice();
                    if (device != null) {
                        r = null;
                        do {
                            LockableQueue lockableQueue = device;
                            synchronized (lockableQueue) {
                                r = (Runnable)device.dequeue(100);
                            }
                            try {
                                if (r == null) continue;
                                r.run();
                            }
                            catch (Exception e) {
                                logger.log(Level.SEVERE, "Exception occurred in WorkerThread runnable", e);
                            }
                        } while (r != null);
                        continue;
                    }
                    r = BBacnetCovWorker.this.deviceQueueMap;
                    synchronized (r) {
                        BBacnetCovWorker.this.deviceQueueMap.wait();
                    }
                }
                catch (InterruptedException ie) {
                    break;
                }
                catch (Exception e) {
                    logger.severe("Exception sending notification:" + e.getMessage());
                }
                finally {
                    if (device == null) continue;
                    device.unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LockableQueue getNextDevice() throws InterruptedException {
            LockableQueue queue2 = null;
            IntHashMap intHashMap = BBacnetCovWorker.this.deviceQueueMap;
            synchronized (intHashMap) {
                if (BBacnetCovWorker.this.deviceQueueMap.isEmpty()) {
                    return null;
                }
                for (LockableQueue queue2 : BBacnetCovWorker.this.deviceQueueMap) {
                    if (queue2.isEmpty() || !queue2.tryLock()) continue;
                    return queue2;
                }
            }
            return null;
        }
    }
}

