/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.server;

import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.services.BacnetReject;
import com.tridium.bacnet.services.BacnetServicePrimitive;
import com.tridium.bacnet.services.confirmed.AtomicReadFileAck;
import com.tridium.bacnet.services.confirmed.AtomicReadFileRequest;
import com.tridium.bacnet.services.confirmed.AtomicWriteFileAck;
import com.tridium.bacnet.services.confirmed.AtomicWriteFileRequest;
import com.tridium.bacnet.services.error.SimpleError;
import com.tridium.bacnet.stack.server.BBacnetServerLayer;
import com.tridium.bacnet.stack.server.ServiceHandler;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetConfirmedServiceChoice;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetBackupState;
import javax.baja.bacnet.export.BBacnetFileDescriptor;
import javax.baja.bacnet.export.BLocalBacnetDevice;

public class FileHandler
implements ServiceHandler,
BacnetConfirmedServiceChoice {
    private static final Logger logger = Logger.getLogger("bacnet.server");
    private final BBacnetServerLayer server;

    FileHandler(BBacnetServerLayer server) {
        this.server = server;
    }

    @Override
    public BacnetServicePrimitive receiveRequest(int serviceChoice, BacnetServicePrimitive request, BBacnetAddress sourceAddress) {
        switch (serviceChoice) {
            case 6: {
                return this.processAtomicReadFileRequest((AtomicReadFileRequest)request);
            }
            case 7: {
                return this.processAtomicWriteFileRequest((AtomicWriteFileRequest)request);
            }
        }
        logger.info("FileHandler.receiveRequest:Unknown request! " + request);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BacnetServicePrimitive processAtomicReadFileRequest(AtomicReadFileRequest request) {
        BBacnetFileDescriptor file;
        BLocalBacnetDevice local = BBacnetNetwork.localDevice();
        BBacnetObjectIdentifier fileId = request.getFileId();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("FileHandler.AtomicReadFileRequest received: " + request);
        }
        if ((file = (BBacnetFileDescriptor)local.lookupBacnetObject(fileId)) == null) {
            return new SimpleError(6, new NErrorType(1, 31));
        }
        if (fileId.equals((Object)this.server.getBackupRestoreFileId()) && local.getBackupAndRestoreState() != BBacnetBackupState.idle) {
            this.server.updateLastBackupRestoreCommTime();
        }
        if (!request.isStreamAccess()) {
            return new SimpleError(6, new NErrorType(5, 10));
        }
        int start = request.getFileStartPosition();
        if (start < 0 || (long)start > file.getFileSize()) {
            return new SimpleError(6, new NErrorType(5, 11));
        }
        long count = request.getRequestedOctetCount();
        if (count > Integer.MAX_VALUE) {
            return new BacnetReject(6);
        }
        byte[] fileData = null;
        boolean eof = false;
        try {
            BBacnetFileDescriptor bBacnetFileDescriptor = file;
            synchronized (bBacnetFileDescriptor) {
                fileData = file.read(request.getFileStartPosition(), (int)count);
                eof = file.isEOF();
            }
        }
        catch (IOException e) {
            logger.log(Level.INFO, "IOException attempting to read file " + file.getFileOrd() + " in response to Bacnet AtomicReadFileRequest!", e);
        }
        if (fileData == null) {
            return new SimpleError(6, new NErrorType(5, 5));
        }
        return new AtomicReadFileAck(eof, request.getFileStartPosition(), fileData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BacnetServicePrimitive processAtomicWriteFileRequest(AtomicWriteFileRequest request) {
        BBacnetFileDescriptor file;
        BLocalBacnetDevice local = BBacnetNetwork.localDevice();
        BBacnetObjectIdentifier fileId = request.getFileId();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("FileHandler.AtomicWriteFileRequest received: " + request);
        }
        if ((file = (BBacnetFileDescriptor)local.lookupBacnetObject(fileId)) == null) {
            return new SimpleError(7, new NErrorType(1, 31));
        }
        if (fileId.equals((Object)this.server.getBackupRestoreFileId()) && local.getBackupAndRestoreState() != BBacnetBackupState.idle) {
            this.server.updateLastBackupRestoreCommTime();
        }
        if (!request.isStreamAccess()) {
            return new SimpleError(7, new NErrorType(5, 10));
        }
        int start = request.getFileStart();
        if (start < 0 || (long)start > file.getFileSize()) {
            return new SimpleError(6, new NErrorType(5, 11));
        }
        int writeResult = -1;
        try {
            BBacnetFileDescriptor bBacnetFileDescriptor = file;
            synchronized (bBacnetFileDescriptor) {
                writeResult = file.write(request.getFileStart(), request.getFileData());
            }
            if (writeResult < 0) {
                return new AtomicWriteFileAck(0, request.getFileStart());
            }
            return new SimpleError(7, new NErrorType(5, writeResult));
        }
        catch (IOException e) {
            logger.log(Level.INFO, "IOException attempting to write file " + file.getFileOrd() + " in response to Bacnet AtomicWriteFileRequest!", e);
            return new SimpleError(7, new NErrorType(5, 5));
        }
    }
}

