/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.server;

import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.services.BacnetReject;
import com.tridium.bacnet.services.BacnetServicePrimitive;
import com.tridium.bacnet.services.BacnetSimpleAck;
import com.tridium.bacnet.services.confirmed.DeviceCommunicationControlRequest;
import com.tridium.bacnet.services.confirmed.ReinitializeDeviceRequest;
import com.tridium.bacnet.services.error.SimpleError;
import com.tridium.bacnet.services.unconfirmed.IAmRequest;
import com.tridium.bacnet.services.unconfirmed.IHaveRequest;
import com.tridium.bacnet.services.unconfirmed.WhoHasRequest;
import com.tridium.bacnet.services.unconfirmed.WhoIsRequest;
import com.tridium.bacnet.stack.DeviceRegistry;
import com.tridium.bacnet.stack.IAmListener;
import com.tridium.bacnet.stack.IHaveListener;
import com.tridium.bacnet.stack.server.BBacnetExportTable;
import com.tridium.bacnet.stack.server.BBacnetServerLayer;
import com.tridium.bacnet.stack.server.ServiceHandler;
import com.tridium.platform.BSystemPlatformService;
import com.tridium.sys.station.Station;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.backup.BBackupService;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetConfirmedServiceChoice;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.BacnetUnconfirmedServiceChoice;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetBackupState;
import javax.baja.bacnet.enums.BBacnetDeviceStatus;
import javax.baja.bacnet.enums.BBacnetErrorClass;
import javax.baja.bacnet.enums.BBacnetErrorCode;
import javax.baja.bacnet.enums.BBacnetRestartReason;
import javax.baja.bacnet.export.BBacnetFileDescriptor;
import javax.baja.bacnet.export.BIBacnetExportObject;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.bacnet.io.BBacnetComm;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.license.Feature;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.security.BPasswordCache;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;

public class DeviceHandler
implements ServiceHandler,
BacnetUnconfirmedServiceChoice,
BacnetConfirmedServiceChoice {
    private final BBacnetServerLayer server;
    private final List<IAmListener> iAmListeners = new ArrayList<IAmListener>();
    private final List<IHaveListener> iHaveListeners = new ArrayList<IHaveListener>();
    private Clock.Ticket ticket = null;
    BBacnetAddress backupRestoreClient = null;
    final AtomicReference<BIFile> backupRestoreFile = new AtomicReference();
    final AtomicReference<BBacnetFileDescriptor> backupRestoreFileDesc = new AtomicReference();
    final Object backupRestoreStepLock = new Object();
    BackupRestoreStep backupRestoreStep = BackupRestoreStep.BACKUP_RESTORE_IDLE;
    private static Boolean supportsWarmRestart = null;
    private static final Logger logger = Logger.getLogger("bacnet.server");
    private static final String BACKUP_FILENAME = "backup_" + Sys.getStation().getStationName() + ".dist";
    private static final String BACKUP_PATH = "~backups/";
    private static final String BACKUP_FILEPATH = "~backups/" + BACKUP_FILENAME;
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    DeviceHandler(BBacnetServerLayer server) {
        this.server = server;
    }

    @Override
    public BacnetServicePrimitive receiveRequest(int serviceChoice, BacnetServicePrimitive request, BBacnetAddress sourceAddress) {
        switch (serviceChoice) {
            case 8: {
                this.processWhoIsRequest((WhoIsRequest)request, sourceAddress);
                return null;
            }
            case 0: {
                this.processIAmRequest((IAmRequest)request, sourceAddress);
                return null;
            }
            case 7: {
                this.processWhoHasRequest((WhoHasRequest)request);
                return null;
            }
            case 1: {
                this.processIHaveRequest((IHaveRequest)request, sourceAddress);
                return null;
            }
            case 17: {
                return this.processDeviceCommunicationControlRequest((DeviceCommunicationControlRequest)request, sourceAddress);
            }
            case 20: {
                return this.processReinitializeDeviceRequest((ReinitializeDeviceRequest)request, sourceAddress);
            }
        }
        logger.info("DeviceHandler.receiveRequest: Unknown request! " + request);
        return null;
    }

    private void processWhoIsRequest(WhoIsRequest request, BBacnetAddress sourceAddress) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("DeviceHandler: WhoIsRequest received: " + request);
        }
        if (!request.useLimits()) {
            this.server.iAm(sourceAddress);
            return;
        }
        int myDeviceNumber = BBacnetNetwork.localDevice().getObjectId().getInstanceNumber();
        if (myDeviceNumber >= request.getDeviceInstanceRangeLowLimit() && myDeviceNumber <= request.getDeviceInstanceRangeHighLimit()) {
            this.server.iAm(sourceAddress);
        }
    }

    private void processIAmRequest(IAmRequest request, BBacnetAddress sourceAddress) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("DeviceHandler: IAmRequest received: " + request);
        }
        DeviceRegistry.update(request.getObjectId(), sourceAddress, request.getMaxAPDULengthAccepted(), request.getSegmentationSupported());
        this.routeToIAmListeners(request, sourceAddress);
    }

    private void processWhoHasRequest(WhoHasRequest request) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("DeviceHandler: WhoHasRequest received: " + request);
        }
        BIBacnetExportObject object = null;
        if (!request.useLimits()) {
            object = request.getObjectId() != null ? BBacnetNetwork.localDevice().lookupBacnetObject(request.getObjectId()) : BBacnetNetwork.localDevice().lookupBacnetObject(request.getObjectName());
        } else {
            int myDeviceNumber = BBacnetNetwork.localDevice().getObjectId().getInstanceNumber();
            if (myDeviceNumber >= request.getDeviceInstanceRangeLowLimit() && myDeviceNumber <= request.getDeviceInstanceRangeHighLimit()) {
                object = request.getObjectId() != null ? BBacnetNetwork.localDevice().lookupBacnetObject(request.getObjectId()) : BBacnetNetwork.localDevice().lookupBacnetObject(request.getObjectName());
            }
        }
        if (object != null) {
            this.server.iHave(object.getObjectId(), object.getObjectName(), request.getEncoding());
        }
    }

    private void processIHaveRequest(IHaveRequest request, BBacnetAddress sourceAddress) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("DeviceHandler: IHaveRequest received: " + request);
        }
        this.routeToIHaveListeners(request, sourceAddress);
    }

    private BacnetServicePrimitive processDeviceCommunicationControlRequest(DeviceCommunicationControlRequest request, BBacnetAddress sourceAddress) {
        String requestPassword;
        NErrorType err;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("DeviceHandler: DeviceCommunicationControlRequest received: " + request);
        }
        if ((err = DeviceHandler.checkUserPassword(requestPassword = request.getPassword())) != null) {
            return new SimpleError(17, err);
        }
        boolean enable = false;
        switch (request.getEnableDisable().getOrdinal()) {
            case 0: {
                this.server.stack().enableComm();
                enable = true;
                break;
            }
            case 1: {
                logger.info(" Disabling Bacnet Communications per DCC request from address " + sourceAddress);
                this.server.stack().disableComm();
                break;
            }
            case 2: {
                logger.info(" Disabling Bacnet Communications Initiation per DCC request from address " + sourceAddress);
                this.server.stack().disableInitiation();
                break;
            }
            default: {
                return new BacnetReject(6);
            }
        }
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        if (!enable && request.isDurationUsed() && !request.isIndefinite()) {
            this.ticket = Clock.schedule((BComponent)this.server.stack(), (BRelTime)request.getDuration(), (Action)BBacnetComm.enableComm, null);
        }
        return new BacnetSimpleAck(17);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BacnetServicePrimitive processReinitializeDeviceRequest(ReinitializeDeviceRequest request, BBacnetAddress sourceAddress) {
        Feature feature;
        boolean serverLicensed;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("DeviceHandler: ReinitializeDeviceRequest received: " + request);
        }
        if (!(serverLicensed = (feature = this.server.bacnet().getLicenseFeature()).getb("export", false))) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("ReinitializeDeviceRequest rejected: station does not contain the bacnet.export license attribute or it is set to false");
            }
            return DeviceHandler.makeReinitializeDeviceError(BBacnetErrorClass.services, BBacnetErrorCode.optionalFunctionalityNotSupported);
        }
        String requestPassword = request.getPassword();
        NErrorType err = DeviceHandler.checkUserPassword(requestPassword);
        if (err != null) {
            return new SimpleError(20, err);
        }
        if (!this.server.getReinitializeAllowed()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("ReinitializeDeviceRequest rejected: reinitialization is not allowed");
            }
            return DeviceHandler.makeReinitializeDeviceError(BBacnetErrorClass.services, BBacnetErrorCode.serviceRequestDenied);
        }
        BLocalBacnetDevice localDevice = BBacnetNetwork.localDevice();
        switch (request.getReinitializedStateOfDevice().getOrdinal()) {
            case 1: {
                if (DeviceHandler.supportsWarmRestart()) {
                    return DeviceHandler.processRestart(1);
                }
                return DeviceHandler.processRestart(0);
            }
            case 0: {
                return DeviceHandler.processRestart(0);
            }
            case 2: {
                if (!this.isCommExecutionEnabled()) {
                    return DeviceHandler.makeReinitializeDeviceError(BBacnetErrorClass.services, BBacnetErrorCode.communicationDisabled);
                }
                Object object = this.backupRestoreStepLock;
                synchronized (object) {
                    if (this.backupRestoreStep == BackupRestoreStep.BACKUP_RESTORE_IDLE) {
                        logger.info("BACnet device at address " + sourceAddress + " has initiated a START_BACKUP...");
                        localDevice.setBackupAndRestoreState(BBacnetBackupState.preparingForBackup);
                        localDevice.updateSystemStatus(BBacnetDeviceStatus.backupInProgress);
                        this.backupRestoreClient = sourceAddress;
                        BBacnetNetwork.bacnet().postAsync(new StartBackup());
                        this.backupRestoreStep = BackupRestoreStep.RUNNING_BACKUP;
                        return new BacnetSimpleAck(20);
                    }
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Cannot start backup on receipt of START_BACKUP from device at address " + sourceAddress + "; systemStatus: " + localDevice.getSystemStatus() + "; backupAndRestoreState: " + (Object)((Object)localDevice.getBackupAndRestoreState()) + "; backupRestoreStep: " + (Object)((Object)this.backupRestoreStep));
                    }
                    return DeviceHandler.makeReinitializeDeviceError(BBacnetErrorClass.device, BBacnetErrorCode.configurationInProgress);
                }
            }
            case 3: {
                if (!this.isCommExecutionEnabled()) {
                    return DeviceHandler.makeReinitializeDeviceError(BBacnetErrorClass.services, BBacnetErrorCode.communicationDisabled);
                }
                logger.info("BACnet device at address " + sourceAddress + " has initiated an END_BACKUP...");
                Object object = this.backupRestoreStepLock;
                synchronized (object) {
                    switch (this.backupRestoreStep) {
                        case RUNNING_BACKUP: {
                            logger.fine("END_BACKUP received while preparing for backup");
                            this.backupRestoreStep = BackupRestoreStep.ABORTING_BACKUP;
                            return new BacnetSimpleAck(20);
                        }
                        case ABORTING_BACKUP: {
                            logger.fine("END_BACKUP received while already aborting a backup");
                            return new BacnetSimpleAck(20);
                        }
                        case FINISHED_BACKUP: 
                        case BACKUP_FAILED: {
                            if (logger.isLoggable(Level.FINE)) {
                                logger.fine("END_BACKUP received in backup step " + (Object)((Object)this.backupRestoreStep) + "; clearing backup");
                            }
                            this.clearBackupRestore();
                            this.backupRestoreStep = BackupRestoreStep.BACKUP_RESTORE_IDLE;
                            return new BacnetSimpleAck(20);
                        }
                        case PREPARING_FOR_RESTORE: 
                        case ABORTING_RESTORE: 
                        case READY_FOR_RESTORE: 
                        case RESTORE_FAILED: 
                        case RUNNING_RESTORE: {
                            if (logger.isLoggable(Level.FINE)) {
                                logger.fine("END_BACKUP received while in restore step " + (Object)((Object)this.backupRestoreStep));
                            }
                            return DeviceHandler.makeReinitializeDeviceError(BBacnetErrorClass.device, BBacnetErrorCode.configurationInProgress);
                        }
                    }
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("END_BACKUP received in invalid backup/restore step " + (Object)((Object)this.backupRestoreStep));
                    }
                    return DeviceHandler.makeReinitializeDeviceError(BBacnetErrorClass.services, BBacnetErrorCode.other);
                }
            }
            case 4: {
                if (!this.isCommExecutionEnabled()) {
                    return DeviceHandler.makeReinitializeDeviceError(BBacnetErrorClass.services, BBacnetErrorCode.communicationDisabled);
                }
                Object object = this.backupRestoreStepLock;
                synchronized (object) {
                    if (this.backupRestoreStep == BackupRestoreStep.BACKUP_RESTORE_IDLE) {
                        logger.info("BACnet device at address " + sourceAddress + " has initiated a START_RESTORE...");
                        localDevice.setBackupAndRestoreState(BBacnetBackupState.preparingForRestore);
                        localDevice.updateSystemStatus(BBacnetDeviceStatus.downloadInProgress);
                        this.backupRestoreClient = sourceAddress;
                        BBacnetNetwork.bacnet().postAsync(new StartRestore());
                        this.backupRestoreStep = BackupRestoreStep.PREPARING_FOR_RESTORE;
                        return new BacnetSimpleAck(20);
                    }
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Cannot start restore on receipt of START_RESTORE from device at address " + sourceAddress + "; systemStatus: " + localDevice.getSystemStatus() + "; backupAndRestoreState: " + (Object)((Object)localDevice.getBackupAndRestoreState()) + "; backupRestoreStep: " + (Object)((Object)this.backupRestoreStep));
                    }
                    return DeviceHandler.makeReinitializeDeviceError(BBacnetErrorClass.device, BBacnetErrorCode.configurationInProgress);
                }
            }
            case 5: {
                if (!this.isCommExecutionEnabled()) {
                    return DeviceHandler.makeReinitializeDeviceError(BBacnetErrorClass.services, BBacnetErrorCode.communicationDisabled);
                }
                logger.info("BACnet device at address " + sourceAddress + " has initiated an END_RESTORE...");
                Object object = this.backupRestoreStepLock;
                synchronized (object) {
                    switch (this.backupRestoreStep) {
                        case PREPARING_FOR_RESTORE: {
                            logger.info("END_RESTORE received while preparing for restore");
                            return DeviceHandler.makeReinitializeDeviceError(BBacnetErrorClass.device, BBacnetErrorCode.configurationInProgress);
                        }
                        case ABORTING_RESTORE: {
                            logger.fine("END_RESTORE received while aborting restore");
                            return DeviceHandler.makeReinitializeDeviceError(BBacnetErrorClass.device, BBacnetErrorCode.configurationInProgress);
                        }
                        case READY_FOR_RESTORE: {
                            logger.fine("END_RESTORE received while performing a restore; starting end restore task");
                            BBacnetNetwork.bacnet().postAsync(new EndRestore());
                            this.backupRestoreStep = BackupRestoreStep.RUNNING_RESTORE;
                            return new BacnetSimpleAck(20);
                        }
                        case RESTORE_FAILED: {
                            logger.fine("END_RESTORE received after restore failure; restore should be aborted");
                            return DeviceHandler.makeReinitializeDeviceError(BBacnetErrorClass.services, BBacnetErrorCode.other);
                        }
                        case RUNNING_RESTORE: {
                            logger.fine("END_RESTORE received while already running a restore");
                            return DeviceHandler.makeReinitializeDeviceError(BBacnetErrorClass.device, BBacnetErrorCode.configurationInProgress);
                        }
                        case RUNNING_BACKUP: 
                        case ABORTING_BACKUP: 
                        case FINISHED_BACKUP: 
                        case BACKUP_FAILED: {
                            if (logger.isLoggable(Level.FINE)) {
                                logger.fine("END_RESTORE received while in backup step " + (Object)((Object)this.backupRestoreStep));
                            }
                            return DeviceHandler.makeReinitializeDeviceError(BBacnetErrorClass.device, BBacnetErrorCode.configurationInProgress);
                        }
                    }
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("END_RESTORE received in invalid backup/restore step " + (Object)((Object)this.backupRestoreStep));
                    }
                    return DeviceHandler.makeReinitializeDeviceError(BBacnetErrorClass.services, BBacnetErrorCode.other);
                }
            }
            case 6: {
                if (!this.isCommExecutionEnabled()) {
                    return DeviceHandler.makeReinitializeDeviceError(BBacnetErrorClass.services, BBacnetErrorCode.communicationDisabled);
                }
                logger.info("BACnet device at address " + sourceAddress + " has initiated an ABORT_RESTORE...");
                Object object = this.backupRestoreStepLock;
                synchronized (object) {
                    switch (this.backupRestoreStep) {
                        case PREPARING_FOR_RESTORE: {
                            logger.info("ABORT_RESTORE received while preparing for restore");
                            this.backupRestoreStep = BackupRestoreStep.ABORTING_RESTORE;
                            return new BacnetSimpleAck(20);
                        }
                        case ABORTING_RESTORE: {
                            logger.info("ABORT_RESTORE received while already aborting the restore");
                            return new BacnetSimpleAck(20);
                        }
                        case READY_FOR_RESTORE: 
                        case RESTORE_FAILED: {
                            logger.fine("ABORT_RESTORE received after preparing for a restore but before ending it");
                            this.clearBackupRestore();
                            this.backupRestoreStep = BackupRestoreStep.BACKUP_RESTORE_IDLE;
                            return new BacnetSimpleAck(20);
                        }
                        case RUNNING_RESTORE: {
                            logger.fine("ABORT_RESTORE received while ending a restore");
                            return DeviceHandler.makeReinitializeDeviceError(BBacnetErrorClass.device, BBacnetErrorCode.configurationInProgress);
                        }
                        case RUNNING_BACKUP: 
                        case ABORTING_BACKUP: 
                        case FINISHED_BACKUP: 
                        case BACKUP_FAILED: {
                            if (logger.isLoggable(Level.FINE)) {
                                logger.fine("ABORT_RESTORE received while in backup step " + (Object)((Object)this.backupRestoreStep));
                            }
                            return DeviceHandler.makeReinitializeDeviceError(BBacnetErrorClass.device, BBacnetErrorCode.configurationInProgress);
                        }
                    }
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("ABORT_RESTORE received in invalid backup/restore step " + (Object)((Object)this.backupRestoreStep));
                    }
                    return DeviceHandler.makeReinitializeDeviceError(BBacnetErrorClass.services, BBacnetErrorCode.other);
                }
            }
        }
        return new BacnetReject(6);
    }

    private static SimpleError makeReinitializeDeviceError(BBacnetErrorClass errorClass, BBacnetErrorCode errorCode) {
        return new SimpleError(20, new NErrorType(errorClass.getOrdinal(), errorCode.getOrdinal()));
    }

    private boolean isCommExecutionEnabled() {
        return this.server.stack().isCommExecutionEnabled();
    }

    private static BBacnetFileDescriptor addBackupRestoreFileDesc(FilePath path) {
        BLocalBacnetDevice localDevice = BBacnetNetwork.localDevice();
        BBacnetExportTable exportTable = (BBacnetExportTable)localDevice.getExportTable();
        int instNum = exportTable.getNextInstance(10);
        BBacnetObjectIdentifier objectId = BBacnetObjectIdentifier.make(10, instNum);
        BBacnetFileDescriptor fileDesc = new BBacnetFileDescriptor();
        fileDesc.setObjectId(objectId);
        fileDesc.setFileOrd(BOrd.make((OrdQuery)path));
        fileDesc.setObjectName(BACKUP_FILENAME);
        fileDesc.setDescription("Station backup file");
        fileDesc.setBackupConigFile(true);
        exportTable.add(fileDesc.getObjectId().toString(BacnetConst.nameContext), (BValue)fileDesc);
        return fileDesc;
    }

    private void clearBackupRestore() {
        BLocalBacnetDevice localDevice = BBacnetNetwork.localDevice();
        localDevice.setBackupAndRestoreState(BBacnetBackupState.idle);
        localDevice.restoreSystemStatus();
        this.server.checkBackupTicket.cancel();
        this.server.cleanupBackupMode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markRestoreFailure() {
        Object object = this.backupRestoreStepLock;
        synchronized (object) {
            BLocalBacnetDevice localDevice = BBacnetNetwork.localDevice();
            if (this.backupRestoreStep == BackupRestoreStep.ABORTING_RESTORE) {
                logger.fine("Restore aborted during preparingForRestore after restore failure");
                this.server.cleanupBackupMode();
                localDevice.setBackupAndRestoreState(BBacnetBackupState.idle);
                localDevice.restoreSystemStatus();
                this.backupRestoreStep = BackupRestoreStep.BACKUP_RESTORE_IDLE;
            } else {
                this.server.cleanupBackupMode();
                this.server.scheduleBackupRestoreFailure();
                localDevice.setBackupAndRestoreState(BBacnetBackupState.restoreFailure);
                this.backupRestoreStep = BackupRestoreStep.RESTORE_FAILED;
            }
        }
    }

    private static BacnetServicePrimitive processRestart(int restartType) {
        try {
            BSystemPlatformService sps = (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
            Runnable restart = null;
            BBacnetRestartReason reason = null;
            if (restartType == 1) {
                restart = new WarmStart(sps);
                reason = BBacnetRestartReason.warmstart;
            } else if (restartType == 0) {
                restart = new ColdStart(sps);
                reason = BBacnetRestartReason.coldstart;
            }
            if (reason != null) {
                BBacnetNetwork.bacnet().getLocalDevice().setLastRestartReason(reason);
            }
            BBacnetNetwork.bacnet().postAsync(restart);
            return new BacnetSimpleAck(20);
        }
        catch (ServiceNotFoundException e) {
            logger.log(Level.SEVERE, "Cannot find System Platform Service!!", e);
            return DeviceHandler.makeReinitializeDeviceError(BBacnetErrorClass.device, BBacnetErrorCode.operationalProblem);
        }
    }

    private static boolean supportsWarmRestart() {
        if (supportsWarmRestart == null) {
            BSystemPlatformService platService = (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
            supportsWarmRestart = platService.getAllowStationRestart() ? Boolean.TRUE : Boolean.FALSE;
        }
        return supportsWarmRestart;
    }

    private static NErrorType checkUserPassword(String pw) {
        BUserService us;
        try {
            us = (BUserService)Sys.getService((Type)BUserService.TYPE);
        }
        catch (ServiceNotFoundException e) {
            logger.severe("Unable to locate User Service; password cannot be verified!");
            return new NErrorType(5, 0);
        }
        BUser bacnetUser = us.getUser("BACnet");
        if (bacnetUser == null) {
            logger.severe("BACnet User required for validation of Device Management request!");
            return new NErrorType(5, 29);
        }
        if (pw == null) {
            return new NErrorType(4, 26);
        }
        if (((BPasswordCache)bacnetUser.getAuthenticator()).validate(pw)) {
            logger.info("Password validated for BACnet User");
            return null;
        }
        logger.severe("Incorrect Password for BACnet Device Management Request!");
        return new NErrorType(4, 26);
    }

    void addIAmListener(IAmListener listener) {
        this.iAmListeners.add(listener);
    }

    void removeIAmListener(IAmListener listener) {
        this.iAmListeners.remove(listener);
    }

    private void routeToIAmListeners(IAmRequest request, BBacnetAddress sourceAddress) {
        for (IAmListener listener : this.iAmListeners) {
            if (listener == null || request == null || sourceAddress == null) continue;
            listener.receiveIAm(request, sourceAddress);
        }
    }

    void addIHaveListener(IHaveListener listener) {
        this.iHaveListeners.add(listener);
    }

    void removeIHaveListener(IHaveListener listener) {
        this.iHaveListeners.remove(listener);
    }

    private void routeToIHaveListeners(IHaveRequest request, BBacnetAddress sourceAddress) {
        for (IHaveListener iHaveListener : this.iHaveListeners) {
            iHaveListener.receiveIHave(request, sourceAddress);
        }
    }

    public static enum BackupRestoreStep {
        BACKUP_RESTORE_IDLE,
        RUNNING_BACKUP,
        ABORTING_BACKUP,
        FINISHED_BACKUP,
        BACKUP_FAILED,
        PREPARING_FOR_RESTORE,
        READY_FOR_RESTORE,
        RESTORE_FAILED,
        RUNNING_RESTORE,
        ABORTING_RESTORE;

    }

    private class EndRestore
    implements Runnable {
        private EndRestore() {
        }

        @Override
        public void run() {
            try {
                AccessController.doPrivileged(() -> {
                    BLocalBacnetDevice localDevice = BBacnetNetwork.localDevice();
                    int restoreDatabaseRev = localDevice.getDatabaseRevision();
                    FilePath path = new FilePath("~backups/lastRestoreTime");
                    BIFile lastRestoreFile = BFileSystem.INSTANCE.makeFile(path, null);
                    try (PrintStream ps = new PrintStream(lastRestoreFile.getOutputStream(), false, "UTF-8");){
                        ps.print(Clock.time().encodeToString() + '\n');
                        ps.print(restoreDatabaseRev + "\n");
                    }
                    BBackupService backupService = (BBackupService)Sys.getService((Type)BBackupService.TYPE);
                    backupService.restoreFiles(DeviceHandler.this.backupRestoreFile.get());
                    return null;
                });
            }
            catch (Exception e) {
                Exception unwrapped = e;
                if (e instanceof PrivilegedActionException) {
                    unwrapped = ((PrivilegedActionException)e).getException();
                }
                logger.log(Level.SEVERE, "Unable to complete restore procedure:" + unwrapped, unwrapped);
                DeviceHandler.this.markRestoreFailure();
            }
        }
    }

    private class StartRestore
    implements Runnable {
        private StartRestore() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                FilePath path = new FilePath(BACKUP_FILEPATH);
                AccessController.doPrivileged(() -> {
                    BIFile file = BFileSystem.INSTANCE.makeFile(path, null);
                    DeviceHandler.this.backupRestoreFile.set(file);
                    file.write(EMPTY_BYTE_ARRAY);
                    return null;
                });
                BBacnetFileDescriptor fileDesc = DeviceHandler.addBackupRestoreFileDesc(path);
                DeviceHandler.this.backupRestoreFileDesc.set(fileDesc);
                if (fileDesc.getStatus().isFault()) {
                    logger.severe("Failed to export the restore file descriptor; faultCause: " + fileDesc.getFaultCause());
                    DeviceHandler.this.markRestoreFailure();
                    return;
                }
                BLocalBacnetDevice localDevice = BBacnetNetwork.localDevice();
                localDevice.getConfigurationFiles().addElement((BValue)fileDesc.getObjectId());
                Object object = DeviceHandler.this.backupRestoreStepLock;
                synchronized (object) {
                    if (DeviceHandler.this.backupRestoreStep == BackupRestoreStep.ABORTING_RESTORE) {
                        logger.fine("Restore aborted during preparingForRestore");
                        DeviceHandler.this.clearBackupRestore();
                        DeviceHandler.this.backupRestoreStep = BackupRestoreStep.BACKUP_RESTORE_IDLE;
                    } else {
                        DeviceHandler.this.server.scheduleBackupRestoreFailure();
                        localDevice.setBackupAndRestoreState(BBacnetBackupState.performingARestore);
                        DeviceHandler.this.backupRestoreStep = BackupRestoreStep.READY_FOR_RESTORE;
                    }
                }
            }
            catch (Exception e) {
                Exception unwrapped = e;
                if (e instanceof PrivilegedActionException) {
                    unwrapped = ((PrivilegedActionException)e).getException();
                }
                logger.log(Level.SEVERE, "Exception occurred in StartRestore runnable", unwrapped);
                DeviceHandler.this.markRestoreFailure();
            }
        }
    }

    private class StartBackup
    implements Runnable {
        private StartBackup() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                long t0 = Clock.ticks();
                Station.saveSync();
                long t1 = Clock.ticks();
                if (this.isBackupAborted()) {
                    logger.fine("Backup ended during preparingForBackup after station save");
                    return;
                }
                FilePath path = new FilePath(BACKUP_FILEPATH);
                AccessController.doPrivileged(() -> {
                    BIFile file = BFileSystem.INSTANCE.makeFile(path, null);
                    DeviceHandler.this.backupRestoreFile.set(file);
                    OutputStream out = file.getOutputStream();
                    BBackupService backupService = (BBackupService)Sys.getService((Type)BBackupService.TYPE);
                    backupService.zip(null, out, true);
                    return null;
                });
                long t2 = Clock.ticks();
                if (this.isBackupAborted()) {
                    logger.fine("Backup ended during preparingForBackup after station backup");
                    return;
                }
                BBacnetFileDescriptor fileDesc = DeviceHandler.addBackupRestoreFileDesc(path);
                DeviceHandler.this.backupRestoreFileDesc.set(fileDesc);
                if (fileDesc.getStatus().isFault()) {
                    logger.severe("Failed to export the backup file descriptor; faultCause: " + fileDesc.getFaultCause());
                    this.markBackupFailure();
                    return;
                }
                BLocalBacnetDevice localDevice = BBacnetNetwork.localDevice();
                localDevice.getConfigurationFiles().addElement((BValue)fileDesc.getObjectId());
                long t3 = Clock.ticks();
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("timing: tSave=" + (t1 - t0) + " tBackup=" + (t2 - t1) + " tExport=" + (t3 - t2) + " total=" + (t3 - t0));
                }
                Object object = DeviceHandler.this.backupRestoreStepLock;
                synchronized (object) {
                    if (this.isBackupAborted()) {
                        logger.fine("Backup ended during preparingForBackup after exportFile descriptor created");
                    } else {
                        DeviceHandler.this.server.scheduleBackupRestoreFailure();
                        localDevice.setBackupAndRestoreState(BBacnetBackupState.performingABackup);
                        DeviceHandler.this.backupRestoreStep = BackupRestoreStep.FINISHED_BACKUP;
                    }
                }
            }
            catch (Exception e) {
                Exception unwrapped = e;
                if (e instanceof PrivilegedActionException) {
                    unwrapped = ((PrivilegedActionException)e).getException();
                }
                logger.log(Level.SEVERE, "Exception occurred in StartBackup runnable", unwrapped);
                this.markBackupFailure();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isBackupAborted() {
            Object object = DeviceHandler.this.backupRestoreStepLock;
            synchronized (object) {
                if (DeviceHandler.this.backupRestoreStep == BackupRestoreStep.ABORTING_BACKUP) {
                    DeviceHandler.this.clearBackupRestore();
                    DeviceHandler.this.backupRestoreStep = BackupRestoreStep.BACKUP_RESTORE_IDLE;
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void markBackupFailure() {
            Object object = DeviceHandler.this.backupRestoreStepLock;
            synchronized (object) {
                BLocalBacnetDevice localDevice = BBacnetNetwork.localDevice();
                if (DeviceHandler.this.backupRestoreStep == BackupRestoreStep.ABORTING_BACKUP) {
                    logger.fine("Backup ended during preparingForBackup after backup failure");
                    DeviceHandler.this.server.cleanupBackupMode();
                    localDevice.setBackupAndRestoreState(BBacnetBackupState.idle);
                    localDevice.restoreSystemStatus();
                    DeviceHandler.this.backupRestoreStep = BackupRestoreStep.BACKUP_RESTORE_IDLE;
                } else {
                    DeviceHandler.this.server.cleanupBackupMode();
                    DeviceHandler.this.server.scheduleBackupRestoreFailure();
                    localDevice.setBackupAndRestoreState(BBacnetBackupState.backupFailure);
                    DeviceHandler.this.backupRestoreStep = BackupRestoreStep.BACKUP_FAILED;
                }
            }
        }
    }

    private static class ColdStart
    implements Runnable {
        BSystemPlatformService sps = null;

        ColdStart(BSystemPlatformService sps) {
            this.sps = sps;
        }

        @Override
        public void run() {
            if (this.sps != null) {
                logger.warning("Rebooting station from BACnet ReinitializeDevice Request...");
                this.sps.reboot();
            } else {
                logger.info("SystemPlatformService not found!  Cannot execute BACnet Cold Start.");
            }
        }
    }

    private static class WarmStart
    implements Runnable {
        BSystemPlatformService sps = null;

        WarmStart(BSystemPlatformService sps) {
            this.sps = sps;
        }

        @Override
        public void run() {
            if (this.sps != null) {
                logger.warning("Restarting station from BACnet ReinitializeDevice Request...");
                this.sps.restartStation();
            } else {
                logger.info("SystemPlatformService not found!  Cannot execute BACnet Warm Start.");
            }
        }
    }
}

