/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.server;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.AlarmDbConnection;
import javax.baja.alarm.BAlarmDatabase;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;

public final class BHashedEventBuffer
extends BComponent {
    public static final Type TYPE = Sys.loadType(BHashedEventBuffer.class);
    private static final Logger logger = Logger.getLogger("bacnet.server");

    public Type getType() {
        return TYPE;
    }

    public String toString(Context cx) {
        return "eventCount=" + this.getSlotCount();
    }

    public synchronized void putRecord(BBacnetObjectIdentifier deviceId, BBacnetObjectIdentifier objectId, long processId, BAlarmRecord record) {
        String key = deviceId.toString(BacnetConst.facetsContext) + "_" + objectId.toString(BacnetConst.facetsContext) + "_" + processId;
        try {
            BValue v = this.get(key);
            if (v != null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("putRecord:replacing old uuid:" + v + " with new uuid:" + record.getUuid());
                }
                this.set(key, (BValue)record.getUuid());
            } else {
                this.add(key, (BValue)record.getUuid());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void removeRecord(BBacnetObjectIdentifier deviceId, BBacnetObjectIdentifier objectId, long processId) {
        String key = deviceId.toString(BacnetConst.facetsContext) + "_" + objectId.toString(BacnetConst.facetsContext) + "_" + processId;
        try {
            BValue v = this.get(key);
            if (v != null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("removeRecord: " + v + " key: " + key);
                }
                this.remove(key);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to remove the record: " + key);
        }
    }

    public synchronized BAlarmRecord getRecord(BBacnetObjectIdentifier deviceId, BBacnetObjectIdentifier objectId, long processId, BUuid uuid, boolean remove) {
        String key = deviceId.toString(BacnetConst.facetsContext) + "_" + objectId.toString(BacnetConst.facetsContext) + "_" + processId;
        return this.getRecord(key, uuid, remove);
    }

    public synchronized BAlarmRecord getRecord(BBacnetObjectIdentifier deviceId, BBacnetObjectIdentifier objectId, long processId, boolean remove) {
        return this.getRecord(deviceId, objectId, processId, null, remove);
    }

    public synchronized boolean checkRecord(BAlarmRecord ackRecord) {
        BAlarmRecord currentRecord;
        if (ackRecord == null) {
            return false;
        }
        BFacets alarmData = ackRecord.getAlarmData();
        if (alarmData == null) {
            return false;
        }
        BString deviceStr = (BString)alarmData.getFacet("deviceId");
        BString objectStr = (BString)alarmData.getFacet("objectId");
        BString processIdStr = (BString)alarmData.getFacet("processId");
        String key = "no record";
        if (deviceStr != null && objectStr != null && processIdStr != null) {
            key = deviceStr + "_" + objectStr + "_" + processIdStr;
        }
        if ((currentRecord = this.getRecord(key, null, false)) == null) {
            return false;
        }
        return ackRecord.getTimestamp().equals((Object)currentRecord.getTimestamp());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private synchronized BAlarmRecord getRecord(String key, BUuid match, boolean remove) {
        Property property = this.getProperty(key);
        if (property == null) {
            return null;
        }
        BUuid uuid = (BUuid)this.get(key);
        if (uuid == null) {
            return null;
        }
        if (match != null && !uuid.equals((Object)match)) {
            return null;
        }
        try {
            BAlarmRecord bAlarmRecord;
            Throwable throwable;
            AlarmDbConnection conn;
            block27: {
                block28: {
                    BAlarmRecord dbRecord;
                    BAlarmService as = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
                    BAlarmDatabase alarmDb = as.getAlarmDb();
                    conn = alarmDb.getDbConnection(null);
                    throwable = null;
                    bAlarmRecord = dbRecord = conn.getRecord(uuid);
                    if (conn == null) break block27;
                    if (throwable == null) break block28;
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block27;
                }
                conn.close();
            }
            return bAlarmRecord;
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (conn != null) {
                            if (throwable != null) {
                                try {
                                    conn.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                conn.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Exception occurred in getRecord", e);
                    BAlarmRecord bAlarmRecord2 = null;
                    return bAlarmRecord2;
                }
            }
        }
        finally {
            if (remove) {
                try {
                    this.remove(key);
                }
                catch (Throwable t) {
                    logger.log(Level.SEVERE, "Throwable occurred in getRecord", t);
                }
            }
        }
    }

    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        BAlarmDatabase alarmDb = null;
        try {
            BAlarmService as = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
            alarmDb = as.getAlarmDb();
        }
        catch (Exception exception) {
            // empty catch block
        }
        out.startProps();
        out.trTitle((Object)"Event Buffer", 2);
        BUuid[] uuids = (BUuid[])this.getChildren(BUuid.class);
        if (alarmDb != null) {
            try (AlarmDbConnection conn = alarmDb.getDbConnection(null);){
                for (int i = 0; i < uuids.length; ++i) {
                    BAlarmRecord dbRecord = null;
                    try {
                        dbRecord = conn.getRecord(uuids[i]);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    String recFacets = dbRecord != null ? dbRecord.getAlarmData().toString() : "";
                    out.prop((Object)dbRecord, (Object)recFacets);
                }
            }
        }
        out.endProps();
    }
}

