/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.server;

import com.tridium.bacnet.BacUtil;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.asn.NReadPropertyResult;
import com.tridium.bacnet.datatypes.BSvoSubordinate;
import com.tridium.bacnet.services.confirmed.ReadRangeAck;
import com.tridium.bacnet.services.error.NChangeListError;
import com.tridium.bacnet.stack.server.BBacnetExportTable;
import com.tridium.bacnet.stack.server.BIBacnetExportFolder;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.agent.AgentList;
import javax.baja.agent.BIAgent;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetArray;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetNodeType;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.export.BIBacnetExportObject;
import javax.baja.bacnet.export.BLocalBacnetDevice;
import javax.baja.bacnet.export.BacnetPropertyList;
import javax.baja.bacnet.export.BacnetPropertyListProvider;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.ChangeListError;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.PropertyReference;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.bacnet.io.RangeData;
import javax.baja.bacnet.io.RangeReference;
import javax.baja.bacnet.io.RejectException;
import javax.baja.license.Feature;
import javax.baja.naming.BOrd;
import javax.baja.security.PermissionException;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatus;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.DuplicateSlotException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;
import javax.baja.util.Lexicon;

public class BBacnetExportFolder
extends BFolder
implements BIAgent,
BIBacnetExportObject,
BIBacnetExportFolder,
BacnetPropertyListProvider {
    public static final Property status = BBacnetExportFolder.newProperty((int)67, (BValue)BStatus.ok, null);
    public static final Property faultCause = BBacnetExportFolder.newProperty((int)3, (String)"", null);
    public static final Property objectId = BBacnetExportFolder.newProperty((int)64, (BValue)BBacnetObjectIdentifier.make(29), null);
    public static final Property objectName = BBacnetExportFolder.newProperty((int)64, (String)"", null);
    public static final Property description = BBacnetExportFolder.newProperty((int)0, (String)"", null);
    public static final Property nodeType = BBacnetExportFolder.newProperty((int)0, (BValue)BBacnetNodeType.unknown, null);
    public static final Property nodeSubtype = BBacnetExportFolder.newProperty((int)0, (String)"", null);
    public static final Property subordinates = BBacnetExportFolder.newProperty((int)0, (BValue)new BBacnetArray(BSvoSubordinate.TYPE), null);
    public static final Topic subordinateAnnotationChanged = BBacnetExportFolder.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BBacnetExportFolder.class);
    private boolean fatalFault = false;
    private static final BIcon icon = BIcon.make((BIcon)BIcon.std((String)"folder.png"), (BIcon)BIcon.std((String)"badges/export.png"));
    private BBacnetObjectIdentifier oldId = null;
    private String oldName = null;
    private boolean duplicate = false;
    private static AsnOutputStream asnOut = new AsnOutputStream();
    private static Logger logger = Logger.getLogger("bacnet.server");
    private static Lexicon lex = Lexicon.make((String)"bacnet");
    private static final int[] REQUIRED_PROPS = new int[]{75, 77, 79, 208, 211};
    private static final int[] OPTIONAL_PROPS = new int[]{28, 207, 210};

    @Override
    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    @Override
    public BBacnetObjectIdentifier getObjectId() {
        return (BBacnetObjectIdentifier)this.get(objectId);
    }

    @Override
    public void setObjectId(BBacnetObjectIdentifier v) {
        this.set(objectId, (BValue)v, null);
    }

    @Override
    public String getObjectName() {
        return this.getString(objectName);
    }

    @Override
    public void setObjectName(String v) {
        this.setString(objectName, v, null);
    }

    public String getDescription() {
        return this.getString(description);
    }

    public void setDescription(String v) {
        this.setString(description, v, null);
    }

    public BBacnetNodeType getNodeType() {
        return (BBacnetNodeType)this.get(nodeType);
    }

    public void setNodeType(BBacnetNodeType v) {
        this.set(nodeType, (BValue)v, null);
    }

    public String getNodeSubtype() {
        return this.getString(nodeSubtype);
    }

    public void setNodeSubtype(String v) {
        this.setString(nodeSubtype, v, null);
    }

    public BBacnetArray getSubordinates() {
        return (BBacnetArray)this.get(subordinates);
    }

    public void setSubordinates(BBacnetArray v) {
        this.set(subordinates, (BValue)v, null);
    }

    public void fireSubordinateAnnotationChanged(BValue event) {
        this.fire(subordinateAnnotationChanged, event, null);
    }

    public Type getType() {
        return TYPE;
    }

    @Override
    public BBacnetExportTable getExports() {
        for (BComplex p = this.getParent(); p != null; p = p.getParent()) {
            if (!(p instanceof BBacnetExportTable)) continue;
            return (BBacnetExportTable)p;
        }
        throw new IllegalStateException();
    }

    public final void started() throws Exception {
        super.started();
        this.checkFatalFault();
        this.oldId = this.getObjectId();
        this.oldName = this.getObjectName();
        this.checkConfiguration();
        if (Sys.isStationStarted()) {
            BBacnetNetwork.localDevice().incrementDatabaseRevision();
        }
    }

    public final void stopped() throws Exception {
        super.stopped();
        BLocalBacnetDevice local = BBacnetNetwork.localDevice();
        local.unexport(this.oldId, this.oldName, this);
        this.oldId = null;
        this.oldName = null;
        if (local.isRunning()) {
            local.incrementDatabaseRevision();
        }
    }

    public final void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(objectId)) {
            BBacnetNetwork.localDevice().unexport(this.oldId, this.oldName, this);
            this.checkConfiguration();
            this.oldId = this.getObjectId();
            try {
                ((BComponent)this.getParent()).rename(this.getPropertyInParent(), this.getObjectId().toString(nameContext));
            }
            catch (DuplicateSlotException e) {
                logger.log(Level.SEVERE, "DuplicateSlotException in changed", e);
            }
            if (this.getStatus().isOk()) {
                BBacnetNetwork.localDevice().incrementDatabaseRevision();
            }
        } else if (p.equals(objectName)) {
            BBacnetNetwork.localDevice().unexport(this.oldId, this.oldName, this);
            this.checkConfiguration();
            this.oldName = this.getObjectName();
            if (this.getStatus().isOk()) {
                BBacnetNetwork.localDevice().incrementDatabaseRevision();
            }
        }
    }

    public final BFacets getSlotFacets(Slot s) {
        if (s == objectId) {
            return BBacnetObjectType.getObjectIdFacets(29);
        }
        return super.getSlotFacets(s);
    }

    @Override
    public final BObject getObject() {
        return this;
    }

    @Override
    public final BOrd getObjectOrd() {
        return this.getOrdInSession();
    }

    @Override
    public final void setObjectOrd(BOrd objectOrd, Context cx) {
        throw new UnsupportedOperationException(lex.getText("UnsupportedOperationException.structuredView.setObjectOrd"));
    }

    @Override
    public void checkConfiguration() {
        BLocalBacnetDevice local = BBacnetNetwork.localDevice();
        if (this.isFatalFault()) {
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
            return;
        }
        boolean configOk = true;
        if (!this.getObjectId().isValid()) {
            this.setFaultCause("Invalid Object ID");
            configOk = false;
        }
        if (configOk) {
            String err = local.export(this);
            if (err != null) {
                this.duplicate = true;
                this.setFaultCause(err);
                configOk = false;
            } else {
                this.duplicate = false;
            }
        }
        if (configOk) {
            this.setFaultCause("");
        }
        this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (!configOk ? 1 : 0) != 0));
    }

    @Override
    public final PropertyValue readProperty(PropertyReference ref) throws RejectException {
        return this.readProperty(ref.getPropertyId(), ref.getPropertyArrayIndex());
    }

    @Override
    public final PropertyValue[] readPropertyMultiple(PropertyReference[] refs) throws RejectException {
        PropertyValue[] readResults = new PropertyValue[]{};
        ArrayList<PropertyValue> results = new ArrayList<PropertyValue>(refs.length);
        block5: for (int i = 0; i < refs.length; ++i) {
            switch (refs[i].getPropertyId()) {
                case 8: {
                    int j;
                    int[] props = REQUIRED_PROPS;
                    for (j = 0; j < props.length; ++j) {
                        results.add(this.readProperty(props[j], -1));
                    }
                    props = OPTIONAL_PROPS;
                    for (j = 0; j < props.length; ++j) {
                        results.add(this.readProperty(props[j], -1));
                    }
                    continue block5;
                }
                case 80: {
                    int j;
                    int[] props = OPTIONAL_PROPS;
                    for (j = 0; j < props.length; ++j) {
                        results.add(this.readProperty(props[j], -1));
                    }
                    continue block5;
                }
                case 105: {
                    int j;
                    int[] props = REQUIRED_PROPS;
                    for (j = 0; j < props.length; ++j) {
                        results.add(this.readProperty(props[j], -1));
                    }
                    continue block5;
                }
                default: {
                    results.add(this.readProperty(refs[i].getPropertyId(), refs[i].getPropertyArrayIndex()));
                }
            }
        }
        return results.toArray(readResults);
    }

    @Override
    public final RangeData readRange(RangeReference rangeReference) throws RejectException {
        return new ReadRangeAck(2, 45);
    }

    @Override
    public final ErrorType writeProperty(PropertyValue val) throws BacnetException {
        return this.writeProperty(val.getPropertyId(), val.getPropertyArrayIndex(), val.getPropertyValue(), val.getPriority());
    }

    @Override
    public final ChangeListError addListElements(PropertyValue propertyValue) throws BacnetException {
        int i;
        int propertyId = propertyValue.getPropertyId();
        for (i = 0; i < REQUIRED_PROPS.length; ++i) {
            if (propertyId != REQUIRED_PROPS[i]) continue;
            return new NChangeListError(8, new NErrorType(5, 22), 0L);
        }
        for (i = 0; i < OPTIONAL_PROPS.length; ++i) {
            if (propertyId != OPTIONAL_PROPS[i]) continue;
            return new NChangeListError(8, new NErrorType(5, 22), 0L);
        }
        return new NChangeListError(8, new NErrorType(2, 32), 0L);
    }

    @Override
    public final ChangeListError removeListElements(PropertyValue propertyValue) throws BacnetException {
        int i;
        int propertyId = propertyValue.getPropertyId();
        for (i = 0; i < REQUIRED_PROPS.length; ++i) {
            if (propertyId != REQUIRED_PROPS[i]) continue;
            return new NChangeListError(9, new NErrorType(5, 22), 0L);
        }
        for (i = 0; i < OPTIONAL_PROPS.length; ++i) {
            if (propertyId != OPTIONAL_PROPS[i]) continue;
            return new NChangeListError(9, new NErrorType(5, 22), 0L);
        }
        return new NChangeListError(9, new NErrorType(2, 32), 0L);
    }

    protected PropertyValue readProperty(int pId, int ndx) {
        if (!this.isArray(pId) && ndx >= 0) {
            return new NReadPropertyResult(pId, ndx, new NErrorType(2, 50));
        }
        switch (pId) {
            case 75: {
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnObjectId(this.getObjectId()));
            }
            case 77: {
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnCharacterString(this.getObjectName()));
            }
            case 79: {
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnEnumerated(this.getObjectId().getObjectType()));
            }
            case 28: {
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnCharacterString(this.getDescription()));
            }
            case 208: {
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnEnumerated((BEnum)this.getNodeType()));
            }
            case 207: {
                return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnCharacterString(this.getNodeSubtype()));
            }
            case 211: {
                return this.readSubordinateList(ndx);
            }
            case 210: {
                return this.readSubordinateAnnotations(ndx);
            }
            case 371: {
                return this.readPropertyList(ndx);
            }
        }
        return new NReadPropertyResult(pId, ndx, new NErrorType(2, 32));
    }

    protected ErrorType writeProperty(int pId, int ndx, byte[] val, int pri) throws BacnetException {
        if (ndx >= 0 && !this.isArray(pId)) {
            return new NErrorType(2, 50);
        }
        try {
            switch (pId) {
                case 75: {
                    return new NErrorType(2, 40);
                }
                case 77: {
                    return BacUtil.setObjectName((BComponent)this, objectName, val);
                }
                case 79: {
                    return new NErrorType(2, 40);
                }
                case 28: {
                    this.setString(description, AsnUtil.fromAsnCharacterString(val), BLocalBacnetDevice.getBacnetContext());
                    return null;
                }
                case 208: {
                    return new NErrorType(2, 40);
                }
                case 207: {
                    return new NErrorType(2, 40);
                }
                case 211: {
                    return new NErrorType(2, 40);
                }
                case 210: {
                    return new NErrorType(2, 40);
                }
                case 371: {
                    return new NErrorType(2, 40);
                }
            }
            return new NErrorType(2, 32);
        }
        catch (AsnException e) {
            logger.info("AsnException writing property " + pId + " in object " + (Object)((Object)this.getObjectId()));
            return new NErrorType(2, 9);
        }
        catch (PermissionException e) {
            logger.info("PermissionException writing property " + pId + " in object " + (Object)((Object)this.getObjectId()) + ":" + (Object)((Object)e));
            return new NErrorType(2, 40);
        }
    }

    public String toString(Context c) {
        return this.getObjectName() + " [" + (Object)((Object)this.getObjectId()) + "]";
    }

    boolean isArray(int propertyId) {
        if (propertyId == 210) {
            return true;
        }
        if (propertyId == 211) {
            return true;
        }
        return propertyId == 371;
    }

    public boolean addSubordinate(BSvoSubordinate sub) {
        try {
            this.getSubordinates().addElement((BValue)sub);
            return true;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception in addSubordinate", e);
            return false;
        }
    }

    public boolean modifySubordinate(int index, BSvoSubordinate sub) {
        try {
            this.getSubordinates().setElement(index, (BValue)sub);
            return true;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception in modifySubordinate", e);
            return false;
        }
    }

    public boolean removeSubordinate(int index) {
        try {
            this.getSubordinates().removeElement(BInteger.make((int)index));
            return true;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception in removeSubordinate", e);
            return false;
        }
    }

    public int countLocalSubordinates() {
        SlotCursor c = this.getProperties();
        int count = 0;
        while (c.next(BIBacnetExportObject.class)) {
            ++count;
        }
        return count;
    }

    public BIBacnetExportObject[] getLocalSubordinates() {
        return (BIBacnetExportObject[])this.getChildren(BIBacnetExportObject.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NReadPropertyResult readSubordinateList(int ndx) {
        if (ndx == 0) {
            int exportCount = this.countLocalSubordinates();
            return new NReadPropertyResult(211, ndx, AsnUtil.toAsnUnsigned(exportCount + this.getSubordinates().getSize()));
        }
        if (ndx == -1) {
            AsnOutputStream exportCount = asnOut;
            synchronized (exportCount) {
                asnOut.reset();
                BIBacnetExportObject[] localSubs = this.getLocalSubordinates();
                for (int i = 0; i < localSubs.length; ++i) {
                    asnOut.writeObjectIdentifier(1, localSubs[i].getObjectId());
                }
                BSvoSubordinate[] subs = (BSvoSubordinate[])this.getSubordinates().getChildren(BSvoSubordinate.class);
                for (int i = 0; i < subs.length; ++i) {
                    subs[i].getReference().writeAsn(asnOut);
                }
                return new NReadPropertyResult(211, ndx, asnOut.toByteArray());
            }
        }
        int exportCount = this.countLocalSubordinates();
        if (ndx < 0 || ndx > exportCount + this.getSubordinates().getSize()) {
            return new NReadPropertyResult(211, ndx, new NErrorType(2, 42));
        }
        if (ndx <= exportCount) {
            BIBacnetExportObject[] localSubs = this.getLocalSubordinates();
            AsnOutputStream asnOutputStream = asnOut;
            synchronized (asnOutputStream) {
                asnOut.reset();
                asnOut.writeObjectIdentifier(1, localSubs[ndx - 1].getObjectId());
                return new NReadPropertyResult(211, ndx, asnOut.toByteArray());
            }
        }
        return new NReadPropertyResult(211, ndx, AsnUtil.toAsn((BValue)((BSvoSubordinate)this.getSubordinates().getElement(ndx - exportCount)).getReference()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NReadPropertyResult readSubordinateAnnotations(int ndx) {
        if (ndx == 0) {
            int exportCount = this.countLocalSubordinates();
            return new NReadPropertyResult(210, ndx, AsnUtil.toAsnUnsigned(exportCount + this.getSubordinates().getSize()));
        }
        if (ndx == -1) {
            AsnOutputStream exportCount = asnOut;
            synchronized (exportCount) {
                asnOut.reset();
                BIBacnetExportObject[] localSubs = this.getLocalSubordinates();
                for (int i = 0; i < localSubs.length; ++i) {
                    asnOut.writeCharacterString((BString)((BComplex)localSubs[i]).get("description"));
                }
                BSvoSubordinate[] subs = (BSvoSubordinate[])this.getSubordinates().getChildren(BSvoSubordinate.class);
                for (int i = 0; i < subs.length; ++i) {
                    asnOut.writeCharacterString(subs[i].getAnnotation());
                }
                return new NReadPropertyResult(210, ndx, asnOut.toByteArray());
            }
        }
        int exportCount = this.countLocalSubordinates();
        if (ndx < 0 || ndx > exportCount + this.getSubordinates().getSize()) {
            return new NReadPropertyResult(210, ndx, new NErrorType(2, 42));
        }
        if (ndx <= exportCount) {
            BIBacnetExportObject[] localSubs = this.getLocalSubordinates();
            AsnOutputStream asnOutputStream = asnOut;
            synchronized (asnOutputStream) {
                asnOut.reset();
                asnOut.writeCharacterString((BString)((BComplex)localSubs[ndx - 1]).get("description"));
                return new NReadPropertyResult(210, ndx, asnOut.toByteArray());
            }
        }
        return new NReadPropertyResult(210, ndx, AsnUtil.toAsnCharacterString(((BSvoSubordinate)this.getSubordinates().getElement(ndx - exportCount)).getAnnotation()));
    }

    @Override
    public final boolean isFatalFault() {
        return this.fatalFault;
    }

    private void checkFatalFault() {
        BBacnetExportTable exports = null;
        BLocalBacnetDevice local = null;
        BBacnetNetwork network = null;
        if (this.fatalFault) {
            return;
        }
        for (BComplex parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (parent instanceof BBacnetExportTable) {
                exports = (BBacnetExportTable)parent;
                continue;
            }
            if (!(parent instanceof BLocalBacnetDevice)) continue;
            local = (BLocalBacnetDevice)parent;
            break;
        }
        if (exports == null || local == null) {
            this.fatalFault = true;
            this.setFaultCause("Not under LocalBacnetDevice Export Table");
            return;
        }
        if (local.isFatalFault()) {
            this.fatalFault = true;
            this.setFaultCause("LocalDevice fault: " + local.getFaultCause());
            return;
        }
        network = (BBacnetNetwork)local.getParent();
        if (network == null) {
            this.fatalFault = true;
            this.setFaultCause("Not under BacnetNetwork");
            return;
        }
        if (network.isFatalFault()) {
            this.fatalFault = true;
            this.setFaultCause("Network fault: " + network.getFaultCause());
            return;
        }
        Feature feature = network.getLicenseFeature();
        boolean serverLicensed = feature.getb("export", false);
        if (!serverLicensed) {
            this.fatalFault = true;
            this.setFaultCause("Server capability not licensed");
            return;
        }
        this.setFaultCause("");
    }

    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        out.startProps();
        out.trTitle((Object)"BacnetStructuredViewDescriptor", 2);
        out.prop((Object)"fatalFault", this.fatalFault);
        out.prop((Object)"oldId", (Object)this.oldId);
        out.prop((Object)"oldName", (Object)this.oldName);
        out.prop((Object)"duplicate", this.duplicate);
        out.endProps();
    }

    public BIcon getIcon() {
        return icon;
    }

    public AgentList getAgents(Context cx) {
        AgentList agents = super.getAgents(cx);
        agents.toTop("bacnet:BacnetExportManager");
        return agents;
    }

    @Override
    public int[] getPropertyList() {
        return BacnetPropertyList.makePropertyList(REQUIRED_PROPS, OPTIONAL_PROPS);
    }
}

