/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack.link.ip;

import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.data.BIDataValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BFdtEntry
extends BStruct {
    public static final Property bacnetIPAddress = BFdtEntry.newProperty((int)0, (String)"", null);
    public static final Property timeToLive = BFdtEntry.newProperty((int)0, (int)-1, null);
    public static final Property purgeTime = BFdtEntry.newProperty((int)3, (BValue)BAbsTime.NULL, null);
    public static final Type TYPE = Sys.loadType(BFdtEntry.class);
    private static final Context TIME_CX = BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.TRUE);

    public String getBacnetIPAddress() {
        return this.getString(bacnetIPAddress);
    }

    public void setBacnetIPAddress(String v) {
        this.setString(bacnetIPAddress, v, null);
    }

    public int getTimeToLive() {
        return this.getInt(timeToLive);
    }

    public void setTimeToLive(int v) {
        this.setInt(timeToLive, v, null);
    }

    public BAbsTime getPurgeTime() {
        return (BAbsTime)this.get(purgeTime);
    }

    public void setPurgeTime(BAbsTime v) {
        this.set(purgeTime, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BFdtEntry() {
    }

    public BFdtEntry(String bacnetIPAddress, int timeToLive, BAbsTime purgeTime) {
        this.setBacnetIPAddress(bacnetIPAddress);
        this.setTimeToLive(timeToLive);
        this.setPurgeTime(purgeTime);
    }

    public byte[] getBIpAddr() {
        return BBacnetAddress.stringToBytes(2, 5, this.getBacnetIPAddress());
    }

    public void setBIpAddr(byte[] bipAddr) {
        this.setBacnetIPAddress(BBacnetAddress.bytesToString(2, bipAddr));
    }

    public boolean isAddressValid() {
        try {
            this.getBIpAddr();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String toString(Context cx) {
        StringBuilder sb = new StringBuilder();
        sb.append("B/IP addr:" + this.getBacnetIPAddress());
        sb.append("  TTL:" + this.getTimeToLive());
        sb.append("  PrgTm:" + this.getPurgeTime().toString(TIME_CX));
        return sb.toString();
    }
}

