/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.stack;

import com.tridium.bacnet.stack.BBacnetPollOrder;
import com.tridium.bacnet.stack.network.BNetworkPort;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.util.BIBacnetPollable;
import javax.baja.bacnet.util.PollList;
import javax.baja.bacnet.util.PollListEntry;
import javax.baja.data.BIDataValue;
import javax.baja.driver.util.BAbstractPollService;
import javax.baja.driver.util.BIPollable;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

public class BBacnetPoll
extends BAbstractPollService
implements Runnable {
    public static final Property fastRate = BBacnetPoll.newProperty((int)0, (BValue)BRelTime.make((long)1000L), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)1L)));
    public static final Property normalRate = BBacnetPoll.newProperty((int)0, (BValue)BRelTime.make((long)5000L), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)1L)));
    public static final Property slowRate = BBacnetPoll.newProperty((int)0, (BValue)BRelTime.make((long)30000L), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)1L)));
    public static final Property statisticsStart = BBacnetPoll.newProperty((int)3, (BValue)BAbsTime.NULL, null);
    public static final Property averagePoll = BBacnetPoll.newProperty((int)3, (String)"-", null);
    public static final Property busyTime = BBacnetPoll.newProperty((int)3, (String)"-", null);
    public static final Property totalPolls = BBacnetPoll.newProperty((int)3, (String)"-", null);
    public static final Property dibsPolls = BBacnetPoll.newProperty((int)3, (String)"-", null);
    public static final Property fastPolls = BBacnetPoll.newProperty((int)3, (String)"-", null);
    public static final Property normalPolls = BBacnetPoll.newProperty((int)3, (String)"-", null);
    public static final Property slowPolls = BBacnetPoll.newProperty((int)3, (String)"-", null);
    public static final Property dibsCount = BBacnetPoll.newProperty((int)3, (String)"-", null);
    public static final Property fastCount = BBacnetPoll.newProperty((int)3, (String)"-", null);
    public static final Property normalCount = BBacnetPoll.newProperty((int)3, (String)"-", null);
    public static final Property slowCount = BBacnetPoll.newProperty((int)3, (String)"-", null);
    public static final Property fastCycleTime = BBacnetPoll.newProperty((int)3, (String)"-", null);
    public static final Property normalCycleTime = BBacnetPoll.newProperty((int)3, (String)"-", null);
    public static final Property slowCycleTime = BBacnetPoll.newProperty((int)3, (String)"-", null);
    public static final Property deviceCount = BBacnetPoll.newProperty((int)7, (int)0, null);
    public static final Property pointCount = BBacnetPoll.newProperty((int)3, (int)0, null);
    public static final Property objectCount = BBacnetPoll.newProperty((int)3, (int)0, null);
    public static final Property virtualCount = BBacnetPoll.newProperty((int)3, (int)0, null);
    public static final Action resetStatistics = BBacnetPoll.newAction((int)128, null);
    public static final Action rebuildPollLists = BBacnetPoll.newAction((int)128, null);
    public static final Type TYPE = Sys.loadType(BBacnetPoll.class);
    protected static final DecimalFormat timeFormat = new DecimalFormat("0.0#ms");
    boolean isAlive;
    Thread thread;
    protected long start;
    protected long lastPollTime;
    protected long totalPollTime;
    protected int totalPollCount;
    protected double average;
    protected Stack<PollList> dibs = new Stack();
    protected int dibsPollTotal;
    protected int dibsSizeTotal;
    protected Object lock = new Object();
    protected int statsCount;
    protected BacnetBucket fast;
    protected BacnetBucket norm;
    protected BacnetBucket slow;
    private BBacnetPollOrder pollOrder = null;
    protected long subTime = 0L;
    protected int subs = 0;
    protected long unsubTime = 0L;
    protected int unsubs = 0;
    protected long getPLEsSubTime = 0L;
    protected long getPLEsUnsubTime = 0L;
    protected long dibsSubTime = 0L;
    protected long pleAddTime = 0L;
    protected int pleAdds = 0;
    protected int pleRems = 0;
    protected long dibsUnsubTime = 0L;
    protected long pleRemTime = 0L;
    private int splitCount = 0;
    public static final String SPLIT_COUNT = "splitOnFailure";
    private long lastRepackTime = -1L;
    private long repackInterval = -1L;
    public static final String REPACK_INTERVAL = "repackInterval";
    protected Logger logger = Logger.getLogger("bacnet.point");
    private static final int DOUBLE_PLE_SIZE = -1;

    public BRelTime getFastRate() {
        return (BRelTime)this.get(fastRate);
    }

    public void setFastRate(BRelTime v) {
        this.set(fastRate, (BValue)v, null);
    }

    public BRelTime getNormalRate() {
        return (BRelTime)this.get(normalRate);
    }

    public void setNormalRate(BRelTime v) {
        this.set(normalRate, (BValue)v, null);
    }

    public BRelTime getSlowRate() {
        return (BRelTime)this.get(slowRate);
    }

    public void setSlowRate(BRelTime v) {
        this.set(slowRate, (BValue)v, null);
    }

    public BAbsTime getStatisticsStart() {
        return (BAbsTime)this.get(statisticsStart);
    }

    public void setStatisticsStart(BAbsTime v) {
        this.set(statisticsStart, (BValue)v, null);
    }

    public String getAveragePoll() {
        return this.getString(averagePoll);
    }

    public void setAveragePoll(String v) {
        this.setString(averagePoll, v, null);
    }

    public String getBusyTime() {
        return this.getString(busyTime);
    }

    public void setBusyTime(String v) {
        this.setString(busyTime, v, null);
    }

    public String getTotalPolls() {
        return this.getString(totalPolls);
    }

    public void setTotalPolls(String v) {
        this.setString(totalPolls, v, null);
    }

    public String getDibsPolls() {
        return this.getString(dibsPolls);
    }

    public void setDibsPolls(String v) {
        this.setString(dibsPolls, v, null);
    }

    public String getFastPolls() {
        return this.getString(fastPolls);
    }

    public void setFastPolls(String v) {
        this.setString(fastPolls, v, null);
    }

    public String getNormalPolls() {
        return this.getString(normalPolls);
    }

    public void setNormalPolls(String v) {
        this.setString(normalPolls, v, null);
    }

    public String getSlowPolls() {
        return this.getString(slowPolls);
    }

    public void setSlowPolls(String v) {
        this.setString(slowPolls, v, null);
    }

    public String getDibsCount() {
        return this.getString(dibsCount);
    }

    public void setDibsCount(String v) {
        this.setString(dibsCount, v, null);
    }

    public String getFastCount() {
        return this.getString(fastCount);
    }

    public void setFastCount(String v) {
        this.setString(fastCount, v, null);
    }

    public String getNormalCount() {
        return this.getString(normalCount);
    }

    public void setNormalCount(String v) {
        this.setString(normalCount, v, null);
    }

    public String getSlowCount() {
        return this.getString(slowCount);
    }

    public void setSlowCount(String v) {
        this.setString(slowCount, v, null);
    }

    public String getFastCycleTime() {
        return this.getString(fastCycleTime);
    }

    public void setFastCycleTime(String v) {
        this.setString(fastCycleTime, v, null);
    }

    public String getNormalCycleTime() {
        return this.getString(normalCycleTime);
    }

    public void setNormalCycleTime(String v) {
        this.setString(normalCycleTime, v, null);
    }

    public String getSlowCycleTime() {
        return this.getString(slowCycleTime);
    }

    public void setSlowCycleTime(String v) {
        this.setString(slowCycleTime, v, null);
    }

    public int getDeviceCount() {
        return this.getInt(deviceCount);
    }

    public void setDeviceCount(int v) {
        this.setInt(deviceCount, v, null);
    }

    public int getPointCount() {
        return this.getInt(pointCount);
    }

    public void setPointCount(int v) {
        this.setInt(pointCount, v, null);
    }

    public int getObjectCount() {
        return this.getInt(objectCount);
    }

    public void setObjectCount(int v) {
        this.setInt(objectCount, v, null);
    }

    public int getVirtualCount() {
        return this.getInt(virtualCount);
    }

    public void setVirtualCount(int v) {
        this.setInt(virtualCount, v, null);
    }

    public void resetStatistics() {
        this.invoke(resetStatistics, null, null);
    }

    public void rebuildPollLists() {
        this.invoke(rebuildPollLists, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public String toString(Context cx) {
        if (this.isRunning()) {
            return "BacnetPoll in " + this.getParent().getName();
        }
        return "BacnetPoll";
    }

    public void started() throws Exception {
        super.started();
        this.setSplitCount(this.getProperty(SPLIT_COUNT));
        this.setRepackInterval(this.getProperty(REPACK_INTERVAL));
    }

    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isRunning()) {
            return;
        }
        if (!this.isAlive) {
            return;
        }
        if (p.equals(fastRate)) {
            this.fast.resetTicks();
        } else if (p.equals(normalRate)) {
            this.norm.resetTicks();
        } else if (p.equals(slowRate)) {
            this.slow.resetTicks();
        } else if (SPLIT_COUNT.equals(p.getName())) {
            this.setSplitCount(p);
        } else if (REPACK_INTERVAL.equals(p.getName())) {
            this.setRepackInterval(p);
        }
    }

    public final boolean isParentLegal(BComponent parent) {
        return parent instanceof BNetworkPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void poll(PollList pl) {
        long t1;
        block18: {
            t1 = Clock.ticks();
            try {
                if (!this.getPollEnabled()) {
                    if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.fine("BBacnetPoll#poll: skipping disabled poll list: " + (pl != null ? pl.debug() : "null"));
                    }
                    return;
                }
                BBacnetDevice device = pl.getDevice();
                if (device.isRunning()) {
                    boolean pollOk = device.poll(pl);
                    if (pollOk) {
                        pl.resetFailedCount();
                        break block18;
                    }
                    if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.fine("BBacnetPoll#poll: poll failed; split count = " + this.splitCount + "; poll list = " + pl.debug());
                    }
                    Object object = this.lock;
                    synchronized (object) {
                        if (this.splitCount >= 0) {
                            pl.incrementFailedCount();
                            if (pl.size() > 1 && pl.getFailedCount() > this.splitCount) {
                                if (this.logger.isLoggable(Level.FINE)) {
                                    this.logger.fine("Redistributing items in poll list:\n " + pl);
                                }
                                this.redistribute(pl);
                            } else if (this.logger.isLoggable(Level.FINE)) {
                                this.logger.fine("Cannot break down the poll list further:\n " + pl);
                            }
                        }
                        break block18;
                    }
                }
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine("BBacnetPoll#poll: poll list's device is not running; poll list = " + pl.debug());
                }
                try {
                    this.getQueue(pl.getPollFrequency()).remove(pl);
                }
                catch (Exception e) {
                    this.logger.log(Level.SEVERE, "BBacnetPoll#poll: Exception removing poll list from queue for stopped device; poll list = " + pl.debug(), e);
                }
            }
            catch (Throwable e) {
                this.logger.log(Level.SEVERE, "BBacnetPoll#poll: Poll exception on " + pl.debug(), e);
            }
        }
        this.lastPollTime = Clock.ticks() - t1;
        ++this.totalPollCount;
        this.totalPollTime += this.lastPollTime;
        this.average = (double)this.totalPollTime / (double)this.totalPollCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeBuckets() {
        Object object = this.lock;
        synchronized (object) {
            if (this.fast == null) {
                this.fast = new BacnetBucket(fastRate);
            }
            if (this.norm == null) {
                this.norm = new BacnetBucket(normalRate);
            }
            if (this.slow == null) {
                this.slow = new BacnetBucket(slowRate);
            }
            this.rebuildPollBucket(this.getQueue(0));
            this.rebuildPollBucket(this.getQueue(2));
            this.rebuildPollBucket(this.getQueue(1));
        }
    }

    public void pollStart() {
        this.initializeBuckets();
        this.doResetStatistics();
        this.pollStop();
        this.isAlive = true;
        this.thread = new Thread((Runnable)this, "BacnetPoll" + ((BNetworkPort)this.getParent()).getPortId());
        this.thread.start();
    }

    public void pollStop() {
        this.isAlive = false;
        if (this.thread != null) {
            this.thread.interrupt();
        }
    }

    public int getNumberOfThreads() {
        return 1;
    }

    @Override
    public void run() {
        long stats = Clock.ticks() + 10000L;
        while (this.isAlive) {
            try {
                if (!this.getPollEnabled()) {
                    Thread.sleep(1000L);
                    continue;
                }
                this.pollDibs();
                this.pollQueues();
                long sleep = this.computeSleep();
                if (sleep > 0L) {
                    Thread.sleep(sleep);
                }
                if (Clock.ticks() <= stats) continue;
                this.checkBucketConfig();
                this.updateStats();
                stats = Clock.ticks() + 10000L;
            }
            catch (InterruptedException sleep) {
            }
            catch (Throwable e) {
                this.logger.log(Level.SEVERE, "Poll runnable exception occurred: ", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pollDibs() {
        while (true) {
            PollList next = null;
            Object object = this.lock;
            synchronized (object) {
                if (this.dibs.isEmpty()) {
                    return;
                }
                next = this.dibs.pop();
                ++this.dibsPollTotal;
            }
            this.poll(next);
        }
    }

    private void pollQueues() {
        this.pollQueue(this.fast);
        this.pollQueue(this.norm);
        this.pollQueue(this.slow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pollQueue(BacnetBucket bucket) {
        long rate;
        if (bucket.nextTicks > Clock.ticks() + 5L) {
            return;
        }
        PollList p = null;
        int size = 0;
        Object object = this.lock;
        synchronized (object) {
            int index = bucket.index;
            size = bucket.q.size();
            if (size > 0) {
                if (index >= size) {
                    index = 0;
                    ++bucket.cycleTotal;
                }
                p = bucket.q.get(index);
                bucket.index = index + 1;
            } else {
                ++bucket.cycleTotal;
            }
        }
        if (p != null) {
            this.poll(p);
            ++bucket.pollTotal;
        }
        long sleep = rate = ((BRelTime)this.get(bucket.rateProp)).getMillis();
        if (size > 0) {
            double dRate = rate;
            double dSize = size;
            sleep = (long)((dRate - dSize * (double)this.lastPollTime) / dSize);
        }
        bucket.nextTicks = Clock.ticks() + sleep;
    }

    protected long computeSleep() {
        long now = Clock.ticks();
        long sleep = 1000L;
        sleep = Math.min(this.fast.nextTicks - now, sleep);
        sleep = Math.min(this.norm.nextTicks - now, sleep);
        sleep = Math.min(this.slow.nextTicks - now, sleep);
        return sleep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkBucketConfig() {
        Object object = this.lock;
        synchronized (object) {
            if (this.pollFrequencyChanged()) {
                ArrayList<PollList> newFast = new ArrayList<PollList>();
                ArrayList<PollList> newNorm = new ArrayList<PollList>();
                ArrayList<PollList> newSlow = new ArrayList<PollList>();
                BBacnetPoll.reSort(this.fast.q, newFast, newNorm, newSlow);
                BBacnetPoll.reSort(this.norm.q, newFast, newNorm, newSlow);
                BBacnetPoll.reSort(this.slow.q, newFast, newNorm, newSlow);
                this.fast.q = newFast;
                this.norm.q = newNorm;
                this.slow.q = newSlow;
            }
        }
    }

    private boolean pollFrequencyChanged() {
        return this.pollFrequencyChanged(this.fast, 0) || this.pollFrequencyChanged(this.norm, 1) || this.pollFrequencyChanged(this.slow, 2);
    }

    private boolean pollFrequencyChanged(BacnetBucket bucket, int pollFrequency) {
        List<PollList> pollLists = bucket.q;
        for (int i = 0; i < pollLists.size(); ++i) {
            PollList pl = pollLists.get(i);
            if (pollFrequency == pl.getPollFrequency()) continue;
            return false;
        }
        return true;
    }

    protected static void reSort(List<PollList> orig, List<PollList> newFast, List<PollList> newNorm, List<PollList> newSlow) {
        int size = orig.size();
        block5: for (int i = 0; i < size; ++i) {
            PollList pl = orig.get(i);
            switch (pl.getPollFrequency()) {
                case 0: {
                    newFast.add(pl);
                    continue block5;
                }
                case 1: {
                    newNorm.add(pl);
                    continue block5;
                }
                case 2: {
                    newSlow.add(pl);
                    continue block5;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    public void doResetStatistics() {
        this.totalPollTime = 0L;
        this.totalPollCount = 0;
        this.average = 0.0;
        this.statsCount = 0;
        this.dibsPollTotal = 0;
        this.dibsSizeTotal = 0;
        this.fast.reset();
        this.norm.reset();
        this.slow.reset();
        this.start = Clock.ticks();
        this.setStatisticsStart(BAbsTime.make());
        this.updateStats();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRebuildPollLists() {
        Object object = this.lock;
        synchronized (object) {
            this.rebuildQueue(this.fast.q);
            this.rebuildQueue(this.norm.q);
            this.rebuildQueue(this.slow.q);
        }
    }

    protected void updateStats() {
        long now = Clock.ticks();
        long uptime = now - this.start;
        ++this.statsCount;
        this.setAveragePoll(timeFormat.format(this.average));
        if (this.totalPollTime > 0L) {
            double totalPollTimeByThd = (double)this.totalPollTime / (double)this.getNumberOfThreads();
            this.setBusyTime("" + (int)(100.0 * totalPollTimeByThd / (double)uptime) + "% (" + BBacnetPoll.duration(this.totalPollTime) + "/" + BBacnetPoll.duration(uptime) + " over " + this.getNumberOfThreads() + " thds");
        }
        this.setTotalPolls("" + BBacnetPoll.count(this.totalPollCount) + " over " + BBacnetPoll.duration(this.totalPollTime));
        this.setDibsPolls(this.toPollTotal(this.dibsPollTotal));
        this.setFastPolls(this.toPollTotal(this.fast.pollTotal));
        this.setNormalPolls(this.toPollTotal(this.norm.pollTotal));
        this.setSlowPolls(this.toPollTotal(this.slow.pollTotal));
        this.setDibsCount(this.toCount(this.dibs.size(), this.dibsSizeTotal));
        this.dibsSizeTotal += this.dibs.size();
        this.setFastCount(this.toCount(this.fast.q.size(), this.fast.sizeTotal));
        this.fast.sizeTotal += this.fast.q.size();
        this.setNormalCount(this.toCount(this.norm.q.size(), this.norm.sizeTotal));
        this.norm.sizeTotal += this.norm.q.size();
        this.setSlowCount(this.toCount(this.slow.q.size(), this.slow.sizeTotal));
        this.slow.sizeTotal += this.slow.q.size();
        this.setFastCycleTime(this.toCycle(this.fast, uptime));
        this.setNormalCycleTime(this.toCycle(this.norm, uptime));
        this.setSlowCycleTime(this.toCycle(this.slow, uptime));
    }

    protected String toPollTotal(int bucketTotal) {
        int total = this.totalPollCount;
        StringBuilder s = new StringBuilder();
        if (total == 0) {
            s.append('-');
        } else {
            s.append((int)(100.0 * (double)bucketTotal / (double)total));
        }
        s.append("% (").append(BBacnetPoll.count(bucketTotal)).append('/').append(BBacnetPoll.count(total)).append(')');
        return s.toString();
    }

    protected String toCount(int current, int total) {
        return "current=" + current + " average=" + total / this.statsCount;
    }

    protected String toCycle(BacnetBucket bucket, long uptime) {
        int cycles = bucket.cycleTotal;
        if (cycles == 0) {
            return "-";
        }
        return "average = " + uptime / (long)cycles + "ms";
    }

    protected static String count(int count) {
        if (count < 10000) {
            return String.valueOf(count);
        }
        return String.valueOf(count / 1000) + "k";
    }

    protected static String duration(long duration) {
        if (duration < 10000L) {
            return String.valueOf(duration) + "ms";
        }
        return String.valueOf(duration / 1000L) + "sec";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pollNow(BIBacnetPollable p) {
        if (p.getPollableType() == 0) {
            return;
        }
        PollListEntry[] ples = p.getPollListEntries();
        if (ples == null) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            for (int i = 0; i < ples.length; ++i) {
                if (ples[i].getDevice().getStatus().isDown()) continue;
                this.add(this.dibs, ples[i], true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(BIPollable p) {
        long tmp;
        long t0 = Clock.ticks();
        if (!(p instanceof BIBacnetPollable)) {
            throw new IllegalArgumentException(Lexicon.make((String)"bacnet").getText("IllegalArgumentException.notBacnetPollable"));
        }
        if (!this.isAlive) {
            return;
        }
        BIBacnetPollable bp = (BIBacnetPollable)p;
        long t1 = Clock.ticks();
        this.pollNow(bp);
        long t2 = Clock.ticks();
        long t6 = Clock.ticks();
        PollListEntry[] ples = bp.getPollListEntries();
        long t7 = Clock.ticks();
        Object object = this.lock;
        synchronized (object) {
            int pollType = bp.getPollableType();
            switch (pollType) {
                case 0: {
                    this.logger.warning("BBacnetPoll.subscribe(device) no longer used!");
                    break;
                }
                case 1: {
                    this.setPointCount(this.getPointCount() + 1);
                    break;
                }
                case 5: {
                    this.setPointCount(this.getPointCount() + 1);
                    break;
                }
                case 2: {
                    this.setObjectCount(this.getObjectCount() + 1);
                    break;
                }
                case 3: {
                    this.setVirtualCount(this.getVirtualCount() + 1);
                    break;
                }
            }
            if (ples == null) {
                return;
            }
            tmp = 0L;
            for (int i = 0; i < ples.length; ++i) {
                long t3 = Clock.ticks();
                List<PollList> bucket = this.getQueue(bp.getPollFrequency().getOrdinal());
                this.add(bucket, ples[i], false);
                long t4 = Clock.ticks();
                ++this.pleAdds;
                tmp += t4 - t3;
            }
        }
        long t5 = Clock.ticks();
        ++this.subs;
        this.subTime += t5 - t0;
        this.dibsSubTime += t2 - t1;
        this.pleAddTime += tmp;
        this.getPLEsSubTime += t7 - t6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unsubscribe(BIPollable p) {
        long tmp2;
        long tmp1;
        long t0 = Clock.ticks();
        if (!(p instanceof BIBacnetPollable)) {
            throw new IllegalArgumentException(Lexicon.make((String)"bacnet").getText("IllegalArgumentException.notBacnetPollable"));
        }
        if (!this.isAlive) {
            return false;
        }
        BIBacnetPollable bp = (BIBacnetPollable)p;
        long t5 = Clock.ticks();
        PollListEntry[] ples = bp.getPollListEntries();
        long t6 = Clock.ticks();
        boolean removed = false;
        Object object = this.lock;
        synchronized (object) {
            int pollType = bp.getPollableType();
            if (ples == null) {
                return false;
            }
            tmp1 = 0L;
            tmp2 = 0L;
            for (int i = 0; i < ples.length; ++i) {
                boolean pleRemoved = true;
                long t1 = Clock.ticks();
                pleRemoved = this.remove(this.dibs, ples[i]);
                long t2 = Clock.ticks();
                pleRemoved = this.remove(this.fast.q, ples[i]);
                if (!pleRemoved) {
                    pleRemoved = this.remove(this.norm.q, ples[i]);
                }
                if (!pleRemoved) {
                    pleRemoved = this.remove(this.slow.q, ples[i]);
                }
                long t3 = Clock.ticks();
                ++this.pleRems;
                tmp1 += t2 - t1;
                tmp2 += t3 - t2;
                removed |= pleRemoved;
            }
            if (removed) {
                switch (pollType) {
                    case 0: {
                        this.logger.warning("BBacnetPoll.unsubscribe(device) no longer used!");
                        break;
                    }
                    case 1: {
                        this.setPointCount(this.getPointCount() - 1);
                        break;
                    }
                    case 5: {
                        this.setPointCount(this.getPointCount() - 1);
                        break;
                    }
                    case 2: {
                        this.setObjectCount(this.getObjectCount() - 1);
                        break;
                    }
                    case 3: {
                        this.setVirtualCount(this.getVirtualCount() - 1);
                        break;
                    }
                }
            }
        }
        long t4 = Clock.ticks();
        ++this.unsubs;
        this.dibsUnsubTime += tmp1;
        this.pleRemTime += tmp2;
        this.unsubTime += t4 - t0;
        this.getPLEsUnsubTime += t6 - t5;
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void removePLE(BIBacnetPollable p, PollListEntry ple) {
        Object object = this.lock;
        synchronized (object) {
            this.remove(this.getQueue(p.getPollFrequency().getOrdinal()), ple);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean contains(List<PollList> list, PollListEntry ple) {
        Object object = this.lock;
        synchronized (object) {
            for (PollList pl : list) {
                if (!pl.contains(ple)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void redistribute(PollList pl) {
        Object object = this.lock;
        synchronized (object) {
            this.setSize(pl, -1);
            List<PollList> queue = this.getQueue(pl.getPollFrequency());
            queue.remove(pl);
            PollListEntry[] entries = pl.getPollEntries();
            for (int i = 0; i < entries.length; ++i) {
                this.addEntryToNewPollList(queue, entries[i]);
            }
        }
    }

    private void rebuildQueue(List<PollList> queue) {
        int i;
        ArrayList<PollListEntry> entryList = new ArrayList<PollListEntry>();
        for (i = 0; i < queue.size(); ++i) {
            PollList pl = queue.get(i);
            PollListEntry[] ples = pl.getPollEntries();
            for (int j = 0; j < ples.length; ++j) {
                if (ples[j] == null) continue;
                entryList.add(ples[j]);
            }
        }
        queue.clear();
        for (i = 0; i < entryList.size(); ++i) {
            PollListEntry entry = (PollListEntry)entryList.get(i);
            this.add(queue, entry, false);
        }
        this.sortPollList(queue);
    }

    private void rebuildPollBucket(List<PollList> queue) {
        for (int i = 0; i < queue.size(); ++i) {
            PollList pl = queue.get(i);
            this.setSize(pl, 11);
        }
        this.rebuildQueue(queue);
    }

    private void setSize(PollList pl, int size) {
        PollListEntry[] entries = pl.getPollEntries();
        for (int i = 0; i < entries.length; ++i) {
            PollListEntry entry = entries[i];
            if (entry == null) continue;
            if (size == -1) {
                entry.doubleDataSize(pl.getDevice().getMaxAPDULengthAccepted());
                continue;
            }
            int newSize = Math.min(pl.getDevice().getMaxAPDULengthAccepted(), size);
            entry.setDataSize(newSize);
        }
    }

    private void addEntryToNewPollList(List<PollList> list, PollListEntry ple) {
        this.add(list, ple, false, true);
    }

    private void add(List<PollList> list, PollListEntry ple, boolean push) {
        this.add(list, ple, push, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(List<PollList> list, PollListEntry ple, boolean push, boolean newList) {
        if (!this.pleExists(list, ple)) {
            Object object = this.lock;
            synchronized (object) {
                PollList pl;
                BBacnetDevice device = ple.getDevice();
                Iterator<PollList> it = list.iterator();
                boolean added = false;
                while (!added && it.hasNext()) {
                    pl = it.next();
                    if (device != pl.getDevice() || newList && pl.polcnt != 0 || pl.isPolling() || pl.getDataSize() + ple.getDataSize() >= this.getMaxDataSize(pl)) continue;
                    pl.add(ple);
                    added = true;
                    break;
                }
                if (!added) {
                    pl = new PollList(ple);
                    if (push) {
                        ((Stack)list).push(pl);
                    } else {
                        list.add(pl);
                    }
                }
            }
        }
    }

    private int getMaxDataSize(PollList pl) {
        int myMax;
        int maxDataSize = pl.getDevice().getMaxAPDULengthAccepted();
        if (maxDataSize > (myMax = BBacnetNetwork.localDevice().getMaxAPDULengthAccepted())) {
            maxDataSize = myMax;
        }
        return maxDataSize - 5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean remove(List<PollList> list, PollListEntry ple) {
        Object object = this.lock;
        synchronized (object) {
            BBacnetDevice device = ple.getDevice();
            boolean removed = false;
            PollList toRemove = null;
            PollList newList = null;
            for (int i = 0; i < list.size(); ++i) {
                PollList pl = list.get(i);
                if (device != pl.getDevice() || !pl.contains(ple)) continue;
                PollListEntry[] entries = pl.getPollEntries();
                if (!pl.isPolling() && pl.isDone()) {
                    removed = pl.remove(ple);
                    if (pl.size() != 0) break;
                    toRemove = pl;
                    break;
                }
                toRemove = pl;
                for (int j = 0; j < entries.length; ++j) {
                    if (entries[j].equals(ple)) continue;
                    if (newList == null) {
                        newList = new PollList(entries[j]);
                        continue;
                    }
                    newList.add(entries[j]);
                }
                break;
            }
            if (toRemove != null) {
                list.remove(toRemove);
                if (newList != null) {
                    newList.setDone(true);
                    list.add(newList);
                }
                removed = true;
            }
            return removed;
        }
    }

    private void sortPollList(List<PollList> queue) {
        if (this.pollOrder != null) {
            this.pollOrder.sort(queue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<PollList> getQueue(int pf) {
        Object object = this.lock;
        synchronized (object) {
            switch (pf) {
                case 0: {
                    return this.fast.q;
                }
                case 2: {
                    return this.slow.q;
                }
                case 1: {
                    return this.norm.q;
                }
            }
            return this.norm.q;
        }
    }

    protected void setPollOrder(BBacnetPollOrder newPollOrder) {
        if (newPollOrder == null) {
            this.pollOrder = null;
        } else if (this.pollOrder != newPollOrder) {
            if (this.pollOrder == null && newPollOrder.getEnabled()) {
                this.pollOrder = newPollOrder;
            } else {
                newPollOrder.setEnabled(false);
                newPollOrder.setFaultCause(Lexicon.make((String)"bacnet").getText("BacnetPoll.onlyOnePollOrderingPerPollService"));
            }
        }
    }

    protected int getSplitCount() {
        return this.splitCount;
    }

    private void setSplitCount(Property p) {
        BValue splitCountValue;
        if (p != null && (splitCountValue = this.get(p)) != null && splitCountValue instanceof BInteger) {
            this.splitCount = ((BInteger)splitCountValue).getInt();
        }
    }

    protected boolean getTimeToRepack() {
        if (this.lastRepackTime == -1L || this.repackInterval == -1L) {
            return false;
        }
        return Clock.ticks() > this.lastRepackTime + this.repackInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRepackInterval(Property p) {
        Object object = this.lock;
        synchronized (object) {
            BValue repackValue;
            if (p != null && (repackValue = this.get(p)) != null && repackValue instanceof BRelTime) {
                this.repackInterval = ((BRelTime)repackValue).getMillis();
                this.lastRepackTime = Clock.ticks();
            }
        }
    }

    protected void setLastRepackTime(long lastRepackTime) {
        this.lastRepackTime = lastRepackTime;
    }

    private boolean pleExists(List<PollList> list, PollListEntry ple) {
        for (int i = 0; i < list.size(); ++i) {
            PollList pl = list.get(i);
            if (!pl.contains(ple)) continue;
            return true;
        }
        return false;
    }

    public void spy(SpyWriter out) throws Exception {
        out.startProps();
        out.prop((Object)"subs", (Object)BInteger.make((int)this.subs));
        out.prop((Object)"subTime", (Object)BLong.make((long)this.subTime));
        out.prop((Object)"subAvg", (Object)BDouble.make((double)((double)this.subTime / (double)this.subs)));
        out.prop((Object)"unsubs", (Object)BInteger.make((int)this.unsubs));
        out.prop((Object)"unsubTime", (Object)BLong.make((long)this.unsubTime));
        out.prop((Object)"unsubAvg", (Object)BDouble.make((double)((double)this.unsubTime / (double)this.unsubs)));
        out.prop((Object)"getPLEsSubTime", (Object)BLong.make((long)this.getPLEsSubTime));
        out.prop((Object)"getPLEsSubAvg", (Object)BDouble.make((double)((double)this.getPLEsSubTime / (double)this.subs)));
        out.prop((Object)"pleAdds", (Object)BInteger.make((int)this.pleAdds));
        out.prop((Object)"pleAddTime", (Object)BLong.make((long)this.pleAddTime));
        out.prop((Object)"pleAddAvg", (Object)BDouble.make((double)((double)this.pleAddTime / (double)this.pleAdds)));
        out.prop((Object)"dibsSubTime", (Object)BLong.make((long)this.dibsSubTime));
        out.prop((Object)"dibsSubAvg", (Object)BDouble.make((double)((double)this.dibsSubTime / (double)this.subs)));
        out.prop((Object)"getPLEsUnsubTime", (Object)BLong.make((long)this.getPLEsUnsubTime));
        out.prop((Object)"getPLEsUnsubAvg", (Object)BDouble.make((double)((double)this.getPLEsUnsubTime / (double)this.subs)));
        out.prop((Object)"pleRems", (Object)BInteger.make((int)this.pleRems));
        out.prop((Object)"pleRemTime", (Object)BLong.make((long)this.pleRemTime));
        out.prop((Object)"pleRemAvg", (Object)BDouble.make((double)((double)this.pleRemTime / (double)this.pleRems)));
        out.prop((Object)"dibsUnsubTime", (Object)BLong.make((long)this.dibsUnsubTime));
        out.prop((Object)"dibsUnsubAvg", (Object)BDouble.make((double)((double)this.dibsUnsubTime / (double)this.unsubs)));
        out.endProps();
        super.spy(out);
        out.startProps();
        out.trTitle((Object)"BacnetPoll", 2);
        out.prop((Object)"isAlive", this.isAlive);
        out.prop((Object)"ticks", (Object)BLong.make((long)Clock.ticks()));
        out.prop((Object)"dibs size", this.dibs.size());
        out.prop((Object)"statsCount", this.statsCount);
        out.prop((Object)"splitCount", (Object)BInteger.make((int)this.splitCount));
        out.prop((Object)"lastRepackTime", (Object)BLong.make((long)this.lastRepackTime));
        out.prop((Object)REPACK_INTERVAL, (Object)BRelTime.make((long)this.repackInterval));
        if (this.fast != null) {
            out.prop((Object)"fast", this.fast.q.size());
            out.prop((Object)"fast.nextTicks", (Object)BLong.make((long)this.fast.nextTicks));
            out.prop((Object)"fast.index", this.fast.index);
            out.prop((Object)"fast.pollCount", this.fast.pollCount);
            Iterator<PollList> it = this.fast.q.iterator();
            int i = 0;
            while (it.hasNext()) {
                out.prop((Object)("fast[" + i++ + "]"), (Object)it.next().debug());
            }
            out.prop((Object)"norm", this.norm.q.size());
            out.prop((Object)"norm.nextTicks", (Object)BLong.make((long)this.norm.nextTicks));
            out.prop((Object)"norm.index", this.norm.index);
            out.prop((Object)"norm.pollCount", this.norm.pollCount);
            it = this.norm.q.iterator();
            i = 0;
            while (it.hasNext()) {
                out.prop((Object)("norm[" + i++ + "]"), (Object)it.next().debug());
            }
            out.prop((Object)"slow", this.slow.q.size());
            out.prop((Object)"slow.nextTicks", (Object)BLong.make((long)this.slow.nextTicks));
            out.prop((Object)"slow.index", this.slow.index);
            out.prop((Object)"slow.pollCount", this.slow.pollCount);
            it = this.slow.q.iterator();
            i = 0;
            while (it.hasNext()) {
                out.prop((Object)("slow[" + i++ + "]"), (Object)it.next().debug());
            }
        }
        out.endProps();
    }

    protected static class BacnetBucket {
        public Property rateProp;
        public List<PollList> q = new ArrayList<PollList>();
        public int index;
        public int pollCount;
        public long nextTicks;
        public int pollTotal;
        public int sizeTotal;
        public int cycleTotal;
        public BacnetBucket nextBucket;

        public BacnetBucket(Property rateProp) {
            this.rateProp = rateProp;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.rateProp.getName()).append('[').append(this.index).append('/').append(this.q.size()).append(']');
            return sb.toString();
        }

        public boolean removeAll(BIBacnetPollable p) {
            int count = 0;
            boolean keepLooking = this.q.size() >= 1;
            boolean found = false;
            while (keepLooking) {
                if (this.q.get(count) == p) {
                    this.q.remove(count);
                    found = true;
                } else {
                    ++count;
                }
                keepLooking = count < this.q.size();
            }
            return found;
        }

        public boolean remove(BIBacnetPollable p) {
            int size = this.q.size();
            for (int i = 0; i < size; ++i) {
                if (this.q.get(i) != p) continue;
                this.q.remove(i);
                return true;
            }
            return false;
        }

        public void reset() {
            this.resetDone();
            this.index = 0;
            this.nextTicks = 0L;
            this.pollTotal = 0;
            this.sizeTotal = 0;
            this.cycleTotal = 0;
            this.pollCount = 0;
        }

        public boolean donePolling() {
            for (int i = 0; i < this.q.size(); ++i) {
                PollList pl = this.q.get(i);
                if (!pl.isPolling() && pl.isDone()) continue;
                return false;
            }
            return true;
        }

        public void resetDone() {
            for (int i = 0; i < this.q.size(); ++i) {
                this.q.get(i).setDone(false);
            }
        }

        public void resetTicks() {
            this.nextTicks = 0L;
        }

        public int count(BIBacnetPollable p) {
            int count = 0;
            int size = this.q.size();
            for (int i = 0; i < size; ++i) {
                if (this.q.get(i) != p) continue;
                ++count;
            }
            return count;
        }
    }
}

