/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.schedule;

import com.tridium.bacnet.schedule.BBacnetScheduleDeviceExt;
import com.tridium.bacnet.schedule.ScheduleSupport0;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.driver.schedule.BScheduleImportExt;
import javax.baja.driver.util.BDescriptorState;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

public class BBacnetScheduleImportExt
extends BScheduleImportExt {
    public static final Property supervisorId = BBacnetScheduleImportExt.newProperty((int)5, (String)"", null);
    public static final Property objectId = BBacnetScheduleImportExt.newProperty((int)0, (BValue)BBacnetObjectIdentifier.make(17), (BFacets)ScheduleSupport0.SCHEDULE_CALENDAR_OBJECT_ID_FACETS);
    public static final Property priorityForWriting = BBacnetScheduleImportExt.newProperty((int)1, (int)16, (BFacets)BFacets.makeInt((int)1, (int)16));
    public static final Type TYPE = Sys.loadType(BBacnetScheduleImportExt.class);
    public static final Logger logger = Logger.getLogger("bacnet.schedule");

    public BBacnetObjectIdentifier getObjectId() {
        return (BBacnetObjectIdentifier)this.get(objectId);
    }

    public void setObjectId(BBacnetObjectIdentifier v) {
        this.set(objectId, (BValue)v, null);
    }

    public int getPriorityForWriting() {
        return this.getInt(priorityForWriting);
    }

    public void setPriorityForWriting(int v) {
        this.setInt(priorityForWriting, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public String toString(Context cx) {
        return this.getParent().getName() + "-ImportExt [" + this.getObjectId().toString(cx) + "]";
    }

    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (cx == Context.decoding || !this.isRunning()) {
            return;
        }
        if (p == objectId) {
            this.execute();
        }
    }

    protected IFuture postExecute(Action action, BValue arg, Context cx) {
        return BBacnetNetwork.bacnet().postAsync((Runnable)new Invocation((BComponent)this, action, arg, cx));
    }

    public void doExecute() {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("doExecute on " + (Object)((Object)this));
        }
        BBacnetScheduleDeviceExt deviceExt = (BBacnetScheduleDeviceExt)this.getDeviceExt();
        this.executeInProgress();
        try {
            BAbstractSchedule ret = deviceExt.readRemote(this);
            if (ret != null) {
                this.importSupervisor(ret);
            }
            this.executeOk();
        }
        catch (BacnetException e1) {
            logger.log(Level.SEVERE, "BacnetException reading supervisor schedule data for " + this.getSubordinate().getName() + " from " + (Object)((Object)this.getObjectId()) + ": " + (Object)((Object)e1), (Throwable)((Object)e1));
            this.executeFail((Throwable)((Object)e1));
        }
        catch (Exception e2) {
            logger.log(Level.SEVERE, "Exception reading supervisor schedule data for " + this.getSubordinate().getName() + " from " + (Object)((Object)this.getObjectId()) + ": " + e2, e2);
            this.executeFail(e2);
        }
        finally {
            this.setState(BDescriptorState.idle);
        }
    }
}

