/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.job;

import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.NBacnetPropertyReference;
import com.tridium.bacnet.asn.NReadAccessResult;
import com.tridium.bacnet.asn.NReadAccessSpec;
import com.tridium.bacnet.asn.NReadPropertyResult;
import com.tridium.bacnet.job.BBacnetDiscoverJob;
import com.tridium.bacnet.job.BDiscoveryPoint;
import com.tridium.bacnet.job.BDiscoveryPointTable;
import com.tridium.bacnet.job.BacnetDiscoveryUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Vector;
import java.util.logging.Level;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.point.BBacnetPointDeviceExt;
import javax.baja.bacnet.util.PropertyInfo;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDeviceExt;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

public class BBacnetDiscoverPointsJob
extends BBacnetDiscoverJob {
    public static final Action discover = BBacnetDiscoverPointsJob.newAction((int)0, (BValue)BDiscoveryPoint.NULL, null);
    public static final Action discoverFacets = BBacnetDiscoverPointsJob.newAction((int)0, (BValue)BBacnetObjectIdentifier.DEFAULT, null);
    public static final Action checkForPriorityArray = BBacnetDiscoverPointsJob.newAction((int)0, (BValue)BBacnetObjectIdentifier.DEFAULT, null);
    public static final Type TYPE = Sys.loadType(BBacnetDiscoverPointsJob.class);
    private long pointsAdded = 0L;

    public BDiscoveryPointTable discover(BDiscoveryPoint point) {
        return (BDiscoveryPointTable)this.invoke(discover, (BValue)point, null);
    }

    public BFacets discoverFacets(BBacnetObjectIdentifier objectId) {
        return (BFacets)this.invoke(discoverFacets, (BValue)objectId, null);
    }

    public BBoolean checkForPriorityArray(BBacnetObjectIdentifier objectId) {
        return (BBoolean)this.invoke(checkForPriorityArray, (BValue)objectId, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BBacnetDiscoverPointsJob() {
    }

    public BBacnetDiscoverPointsJob(BBacnetPointDeviceExt deviceExt) {
        super((BDeviceExt)deviceExt);
    }

    public BDiscoveryPointTable doDiscover(BDiscoveryPoint point) {
        BDiscoveryPoint[] propList = new BDiscoveryPoint[]{};
        try {
            switch (point.getPointType()) {
                case 0: {
                    HashMap<String, BIDataValue> facetMap = new HashMap<String, BIDataValue>();
                    propList = this.discoverProperties(point.getObjectName(), point.getObjectId(), facetMap);
                    BFacets facets = BFacets.make(facetMap);
                    for (int i = 0; i < propList.length; ++i) {
                        PropertyInfo info = this.device().getPropertyInfo(propList[i].getObjectId().getObjectType(), propList[i].getPropertyId());
                        if (info == null || info.getFacetControl().equals("no")) continue;
                        propList[i].setFacets(facets);
                    }
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    propList = this.discoverElements(point);
                    break;
                }
            }
        }
        catch (Exception e) {
            this.log().failed(" ERROR: Unable to learn Bacnet properties of " + (Object)((Object)point.getObjectId()) + ": " + e);
            logger.log(Level.SEVERE, "Unable to learn Bacnet properties of " + (Object)((Object)point.getObjectId()) + ": " + e, e);
        }
        return this.makeDiscoveryPointTable(propList);
    }

    public BFacets doDiscoverFacets(BBacnetObjectIdentifier objectId) {
        HashMap<String, BIDataValue> map = BacnetDiscoveryUtil.discoverFacets(objectId, this.device());
        switch (objectId.getObjectType()) {
            case 2: 
            case 5: 
            case 19: {
                map.put("priPV", (BIDataValue)BacnetDiscoveryUtil.checkForPriorityArray(objectId, this.device()));
                break;
            }
        }
        return BFacets.make(map);
    }

    public BBoolean doCheckForPriorityArray(BBacnetObjectIdentifier objectId) {
        return BacnetDiscoveryUtil.checkForPriorityArray(objectId, this.device());
    }

    @Override
    void addDiscoveryChild(BBacnetDiscoverJob.IdVals iv) {
        BBacnetDiscoverJob.PropVal primary = iv.primary();
        if (primary == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("No primary value for discovered object " + iv);
            }
        } else {
            BDiscoveryPoint dp = new BDiscoveryPoint(iv.name, iv.id, BBacnetPropertyIdentifier.tag(primary.propId), primary.val, null, true);
            BBacnetDiscoverJob.PropVal desc = iv.get(28);
            if (desc != null) {
                dp.setDescription(desc.toString());
            }
            this.add("dc" + this.pointsAdded++, (BValue)dp);
        }
    }

    protected BDiscoveryPointTable makeDiscoveryPointTable(BDiscoveryPoint[] pointList) {
        BDiscoveryPointTable table = new BDiscoveryPointTable();
        if (pointList != null) {
            for (int i = 0; i < pointList.length; ++i) {
                table.add(null, pointList[i].newCopy());
            }
        }
        return table;
    }

    BDiscoveryPoint[] discoverProperties(String objectName, BBacnetObjectIdentifier objectId, HashMap<String, BIDataValue> facetMap) {
        Vector vals;
        if (!this.device().isServiceSupported("readPropertyMultiple")) {
            return this.buildPropertyChildren(objectName, objectId, this.device().getRequiredProperties(objectId), facetMap);
        }
        Vector<NReadAccessSpec> specs = new Vector<NReadAccessSpec>();
        specs.add(new NReadAccessSpec(objectId, 8));
        try {
            vals = BBacnetDiscoverPointsJob.client().readPropertyMultiple(this.device().getAddress(), specs);
        }
        catch (BacnetException e) {
            logger.info("BacnetException reading properties for " + (Object)((Object)objectId) + ": " + (Object)((Object)e));
            return this.buildPropertyChildren(objectName, objectId, this.device().getRequiredProperties(objectId), facetMap);
        }
        if (vals == null) {
            return this.buildPropertyChildren(objectName, objectId, this.device().getRequiredProperties(objectId), facetMap);
        }
        ListIterator it = ((NReadAccessResult)vals.elementAt(0)).getResults();
        int objectType = objectId.getObjectType();
        PropertyInfo propInfo = null;
        ArrayList<BDiscoveryPoint> results = new ArrayList<BDiscoveryPoint>();
        while (it.hasNext()) {
            BDiscoveryPoint prop;
            NReadPropertyResult rpr = (NReadPropertyResult)it.next();
            if (rpr.getPropertyId() == 8) {
                return this.buildPropertyChildren(objectName, objectId, this.device().getRequiredProperties(objectId), facetMap);
            }
            propInfo = this.device().getPropertyInfo(objectType, rpr.getPropertyId());
            if (rpr.isError()) {
                prop = new BDiscoveryPoint(objectName, objectId, BBacnetPropertyIdentifier.tag(rpr.getPropertyId()), (BValue)BString.make((String)(lex.get("pointManager.error") + ":" + rpr.getPropertyAccessError().toString())), null, false);
                results.add(prop);
                continue;
            }
            if (propInfo != null) {
                prop = this.buildPropertyResult(objectName, objectId, propInfo, rpr.getPropertyValue(), facetMap);
                if (prop == null) continue;
                results.add(prop);
                continue;
            }
            prop = this.buildPropertyResult(objectName, objectId, rpr.getPropertyId(), rpr.getPropertyValue());
            if (prop == null) continue;
            results.add(prop);
        }
        return results.toArray(new BDiscoveryPoint[0]);
    }

    private BDiscoveryPoint buildPropertyResult(String objectName, BBacnetObjectIdentifier objectId, int propertyId, byte[] propertyValue) {
        BDiscoveryPoint plr = null;
        String property = BBacnetPropertyIdentifier.tag(propertyId);
        try {
            BValue[] propVals = AsnUtil.fromAsn(propertyValue);
            if (propVals.length == 1) {
                plr = new BDiscoveryPoint(objectName, objectId, property, propVals[0], null, false);
            } else {
                Type t = propVals[0].getType();
                boolean array = true;
                for (int i = 1; i < propVals.length; ++i) {
                    if (propVals[i].getType() == t) continue;
                    array = false;
                    break;
                }
                if (array) {
                    BDiscoveryPoint[] kids = new BDiscoveryPoint[propVals.length];
                    for (int i = 1; i <= propVals.length; ++i) {
                        BDiscoveryPoint kid;
                        kids[i - 1] = kid = new BDiscoveryPoint(objectName, objectId, property, i, (BValue)BString.make((String)""), null);
                    }
                    plr = new BDiscoveryPoint(objectName, objectId, property, kids, null);
                } else {
                    plr = new BDiscoveryPoint(objectName, objectId, property, (BValue)BString.make((String)""), null, false);
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Exception in buildPropertyResult for " + objectName + " [" + (Object)((Object)objectId) + "] pId:" + propertyId + " val=" + ByteArrayUtil.toHexString((byte[])propertyValue) + ":" + e, e);
            plr = new BDiscoveryPoint(objectName, objectId, property, (BValue)BString.make((String)"???"), null, false);
        }
        return plr;
    }

    private BDiscoveryPoint buildPropertyResult(String objectName, BBacnetObjectIdentifier objectId, PropertyInfo info, byte[] propertyValue, HashMap<String, BIDataValue> facetMap) {
        try {
            BDiscoveryPoint plr = null;
            if (info.isArray()) {
                int size = info.getSize();
                if (size < 0) {
                    try {
                        byte[] encodedSize = BBacnetDiscoverPointsJob.client().readProperty(this.device().getAddress(), objectId, info.getId(), 0);
                        int arraySize = AsnUtil.fromAsnInteger(encodedSize);
                        BDiscoveryPoint[] kids = new BDiscoveryPoint[arraySize];
                        for (int i = 1; i <= arraySize; ++i) {
                            BDiscoveryPoint kid;
                            kids[i - 1] = kid = new BDiscoveryPoint(objectName, objectId, info.getName(), i, (BValue)BString.make((String)""), null);
                        }
                        plr = new BDiscoveryPoint(objectName, objectId, info.getName(), kids, null);
                    }
                    catch (BacnetException e) {
                        logger.info("Unable to read array size for " + objectName + " [" + (Object)((Object)objectId) + "] " + info.getName() + ": " + (Object)((Object)e));
                    }
                } else {
                    BDiscoveryPoint[] kids = new BDiscoveryPoint[size];
                    for (int i = 1; i <= size; ++i) {
                        BDiscoveryPoint kid;
                        kids[i - 1] = kid = new BDiscoveryPoint(objectName, objectId, info.getName(), i, (BValue)BString.make((String)""), null);
                    }
                    plr = new BDiscoveryPoint(objectName, objectId, info.getName(), kids, null);
                }
            } else {
                try {
                    BValue v = AsnUtil.asnToValue(info, propertyValue);
                    BFacets facets = null;
                    if (info.isEnum()) {
                        try {
                            BTypeSpec tspec = BTypeSpec.make((String)info.getType());
                            BEnum en = (BEnum)tspec.getInstance();
                            facets = info.isExtensible() ? BFacets.makeEnum((BEnumRange)BEnumRange.make((Type)en.getType())) : BFacets.makeEnum((BEnumRange)en.getRange());
                        }
                        catch (Exception e) {
                            logger.log(Level.SEVERE, "Exception in buildPropertyResult for " + objectName + " [" + (Object)((Object)objectId) + "] pInfo:" + info + " val=" + ByteArrayUtil.toHexString((byte[])propertyValue) + " f=" + facetMap + ":", e);
                        }
                    }
                    plr = new BDiscoveryPoint(objectName, objectId, info.getName(), v, facets, false);
                }
                catch (AsnException e) {
                    logger.log(Level.SEVERE, "AsnException in buildPropertyResult for " + objectName + " [" + (Object)((Object)objectId) + "] pInfo:" + info + " val=" + ByteArrayUtil.toHexString((byte[])propertyValue) + " f=" + facetMap + ":", (Throwable)((Object)e));
                    return new BDiscoveryPoint(objectName, objectId, info.getName(), (BValue)BString.make((String)"???"), null, false);
                }
            }
            if (info.isFacet()) {
                BacnetDiscoveryUtil.addFacet(info.getId(), propertyValue, facetMap, this.device());
            }
            return plr;
        }
        catch (RuntimeException e) {
            logger.log(Level.SEVERE, "Exception in buildPropertyResult for " + objectName + " [" + (Object)((Object)objectId) + "] pInfo:" + info + " val=" + ByteArrayUtil.toHexString((byte[])propertyValue) + " f=" + facetMap + ":", e);
            return new BDiscoveryPoint(objectName, objectId, info.getName(), (BValue)BString.make((String)"???"), null, false);
        }
    }

    private BDiscoveryPoint[] buildPropertyChildren(String objectName, BBacnetObjectIdentifier objectId, int[] propertyList, HashMap<String, BIDataValue> facetMap) {
        BDiscoveryPoint[] ret = new BDiscoveryPoint[propertyList.length];
        for (int i = 0; i < propertyList.length; ++i) {
            try {
                PropertyInfo info = this.device().getPropertyInfo(objectId.getObjectType(), propertyList[i]);
                byte[] encodedValue = BBacnetDiscoverPointsJob.client().readProperty(this.device().getAddress(), objectId, propertyList[i]);
                if (info != null) {
                    ret[i] = this.buildPropertyResult(objectName, objectId, info, encodedValue, facetMap);
                    continue;
                }
                ret[i] = new BDiscoveryPoint(objectName, objectId, BBacnetPropertyIdentifier.tag(propertyList[i]), (BValue)BString.make((String)"?n/a?"), null, false);
                continue;
            }
            catch (BacnetException e) {
                logger.info("BacnetException reading property " + BBacnetPropertyIdentifier.tag(propertyList[i]) + ":" + (Object)((Object)e));
                ret[i] = new BDiscoveryPoint(objectName, objectId, BBacnetPropertyIdentifier.tag(propertyList[i]), (BValue)BString.make((String)"???"), null, false);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BDiscoveryPoint[] discoverElements(BDiscoveryPoint point) {
        BDiscoveryPoint[] elements = point.getPoints();
        int propertyId = point.getPropertyId();
        PropertyInfo propInfo = this.device().getPropertyInfo(point.getObjectId().getObjectType(), propertyId);
        if (this.device().isServiceSupported("readPropertyMultiple")) {
            Vector<NBacnetPropertyReference> refs = new Vector<NBacnetPropertyReference>();
            for (int i = 0; i < elements.length; ++i) {
                refs.add(new NBacnetPropertyReference(propertyId, elements[i].getPropertyArrayIndex()));
            }
            try {
                Vector vals = BBacnetDiscoverPointsJob.client().readPropertyMultiple(this.device().getAddress(), point.getObjectId(), refs);
                Iterator it = vals.iterator();
                int elem = 0;
                while (it.hasNext()) {
                    try {
                        NReadPropertyResult rpr = (NReadPropertyResult)it.next();
                        if (propInfo != null) {
                            BTypeSpec tspec = BTypeSpec.make((String)propInfo.getType());
                            BValue v = (BValue)tspec.getInstance();
                            v = AsnUtil.fromAsn(rpr.getPropertyValue(), v);
                            elements[elem].setValue(v);
                            continue;
                        }
                        BValue v = AsnUtil.asnToValue(rpr.getPropertyValue());
                        elements[elem].setValue(v);
                    }
                    catch (Exception e) {
                        logger.info("Exception reading element " + elem + " in " + (Object)((Object)point.getObjectId()) + " [" + point.getPropertyIdentifier() + "]: " + e);
                        elements[elem].setValue((BValue)BString.make((String)"???"));
                    }
                    finally {
                        ++elem;
                    }
                }
            }
            catch (BacnetException e) {
                logger.info("BacnetException reading elements in " + (Object)((Object)point.getObjectId()) + " [" + point.getPropertyIdentifier() + "]: " + (Object)((Object)e));
            }
        } else {
            for (int i = 0; i < elements.length; ++i) {
                try {
                    byte[] encodedValue = BBacnetDiscoverPointsJob.client().readProperty(this.device().getAddress(), elements[i].getObjectId(), propertyId, elements[i].getPropertyArrayIndex());
                    BTypeSpec tspec = BTypeSpec.make((String)propInfo.getType());
                    BValue v = (BValue)tspec.getInstance();
                    v = AsnUtil.fromAsn(encodedValue, v);
                    elements[i].setValue(v);
                    continue;
                }
                catch (BacnetException e) {
                    logger.info("BacnetException reading element " + i + " in " + (Object)((Object)point.getObjectId()) + " [" + point.getPropertyIdentifier() + "]: " + (Object)((Object)e));
                    elements[i].setValue((BValue)BString.make((String)"???"));
                    continue;
                }
                catch (Exception e) {
                    logger.info("Exception reading element " + i + " in " + (Object)((Object)point.getObjectId()) + " [" + point.getPropertyIdentifier() + "]: " + e);
                    elements[i].setValue((BValue)BString.make((String)"???"));
                }
            }
        }
        return elements;
    }
}

