/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.history;

import com.tridium.bacnet.ObjectTypeList;
import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.history.BBacnetHistoryDeviceExt;
import com.tridium.bacnet.history.BacnetTrendLogUtil;
import com.tridium.bacnet.job.BacnetDiscoveryUtil;
import com.tridium.bacnet.stack.BBacnetStack;
import com.tridium.bacnet.stack.DeviceRegistry;
import com.tridium.bacnet.stack.client.BBacnetClientLayer;
import java.util.HashMap;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.bacnet.datatypes.BBacnetDateTime;
import javax.baja.bacnet.datatypes.BBacnetDeviceObjectPropertyReference;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.util.PropertyInfo;
import javax.baja.control.trigger.BManualTriggerMode;
import javax.baja.data.BIDataValue;
import javax.baja.driver.history.ArchiveException;
import javax.baja.driver.history.BHistoryImport;
import javax.baja.driver.util.BDescriptorState;
import javax.baja.history.BCollectionInterval;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.HistorySpaceConnection;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.history.db.HistoryDatabaseConnection;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLong;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Slot;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.BFormat;
import javax.baja.util.BTypeSpec;
import javax.baja.util.IFuture;
import javax.baja.util.Lexicon;

public abstract class BAbstractBacnetHistory
extends BHistoryImport
implements BacnetConst {
    public static final Property historyId = BAbstractBacnetHistory.newProperty((int)1, (BValue)BHistoryId.NULL, null);
    public static final Lexicon lex = Lexicon.make((String)"bacnet");
    private static final String UNKNOWN = lex.get("historyType.unknown", "unknown");
    public static final Property objectId = BAbstractBacnetHistory.newProperty((int)0, (BValue)BBacnetObjectIdentifier.make(20), null);
    public static final Property localHistoryName = BAbstractBacnetHistory.newProperty((int)1, (String)"", null);
    public static final Property localHistoryNameFormat = BAbstractBacnetHistory.newProperty((int)0, (BValue)BFormat.make((String)"%name%"), null);
    public static final Property referenceTime = BAbstractBacnetHistory.newProperty((int)0, (BValue)new BBacnetDateTime(BAbsTime.make((long)0L, (BTimeZone)BTimeZone.UTC)), null);
    public static final Property maxRecordsPerRequest = BAbstractBacnetHistory.newProperty((int)0, (int)0, (BFacets)BFacets.makeInt(null, (int)0, (int)Integer.MAX_VALUE));
    public static final Property alwaysRequestByReferenceTime = BAbstractBacnetHistory.newProperty((int)0, (boolean)false, null);
    public static final Property lastSequenceNumberProcessed = BAbstractBacnetHistory.newProperty((int)0, (BValue)BLong.make((long)0L), null);
    public static final Property maxStartingEvents = BAbstractBacnetHistory.newProperty((int)4, (int)3, null);
    public static final Property discoveryHistoryType = BAbstractBacnetHistory.newProperty((int)5, (String)UNKNOWN, null);
    public static final Action clearRecordsInDevice = BAbstractBacnetHistory.newAction((int)128, null);
    public static final Type TYPE = Sys.loadType(BAbstractBacnetHistory.class);
    public static final Logger logger = Logger.getLogger("bacnet.history");
    protected AsnInputStream asnIn = new AsnInputStream();
    protected boolean bufferReady = false;
    protected boolean formatChecked = false;
    protected boolean overridesConfigured = false;
    protected byte[] prev = null;
    protected String prevNam = null;
    protected boolean oprChange = true;
    private BacnetHistoryImportSubscriber bacnetHistoryImportSubscriber;

    public BBacnetObjectIdentifier getObjectId() {
        return (BBacnetObjectIdentifier)this.get(objectId);
    }

    public void setObjectId(BBacnetObjectIdentifier v) {
        this.set(objectId, (BValue)v, null);
    }

    public String getLocalHistoryName() {
        return this.getString(localHistoryName);
    }

    public void setLocalHistoryName(String v) {
        this.setString(localHistoryName, v, null);
    }

    public BFormat getLocalHistoryNameFormat() {
        return (BFormat)this.get(localHistoryNameFormat);
    }

    public void setLocalHistoryNameFormat(BFormat v) {
        this.set(localHistoryNameFormat, (BValue)v, null);
    }

    public BBacnetDateTime getReferenceTime() {
        return (BBacnetDateTime)this.get(referenceTime);
    }

    public void setReferenceTime(BBacnetDateTime v) {
        this.set(referenceTime, (BValue)v, null);
    }

    public int getMaxRecordsPerRequest() {
        return this.getInt(maxRecordsPerRequest);
    }

    public void setMaxRecordsPerRequest(int v) {
        this.setInt(maxRecordsPerRequest, v, null);
    }

    public boolean getAlwaysRequestByReferenceTime() {
        return this.getBoolean(alwaysRequestByReferenceTime);
    }

    public void setAlwaysRequestByReferenceTime(boolean v) {
        this.setBoolean(alwaysRequestByReferenceTime, v, null);
    }

    public long getLastSequenceNumberProcessed() {
        return this.getLong(lastSequenceNumberProcessed);
    }

    public void setLastSequenceNumberProcessed(long v) {
        this.setLong(lastSequenceNumberProcessed, v, null);
    }

    public int getMaxStartingEvents() {
        return this.getInt(maxStartingEvents);
    }

    public void setMaxStartingEvents(int v) {
        this.setInt(maxStartingEvents, v, null);
    }

    public String getDiscoveryHistoryType() {
        return this.getString(discoveryHistoryType);
    }

    public void setDiscoveryHistoryType(String v) {
        this.setString(discoveryHistoryType, v, null);
    }

    public void clearRecordsInDevice() {
        this.invoke(clearRecordsInDevice, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final BBacnetDevice device() {
        return (BBacnetDevice)this.getDeviceExt().getDevice();
    }

    public final BBacnetHistoryDeviceExt deviceExt() {
        return (BBacnetHistoryDeviceExt)this.getDeviceExt();
    }

    public void started() throws Exception {
        super.started();
        if (Sys.atSteadyState() && this.isEnabled()) {
            this.postConfigureOverrides();
            if (this.getExecutionTime().getTriggerMode() != BManualTriggerMode.DEFAULT) {
                this.execute();
            }
        }
        this.bacnetHistoryImportSubscriber = new BacnetHistoryImportSubscriber();
        this.bacnetHistoryImportSubscriber.subscribe(this.getConfigOverrides());
    }

    public boolean isEnabled() {
        return super.isEnabled() && this.device().getEnabled() && !this.device().isFault();
    }

    public void atSteadyState() throws Exception {
        super.atSteadyState();
        if (this.isEnabled()) {
            this.postConfigureOverrides();
            if (this.getExecutionTime().getTriggerMode() != BManualTriggerMode.DEFAULT) {
                this.execute();
            }
        }
    }

    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(status) && Sys.atSteadyState() && this.isEnabled() && !this.overridesConfigured) {
            this.postConfigureOverrides();
        }
        if (p.getName().equals(BHistoryImport.configOverrides.getName())) {
            this.saveConfigOverride();
        }
    }

    protected BBacnetClientLayer client() {
        return ((BBacnetStack)BBacnetNetwork.bacnet().getBacnetComm()).getClient();
    }

    public void doClearRecordsInDevice() {
        this.doClearDeviceRecords();
    }

    public boolean isBufferReady() {
        return this.bufferReady;
    }

    public void setBufferReady(boolean val) {
        this.bufferReady = val;
    }

    protected IFuture postExecute(Action archiveAction, BValue arg, Context cx) {
        try {
            return BBacnetNetwork.bacnet().postAsync(new AsyncImport());
        }
        catch (Exception e) {
            this.executeFail(e);
            return null;
        }
    }

    protected void postConfigureOverrides() {
        try {
            if (this.device().isOperational()) {
                BBacnetNetwork.bacnet().postAsync(new Runnable(){

                    @Override
                    public void run() {
                        BAbstractBacnetHistory.this.configureOverrides();
                    }
                });
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to invoke postConfigureOverrides", e);
        }
    }

    protected synchronized void configureOverrides() {
        if (this.overridesConfigured) {
            return;
        }
        if (this.device().isOperational()) {
            BComponent overrides = this.getConfigOverrides();
            this.setTimeZone(overrides);
            this.setLogInterval(overrides);
            this.setValueFacets(overrides);
        }
        this.overridesConfigured = true;
    }

    private void setTimeZone(BComponent overrides) {
        BTimeZone timeZone = this.deviceExt().getTimeZone();
        if (timeZone == null) {
            logger.warning("TimeZone determined from TimeZoneDatabase and device values is null, resetting to default!");
            timeZone = BTimeZone.getLocal();
            Property tzprop = overrides.getProperty("timeZone");
            if (tzprop == null) {
                overrides.add("timeZone", (BValue)timeZone, 0, BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"driver:TimeZoneSelectionFE")), null);
            } else {
                overrides.set(tzprop, (BValue)timeZone);
                overrides.setFlags((Slot)tzprop, overrides.getFlags((Slot)tzprop) & 0xFFFFFFFE);
                overrides.setFacets((Slot)tzprop, BFacets.make((BFacets)overrides.getSlotFacets((Slot)tzprop), (String)"fieldEditor", (BIDataValue)BString.make((String)"driver:TimeZoneSelectionFE")));
            }
        } else if (overrides.getProperty("timeZone") == null) {
            overrides.add("timeZone", (BValue)timeZone, 0, BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"driver:TimeZoneSelectionFE")), null);
        }
    }

    private void setLogInterval(BComponent overrides) {
        try {
            byte[] encodedValue = this.client().readProperty(this.device().getAddress(), this.getObjectId(), 134);
            long logInterval = AsnUtil.fromAsnUnsignedInteger(encodedValue);
            BCollectionInterval interval = BCollectionInterval.IRREGULAR;
            if (logInterval >= 0L) {
                interval = BCollectionInterval.make((BRelTime)BRelTime.make((long)(logInterval * 10L)));
            }
            BAbstractBacnetHistory.setOrAdd(overrides, "interval", (BValue)interval);
        }
        catch (BacnetException e) {
            logger.info("Unable to read Log_Interval from " + (Object)((Object)this.getObjectId()) + " in " + this.device() + ":" + (Object)((Object)e));
        }
    }

    private void setValueFacets(BComponent overrides) {
        BBacnetObjectIdentifier deviceId;
        BBacnetDeviceObjectPropertyReference dopr = this.getDeviceObjectProp();
        if (dopr != null && BAbstractBacnetHistory.hasValueFacets(dopr) && (deviceId = dopr.getDeviceId()) != null) {
            BFacets valueFacets;
            HashMap<String, BIDataValue> map;
            BBacnetAddress address;
            if (deviceId == BBacnetObjectIdentifier.DEFAULT_DEVICE) {
                deviceId = this.device().getObjectId();
            }
            if ((address = DeviceRegistry.getDeviceAddress(deviceId)) != null && (map = BacnetDiscoveryUtil.discoverFacets(dopr.getObjectId(), address)) != null && (valueFacets = BFacets.make(map)) != null) {
                BAbstractBacnetHistory.setOrAdd(overrides, "valueFacets", (BValue)valueFacets);
            }
        }
    }

    private static boolean hasValueFacets(BBacnetDeviceObjectPropertyReference dopr) {
        if (dopr.getPropertyId() == 85 && dopr.getPropertyArrayIndex() == -1) {
            switch (dopr.getObjectId().getObjectType()) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 13: 
                case 14: 
                case 19: {
                    return true;
                }
            }
        }
        return false;
    }

    public BHistoryRecord correctTimestamp(BHistoryRecord rec) {
        BTimeZone timeZone = this.deviceExt().getTimeZone();
        if (timeZone == null) {
            return rec;
        }
        BAbsTime ts = rec.getTimestamp();
        BRelTime tsOff = BRelTime.make((long)ts.getTimeZone().getUtcOffset());
        BRelTime tzOff = BRelTime.make((long)timeZone.getUtcOffset());
        rec.setTimestamp(BAbsTime.make((BAbsTime)ts.subtract(tzOff).add(tsOff), (BTimeZone)timeZone));
        return rec;
    }

    protected BHistoryDatabase getHistoryDb() throws ArchiveException {
        try {
            BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
            return service.getDatabase();
        }
        catch (ServiceNotFoundException e) {
            this.executeFail(e);
            throw new ArchiveException((Throwable)e);
        }
    }

    protected long determineNextIndex() throws BacnetException {
        long lastSeq = this.getLastSequenceNumberProcessed();
        long expectedSeq = BacnetTrendLogUtil.incrementSequenceNumber(lastSeq);
        byte[] ba = this.client().readProperty(this.device().getAddress(), this.getObjectId(), 145);
        long totalRecordCount = AsnUtil.fromAsnUnsignedInteger(ba);
        ba = this.client().readProperty(this.device().getAddress(), this.getObjectId(), 141);
        long recordCount = AsnUtil.fromAsnUnsignedInteger(ba);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("determineNextIndex():lastSeq=" + lastSeq + " recordCount=" + recordCount + " totalRecordCount=" + totalRecordCount + " expectedSeq=" + expectedSeq);
        }
        if (recordCount == 0L || lastSeq == totalRecordCount) {
            return -1L;
        }
        if (recordCount <= totalRecordCount) {
            long firstIndex = totalRecordCount - recordCount + 1L;
            if (expectedSeq < firstIndex || expectedSeq > totalRecordCount) {
                expectedSeq = firstIndex;
            }
        } else {
            long firstIndex = BacnetTrendLogUtil.MAX_SEQ_NUM - (recordCount - totalRecordCount) + 1L;
            if (expectedSeq < firstIndex && expectedSeq > totalRecordCount) {
                expectedSeq = firstIndex;
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(" --> expectedSeq=" + expectedSeq);
        }
        return expectedSeq;
    }

    private BBacnetDeviceObjectPropertyReference getDeviceObjectPropEx() throws ArchiveException {
        try {
            return this.readDeviceObjectProp();
        }
        catch (Throwable e) {
            throw new ArchiveException(e);
        }
    }

    private BBacnetDeviceObjectPropertyReference getDeviceObjectProp() {
        try {
            return this.readDeviceObjectProp();
        }
        catch (Throwable e) {
            return null;
        }
    }

    private BBacnetDeviceObjectPropertyReference readDeviceObjectProp() throws BacnetException {
        byte[] ba = this.client().readProperty(this.device().getAddress(), this.getObjectId(), 132);
        this.oprChange = this.prev == null || !ByteArrayUtil.equals((byte[])ba, (byte[])this.prev);
        this.prev = ba;
        this.asnIn.setBuffer(ba);
        BBacnetDeviceObjectPropertyReference dopr = new BBacnetDeviceObjectPropertyReference();
        dopr.readAsn(this.asnIn);
        return dopr;
    }

    protected BIHistory getOrCreateHistory(HistorySpaceConnection conn) {
        String histName = this.getLocalHistoryName();
        BHistoryId id = BHistoryId.make((String)this.device().getName(), (String)histName);
        if (id == null) {
            throw new ArchiveException("Invalid names for historyId:" + this.device().getName() + "/" + histName);
        }
        BIHistory hist = conn.getHistory(id);
        if (hist != null) {
            return hist;
        }
        BTypeSpec ts = this.getTypeSpec();
        if (ts == null) {
            throw new ArchiveException("History type cannot be determined from device!");
        }
        return this.createHistory(conn, ts, id);
    }

    protected BIHistory createHistory(HistorySpaceConnection conn, BTypeSpec ts, BHistoryId id) {
        BHistoryConfig config = new BHistoryConfig(id, ts);
        config = this.makeLocalConfig(config);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Create history from config:" + config);
        }
        conn.createHistory(config);
        id = config.getId();
        this.setHistoryId(id);
        return conn.getHistory(id);
    }

    protected BTypeSpec getTypeSpec() {
        BTypeSpec ts;
        block9: {
            block8: {
                ts = null;
                if (!this.getDiscoveryHistoryType().equalsIgnoreCase(UNKNOWN)) {
                    ts = BTypeSpec.make((String)"bacnet", (String)("Bacnet" + this.getDiscoveryHistoryType() + "TrendRecord"));
                }
                if (ts != null) {
                    return ts;
                }
                try {
                    ts = this.getTypeSpec(this.getDeviceObjectPropEx());
                }
                catch (Exception e) {
                    if (!logger.isLoggable(Level.FINE)) break block8;
                    logger.fine("Cannot create history for " + this + " from Log_DeviceObjectProperty");
                }
            }
            if (ts != null) {
                return ts;
            }
            if (this.getDiscoveryHistoryType().equalsIgnoreCase(UNKNOWN)) {
                try {
                    ts = BacnetTrendLogUtil.findHistoryTypeByRecords(this.device(), this.getObjectId());
                }
                catch (Exception e) {
                    if (!logger.isLoggable(Level.FINE)) break block9;
                    logger.fine("Cannot get history type spec for " + this + " from records");
                }
            }
        }
        return ts;
    }

    protected BTypeSpec getTypeSpec(BBacnetDeviceObjectPropertyReference opr) {
        try {
            PropertyInfo pi;
            if (opr.getObjectId().getInstanceNumber() != 0x3FFFFF && (pi = ObjectTypeList.getInstance().getPropertyInfo(opr.getObjectId().getObjectType(), opr.getPropertyId())) != null) {
                return this.asnTagToTypeSpec(pi.getAsnType());
            }
            byte[] ba = this.client().readProperty(this.device().getAddress(), opr.getObjectId(), opr.getPropertyId());
            this.asnIn.setBuffer(ba);
            int tag = this.asnIn.peekTag();
            if (this.asnIn.isApplicationTag(tag)) {
                return this.asnTagToTypeSpec(tag);
            }
            return BTypeSpec.make((String)"bacnet", (String)"BacnetStringTrendRecord");
        }
        catch (Throwable e) {
            return null;
        }
    }

    private BTypeSpec asnTagToTypeSpec(int tag) {
        switch (tag) {
            case 1: {
                return BTypeSpec.make((String)"bacnet", (String)"BacnetBooleanTrendRecord");
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return BTypeSpec.make((String)"bacnet", (String)"BacnetNumericTrendRecord");
            }
            case 9: {
                return BTypeSpec.make((String)"bacnet", (String)"BacnetEnumTrendRecord");
            }
            case 6: 
            case 7: 
            case 8: 
            case 12: {
                return BTypeSpec.make((String)"bacnet", (String)"BacnetStringTrendRecord");
            }
        }
        return BTypeSpec.make((String)"bacnet", (String)"BacnetStringTrendRecord");
    }

    public void doClearDeviceRecords() {
        try {
            if (!this.device().isServiceSupported("writeProperty")) {
                logger.info("Cannot clear device records:" + lex.getText("serviceNotSupported.writeProperty"));
            } else {
                this.client().writeProperty(this.device().getAddress(), this.getObjectId(), 141, AsnUtil.toAsnUnsigned(0L));
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Problem during auto-clear of trend log records (device " + this.device().getAddress() + ", id " + (Object)((Object)this.getObjectId()) + ")", e);
        }
    }

    public String verifyLocalNameFormat() {
        String format;
        String name = format = this.getLocalHistoryNameFormat().format((Object)this);
        if (!this.formatChecked) {
            boolean nameDef = localHistoryName.isEquivalentToDefaultValue(this.get(localHistoryName));
            if (!nameDef && !this.getLocalHistoryName().equals(format)) {
                this.setLocalHistoryNameFormat(BFormat.make((String)this.getLocalHistoryName()));
                name = this.getLocalHistoryName();
            } else {
                this.setLocalHistoryName(format);
            }
            this.formatChecked = true;
        }
        return name;
    }

    private static void setOrAdd(BComponent c, String propName, BValue v) {
        if (c.get(propName) == null) {
            c.add(propName, v);
        } else {
            c.set(propName, v);
        }
    }

    private void saveConfigOverride() {
        BHistoryId id = BHistoryId.make((String)this.device().getName(), (String)this.getLocalHistoryName());
        BHistoryConfig config = new BHistoryConfig(id, this.getTypeSpec());
        config = this.makeLocalConfig(config);
        Optional service = Sys.findService((Type)BHistoryService.TYPE);
        if (service.isPresent()) {
            BHistoryService historyService = (BHistoryService)service.get();
            BHistoryDatabase db = historyService.getDatabase();
            try (HistoryDatabaseConnection conn = db.getDbConnection(null);){
                conn.reconfigureHistory(config);
            }
        }
    }

    public void stopped() throws Exception {
        if (null != this.bacnetHistoryImportSubscriber) {
            this.bacnetHistoryImportSubscriber.unsubscribe(this.getConfigOverrides());
        }
    }

    protected class BacnetHistoryImportSubscriber
    extends Subscriber {
        protected BacnetHistoryImportSubscriber() {
        }

        public void event(BComponentEvent event) {
            if (event.getId() == 0) {
                BAbstractBacnetHistory.this.saveConfigOverride();
            }
        }
    }

    class AsyncImport
    implements Runnable {
        AsyncImport() {
        }

        @Override
        public void run() {
            try {
                BAbstractBacnetHistory.this.doExecute();
            }
            catch (Throwable t) {
                BAbstractBacnetHistory.this.executeFail(t);
            }
            finally {
                BAbstractBacnetHistory.this.setState(BDescriptorState.idle);
            }
        }
    }
}

