/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.weather.ui;

import com.tridium.ui.theme.Theme;
import com.tridium.weather.ui.BAdvisoryDetailsDialog;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.status.BStatus;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.util.Lexicon;
import javax.baja.weather.BCurrentConditions;
import javax.baja.weather.BForecast;
import javax.baja.weather.BWeatherReport;
import javax.baja.weather.advisory.BAdvisory;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.BMgrTable;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrTypeInfo;

public class BAdvisoryManager
extends BAbstractManager {
    public static final Type TYPE = Sys.loadType(BAdvisoryManager.class);
    static Lexicon lex = Lexicon.make((String)"weather");
    MgrColumn colSummary = new MgrColumn.Prop(BAdvisory.TYPE.getDisplayName(null), BAdvisory.weatherSummary, 4);
    MgrColumn colState = new MgrColumn.Prop(BAdvisory.state, 4);
    MgrColumn colUrgency = new MgrColumn.Prop(BAdvisory.urgency, 4);
    MgrColumn colSeverity = new MgrColumn.Prop(BAdvisory.severity, 4);
    MgrColumn colCertainty = new MgrColumn.Prop(BAdvisory.certainty, 4);
    MgrColumn colEffective = new MgrColumn.Prop(BAdvisory.effective, 4);
    MgrColumn colExpires = new MgrColumn.Prop(BAdvisory.expires, 4);
    protected MgrColumn[] cols = new MgrColumn[]{this.colSummary, this.colState, this.colUrgency, this.colSeverity, this.colCertainty, this.colEffective, this.colExpires};

    public Type getType() {
        return TYPE;
    }

    protected void init() {
        super.init();
        this.getModel().getTable().sortByColumn(5, false);
    }

    protected MgrModel makeModel() {
        return new Model(this);
    }

    protected MgrController makeController() {
        return new Controller(this);
    }

    class SunriseColumn
    extends MgrColumn.Prop {
        public SunriseColumn() {
            super(lex.getText("sunrise.sunset"), BWeatherReport.current, 4);
        }

        public String toDisplayString(Object row, Object value, Context cx) {
            BCurrentConditions r = (BCurrentConditions)value;
            return new StringBuffer().append(r.getSunrise()).append('/').append(r.getSunset()).toString();
        }

        public Object toSortKey(Object row) {
            BCurrentConditions conditions = (BCurrentConditions)super.toSortKey(row);
            return conditions.getSunrise();
        }
    }

    class ForecastColumn
    extends MgrColumn.Prop {
        int myIndex;

        public ForecastColumn(String name, int index) {
            super(name, BWeatherReport.current, 4);
            this.myIndex = 0;
            this.myIndex = index;
        }

        public String toDisplayString(Object row, Object value, Context cx) {
            BCurrentConditions curr = (BCurrentConditions)value;
            BWeatherReport r = (BWeatherReport)curr.getParent();
            BForecast[] f = r.getForecast();
            if (this.myIndex < f.length) {
                return f[this.myIndex].toString(cx);
            }
            return "-";
        }

        public Object toSortKey(Object row) {
            BCurrentConditions curr = (BCurrentConditions)super.toSortKey(row);
            BWeatherReport r = (BWeatherReport)curr.getParent();
            BForecast[] f = r.getForecast();
            if (this.myIndex < f.length) {
                return f[this.myIndex];
            }
            return null;
        }
    }

    class Model
    extends MgrModel {
        Model(BAdvisoryManager mgr) {
            super((BAbstractManager)mgr);
        }

        protected String makeTableTitle() {
            return TYPE.getDisplayName(null);
        }

        protected MgrColumn[] makeColumns() {
            return this.appendMixInColumns(BAdvisoryManager.this.cols, BWeatherReport.TYPE);
        }

        public int getSubscribeDepth() {
            return 3;
        }

        public Type[] getIncludeTypes() {
            return new Type[]{BAdvisory.TYPE};
        }

        public MgrTypeInfo[] getNewTypes() {
            return new MgrTypeInfo[0];
        }

        protected BMgrTable makeTable() {
            BMgrTable table = new BMgrTable((MgrModel)this);
            table.setCellRenderer((TableCellRenderer)new BMgrTable.CellRenderer(table){

                public BBrush getForeground(TableCellRenderer.Cell cell) {
                    return Theme.table().getTextBrush();
                }

                public BBrush getBackground(TableCellRenderer.Cell cell) {
                    BColor c = (BColor)BStatus.ok.getBackgroundColor(null);
                    if (c != null) {
                        return c.toBrush();
                    }
                    return null;
                }
            });
            return table;
        }
    }

    class Controller
    extends MgrController {
        public Controller(BAbstractManager manager) {
            super(manager);
        }

        protected MgrController.IMgrCommand[] makeCommands() {
            return new MgrController.IMgrCommand[0];
        }

        public void cellDoubleClicked(BMgrTable table, BMouseEvent event, int row, int col) {
            BAdvisoryDetailsDialog dialog = new BAdvisoryDetailsDialog(BAdvisoryManager.this, (BAdvisory)this.getSelectedComponents()[0]);
            dialog.setBoundsCenteredOnOwner();
            dialog.open();
        }
    }
}

