/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.weather.nws.hx;

import com.tridium.weather.nws.BNwsWeatherProvider;
import com.tridium.weather.nws.NwsStationList;
import java.io.IOException;
import java.util.Arrays;
import javax.baja.hx.BHxFieldEditor;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BHxNwsWeatherProviderFE
extends BHxFieldEditor {
    public static final BHxNwsWeatherProviderFE INSTANCE = new BHxNwsWeatherProviderFE();
    public static final Type TYPE = Sys.loadType(BHxNwsWeatherProviderFE.class);
    private UpdateLocationsCommand updateLocations = new UpdateLocationsCommand((BHxView)this);

    public Type getType() {
        return TYPE;
    }

    protected BHxNwsWeatherProviderFE() {
        this.registerEvent((Event)this.updateLocations);
    }

    public void write(HxOp op) throws Exception {
        BNwsWeatherProvider provider = (BNwsWeatherProvider)op.get();
        NwsStationList stations = new NwsStationList();
        NwsStationList.Station station = stations.getStation(provider.getStationId());
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<span style='white-space:nowrap;'>");
        String[] stateNames = stations.getStates();
        Arrays.sort(stateNames, String.CASE_INSENSITIVE_ORDER);
        out.w((Object)"<select onChange='").w((Object)this.updateLocations.getInvokeCode(op)).w((Object)"' id='").w((Object)op.scope("state")).w((Object)"' name='").w((Object)op.scope("state")).w((Object)"'");
        if (!op.canWrite()) {
            out.w((Object)" disabled='disabled'");
        }
        out.w((Object)">");
        String state = stateNames[0];
        for (String stateName : stateNames) {
            if (station != null && station.state.equals(stateName)) {
                out.w((Object)"<option selected='selected' value='").safe((Object)stateName).w((Object)"'>").safe((Object)stateName).w((Object)"</option>");
                state = stateName;
                continue;
            }
            out.w((Object)"<option value='").w((Object)stateName).w((Object)"'>").safe((Object)stateName).w((Object)"</option>");
        }
        out.w((Object)"</select>");
        out.w((Object)"&nbsp;&nbsp;");
        out.w((Object)"<span id='").w((Object)op.scope("locationDiv")).w((Object)"'>");
        this.drawLocationSelect(state, station != null ? station.name : null, op);
        out.w((Object)"</span>");
        out.w((Object)"</span>");
    }

    public BObject save(HxOp op) throws Exception {
        BNwsWeatherProvider provider = (BNwsWeatherProvider)op.get();
        String state = op.getFormValue("state");
        String location = op.getFormValue("location");
        if (state == null || state.equals("") || location == null || location.equals("")) {
            return provider;
        }
        NwsStationList stations = new NwsStationList();
        String stationId = stations.getStationId(location, state);
        BString bStationId = BString.make((String)stationId);
        if (!bStationId.equals((Object)provider.getStationId())) {
            provider.set(BNwsWeatherProvider.stationId, (BValue)bStationId, (Context)op);
        }
        return provider;
    }

    private void drawLocationSelect(String state, String currentValue, HxOp op) throws IOException {
        HtmlWriter out = op.getHtmlWriter();
        NwsStationList stations = new NwsStationList();
        String[] locationNames = stations.getLocations(state);
        Arrays.sort(locationNames, String.CASE_INSENSITIVE_ORDER);
        out.w((Object)"<select id='").w((Object)op.scope("location")).w((Object)"' name='").w((Object)op.scope("location")).w((Object)"'");
        if (!op.canWrite()) {
            out.w((Object)" disabled='disabled'");
        }
        out.w((Object)">");
        for (int i = 0; i < locationNames.length; ++i) {
            if (locationNames[i].equals(currentValue)) {
                out.w((Object)"<option selected='selected' value='").safe((Object)locationNames[i]).w((Object)"'>").safe((Object)locationNames[i]).w((Object)"</option>");
                continue;
            }
            out.w((Object)"<option value='").safe((Object)locationNames[i]).w((Object)"'>").safe((Object)locationNames[i]).w((Object)"</option>");
        }
        out.w((Object)"</select>");
    }

    private class UpdateLocationsCommand
    extends Command {
        public UpdateLocationsCommand(BHxView view) {
            super(view);
        }

        public void handle(HxOp op) throws Exception {
            HtmlWriter out = op.getHtmlWriter();
            String state = op.getFormValue("state");
            out.w((Object)"var locationDiv = document.getElementById('").w((Object)op.scope("locationDiv")).w((Object)"');");
            out.w((Object)"locationDiv.innerHTML=\"");
            BHxNwsWeatherProviderFE.this.drawLocationSelect(state, null, op);
            out.w((Object)"\";");
        }
    }
}

