/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.kitpx;

import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBinding;

public class BSpectrumBinding
extends BBinding {
    public static final Property widgetProperty = BSpectrumBinding.newProperty((int)0, (String)"fill", null);
    public static final Property lowColor = BSpectrumBinding.newProperty((int)0, (BValue)BColor.blue, null);
    public static final Property midColor = BSpectrumBinding.newProperty((int)0, (BValue)BColor.white, null);
    public static final Property highColor = BSpectrumBinding.newProperty((int)0, (BValue)BColor.red, null);
    public static final Property setpoint = BSpectrumBinding.newProperty((int)0, (int)50, null);
    public static final Property extent = BSpectrumBinding.newProperty((int)0, (int)100, null);
    public static final Type TYPE = Sys.loadType(BSpectrumBinding.class);

    public String getWidgetProperty() {
        return this.getString(widgetProperty);
    }

    public void setWidgetProperty(String v) {
        this.setString(widgetProperty, v, null);
    }

    public BColor getLowColor() {
        return (BColor)this.get(lowColor);
    }

    public void setLowColor(BColor v) {
        this.set(lowColor, (BValue)v, null);
    }

    public BColor getMidColor() {
        return (BColor)this.get(midColor);
    }

    public void setMidColor(BColor v) {
        this.set(midColor, (BValue)v, null);
    }

    public BColor getHighColor() {
        return (BColor)this.get(highColor);
    }

    public void setHighColor(BColor v) {
        this.set(highColor, (BValue)v, null);
    }

    public double getSetpoint() {
        return this.getDouble(setpoint);
    }

    public void setSetpoint(double v) {
        this.setDouble(setpoint, v, null);
    }

    public double getExtent() {
        return this.getDouble(extent);
    }

    public void setExtent(double v) {
        this.setDouble(extent, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BValue getOnWidget(Property prop) {
        BObject target;
        if (prop.getName().equals(this.getWidgetProperty()) && this.isBound() && (target = this.get()) instanceof BINumeric) {
            double value = ((BINumeric)target).getNumeric();
            BColor color = this.solveColor(value);
            if (prop.getType().is(BBrush.TYPE)) {
                return color.toBrush();
            }
            if (prop.getType().is(BColor.TYPE)) {
                return color;
            }
        }
        return super.getOnWidget(prop);
    }

    BColor solveColor(double value) {
        int alpha;
        int blue;
        int green;
        int red;
        double mid = this.getSetpoint();
        double delta = this.getExtent() / 2.0;
        BColor lowColor = this.getLowColor();
        BColor midColor = this.getMidColor();
        BColor highColor = this.getHighColor();
        if (value < mid) {
            if (value < mid - delta) {
                return lowColor;
            }
            double mRed = (double)(midColor.getRed() - lowColor.getRed()) / delta;
            double bRed = (double)midColor.getRed() - mRed * mid;
            red = (int)(mRed * value + bRed);
            double mGreen = (double)(midColor.getGreen() - lowColor.getGreen()) / delta;
            double bGreen = (double)midColor.getGreen() - mGreen * mid;
            green = (int)(mGreen * value + bGreen);
            double mBlue = (double)(midColor.getBlue() - lowColor.getBlue()) / delta;
            double bBlue = (double)midColor.getBlue() - mBlue * mid;
            blue = (int)(mBlue * value + bBlue);
            double mAlpha = (double)(midColor.getAlpha() - lowColor.getAlpha()) / delta;
            double bAlpha = (double)midColor.getAlpha() - mAlpha * mid;
            alpha = (int)(mAlpha * value + bAlpha);
        } else {
            if (value > mid + delta) {
                return highColor;
            }
            double mRed = (double)(highColor.getRed() - midColor.getRed()) / delta;
            double bRed = (double)midColor.getRed() - mRed * mid;
            red = (int)(mRed * value + bRed);
            double mGreen = (double)(highColor.getGreen() - midColor.getGreen()) / delta;
            double bGreen = (double)midColor.getGreen() - mGreen * mid;
            green = (int)(mGreen * value + bGreen);
            double mBlue = (double)(highColor.getBlue() - midColor.getBlue()) / delta;
            double bBlue = (double)midColor.getBlue() - mBlue * mid;
            blue = (int)(mBlue * value + bBlue);
            double mAlpha = (double)(highColor.getAlpha() - midColor.getAlpha()) / delta;
            double bAlpha = (double)midColor.getAlpha() - mAlpha * mid;
            alpha = (int)(mAlpha * value + bAlpha);
        }
        return BColor.make((int)red, (int)green, (int)blue, (int)alpha);
    }
}

