/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.kitpx;

import com.tridium.kitpx.BPopupProfile;
import com.tridium.ui.UiEnv;
import com.tridium.util.FormatUtil;
import com.tridium.workbench.shell.BNiagaraWbDialog;
import java.util.logging.Level;
import javax.baja.gx.BPoint;
import javax.baja.gx.BSize;
import javax.baja.naming.BOrd;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBinding;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;

public final class BPopupBinding
extends BBinding {
    public static final Property title = BPopupBinding.newProperty((int)0, (String)"Pop up", null);
    public static final Property position = BPopupBinding.newProperty((int)0, (BValue)BPoint.make((double)100.0, (double)100.0), null);
    public static final Property size = BPopupBinding.newProperty((int)0, (BValue)BSize.make((double)800.0, (double)600.0), null);
    public static final Property modal = BPopupBinding.newProperty((int)0, (boolean)false, null);
    public static final Action mouseEvent = BPopupBinding.newAction((int)0, (BValue)new BMouseEvent(), null);
    public static final Type TYPE = Sys.loadType(BPopupBinding.class);
    private MouseCursor restoreCursor;
    private boolean isOver = false;
    private static final Lexicon lex = Lexicon.make(BPopupBinding.class);

    public String getTitle() {
        return this.getString(title);
    }

    public void setTitle(String v) {
        this.setString(title, v, null);
    }

    public BPoint getPosition() {
        return (BPoint)this.get(position);
    }

    public void setPosition(BPoint v) {
        this.set(position, (BValue)v, null);
    }

    public BSize getSize() {
        return (BSize)this.get(size);
    }

    public void setSize(BSize v) {
        this.set(size, (BValue)v, null);
    }

    public boolean getModal() {
        return this.getBoolean(modal);
    }

    public void setModal(boolean v) {
        this.setBoolean(modal, v, null);
    }

    public void mouseEvent(BMouseEvent event) {
        this.invoke(mouseEvent, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        super.started();
        if (this.getWidget() != null) {
            this.linkTo((BComponent)this.getWidget(), (Slot)BWidget.mouseEvent, (Slot)mouseEvent);
        }
    }

    public void doMouseEvent(BMouseEvent event) {
        if (!this.getWidget().isEnabled()) {
            return;
        }
        switch (event.getId()) {
            case 504: {
                this.entered(event);
                break;
            }
            case 505: {
                this.exited(event);
                break;
            }
            case 502: {
                this.released(event);
            }
        }
    }

    private void entered(BMouseEvent event) {
        BWidgetShell shell = this.getShell();
        this.isOver = true;
        if (shell != null) {
            shell.showStatus(this.toShowStatus());
            this.restoreCursor = !this.getOrd().isNull() && UiEnv.get().hasMouse() ? this.getWidget().setMouseCursor(MouseCursor.hand) : null;
        }
    }

    private void exited(BMouseEvent event) {
        BWidgetShell shell = this.getShell();
        this.isOver = false;
        if (shell != null) {
            shell.showStatus("");
        }
        if (this.restoreCursor != null) {
            this.getWidget().setMouseCursor(this.restoreCursor);
        }
    }

    private void released(BMouseEvent event) {
        if (this.isOver && !this.getOrd().isNull() && event.isButton1Down()) {
            this.popup();
        }
    }

    String toShowStatus() {
        BOrd ord = this.getOrd();
        if (ord.isNull()) {
            return "";
        }
        return lex.getText("popupBinding.summary", new Object[]{ord});
    }

    private void popup() {
        try {
            BWbShell shell = BWbShell.getWbShell((BWidget)this.getWidget());
            BOrd o = BOrd.make((BOrd)shell.getActiveOrd(), (BOrd)this.getOrd()).normalize();
            String titleFormat = FormatUtil.formatForStringProperty((String)this.getTitle(), (Context)this.getTarget());
            BNiagaraWbDialog dlg = new BNiagaraWbDialog(BPopupProfile.TYPE, (BWidget)shell, o, titleFormat, this.getPosition(), this.getSize(), this.getModal());
            dlg.open();
        }
        catch (Exception e) {
            BBinding.LOGGER.log(Level.SEVERE, "Could not resolve pop up binding ORD", e);
        }
    }
}

