/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.kitpx;

import javax.baja.gx.BImage;
import javax.baja.gx.BSize;
import javax.baja.gx.Graphics;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;

public class BImageButton
extends BButton {
    public static final Property normal = BImageButton.newProperty((int)0, (BValue)BImage.NULL, null);
    public static final Property mouseOver = BImageButton.newProperty((int)0, (BValue)BImage.NULL, null);
    public static final Property pressed = BImageButton.newProperty((int)0, (BValue)BImage.NULL, null);
    public static final Property disabled = BImageButton.newProperty((int)0, (BValue)BImage.NULL, null);
    public static final Type TYPE = Sys.loadType(BImageButton.class);
    private boolean nloaded = false;
    private boolean oloaded = false;
    private boolean ploaded = false;
    private boolean dloaded = false;

    public BImage getNormal() {
        return (BImage)this.get(normal);
    }

    public void setNormal(BImage v) {
        this.set(normal, (BValue)v, null);
    }

    public BImage getMouseOver() {
        return (BImage)this.get(mouseOver);
    }

    public void setMouseOver(BImage v) {
        this.set(mouseOver, (BValue)v, null);
    }

    public BImage getPressed() {
        return (BImage)this.get(pressed);
    }

    public void setPressed(BImage v) {
        this.set(pressed, (BValue)v, null);
    }

    public BImage getDisabled() {
        return (BImage)this.get(disabled);
    }

    public void setDisabled(BImage v) {
        this.set(disabled, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void computePreferredSize() {
        super.computePreferredSize();
        BSize size = this.getMaxImageSize();
        double pw = Math.max(size.width, this.getPreferredWidth());
        double ph = Math.max(size.height, this.getPreferredHeight());
        if (pw > 0.0 && ph > 0.0) {
            this.setPreferredSize(pw, ph);
        }
    }

    public void paintBackground(Graphics g) {
        super.paintBackground(g);
        if (!this.isEnabled()) {
            BImage img = this.getDisabled();
            if (img.isNull() && !this.getNormal().isNull()) {
                img = this.getNormal().getDisabledImage();
            }
            this.paintImage(g, img);
        } else if (this.isPressed() && this.isMouseOver() && !this.getPressed().isNull()) {
            this.paintImage(g, this.getPressed());
        } else if (this.isMouseOver() && !this.getMouseOver().isNull()) {
            this.paintImage(g, this.getMouseOver());
        } else if (!this.getNormal().isNull()) {
            this.paintImage(g, this.getNormal());
        }
    }

    protected void paintIcon(Graphics g, BImage image, double x, double y) {
        if (this.getNormal().isNull() && this.getMouseOver().isNull() && this.getPressed().isNull()) {
            super.paintIcon(g, image, x, y);
        }
    }

    protected void paintText(Graphics g, String text, double tx, double ty) {
        if (!this.getNormal().isNull()) {
            return;
        }
        if (!this.getPressed().isNull() && this.isPressed()) {
            return;
        }
        if (!this.getMouseOver().isNull() && this.isMouseOver()) {
            return;
        }
        super.paintText(g, text, tx, ty);
    }

    private void paintImage(Graphics g, BImage img) {
        double x = (this.getWidth() - img.getWidth()) / 2.0;
        double y = (this.getHeight() - img.getHeight()) / 2.0;
        g.drawImage(img, x, y);
    }

    public void animate() {
        super.animate();
        if (!this.getNormal().isNull()) {
            if (!this.nloaded && this.getNormal().isLoaded()) {
                this.nloaded = true;
                this.relayout();
            }
            if (this.getNormal().animate()) {
                this.repaint();
            }
        }
        if (!this.getMouseOver().isNull()) {
            if (!this.oloaded && this.getMouseOver().isLoaded()) {
                this.oloaded = true;
                this.relayout();
            }
            if (this.getMouseOver().animate()) {
                this.repaint();
            }
        }
        if (!this.getPressed().isNull()) {
            if (!this.ploaded && this.getPressed().isLoaded()) {
                this.ploaded = true;
                this.relayout();
            }
            if (this.getPressed().animate()) {
                this.repaint();
            }
        }
        if (!this.getDisabled().isNull()) {
            if (!this.dloaded && this.getDisabled().isLoaded()) {
                this.dloaded = true;
                this.relayout();
            }
            if (this.getDisabled().animate()) {
                this.repaint();
            }
        }
    }

    private BSize getMaxImageSize() {
        double iw = 0.0;
        double ih = 0.0;
        BImage img = this.getNormal();
        if (!img.isNull()) {
            iw = img.getWidth();
            ih = img.getHeight();
        }
        if (!(img = this.getMouseOver()).isNull()) {
            iw = Math.max(iw, img.getWidth());
            ih = Math.max(ih, img.getHeight());
        }
        if (!(img = this.getPressed()).isNull()) {
            iw = Math.max(iw, img.getWidth());
            ih = Math.max(ih, img.getHeight());
        }
        if (!(img = this.getDisabled()).isNull()) {
            iw = Math.max(iw, img.getWidth());
            ih = Math.max(ih, img.getHeight());
        }
        return BSize.make((double)iw, (double)ih);
    }
}

