/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.kitpx;

import com.tridium.kitpx.enums.BMouseOverEffect;
import com.tridium.ui.theme.Theme;
import javax.baja.agent.AgentList;
import javax.baja.gx.BBrush;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BLabel;
import javax.baja.ui.event.BMouseEvent;

public class BBoundLabel
extends BLabel {
    public static final Property border = BBoundLabel.newProperty((int)0, (BValue)BBorder.none, null);
    public static final Property mouseOver = BBoundLabel.newProperty((int)0, (BValue)BMouseOverEffect.none, null);
    public static final Property padding = BBoundLabel.newProperty((int)0, (BValue)BInsets.DEFAULT, null);
    public static final Type TYPE = Sys.loadType(BBoundLabel.class);
    private BImage img;
    private boolean isMouseOver = false;

    public BBorder getBorder() {
        return (BBorder)this.get(border);
    }

    public void setBorder(BBorder v) {
        this.set(border, (BValue)v, null);
    }

    public BMouseOverEffect getMouseOver() {
        return (BMouseOverEffect)this.get(mouseOver);
    }

    public void setMouseOver(BMouseOverEffect v) {
        this.set(mouseOver, (BValue)v, null);
    }

    public BInsets getPadding() {
        return (BInsets)this.get(padding);
    }

    public void setPadding(BInsets v) {
        this.set(padding, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public boolean receiveInputEvents() {
        return true;
    }

    public void paint(Graphics g) {
        super.paint(g);
        BBorder border = this.isMouseOver && this.getMouseOver().equals((Object)BMouseOverEffect.outline) ? (this.getBorder().isNull() || this.getBorder().topWidth == 0.0 && this.getBorder().leftWidth == 0.0 && this.getBorder().rightWidth == 0.0 && this.getBorder().bottomWidth == 0.0 ? BBorder.make((double)1.0, (int)1, (BBrush)Theme.widget().getSelectionBackground()) : BBorder.make((BBorder)this.getBorder(), (BBrush)Theme.widget().getSelectionBackground())) : this.getBorder();
        border.paint(g, 1.0, 1.0, this.getWidth() - 2.0, this.getHeight() - 2.0);
    }

    protected void paintBackground(Graphics g, BBrush background) {
        if (this.isMouseOver && this.getMouseOver().equals((Object)BMouseOverEffect.highlight)) {
            g.push();
            g.setBrush(Theme.widget().getSelectionBackground());
            g.fillRect(0.0, 0.0, this.getWidth(), this.getHeight());
            g.pop();
        } else {
            super.paintBackground(g, background);
        }
    }

    protected void paintIcon(Graphics g, BImage image, double x, double y) {
        if (this.isMouseOver && this.getMouseOver().equals((Object)BMouseOverEffect.highlight)) {
            image = this.makeImage(image);
        }
        super.paintIcon(g, image, x, y);
    }

    protected void paintText(Graphics g, String text, double tx, double ty) {
        g.push();
        if (this.isMouseOver && this.getMouseOver().equals((Object)BMouseOverEffect.highlight)) {
            g.setBrush(Theme.widget().getSelectionForeground());
        }
        super.paintText(g, text, tx, ty);
        g.pop();
    }

    public void mouseEntered(BMouseEvent event) {
        this.isMouseOver = true;
        this.repaint();
    }

    public void mouseExited(BMouseEvent event) {
        this.isMouseOver = false;
        this.repaint();
    }

    public AgentList getAgents(Context cx) {
        AgentList agents = super.getAgents(cx);
        agents.toTop("kitPx:BoundLabelBinding");
        return agents;
    }

    private BImage makeImage(BImage orig) {
        int w = (int)orig.getWidth();
        int h = (int)orig.getHeight();
        int[] pixels = orig.getPixels();
        for (int j = 0; j < h; ++j) {
            for (int i = 0; i < w; ++i) {
                int rgb = pixels[j * w + i];
                int a = 0xFF & rgb >> 24;
                int r = 0xFF & rgb >> 16;
                int g = 0xFF & rgb >> 8;
                int b = 0xFF & rgb;
                b = b / 2 + 65;
                pixels[j * w + i] = a << 24 | (r /= 2) << 16 | (g /= 2) << 8 | b;
            }
        }
        if (this.img == null || this.img.getWidth() != (double)w || this.img.getHeight() != (double)h) {
            this.img = BImage.make((double)w, (double)h);
        }
        this.img.setPixels(pixels);
        return this.img;
    }
}

