/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.driver.util;

import com.tridium.sys.metrics.BISubLicenseable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceExt;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.driver.util.BAbstractDescriptor;
import javax.baja.driver.util.BDescriptorDeviceExt;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.status.BStatus;
import javax.baja.sys.BComplex;
import javax.baja.sys.BObject;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public abstract class BDescriptor
extends BAbstractDescriptor {
    public static final Type TYPE = Sys.loadType(BDescriptor.class);
    static TypeInfo archiveType;
    static TypeInfo schedExportType;
    static TypeInfo schedImportType;
    private BDevice device;
    private BDescriptorDeviceExt deviceExt;
    private boolean fatalFault;
    private BDeviceNetwork network;
    private int oldStatus = 16;

    @Override
    public Type getType() {
        return TYPE;
    }

    public final BDevice getDevice() {
        if (this.device != null) {
            return this.device;
        }
        if (!this.isRunning()) {
            throw new NotRunningException();
        }
        throw new IllegalStateException(this.getFaultCause());
    }

    public final BDescriptorDeviceExt getDeviceExt() {
        if (this.deviceExt != null) {
            return this.deviceExt;
        }
        if (!this.isRunning()) {
            throw new NotRunningException();
        }
        throw new IllegalStateException(this.getFaultCause());
    }

    public final BDeviceNetwork getNetwork() {
        if (this.network != null) {
            return this.network;
        }
        if (!this.isRunning()) {
            throw new NotRunningException();
        }
        throw new IllegalStateException(this.getFaultCause());
    }

    @Override
    public boolean isUnoperational() {
        return this.fatalFault || super.isUnoperational();
    }

    @Override
    public final boolean isDown() {
        return super.isDown();
    }

    @Override
    public final boolean isFault() {
        return super.isFault();
    }

    @Override
    public final boolean isDisabled() {
        return super.isDisabled();
    }

    @Override
    public final void updateStatus() {
        BStatus devStatus;
        int newStatus = this.getStatus().getBits();
        BStatus bStatus = devStatus = this.device == null ? BStatus.ok : this.device.getStatus();
        newStatus = !this.getEnabled() || devStatus.isDisabled() ? (newStatus |= 1) : (newStatus &= 0xFFFFFFFE);
        newStatus = devStatus.isDown() ? (newStatus |= 4) : (newStatus &= 0xFFFFFFFB);
        newStatus = this.isFatalFault() || !this.getLastFailure().isNull() && this.getLastFailure().isAfter(this.getLastSuccess()) || devStatus.isFault() ? (newStatus |= 2) : (newStatus &= 0xFFFFFFFD);
        if (newStatus == this.oldStatus) {
            return;
        }
        this.setStatus(BStatus.make((int)newStatus));
        this.oldStatus = newStatus;
    }

    public final boolean isFatalFault() {
        return this.fatalFault;
    }

    private void checkFatalFault() {
        Object licenseFault;
        BDeviceExt deviceExt = null;
        for (BComplex parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof BDescriptorDeviceExt)) continue;
            deviceExt = (BDescriptorDeviceExt)parent;
            break;
        }
        if (deviceExt == null) {
            this.fatalFault = true;
            this.setFaultCause("Not under DescriptorDeviceExt");
            return;
        }
        BDevice device = deviceExt.getDevice();
        if (device == null) {
            this.fatalFault = true;
            this.setFaultCause("Not under Device");
            return;
        }
        if (device.isFatalFault()) {
            this.fatalFault = true;
            this.setFaultCause("Device fault: " + device.getFaultCause());
            return;
        }
        BDeviceNetwork network = device.getNetwork();
        if (network == null) {
            this.fatalFault = true;
            this.setFaultCause("Not under DeviceNetwork");
            return;
        }
        if (network.isFatalFault()) {
            this.fatalFault = true;
            this.setFaultCause("Network fault: " + network.getFaultCause());
            return;
        }
        String licenseLimitKey = this.getLicenseLimitKey();
        if (licenseLimitKey != null && (licenseFault = network.fw(501, BISubLicenseable.getLicenseKey((BObject)this, (String)licenseLimitKey), (Object)this, null, null)) != null) {
            this.fatalFault = true;
            this.setFaultCause(licenseFault.toString());
            return;
        }
        this.network = network;
        this.device = device;
        this.deviceExt = deviceExt;
        this.setFaultCause("");
        if (this.network == null || this.device == null || this.deviceExt == null) {
            throw new IllegalStateException();
        }
    }

    private String getLicenseLimitKey() {
        Type t = this.getType();
        if (archiveType != null && t.is(archiveType)) {
            return "history.limit";
        }
        if (schedImportType != null && t.is(schedImportType) || schedExportType != null && t.is(schedExportType)) {
            return "schedule.limit";
        }
        return null;
    }

    @Override
    public final Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 11: {
                return this.fwStarted(a, b, c, d);
            }
            case 12: {
                this.fwStopped();
            }
        }
        return super.fw(x, a, b, c, d);
    }

    private Object fwStarted(Object a, Object b, Object c, Object d) {
        this.checkFatalFault();
        super.fw(11, a, b, c, d);
        if (Sys.isStationStarted()) {
            super.fw(23, a, b, c, d);
        }
        return null;
    }

    private void fwStopped() {
        this.network = null;
        this.device = null;
        this.deviceExt = null;
    }

    static {
        try {
            archiveType = Sys.getRegistry().getType("driver:ArchiveDescriptor");
        }
        catch (Exception e) {
            Logger.getLogger(TYPE.getModule().getModuleName()).log(Level.SEVERE, "Could not find type 'driver:ArchiveDescriptor'", e);
        }
        try {
            schedExportType = Sys.getRegistry().getType("driver:ScheduleExport");
        }
        catch (Exception e) {
            Logger.getLogger(TYPE.getModule().getModuleName()).log(Level.SEVERE, "Could not find type 'driver:ScheduleExport'", e);
        }
        try {
            schedImportType = Sys.getRegistry().getType("driver:ScheduleImportExt");
        }
        catch (Exception e) {
            Logger.getLogger(TYPE.getModule().getModuleName()).log(Level.SEVERE, "Could not find type 'driver:ScheduleImportExt'", e);
        }
    }
}

