/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.driver.point;

import java.util.Comparator;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.driver.point.BTuningPolicy;
import javax.baja.driver.point.Tuning;
import javax.baja.nre.util.Array;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BTuningPolicyMap
extends BComponent {
    public static final Property defaultPolicy = BTuningPolicyMap.newProperty((int)0, (BValue)new BTuningPolicy(), null);
    public static final Type TYPE = Sys.loadType(BTuningPolicyMap.class);
    private static final BIcon icon = BIcon.std((String)"wrench.png");
    static long minScan = 200L;
    static long maxScan = 20000L;
    BackgroundThread thread;
    Object lock = new Object();
    Tuning[] tunings = new Tuning[100];
    long scanFrequency = 1000L;
    int scanCount;
    long lastScanDuration;

    public BTuningPolicy getDefaultPolicy() {
        return (BTuningPolicy)this.get(defaultPolicy);
    }

    public void setDefaultPolicy(BTuningPolicy v) {
        this.set(defaultPolicy, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final BDeviceNetwork getNetwork() {
        return (BDeviceNetwork)this.getParent();
    }

    public final BTuningPolicy[] getPolicies() {
        return (BTuningPolicy[])this.getChildren(BTuningPolicy.class);
    }

    public boolean isChildLegal(BComponent c) {
        return c instanceof BTuningPolicy;
    }

    public void started() throws Exception {
        super.started();
        this.startThread();
    }

    public void stopped() throws Exception {
        super.stopped();
        this.stopThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int register(Tuning tuning) {
        Object object = this.lock;
        synchronized (object) {
            for (int i = 1; i < this.tunings.length; ++i) {
                if (this.tunings[i] != null) continue;
                this.tunings[i] = tuning;
                return i;
            }
            int oldLength = this.tunings.length;
            Tuning[] temp = new Tuning[oldLength * 2];
            System.arraycopy(this.tunings, 0, temp, 0, oldLength);
            this.tunings = temp;
            this.tunings[oldLength] = tuning;
            return oldLength;
        }
    }

    void startThread() {
        this.stopThread();
        this.thread = new BackgroundThread(this.getNetwork());
        this.thread.start();
    }

    void stopThread() {
        if (this.thread != null) {
            this.thread.kill();
        }
        this.thread = null;
    }

    long computeScanFrequency() {
        long t = maxScan;
        BTuningPolicy[] policies = this.getPolicies();
        for (int i = 0; i < policies.length; ++i) {
            BTuningPolicy policy = policies[i];
            long minWrite = policy.getMinWriteTime().getMillis();
            long maxWrite = policy.getMaxWriteTime().getMillis();
            long stale = policy.getStaleTime().getMillis();
            if (minWrite > 0L) {
                t = Math.min(t, minWrite / 2L);
            }
            if (maxWrite > 0L) {
                t = Math.min(t, maxWrite / 2L);
            }
            if (stale <= 0L) continue;
            t = Math.min(t, stale / 2L);
        }
        t = Math.max(t, minScan);
        return t;
    }

    public void spy(SpyWriter out) throws Exception {
        Array a = new Array(Tuning.class);
        for (int i = 0; i < this.tunings.length; ++i) {
            if (this.tunings[i] == null) continue;
            a.add((Object)this.tunings[i]);
        }
        out.startProps("Tuning Performance");
        out.prop((Object)"scanFrequency", (Object)BRelTime.toString((long)this.scanFrequency));
        out.prop((Object)"scanCount", (Object)("" + this.scanCount));
        out.prop((Object)"lastScanDuration", (Object)BRelTime.toString((long)this.lastScanDuration));
        out.prop((Object)"proxyPointCount", (Object)("" + a.size()));
        out.endProps();
        super.spy(out);
        int max = 1000;
        if (a.size() < max) {
            a = a.sort((Comparator)new Comparator<Tuning>(){

                @Override
                public int compare(Tuning x, Tuning y) {
                    BComponent xc = (BComponent)x.getTunable();
                    BComponent yc = (BComponent)y.getTunable();
                    String xs = xc.toPathString();
                    String ys = yc.toPathString();
                    return xs.compareTo(ys);
                }
            });
        }
        out.startTable(true);
        out.trTitle((Object)("Proxy Point List [" + a.size() + "]"), 3);
        out.w((Object)"<tr>").th((Object)"Id").th((Object)"Path").th((Object)"Type").w((Object)"</tr>\n");
        for (int i = 0; i < a.size() && i < max; ++i) {
            Tuning t = (Tuning)a.get(i);
            BComponent p = (BComponent)t.getTunable();
            out.tr((Object)("" + t.processId()), (Object)p.toPathString(), (Object)p.getType());
        }
        if (a.size() >= max) {
            out.tr((Object)("" + (a.size() - max) + " more points..."), (Object)"");
        }
        out.endTable();
    }

    public BIcon getIcon() {
        return icon;
    }

    class BackgroundThread
    extends Thread {
        BDeviceNetwork network;
        boolean isAlive;

        BackgroundThread(BDeviceNetwork network) {
            super("Tuning:" + network.getName());
            this.isAlive = true;
            this.network = network;
        }

        void kill() {
            this.isAlive = false;
            this.interrupt();
        }

        @Override
        public void run() {
            while (this.isAlive) {
                try {
                    BTuningPolicyMap.this.scanFrequency = BTuningPolicyMap.this.computeScanFrequency();
                    Thread.sleep(BTuningPolicyMap.this.scanFrequency);
                    if (!this.network.isDescendantsStarted()) continue;
                    long t1 = Clock.ticks();
                    Tuning[] temp = BTuningPolicyMap.this.tunings;
                    for (int i = 0; i < temp.length; ++i) {
                        this.process(temp, i);
                    }
                    long t2 = Clock.ticks();
                    ++BTuningPolicyMap.this.scanCount;
                    BTuningPolicyMap.this.lastScanDuration = t2 - t1;
                }
                catch (Throwable e) {
                    if (!this.isAlive) continue;
                    e.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void process(Tuning[] list, int index) {
            block6: {
                Tuning t = list[index];
                if (t == null) {
                    return;
                }
                try {
                    boolean ok = t.process();
                    if (ok) break block6;
                    Object object = BTuningPolicyMap.this.lock;
                    synchronized (object) {
                        BTuningPolicyMap.this.tunings[index] = null;
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

