/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.driver.point;

import com.tridium.sys.metrics.BISubLicenseable;
import com.tridium.sys.metrics.Metrics;
import com.tridium.sys.resource.ResourceReport;
import javax.baja.control.BControlPoint;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.driver.point.BDefaultProxyConversion;
import javax.baja.driver.point.BITunable;
import javax.baja.driver.point.BPointDeviceExt;
import javax.baja.driver.point.BProxyConversion;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.driver.point.BTuningPolicy;
import javax.baja.driver.point.Tuning;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComplex;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnitConversion;

public abstract class BProxyExt
extends BAbstractProxyExt
implements BIStatus,
BITunable {
    public static final Property status = BProxyExt.newProperty((int)3, (BValue)BStatus.stale, null);
    public static final Property faultCause = BProxyExt.newProperty((int)3, (String)"", null);
    public static final Property enabled = BProxyExt.newProperty((int)0, (boolean)true, null);
    public static final Property deviceFacets = BProxyExt.newProperty((int)0, (BValue)BFacets.NULL, null);
    public static final Property conversion = BProxyExt.newProperty((int)0, (BValue)BDefaultProxyConversion.DEFAULT, (BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldEditor", (String)"driver:ProxyConversionFE"), (BFacets)BFacets.make((String)"uxFieldEditor", (String)"driver:ProxyConversionEditor")));
    public static final Property tuningPolicyName = BProxyExt.newProperty((int)0, (String)"defaultPolicy", (BFacets)TUNING_POLICY_NAME_FACETS);
    public static final Property readValue = BProxyExt.newProperty((int)3, (BValue)new BStatusString("-"), null);
    public static final Property writeValue = BProxyExt.newProperty((int)3, (BValue)new BStatusString("-"), null);
    public static final Type TYPE = Sys.loadType(BProxyExt.class);
    static final int FATAL_FAULT = 1;
    static final int STALE = 2;
    static final int FORCE_WRITE = 4;
    static final int CONV_ERR_D2P = 8;
    static final int CONV_ERR_P2D = 16;
    private BDevice device;
    private BPointDeviceExt deviceExt;
    private int flags = 2;
    private int oldStatus = 16;
    private String readFault;
    private String writeFault;
    private BStatusValue lastWorking;
    private Tuning tuning = new Tuning(this);

    @Override
    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public BFacets getDeviceFacets() {
        return (BFacets)this.get(deviceFacets);
    }

    public void setDeviceFacets(BFacets v) {
        this.set(deviceFacets, (BValue)v, null);
    }

    public BProxyConversion getConversion() {
        return (BProxyConversion)this.get(conversion);
    }

    public void setConversion(BProxyConversion v) {
        this.set(conversion, (BValue)v, null);
    }

    @Override
    public String getTuningPolicyName() {
        return this.getString(tuningPolicyName);
    }

    public void setTuningPolicyName(String v) {
        this.setString(tuningPolicyName, v, null);
    }

    public BStatusValue getReadValue() {
        return (BStatusValue)this.get(readValue);
    }

    public void setReadValue(BStatusValue v) {
        this.set(readValue, (BValue)v, null);
    }

    public BStatusValue getWriteValue() {
        return (BStatusValue)this.get(writeValue);
    }

    public void setWriteValue(BStatusValue v) {
        this.set(writeValue, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public abstract Type getDeviceExtType();

    @Override
    public abstract BReadWriteMode getMode();

    public final BDeviceNetwork getNetwork() {
        return this.getDevice().getNetwork();
    }

    public final BDevice getDevice() {
        if (this.device != null) {
            return this.device;
        }
        if (!this.isRunning()) {
            throw new NotRunningException();
        }
        throw new IllegalStateException(this.getFaultCause());
    }

    public final BPointDeviceExt getDeviceExt() {
        if (this.deviceExt != null) {
            return this.deviceExt;
        }
        if (!this.isRunning()) {
            throw new NotRunningException();
        }
        throw new IllegalStateException(this.getFaultCause());
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot.equals((Object)readValue) || slot.equals((Object)writeValue)) {
            return BFacets.make((BFacets)this.getDeviceFacets(), (String)"unitConversion", (BIDataValue)BDynamicEnum.make((BEnum)BUnitConversion.none));
        }
        return super.getSlotFacets(slot);
    }

    public final boolean isDown() {
        return this.getStatus().isDown();
    }

    public final boolean isDisabled() {
        return this.getStatus().isDisabled();
    }

    public final boolean isFault() {
        return this.getStatus().isFault();
    }

    public final boolean isUnoperational() {
        return this.isDown() || this.isDisabled() || this.isFatalFault();
    }

    public final void updateStatus() {
        BStatus device;
        int newStatus = this.getStatus().getBits();
        BStatus bStatus = device = this.device == null ? BStatus.ok : this.device.getStatus();
        newStatus = !this.getEnabled() || device.isDisabled() ? (newStatus |= 1) : (newStatus &= 0xFFFFFFFE);
        newStatus = device.isDown() ? (newStatus |= 4) : (newStatus &= 0xFFFFFFFB);
        newStatus = this.fatalFault() || this.readFault != null || this.writeFault != null || device.isFault() ? (newStatus |= 2) : (newStatus &= 0xFFFFFFFD);
        newStatus = this.stale() ? (newStatus |= 0x10) : (newStatus &= 0xFFFFFFEF);
        if (this.oldStatus == newStatus) {
            return;
        }
        this.setStatus(BStatus.make((int)newStatus));
        this.oldStatus = newStatus;
        this.updateFaultCause();
        this.getTuning().transition();
        this.executePoint();
    }

    private void updateFaultCause() {
        if (this.fatalFault()) {
            return;
        }
        String cause = this.readFault != null && this.writeFault != null ? "Read fault: " + this.readFault + "; Write fault: " + this.writeFault : (this.readFault != null ? "Read fault: " + this.readFault : (this.writeFault != null ? "Write fault: " + this.writeFault : (this.convErrD2P() || this.convErrP2D() ? "Conversion Error" : "")));
        this.setFaultCause(cause);
    }

    @Override
    public final boolean isFatalFault() {
        return this.fatalFault();
    }

    public final void configFatal(String cause) {
        this.fatalFault(true);
        this.setFaultCause(cause);
        this.updateStatus();
    }

    private void checkFatalFault(String badGroups) {
        Object licenseFault;
        if (badGroups != null) {
            this.configFatal("Exceeded point limit for " + badGroups);
            return;
        }
        BPointDeviceExt deviceExt = null;
        BDevice device = null;
        BDeviceNetwork network = null;
        if (this.fatalFault()) {
            return;
        }
        for (BComplex parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof BPointDeviceExt)) continue;
            deviceExt = (BPointDeviceExt)parent;
            break;
        }
        if (deviceExt == null) {
            this.fatalFault(true);
            this.setFaultCause("Not under PointDeviceExt");
            return;
        }
        if (!deviceExt.getType().is(this.getDeviceExtType())) {
            this.fatalFault(true);
            this.setFaultCause("Parent PointDeviceExt " + deviceExt.getType() + " is not " + this.getDeviceExtType());
            return;
        }
        device = deviceExt.getDevice();
        if (device == null) {
            this.fatalFault(true);
            this.setFaultCause("Not under Device");
            return;
        }
        if (!device.getType().is(deviceExt.getDeviceType())) {
            this.fatalFault(true);
            this.setFaultCause("Parent Device " + device.getType() + " is not " + deviceExt.getDeviceType());
            return;
        }
        if (device.isFatalFault()) {
            this.fatalFault(true);
            this.setFaultCause("Device fault: " + device.getFaultCause());
            return;
        }
        network = device.getNetwork();
        if (network == null) {
            this.fatalFault(true);
            this.setFaultCause("Not under DeviceNetwork");
            return;
        }
        if (network.isFatalFault()) {
            this.fatalFault(true);
            this.setFaultCause("Network fault: " + network.getFaultCause());
            return;
        }
        if (this.getType().is(deviceExt.getProxyExtType()) && (licenseFault = network.fw(501, BISubLicenseable.getLicenseKey((BObject)this, (String)"point.limit"), this, null, null)) != null) {
            this.fatalFault(true);
            this.setFaultCause(licenseFault.toString());
            return;
        }
        this.device = device;
        this.deviceExt = deviceExt;
        this.setFaultCause("");
        if (this.device == null || this.deviceExt == null) {
            throw new IllegalStateException();
        }
    }

    public void checkStatusValueTypes() {
        BControlPoint parent = this.getParentPoint();
        if (parent == null) {
            return;
        }
        BStatusValue out = parent.getOutStatusValue();
        if (out.getType() != this.getReadValue().getType()) {
            this.set(readValue, (BValue)((BStatusValue)out.getType().getInstance()));
        }
        if (out.getType() != this.getWriteValue().getType()) {
            this.set(writeValue, (BValue)((BStatusValue)out.getType().getInstance()));
        }
    }

    public final void onExecute(BStatusValue working, Context cx) {
        if (this.getMode().isWrite() && (this.hasWorkingChanged(working) || this.forceWrite())) {
            this.forceWrite(false);
            this.convertProxyToDevice(working, this.getWriteValue());
            this.getTuning().writeDesired();
        }
        BStatus inStatus = working.getStatus();
        this.convertDeviceToProxy(this.getReadValue(), working);
        BStatus readStatus = working.getStatus();
        int inBits = inStatus.getBits() & 0xFFFFFFBF;
        int readBits = readStatus.getBits();
        int myBits = this.getStatus().getBits();
        int bits = inBits | readBits | myBits;
        BStatus outStatus = readStatus.getFacets().isNull() ? BStatus.make((BStatus)inStatus, (int)bits) : BStatus.make((int)bits, (BFacets)BFacets.make((BFacets)inStatus.getFacets(), (BFacets)readStatus.getFacets()));
        working.setStatus(outStatus);
    }

    public void pointFacetsChanged() {
        this.forceWrite(true);
    }

    public void writablePointActionInvoked() {
        this.forceWrite(true);
    }

    private boolean hasWorkingChanged(BStatusValue working) {
        if (this.lastWorking == null) {
            this.lastWorking = (BStatusValue)working.newCopy();
            this.convertProxyToDevice(working, this.getWriteValue());
            return false;
        }
        if (this.lastWorking.equivalent((Object)working)) {
            return false;
        }
        this.lastWorking.copyFrom((BComplex)working);
        return true;
    }

    @Override
    public final Tuning getTuning() {
        return this.tuning;
    }

    @Override
    public void setStale(boolean stale, Context cx) {
        if (this.stale() != stale) {
            this.stale(stale);
            this.updateStatus();
        }
    }

    public final BTuningPolicy getTuningPolicy() {
        return this.getTuning().getPolicy();
    }

    @Override
    public boolean isSubscribedDesired() {
        return this.getParentPoint().isSubscribed();
    }

    public final void pointSubscribed() {
        this.getTuning().transition();
    }

    public final void pointUnsubscribed() {
        this.getTuning().transition();
    }

    @Override
    public abstract void readSubscribed(Context var1) throws Exception;

    @Override
    public abstract void readUnsubscribed(Context var1) throws Exception;

    @Override
    public abstract boolean write(Context var1) throws Exception;

    public void readOk(BStatusValue newValue) {
        this.setReadValue((BStatusValue)newValue.newCopy());
        this.getTuning().readOk();
        this.readFault = null;
        this.stale(false);
        this.updateStatus();
        this.executePoint();
    }

    public void readReset() {
        this.readFault = null;
        this.stale(true);
        this.updateStatus();
        this.executePoint();
    }

    @Override
    public void readFail(String cause) {
        this.getTuning().readFail();
        this.readFault = cause;
        this.oldStatus = -1;
        this.updateStatus();
        this.executePoint();
    }

    public void writeOk(BStatusValue writeValue) {
        if (this.getMode().isWriteonly()) {
            this.setReadValue((BStatusValue)writeValue.newCopy());
            this.stale(false);
        }
        this.getTuning().writeOk();
        this.writeFault = null;
        this.updateStatus();
        if (this.getMode().isWriteonly()) {
            this.executePoint();
        }
    }

    public void writeReset() {
        this.getTuning().writeFail();
        this.writeFault = null;
        this.oldStatus = -1;
        this.updateStatus();
    }

    @Override
    public void writeFail(String cause) {
        this.getTuning().writeFail();
        this.writeFault = cause;
        this.oldStatus = -1;
        this.updateStatus();
    }

    protected void convertDeviceToProxy(BStatusValue deviceValue, BStatusValue proxyValue) {
        boolean newErr;
        boolean oldErr = this.convErrD2P();
        try {
            this.getConversion().convertDeviceToProxy(this, deviceValue, proxyValue);
            newErr = false;
        }
        catch (Exception e) {
            proxyValue.setValueValue(deviceValue.getValueValue());
            proxyValue.setStatusFault(true);
            newErr = true;
        }
        if (oldErr != newErr) {
            this.convErrD2P(newErr);
            this.updateFaultCause();
        }
    }

    protected void convertProxyToDevice(BStatusValue proxyValue, BStatusValue deviceValue) {
        boolean newErr;
        boolean oldErr = this.convErrP2D();
        try {
            this.getConversion().convertProxyToDevice(this, proxyValue, deviceValue);
            newErr = false;
        }
        catch (Exception e) {
            deviceValue.setValueValue(proxyValue.getValueValue());
            deviceValue.setStatusFault(true);
            newErr = true;
        }
        if (oldErr != newErr) {
            this.convErrP2D(newErr);
            this.updateFaultCause();
        }
    }

    public final Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 11: {
                this.fwStarted();
                break;
            }
            case 20: {
                this.fwAtSteadyState();
                break;
            }
            case 12: {
                this.fwStopped();
                break;
            }
            case 14: {
                this.fwDescendantsStopped();
                break;
            }
            case 2: {
                this.fwChanged((Property)a);
                break;
            }
            case 21: {
                ((ResourceReport)a).add("proxyExt", 250);
            }
        }
        return super.fw(x, a, b, c, d);
    }

    private void fwStarted() {
        this.checkFatalFault(Metrics.incrementPoint((BComplex)this));
        this.updateStatus();
        this.getTuning().transition();
    }

    private void fwAtSteadyState() {
        this.getTuning().transition();
    }

    private void fwStopped() {
        this.getTuning().transition();
    }

    private void fwDescendantsStopped() {
        this.device = null;
        this.deviceExt = null;
    }

    private void fwChanged(Property prop) {
        if (!this.isRunning()) {
            return;
        }
        if (prop.equals(enabled)) {
            this.updateStatus();
        } else if (prop.equals(deviceFacets) || prop.equals(conversion)) {
            this.forceWrite(true);
            this.executePoint();
        }
    }

    public void spy(SpyWriter out) throws Exception {
        out.startProps("ProxyExt");
        out.prop((Object)"fatalFault", (Object)("" + this.fatalFault()));
        out.prop((Object)"stale", (Object)("" + this.stale()));
        out.prop((Object)"readFault", (Object)("" + this.readFault));
        out.prop((Object)"writeFault", (Object)("" + this.writeFault));
        out.prop((Object)"lastWorking", (Object)this.lastWorking);
        out.prop((Object)"convErrP2D", this.convErrP2D());
        out.prop((Object)"convErrD2P", this.convErrD2P());
        out.prop((Object)"tuning.subscribed", (Object)("" + this.tuning.subscribed()));
        out.prop((Object)"tuning.readTicks", (Object)BProxyExt.timestr(this.tuning.readTicks));
        out.prop((Object)"tuning.writeTicks", (Object)BProxyExt.timestr(this.tuning.writeTicks));
        out.prop((Object)"tuning.wrieDesiredTicks", (Object)BProxyExt.timestr(this.tuning.writeTicks));
        out.prop((Object)"tuning.writePending", (Object)("" + this.tuning.writePending()));
        out.prop((Object)"tuning.state", (Object)Tuning.toString(this.tuning.state()));
        out.prop((Object)"tuning.processId", (Object)("" + this.tuning.processId()));
        out.endProps();
        super.spy(out);
    }

    static String timestr(long ticks) {
        if (ticks == 0L) {
            return "null";
        }
        long now = Clock.ticks();
        long diff = now - ticks;
        if (diff < 1000L) {
            return "" + diff + "ms";
        }
        return diff / 1000L + "sec";
    }

    private boolean fatalFault() {
        return (this.flags & 1) != 0;
    }

    private void fatalFault(boolean b) {
        this.flags = b ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
    }

    private boolean stale() {
        return (this.flags & 2) != 0;
    }

    private void stale(boolean b) {
        this.flags = b ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
    }

    private boolean forceWrite() {
        return (this.flags & 4) != 0;
    }

    private void forceWrite(boolean b) {
        this.flags = b ? (this.flags |= 4) : (this.flags &= 0xFFFFFFFB);
    }

    private boolean convErrD2P() {
        return (this.flags & 8) != 0;
    }

    private void convErrD2P(boolean b) {
        this.flags = b ? (this.flags |= 8) : (this.flags &= 0xFFFFFFF7);
    }

    private boolean convErrP2D() {
        return (this.flags & 0x10) != 0;
    }

    private void convErrP2D(boolean b) {
        this.flags = b ? (this.flags |= 0x10) : (this.flags &= 0xFFFFFFEF);
    }
}

