/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.driver.ping;

import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.baja.alarm.AlarmSupport;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BSourceState;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.driver.ping.BIPingable;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="pingEnabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="pingFrequency", type="BRelTime", defaultValue="BRelTime.make(5L*60L*1000L)"), @NiagaraProperty(name="alarmOnFailure", type="boolean", defaultValue="true"), @NiagaraProperty(name="startupAlarmDelay", type="BRelTime", defaultValue="BRelTime.make(5L*60L*1000L)"), @NiagaraProperty(name="numRetriesUntilPingFail", type="int", defaultValue="0", facets={@Facet(value="BFacets.makeInt(null, 0, Integer.MAX_VALUE)")})})
@NiagaraActions(value={@NiagaraAction(name="enable"), @NiagaraAction(name="disable")})
public class BPingMonitor
extends BComponent
implements Runnable {
    public static final Property pingEnabled = BPingMonitor.newProperty((int)0, (boolean)true, null);
    public static final Property pingFrequency = BPingMonitor.newProperty((int)0, (BValue)BRelTime.make((long)300000L), null);
    public static final Property alarmOnFailure = BPingMonitor.newProperty((int)0, (boolean)true, null);
    public static final Property startupAlarmDelay = BPingMonitor.newProperty((int)0, (BValue)BRelTime.make((long)300000L), null);
    public static final Property numRetriesUntilPingFail = BPingMonitor.newProperty((int)0, (int)0, (BFacets)BFacets.makeInt(null, (int)0, (int)Integer.MAX_VALUE));
    public static final Action enable = BPingMonitor.newAction((int)0, null);
    public static final Action disable = BPingMonitor.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BPingMonitor.class);
    private static final BIcon icon = BIcon.std((String)"monitor.png");
    boolean isAlive;
    private BIPingable[] pingables = null;
    private long lastPingablesUpdate = 0L;
    long startupTicks = 0L;
    Thread thread;
    private final Map<BIPingable, Integer> pingFailsPerDeviceMap = new ConcurrentHashMap<BIPingable, Integer>();

    public boolean getPingEnabled() {
        return this.getBoolean(pingEnabled);
    }

    public void setPingEnabled(boolean v) {
        this.setBoolean(pingEnabled, v, null);
    }

    public BRelTime getPingFrequency() {
        return (BRelTime)this.get(pingFrequency);
    }

    public void setPingFrequency(BRelTime v) {
        this.set(pingFrequency, (BValue)v, null);
    }

    public boolean getAlarmOnFailure() {
        return this.getBoolean(alarmOnFailure);
    }

    public void setAlarmOnFailure(boolean v) {
        this.setBoolean(alarmOnFailure, v, null);
    }

    public BRelTime getStartupAlarmDelay() {
        return (BRelTime)this.get(startupAlarmDelay);
    }

    public void setStartupAlarmDelay(BRelTime v) {
        this.set(startupAlarmDelay, (BValue)v, null);
    }

    public int getNumRetriesUntilPingFail() {
        return this.getInt(numRetriesUntilPingFail);
    }

    public void setNumRetriesUntilPingFail(int v) {
        this.setInt(numRetriesUntilPingFail, v, null);
    }

    public void enable() {
        this.invoke(enable, null, null);
    }

    public void disable() {
        this.invoke(disable, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BDeviceNetwork getNetwork() {
        return (BDeviceNetwork)this.getParent();
    }

    public void started() throws Exception {
        super.started();
        if (Sys.atSteadyState()) {
            this.startThread();
        }
    }

    public void atSteadyState() throws Exception {
        super.atSteadyState();
        this.startThread();
    }

    public void stopped() throws Exception {
        super.stopped();
        this.stopThread();
    }

    void startThread() {
        this.isAlive = true;
        this.thread = new Thread((Runnable)this, "Ping:" + this.getParent().getName());
        this.thread.start();
    }

    void stopThread() {
        this.isAlive = false;
        if (this.thread != null) {
            this.thread.interrupt();
        }
    }

    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isRunning()) {
            return;
        }
    }

    public BIPingable[] getPingables() {
        BDevice[] devices = this.getNetwork().getDevices();
        BIPingable[] result = new BIPingable[devices.length + 1];
        result[0] = this.getNetwork();
        System.arraycopy(devices, 0, result, 1, devices.length);
        return result;
    }

    @Override
    public void run() {
        this.startupTicks = Clock.ticks();
        while (this.isAlive) {
            try {
                Thread.sleep(1000L);
                if (!this.getPingEnabled()) continue;
                long freq = this.getPingFrequency().getMillis();
                long now = Clock.ticks();
                if (this.pingables == null || now > this.lastPingablesUpdate + freq) {
                    this.lastPingablesUpdate = now;
                    this.updatePingables();
                }
                for (int i = 0; i < this.pingables.length && this.getPingEnabled(); ++i) {
                    BIPingable p = this.pingables[i];
                    if (p == null || !this.isPingEnabled(p) || p instanceof BDevice && !((BDevice)p).isRunning()) continue;
                    BPingMonitor.checkPing(p, freq, now);
                }
            }
            catch (Throwable e) {
                if (!this.isAlive) continue;
                e.printStackTrace();
            }
        }
    }

    private static void checkPing(BIPingable p, long freq, long now) throws Exception {
        if (p != null && now > p.getHealth().lastAttemptTicks + freq) {
            p.getHealth().lastAttemptTicks = now;
            p.doPing();
        }
    }

    public boolean isPingEnabled(BIPingable pingable) {
        BStatus status = pingable.getStatus();
        if (status.isDisabled()) {
            return false;
        }
        return !status.isFault();
    }

    public void pingOk(BIPingable p) {
        this.resetPingsFailed(p);
        if (p.getHealth().getAlarm()) {
            p.getHealth().setAlarm(false);
            this.alarmToNormal(p);
        }
    }

    public void pingFail(BIPingable p) {
        int consecutivePingFails = this.incrementPingsFailed(p);
        if (this.getAlarmOnFailure()) {
            if (p.getHealth().getAlarm()) {
                return;
            }
            if (consecutivePingFails > this.getNumRetriesUntilPingFail()) {
                long delay = this.getStartupAlarmDelay().getMillis();
                long now = Clock.ticks();
                if (now <= this.startupTicks + delay) {
                    return;
                }
                p.getHealth().setAlarm(true);
                this.alarmToOffnormal(p);
            }
        }
    }

    void alarmToOffnormal(BIPingable p) {
        boolean ackRequired = false;
        try {
            AlarmSupport support = this.getAlarmSupport(p);
            ackRequired = support.isAckRequired(BSourceState.offnormal);
            support.newOffnormalAlarm(p.getAlarmSourceInfo().makeAlarmData(BSourceState.offnormal));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        int status = p.getStatus().getBits();
        status |= 8;
        if (ackRequired) {
            status |= 0x80;
        }
        p.setStatus(BStatus.make((int)status));
    }

    void alarmToNormal(BIPingable p) {
        try {
            this.getAlarmSupport(p).toNormal(p.getAlarmSourceInfo().makeAlarmData(BSourceState.normal), null);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        p.setStatus(BStatus.make((BStatus)p.getStatus(), (int)8, (boolean)false));
    }

    void updatePingables() {
        this.pingables = this.getPingables();
        this.pingFailsPerDeviceMap.keySet().retainAll(Arrays.asList(this.pingables));
    }

    BBoolean alarmAck(BIPingable p, BAlarmRecord ackRequest) {
        try {
            this.getAlarmSupport(p).ackAlarm(ackRequest);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        p.setStatus(BStatus.make((BStatus)p.getStatus(), (int)128, (boolean)false));
        return BBoolean.TRUE;
    }

    AlarmSupport getAlarmSupport(BIPingable p) {
        AlarmSupport support = (AlarmSupport)((BObject)p).fw(502);
        support.setAlarmClass(p.getAlarmSourceInfo().getAlarmClass());
        return support;
    }

    private int incrementPingsFailed(BIPingable p) {
        return this.pingFailsPerDeviceMap.compute(p, (key, value) -> value == null ? 1 : value + 1);
    }

    private void resetPingsFailed(BIPingable p) {
        this.pingFailsPerDeviceMap.remove(p);
    }

    public void spy(SpyWriter out) throws Exception {
        if (!this.pingFailsPerDeviceMap.isEmpty()) {
            out.startTable(true);
            out.trTitle((Object)"Pingables currently failing", 3);
            out.w((Object)"<tr>").th((Object)"Pingable").th((Object)"Consecutive Ping Fails").th((Object)"Current Status").w((Object)"</tr>\n");
            for (Map.Entry<BIPingable, Integer> entry : this.pingFailsPerDeviceMap.entrySet()) {
                BIPingable key = entry.getKey();
                if (key instanceof BComponent) {
                    out.tr((Object)((BComponent)key).toPathString(), (Object)entry.getValue(), (Object)key.getStatus());
                    continue;
                }
                out.tr((Object)key, (Object)entry.getValue(), (Object)key.getStatus());
            }
            out.endTable();
        }
        super.spy(out);
    }

    public void doEnable() {
        this.setPingEnabled(true);
    }

    public void doDisable() {
        this.setPingEnabled(false);
    }

    public BIcon getIcon() {
        return icon;
    }
}

