/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.driver;

import com.tridium.sys.metrics.BISubLicenseable;
import com.tridium.sys.metrics.Metrics;
import com.tridium.sys.resource.ResourceReport;
import java.util.logging.Logger;
import javax.baja.alarm.AlarmSupport;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmSourceInfo;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.driver.BDeviceExt;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.driver.ping.BIPingable;
import javax.baja.driver.ping.BPingHealth;
import javax.baja.driver.ping.BPingMonitor;
import javax.baja.log.Log;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.IFuture;

public abstract class BDevice
extends BComponent
implements BIStatus,
BIPingable {
    public static final Property status = BDevice.newProperty((int)75, (BValue)BStatus.ok, null);
    public static final Property enabled = BDevice.newProperty((int)0, (boolean)true, null);
    public static final Property faultCause = BDevice.newProperty((int)67, (String)"", null);
    public static final Property health = BDevice.newProperty((int)65, (BValue)new BPingHealth(), null);
    public static final Property alarmSourceInfo = BDevice.newProperty((int)0, (BValue)BDevice.initAlarmSourceInfo(), null);
    public static final Action ping = BDevice.newAction((int)16, null);
    public static final Action ackAlarm = BDevice.newAction((int)4, (BValue)new BAlarmRecord(), null);
    public static final Type TYPE = Sys.loadType(BDevice.class);
    protected static final BIcon icon = BIcon.std((String)"device.png");
    private Logger log;
    private int oldStatus = 0;
    private BDeviceNetwork network;
    private boolean fatalFault;
    private boolean configFault;
    private final AlarmSupport alarmSupport = new AlarmSupport((BIAlarmSource)this, "");

    @Override
    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    @Override
    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    @Override
    public BPingHealth getHealth() {
        return (BPingHealth)this.get(health);
    }

    public void setHealth(BPingHealth v) {
        this.set(health, (BValue)v, null);
    }

    @Override
    public BAlarmSourceInfo getAlarmSourceInfo() {
        return (BAlarmSourceInfo)this.get(alarmSourceInfo);
    }

    public void setAlarmSourceInfo(BAlarmSourceInfo v) {
        this.set(alarmSourceInfo, (BValue)v, null);
    }

    @Override
    public void ping() {
        this.invoke(ping, null, null);
    }

    @Override
    public BBoolean ackAlarm(BAlarmRecord alarm) {
        return (BBoolean)this.invoke(ackAlarm, (BValue)alarm, null);
    }

    public Type getType() {
        return TYPE;
    }

    public abstract Type getNetworkType();

    public final BDeviceNetwork getNetwork() {
        if (this.network != null) {
            return this.network;
        }
        if (!this.isRunning()) {
            throw new NotRunningException();
        }
        throw new IllegalStateException(this.getFaultCause());
    }

    public final BDeviceExt[] getDeviceExts() {
        return (BDeviceExt[])this.getChildren(BDeviceExt.class);
    }

    public final boolean isDown() {
        return this.getStatus().isDown();
    }

    public final boolean isDisabled() {
        return this.getStatus().isDisabled();
    }

    public final boolean isFault() {
        return this.getStatus().isFault();
    }

    @Override
    public final void updateStatus() {
        BStatus network;
        int newStatus = this.getStatus().getBits();
        BStatus bStatus = network = this.network == null ? BStatus.ok : this.network.getStatus();
        newStatus = !this.getEnabled() || network.isDisabled() ? (newStatus |= 1) : (newStatus &= 0xFFFFFFFE);
        newStatus = this.getHealth().getDown() || network.isDown() ? (newStatus |= 4) : (newStatus &= 0xFFFFFFFB);
        newStatus = this.fatalFault || this.configFault || network.isFault() ? (newStatus |= 2) : (newStatus &= 0xFFFFFFFD);
        if (this.oldStatus == newStatus) {
            return;
        }
        this.setStatus(BStatus.make((int)newStatus));
        this.oldStatus = newStatus;
        BDeviceExt[] exts = this.getDeviceExts();
        for (int i = 0; i < exts.length; ++i) {
            try {
                exts[i].updateStatus();
                continue;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public final boolean isFatalFault() {
        return this.fatalFault;
    }

    public final void configOk() {
        this.configFault = false;
        if (this.fatalFault) {
            return;
        }
        this.setFaultCause("");
        this.updateStatus();
    }

    public final void configFail(String cause) {
        this.configFault = true;
        if (this.fatalFault) {
            return;
        }
        this.setFaultCause(cause);
        this.updateStatus();
    }

    public final void configFatal(String cause) {
        this.fatalFault = true;
        this.setFaultCause(cause);
        this.updateStatus();
    }

    private void checkFatalFault(String badGroups) {
        Object licenseFault;
        if (badGroups != null) {
            this.fatalFault = true;
            this.getLogger().severe("Exceeded device limit for " + badGroups);
            this.setFaultCause("Exceeded device limit for " + badGroups);
            return;
        }
        BDeviceNetwork network = null;
        if (this.fatalFault) {
            return;
        }
        for (BComplex parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof BDeviceNetwork)) continue;
            network = (BDeviceNetwork)parent;
            break;
        }
        if (network == null) {
            this.fatalFault = true;
            this.setFaultCause("Not under DeviceNetwork");
            return;
        }
        if (!network.getType().is(this.getNetworkType())) {
            this.fatalFault = true;
            this.setFaultCause("Parent DeviceNetwork " + network.getType() + " is not " + this.getNetworkType());
            return;
        }
        if (network.isFatalFault()) {
            this.fatalFault = true;
            this.setFaultCause("Network fault: " + network.getFaultCause());
            return;
        }
        if (this.getType().is(network.getDeviceType()) && (licenseFault = network.fw(501, BISubLicenseable.getLicenseKey((BObject)this, (String)"device.limit"), this, null, null)) != null) {
            this.fatalFault = true;
            this.setFaultCause(licenseFault.toString());
            return;
        }
        this.network = network;
        this.setFaultCause("");
    }

    protected abstract IFuture postPing();

    @Override
    public abstract void doPing() throws Exception;

    @Override
    public BPingMonitor getMonitor() {
        return this.getNetwork().getMonitor();
    }

    @Override
    public void pingOk() {
        this.getHealth().pingOk();
    }

    @Override
    public void pingFail(String cause) {
        this.getHealth().pingFail(cause);
    }

    @Override
    public BBoolean doAckAlarm(BAlarmRecord ackRequest) {
        return this.getHealth().doAckAlarm(ackRequest);
    }

    public IFuture post(Action action, BValue arg, Context cx) {
        if (action.equals(ping)) {
            if (this.getStatus().isDisabled()) {
                return null;
            }
            return this.postPing();
        }
        return super.post(action, arg, cx);
    }

    public final Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 11: {
                this.fwStarted();
                break;
            }
            case 13: {
                this.fwDescendantsStarted();
                break;
            }
            case 14: {
                this.fwDescendantsStopped();
                break;
            }
            case 2: {
                this.fwChanged((Property)a);
                break;
            }
            case 21: {
                ((ResourceReport)a).add("device", 5000);
                break;
            }
            case 502: {
                return this.alarmSupport;
            }
        }
        return super.fw(x, a, b, c, d);
    }

    private void fwStarted() {
        this.checkFatalFault(Metrics.incrementDevice((BComplex)this));
    }

    private void fwDescendantsStopped() {
        this.network = null;
    }

    private void fwDescendantsStarted() {
        this.updateStatus();
    }

    private void fwChanged(Property prop) {
        if (!this.isRunning()) {
            return;
        }
        if (prop == enabled) {
            this.updateStatus();
        }
    }

    @Deprecated
    public Log getLog() {
        return Log.getLog((String)this.getLogger().getName());
    }

    public Logger getLogger() {
        if (this.log == null) {
            try {
                this.log = Logger.getLogger(this.getNetwork().getLogger().getName() + "." + this.getName());
            }
            catch (Exception e) {
                this.log = Logger.getLogger(this.getType().getTypeName());
            }
        }
        return this.log;
    }

    static BAlarmSourceInfo initAlarmSourceInfo() {
        BAlarmSourceInfo asi = new BAlarmSourceInfo();
        asi.setSourceName(BFormat.make((String)"%parent.parent.displayName% %parent.displayName%"));
        asi.setToOffnormalText(BFormat.make((String)"%lexicon(driver:pingFail)%"));
        asi.setToNormalText(BFormat.make((String)"%lexicon(driver:pingSuccess)%"));
        return asi;
    }

    public BIcon getIcon() {
        return icon;
    }
}

