/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.driver.file.history;

import com.tridium.driver.file.BFileDevice;
import com.tridium.driver.file.enums.BRecordTypeEnum;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.baja.control.trigger.BManualTriggerMode;
import javax.baja.control.trigger.BTimeTrigger;
import javax.baja.control.trigger.BTriggerMode;
import javax.baja.data.BIDataValue;
import javax.baja.driver.file.history.BFileHistoryImport;
import javax.baja.file.BIFile;
import javax.baja.history.BBooleanTrendRecord;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.BIHistoryRecordSet;
import javax.baja.history.BNumericTrendRecord;
import javax.baja.history.BStringTrendRecord;
import javax.baja.history.HistorySpaceConnection;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.history.db.HistoryDatabaseConnection;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.space.BComponentSpace;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.BTypeSpec;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.Lexicon;

public class BDelimitedFileImport
extends BFileHistoryImport {
    static Lexicon lex = Lexicon.make((String)"driver");
    public static final Property fullImportOnExecute = BDelimitedFileImport.newProperty((int)0, (boolean)false, (BFacets)BFacets.makeBoolean((String)lex.getText("import.fullImport.enabled"), (String)lex.getText("import.fullImport.disabled")));
    public static final Property rowStart = BDelimitedFileImport.newProperty((int)0, (int)1, (BFacets)BFacets.makeInt(null, (int)0, (int)Integer.MAX_VALUE));
    public static final Property rowEnd = BDelimitedFileImport.newProperty((int)0, (int)-1, (BFacets)BFacets.make((BFacets)BFacets.makeInt(null, (int)-1, (int)Integer.MAX_VALUE), (String)"fieldEditor", (BIDataValue)BString.make((String)"driver:OptionalPositiveIntegerFE")));
    public static final Property delimiter = BDelimitedFileImport.newProperty((int)0, (String)",", null);
    public static final Property timestampColumnIndex = BDelimitedFileImport.newProperty((int)0, (int)0, (BFacets)BFacets.makeInt(null, (int)0, (int)Integer.MAX_VALUE));
    public static final Property timestampFormat = BDelimitedFileImport.newProperty((int)0, (String)"d-MMM-yy h:mm a z", (BFacets)BFacets.make((String)"fieldEditor", (String)"driver:TimestampFormatFE"));
    public static final Property valueColumnIndex = BDelimitedFileImport.newProperty((int)0, (int)0, (BFacets)BFacets.makeInt(null, (int)0, (int)Integer.MAX_VALUE));
    public static final Property valueFormat = BDelimitedFileImport.newProperty((int)0, (BValue)BRecordTypeEnum.numericType, null);
    public static final Property statusColumnIndex = BDelimitedFileImport.newProperty((int)0, (int)-1, (BFacets)BFacets.make((BFacets)BFacets.makeInt(null, (int)-1, (int)Integer.MAX_VALUE), (String)"fieldEditor", (BIDataValue)BString.make((String)"driver:OptionalPositiveIntegerFE")));
    public static final Property identifierColumnIndex = BDelimitedFileImport.newProperty((int)0, (int)-1, (BFacets)BFacets.make((BFacets)BFacets.makeInt(null, (int)-1, (int)Integer.MAX_VALUE), (String)"fieldEditor", (BIDataValue)BString.make((String)"driver:OptionalPositiveIntegerFE")));
    public static final Property identifierPattern = BDelimitedFileImport.newProperty((int)0, (String)"*", null);
    public static final Type TYPE = Sys.loadType(BDelimitedFileImport.class);
    private static final BIcon icon = BIcon.make((BIcon)BIcon.std((String)"propertySheet.png"), (BIcon)BIcon.std((String)"badges/import.png"));
    Pattern rowPattern;
    private static final char ONE_CHAR = '\u0000';

    public boolean getFullImportOnExecute() {
        return this.getBoolean(fullImportOnExecute);
    }

    public void setFullImportOnExecute(boolean v) {
        this.setBoolean(fullImportOnExecute, v, null);
    }

    public int getRowStart() {
        return this.getInt(rowStart);
    }

    public void setRowStart(int v) {
        this.setInt(rowStart, v, null);
    }

    public int getRowEnd() {
        return this.getInt(rowEnd);
    }

    public void setRowEnd(int v) {
        this.setInt(rowEnd, v, null);
    }

    public String getDelimiter() {
        return this.getString(delimiter);
    }

    public void setDelimiter(String v) {
        this.setString(delimiter, v, null);
    }

    public int getTimestampColumnIndex() {
        return this.getInt(timestampColumnIndex);
    }

    public void setTimestampColumnIndex(int v) {
        this.setInt(timestampColumnIndex, v, null);
    }

    public String getTimestampFormat() {
        return this.getString(timestampFormat);
    }

    public void setTimestampFormat(String v) {
        this.setString(timestampFormat, v, null);
    }

    public int getValueColumnIndex() {
        return this.getInt(valueColumnIndex);
    }

    public void setValueColumnIndex(int v) {
        this.setInt(valueColumnIndex, v, null);
    }

    public BRecordTypeEnum getValueFormat() {
        return (BRecordTypeEnum)this.get(valueFormat);
    }

    public void setValueFormat(BRecordTypeEnum v) {
        this.set(valueFormat, (BValue)v, null);
    }

    public int getStatusColumnIndex() {
        return this.getInt(statusColumnIndex);
    }

    public void setStatusColumnIndex(int v) {
        this.setInt(statusColumnIndex, v, null);
    }

    public int getIdentifierColumnIndex() {
        return this.getInt(identifierColumnIndex);
    }

    public void setIdentifierColumnIndex(int v) {
        this.setInt(identifierColumnIndex, v, null);
    }

    public String getIdentifierPattern() {
        return this.getString(identifierPattern);
    }

    public void setIdentifierPattern(String v) {
        this.setString(identifierPattern, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BDelimitedFileImport() {
        this.setExecutionTime(new BTimeTrigger((BTriggerMode)BManualTriggerMode.make()));
    }

    @Override
    protected IFuture postExecute(Action action, BValue arg, Context cx) {
        BFileDevice device = (BFileDevice)this.getDevice();
        if (device != null) {
            device.getWorker().postAsync((Runnable)new Invocation((BComponent)this, action, arg, cx));
        }
        return null;
    }

    public void changed(Property p, Context c) {
        if (p == identifierPattern) {
            this.rowPattern = null;
        } else {
            super.changed(p, c);
        }
    }

    @Override
    public BIcon getIcon() {
        return icon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void executeFileImport(BIFile file) {
        InputStream in = null;
        BufferedReader fileReader = null;
        this.executeInProgress();
        int fileLineTracker = -1;
        try {
            BHistoryId id = this.getHistoryId();
            if (id.isNull()) {
                this.executeFail(lex.getText("import.error.nullId"));
                return;
            }
            BHistoryDatabase localDb = ((BHistoryService)Sys.getService((Type)BHistoryService.TYPE)).getDatabase();
            if (localDb == null) {
                this.executeFail(lex.getText("import.error.dbNotAvailable"));
                return;
            }
            BTypeSpec recordType = BDelimitedFileImport.getRecordType(this.getValueFormat());
            if (recordType == null) {
                Object[] args = new Object[]{this.getValueFormat()};
                this.executeFail(lex.getText("import.error.invalidRecordType", args));
                return;
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat(this.getTimestampFormat());
            in = file.getInputStream();
            fileReader = new BufferedReader(new InputStreamReader(in));
            int startIndex = this.getRowStart();
            fileLineTracker = startIndex + 1;
            int endIndex = this.getRowEnd();
            int timeCol = this.getTimestampColumnIndex();
            int valCol = this.getValueColumnIndex();
            int statusCol = this.getStatusColumnIndex();
            int idCol = this.getIdentifierColumnIndex();
            if (this.rowPattern == null) {
                this.rowPattern = new Pattern(this.getIdentifierPattern());
            }
            Pattern rowId = this.rowPattern;
            boolean checkIdentifier = idCol >= 0 && rowId != null;
            Vector<DelimitedRow> rowData = new Vector<DelimitedRow>();
            String data = "";
            String delim = this.getDelimiter();
            int currentRow = 0;
            while ((data = fileReader.readLine()) != null) {
                if (currentRow >= startIndex && (endIndex < 0 || currentRow <= endIndex)) {
                    String timestampString = null;
                    String valueString = null;
                    String statusString = null;
                    boolean rowValid = !checkIdentifier;
                    StringTokenizer stoken = new StringTokenizer(data, delim);
                    int currentCol = 0;
                    while (stoken.hasMoreTokens()) {
                        String token = stoken.nextToken();
                        if (currentCol == idCol && checkIdentifier) {
                            rowValid = rowId.isMatch(token);
                        }
                        if (currentCol == timeCol) {
                            timestampString = token;
                        }
                        if (currentCol == valCol) {
                            valueString = token;
                        }
                        if (currentCol == statusCol) {
                            statusString = token;
                        }
                        ++currentCol;
                    }
                    if (rowValid) {
                        BAbsTime tstamp = null;
                        tstamp = timeCol >= 0 ? BAbsTime.make((long)dateFormat.parse(timestampString, new ParsePosition(0)).getTime()) : BAbsTime.now();
                        BStatus status = BStatus.ok;
                        if (statusCol >= 0) {
                            status = BStatus.make((int)Integer.parseInt(statusString));
                        }
                        rowData.addElement(new DelimitedRow(tstamp, valueString, status));
                    }
                }
                ++fileLineTracker;
                if (endIndex < 0 || ++currentRow <= endIndex) continue;
            }
            fileLineTracker = -1;
            DelimitedRow[] rows = BDelimitedFileImport.sortByTimestamp(rowData);
            BHistoryConfig config = null;
            BIHistory history = null;
            BAbsTime lastTimestamp = null;
            try (HistoryDatabaseConnection conn = localDb.getDbConnection(null);){
                if (!conn.exists(id)) {
                    config = this.makeLocalConfig(this.makeLocalHistoryFileConfig(id, recordType));
                    conn.createHistory(config);
                    history = conn.getHistory(id);
                } else {
                    if (this.getFullImportOnExecute()) {
                        conn.clearAllRecords(id);
                    }
                    config = this.makeLocalConfig(conn.getHistory(id).getConfig());
                    conn.reconfigureHistory(config);
                    history = conn.getHistory(id);
                    if (!this.getFullImportOnExecute()) {
                        lastTimestamp = conn.getLastTimestamp(history);
                    }
                }
                recordType = config.getRecordType();
                String recTypeName = recordType.getTypeName();
                BHistoryRecord rec = config.makeRecord();
                this.appendToHistory((HistorySpaceConnection)conn, history, rec, lastTimestamp, rows, recTypeName);
            }
            this.executeOk();
            return;
        }
        catch (Exception e) {
            if (fileLineTracker >= 0) {
                System.out.println("File import failed on file line " + fileLineTracker + ".");
            }
            e.printStackTrace();
            if (fileLineTracker >= 0) {
                Object[] args = new Object[]{new Integer(fileLineTracker)};
                this.executeFail(lex.getText("import.fileError.lineNumber", args));
                return;
            }
            if (e instanceof LocalizableRuntimeException) {
                this.executeFail(((LocalizableRuntimeException)e).toString(null));
                return;
            }
            this.executeFail(e);
            return;
        }
        finally {
            if (fileReader != null) {
                try {
                    fileReader.close();
                }
                catch (Exception exception) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    void appendToHistory(HistorySpaceConnection conn, BIHistory history, BHistoryRecord rec, BAbsTime lastTimestamp, DelimitedRow[] rows, String recTypeName) throws Exception {
        BAbsTime duplicateTimestamp = null;
        for (int i = 0; i < rows.length; ++i) {
            if (lastTimestamp != null && !lastTimestamp.isBefore(rows[i].timestamp)) continue;
            if (i > 0 && rec.getTimestamp().equals((Object)rows[i].timestamp)) {
                duplicateTimestamp = rows[i].timestamp;
                continue;
            }
            if (recTypeName.equals("NumericTrendRecord")) {
                conn.append(history, (BIHistoryRecordSet)((BNumericTrendRecord)rec).set(rows[i].timestamp, Double.valueOf(rows[i].value).doubleValue(), rows[i].status));
                continue;
            }
            if (recTypeName.equals("BooleanTrendRecord")) {
                boolean boolVal = false;
                try {
                    boolVal = Integer.valueOf(rows[i].value) != 0;
                }
                catch (Exception e) {
                    boolVal = Boolean.valueOf(rows[i].value);
                }
                conn.append(history, (BIHistoryRecordSet)((BBooleanTrendRecord)rec).set(rows[i].timestamp, boolVal, rows[i].status));
                continue;
            }
            if (!recTypeName.equals("StringTrendRecord")) continue;
            conn.append(history, (BIHistoryRecordSet)((BStringTrendRecord)rec).set(rows[i].timestamp, rows[i].value, rows[i].status));
        }
        if (duplicateTimestamp != null) {
            Object[] args = new BAbsTime[]{duplicateTimestamp};
            throw new LocalizableRuntimeException("driver", "import.error.duplicateTimestamp", args);
        }
    }

    BOrd getSourceOrd() {
        BComponentSpace cs = this.getComponentSpace();
        if (cs == null) {
            return null;
        }
        BOrd base = cs.getOrdInSession();
        if (base == null) {
            return null;
        }
        return BOrd.make((BOrd)base, (BOrd)this.getSlotPathOrd());
    }

    BHistoryConfig makeLocalHistoryFileConfig(BHistoryId id, BTypeSpec recordType) {
        BHistoryConfig result = new BHistoryConfig(id, recordType);
        result.setSource(BOrdList.make((BOrd)this.getSourceOrd()));
        result.setSourceHandle(this.getHandleOrd());
        result.setTimeZone(BTimeZone.getLocal());
        return result;
    }

    static BTypeSpec getRecordType(BRecordTypeEnum recordTypeEnum) {
        if (recordTypeEnum == BRecordTypeEnum.numericType) {
            return BNumericTrendRecord.TYPE.getTypeSpec();
        }
        if (recordTypeEnum == BRecordTypeEnum.stringType) {
            return BStringTrendRecord.TYPE.getTypeSpec();
        }
        if (recordTypeEnum == BRecordTypeEnum.booleanType) {
            return BBooleanTrendRecord.TYPE.getTypeSpec();
        }
        return null;
    }

    static DelimitedRow[] sortByTimestamp(Vector<DelimitedRow> unsorted) {
        int count = unsorted.size();
        DelimitedRow[] sorted = new DelimitedRow[count];
        for (int i = 0; i < count; ++i) {
            sorted[i] = unsorted.elementAt(i);
        }
        int j = -1;
        DelimitedRow tempRow = null;
        for (int i = 0; i < count; ++i) {
            tempRow = sorted[i];
            for (j = i - 1; j >= 0 && tempRow.timestamp.isBefore(sorted[j].timestamp); --j) {
                sorted[j + 1] = sorted[j];
                sorted[j] = tempRow;
            }
        }
        return sorted;
    }

    static class Pattern {
        private char[][] pattern;
        private boolean matchAll;

        public Pattern(String patternString) {
            this.init(patternString.toCharArray());
        }

        private void init(char[] patternStr) {
            this.matchAll = true;
            for (int i = 0; i < patternStr.length; ++i) {
                if (patternStr[i] == '*' || patternStr[i] == '%') continue;
                this.matchAll = false;
                break;
            }
            if (this.matchAll) {
                return;
            }
            Vector<String> v = new Vector<String>();
            int i = 0;
            StringBuffer buf = new StringBuffer(16);
            while (true) {
                if (i == patternStr.length) {
                    if (buf.length() <= 0) break;
                    v.addElement(buf.toString());
                    break;
                }
                if (patternStr[i] == '\\') {
                    if (buf.length() == 0) {
                        buf.append(' ');
                    }
                    if (i < patternStr.length - 1) {
                        char next = patternStr[i + 1];
                        if (next == '%' || next == '*' || next == '_' || next == '\\') {
                            buf.append(next);
                        } else if (next == 'n') {
                            buf.append('\n');
                        } else if (next == 'r') {
                            buf.append('\r');
                        } else if (next == 't') {
                            buf.append('\t');
                        } else {
                            throw new IllegalArgumentException("Invalid escape sequence: \\" + next);
                        }
                        i += 2;
                        continue;
                    }
                    throw new IllegalArgumentException("Invalid escape sequence: \\");
                }
                if (patternStr[i] == '%' || patternStr[i] == '*' || patternStr[i] == '_') {
                    if (patternStr[i] == '_') {
                        if (buf.length() == 0) {
                            buf.append(' ');
                        }
                        buf.append('\u0000');
                        ++i;
                        continue;
                    }
                    if (buf.length() > 0) {
                        v.addElement(buf.toString());
                    }
                    v.addElement("*");
                    while (i < patternStr.length && (patternStr[i] == '%' || patternStr[i] == '*')) {
                        ++i;
                    }
                    buf.setLength(0);
                    continue;
                }
                if (buf.length() == 0) {
                    buf.append(' ');
                }
                buf.append(patternStr[i++]);
            }
            this.pattern = new char[v.size()][];
            for (int j = 0; j < v.size(); ++j) {
                this.pattern[j] = ((String)v.elementAt(j)).toCharArray();
            }
        }

        public boolean isMatch(String testStr) {
            if (this.matchAll) {
                return true;
            }
            char[] test = testStr.toCharArray();
            int ti = 0;
            boolean lastStart = false;
            int len = test.length;
            if (len == 0) {
                return this.pattern.length == 0;
            }
            boolean afterWildcard = false;
            block0: for (int pi = 0; pi < this.pattern.length; ++pi) {
                if (this.pattern[pi][0] == '*') {
                    if (pi == this.pattern.length - 1) {
                        return true;
                    }
                    afterWildcard = true;
                    continue;
                }
                while (ti < len) {
                    int ei;
                    int start = ti;
                    for (ei = 1; ti < len && ei < this.pattern[pi].length && (this.pattern[pi][ei] == '\u0000' || this.pattern[pi][ei] == test[ti]); ++ti, ++ei) {
                    }
                    if (ei == this.pattern[pi].length) {
                        if (pi == this.pattern.length - 1) {
                            if (ti == len) {
                                return true;
                            }
                            if (afterWildcard) {
                                ti = len - (this.pattern[pi].length - 1);
                                continue;
                            }
                            return false;
                        }
                        afterWildcard = false;
                        continue block0;
                    }
                    if (ti == len) {
                        return false;
                    }
                    if (!afterWildcard) {
                        return false;
                    }
                    ti = start + 1;
                    if (ti != len) continue;
                    return false;
                }
            }
            return false;
        }
    }

    class DelimitedRow {
        BAbsTime timestamp;
        String value;
        BStatus status;

        public DelimitedRow(BAbsTime timestamp, String value, BStatus status) {
            this.timestamp = timestamp;
            this.value = value;
            this.status = status;
        }
    }
}

