/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.converters;

import java.text.DecimalFormat;
import javax.baja.agent.BIAgent;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BConverter;

public final class BStatusNumericToStatusString
extends BConverter
implements BIAgent {
    public static final Property format = BStatusNumericToStatusString.newProperty((int)0, (String)"", (BFacets)BFacets.NULL);
    public static final Type TYPE = Sys.loadType(BStatusNumericToStatusString.class);

    public final String getFormat() {
        return this.getString(format);
    }

    public final void setFormat(String format) {
        this.setString(BStatusNumericToStatusString.format, format, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BObject convert(BObject from, BObject to, Context cx) {
        BStatusString statusString = (BStatusString)to;
        BStatusNumeric statusNumeric = (BStatusNumeric)from;
        if (this.getFormat().length() == 0) {
            statusString.setValue(statusNumeric.getValueValue().toString(cx));
            statusString.setStatus(statusNumeric.getStatus());
        } else {
            try {
                DecimalFormat decFormat = new DecimalFormat(this.getFormat());
                statusString.setValue(decFormat.format(statusNumeric.getValue()));
                statusString.setStatus(statusNumeric.getStatus());
            }
            catch (IllegalArgumentException iae) {
                statusString.setStatus(BStatus.fault);
            }
        }
        return statusString;
    }
}

