/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.converters;

import java.text.DecimalFormat;
import javax.baja.agent.BIAgent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BConverter;

public final class BNumberToString
extends BConverter
implements BIAgent {
    public static final Property format = BNumberToString.newProperty((int)0, (String)"", (BFacets)BFacets.NULL);
    public static final Type TYPE = Sys.loadType(BNumberToString.class);
    private static final BString NaN = BString.make((String)"NaN");

    public final String getFormat() {
        return this.getString(format);
    }

    public final void setFormat(String format) {
        this.setString(BNumberToString.format, format, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BObject convert(BObject from, BObject to, Context cx) {
        if (from instanceof BFloat && from == BFloat.NaN || from instanceof BDouble && from == BDouble.NaN) {
            return NaN;
        }
        BNumber number = (BNumber)from;
        if (this.getFormat().length() == 0) {
            return BString.make((String)number.toString(cx));
        }
        try {
            DecimalFormat decFormat = new DecimalFormat(this.getFormat());
            return BString.make((String)decFormat.format(number.getDouble()));
        }
        catch (IllegalArgumentException iae) {
            return to;
        }
    }
}

