/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.converters;

import javax.baja.agent.BIAgent;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusEnum;
import javax.baja.sys.BDouble;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFloat;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BConverter;

public final class BNumberToStatusEnum
extends BConverter
implements BIAgent {
    public static final Type TYPE = Sys.loadType(BNumberToStatusEnum.class);

    public Type getType() {
        return TYPE;
    }

    public BObject convert(BObject from, BObject to, Context cx) {
        BStatusEnum statusEnum = (BStatusEnum)to;
        if (from instanceof BFloat && from == BFloat.NaN || from instanceof BDouble && from == BDouble.NaN) {
            statusEnum.setStatus(64);
            return statusEnum;
        }
        BNumber value = (BNumber)from;
        statusEnum.setValue(BDynamicEnum.make((int)value.getInt(), (BEnumRange)((BStatusEnum)to).getValue().getRange()));
        statusEnum.setStatus(BStatus.ok);
        return statusEnum;
    }
}

