/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.converters;

import javax.baja.sys.BBoolean;
import javax.baja.sys.BIBoolean;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BConverter;

public final class BIBooleanToSimple
extends BConverter {
    public static final Property trueValue = BIBooleanToSimple.newProperty((int)0, (BValue)BBoolean.TRUE, null);
    public static final Property falseValue = BIBooleanToSimple.newProperty((int)0, (BValue)BBoolean.FALSE, null);
    public static final Type TYPE = Sys.loadType(BIBooleanToSimple.class);

    public BSimple getTrueValue() {
        return (BSimple)this.get(trueValue);
    }

    public void setTrueValue(BSimple v) {
        this.set(trueValue, (BValue)v, null);
    }

    public BSimple getFalseValue() {
        return (BSimple)this.get(falseValue);
    }

    public void setFalseValue(BSimple v) {
        this.set(falseValue, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void init(BObject from, BObject to) {
        this.setTrueValue((BSimple)to);
        this.setFalseValue((BSimple)to);
    }

    public BObject convert(BObject from, BObject to, Context cx) {
        boolean bool = ((BIBoolean)from).getBoolean();
        BSimple v = bool ? this.getTrueValue() : this.getFalseValue();
        if (v.getType() == to.getType()) {
            return v;
        }
        return to;
    }
}

