/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.converters;

import javax.baja.agent.BIAgent;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BConverter;

public final class BBooleanToNumber
extends BConverter
implements BIAgent {
    public static final Property trueValue = BBooleanToNumber.newProperty((int)0, (int)BBoolean.TRUE.getOrdinal(), (BFacets)BFacets.NULL);
    public static final Property falseValue = BBooleanToNumber.newProperty((int)0, (int)BBoolean.FALSE.getOrdinal(), (BFacets)BFacets.NULL);
    public static final Type TYPE = Sys.loadType(BBooleanToNumber.class);

    public final int getTrueValue() {
        return this.getInt(trueValue);
    }

    public final void setTrueValue(int trueValue) {
        this.setInt(BBooleanToNumber.trueValue, trueValue, null);
    }

    public final int getFalseValue() {
        return this.getInt(falseValue);
    }

    public final void setFalseValue(int falseValue) {
        this.setInt(BBooleanToNumber.falseValue, falseValue, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BObject convert(BObject from, BObject to, Context cx) {
        boolean bool = ((BBoolean)from).getBoolean();
        int value = bool ? this.getTrueValue() : this.getFalseValue();
        switch (to.getType().getDataTypeSymbol()) {
            case 'i': {
                return BInteger.make((int)value);
            }
            case 'l': {
                return BLong.make((long)value);
            }
            case 'f': {
                return BFloat.make((float)value);
            }
            case 'd': {
                return BDouble.make((double)value);
            }
        }
        throw new IllegalStateException();
    }
}

