/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.report;

import com.tridium.report.BExportSourceInfo;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentList;
import javax.baja.file.BExporter;
import javax.baja.file.BIFile;
import javax.baja.file.ExportOp;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.nav.BINavNode;
import javax.baja.report.BReport;
import javax.baja.report.BReportService;
import javax.baja.report.BReportSource;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BExportSource
extends BReportSource {
    public static final Property source = BExportSource.newProperty((int)0, (BValue)BExportSourceInfo.NULL, null);
    public static final Type TYPE = Sys.loadType(BExportSource.class);
    static AgentFilter ExportFilter = AgentFilter.is((Type)BExporter.TYPE);

    public BExportSourceInfo getSource() {
        return (BExportSourceInfo)this.get(source);
    }

    public void setSource(BExportSourceInfo v) {
        this.set(source, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public BReport handleGenerate() throws Exception {
        BExportSourceInfo sourceInfo = this.getSource();
        BOrd ord = sourceInfo.getSource();
        OrdTarget source = ord.resolve();
        if (BReportService.log.isLoggable(Level.FINE)) {
            BReportService.log.fine("BExportSource generating report: " + source);
        }
        BObject obj = source.get();
        String agentId = this.getSource().getAgentId();
        BExporter exporter = this.getSource().getExporter();
        if (null == exporter) {
            AgentList agents = obj.getAgents().filter(ExportFilter);
            for (int i = 0; i < agents.size(); ++i) {
                if (!agentId.equals(agents.get(i).getAgentId())) continue;
                exporter = (BExporter)agents.get(i).getInstance();
                break;
            }
        }
        String rname = "Report";
        if (obj instanceof BIFile) {
            rname = this.getBaseFileName((BIFile)obj);
        } else if (obj instanceof BINavNode) {
            rname = ((BINavNode)obj).getNavDisplayName(null);
        }
        String fname = rname + "." + exporter.getFileExtension();
        String mime = exporter.getFileMimeType();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        if (BReportService.log.isLoggable(Level.FINE)) {
            BReportService.log.fine("exporting report to PDF for source: " + source.toString());
        }
        exporter.export(ExportOp.make((OrdTarget)source, (OutputStream)out));
        return new BReport(rname, fname, mime, out.toByteArray());
    }

    private String getBaseFileName(BIFile file) {
        String s = file.getFileName();
        int index = s.lastIndexOf(".");
        if (index != -1) {
            s = s.substring(0, index);
        }
        return s;
    }
}

