/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.report;

import javax.baja.data.BIDataValue;
import javax.baja.email.BBlobPart;
import javax.baja.email.BEmail;
import javax.baja.email.BEmailAddressList;
import javax.baja.email.BEmailPart;
import javax.baja.email.BEmailService;
import javax.baja.email.BOutgoingAccount;
import javax.baja.email.BTextPart;
import javax.baja.report.BReport;
import javax.baja.report.BReportRecipient;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBlob;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.util.BFormat;
import javax.baja.util.Lexicon;

public class BEmailRecipient
extends BReportRecipient {
    public static final Property to = BEmailRecipient.newProperty((int)0, (BValue)BEmailAddressList.DEFAULT, null);
    public static final Property cc = BEmailRecipient.newProperty((int)0, (BValue)BEmailAddressList.DEFAULT, null);
    public static final Property bcc = BEmailRecipient.newProperty((int)0, (BValue)BEmailAddressList.DEFAULT, null);
    public static final Property language = BEmailRecipient.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)6)));
    public static final Property emailAccount = BEmailRecipient.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"email:OutgoingAccountFE")));
    public static final Property subject = BEmailRecipient.newProperty((int)0, (BValue)BFormat.make((String)Lexicon.make(BEmailRecipient.class).get("email.subject")), null);
    public static final Property body = BEmailRecipient.newProperty((int)0, (BValue)BFormat.make((String)Lexicon.make(BEmailRecipient.class).get("email.body")), (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE));
    public static final Type TYPE = Sys.loadType(BEmailRecipient.class);
    private static final BIcon icon = BIcon.std((String)"email.png");
    static Lexicon lex = Lexicon.make(BEmailRecipient.class);
    static final BFacets TIME_FACETS = BFacets.make((String)"showSeconds", (boolean)true);

    public BEmailAddressList getTo() {
        return (BEmailAddressList)this.get(to);
    }

    public void setTo(BEmailAddressList v) {
        this.set(to, (BValue)v, null);
    }

    public BEmailAddressList getCc() {
        return (BEmailAddressList)this.get(cc);
    }

    public void setCc(BEmailAddressList v) {
        this.set(cc, (BValue)v, null);
    }

    public BEmailAddressList getBcc() {
        return (BEmailAddressList)this.get(bcc);
    }

    public void setBcc(BEmailAddressList v) {
        this.set(bcc, (BValue)v, null);
    }

    public String getLanguage() {
        return this.getString(language);
    }

    public void setLanguage(String v) {
        this.setString(language, v, null);
    }

    public String getEmailAccount() {
        return this.getString(emailAccount);
    }

    public void setEmailAccount(String v) {
        this.setString(emailAccount, v, null);
    }

    public BFormat getSubject() {
        return (BFormat)this.get(subject);
    }

    public void setSubject(BFormat v) {
        this.set(subject, (BValue)v, null);
    }

    public BFormat getBody() {
        return (BFormat)this.get(body);
    }

    public void setBody(BFormat v) {
        this.set(body, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void handleRoute(BReport report) throws Exception {
        BComponent service = Sys.getService((Type)BEmailService.TYPE);
        BOutgoingAccount account = (BOutgoingAccount)service.loadSlots().get(this.getEmailAccount());
        if (account == null) {
            System.out.println("BEmailRecipient.handleReport: cannot find email account '" + this.getEmailAccount() + "'.");
            return;
        }
        String lang = this.getLanguage();
        if (lang.isEmpty()) {
            lang = Sys.getLanguage();
        }
        BAbsTime tstamp = BAbsTime.now();
        BEmail mail = new BEmail();
        mail.setFrom(account.getReplyTo());
        mail.setTo(this.getTo());
        mail.setCc(this.getCc());
        mail.setBcc(this.getBcc());
        mail.setDate(BAbsTime.now());
        mail.setSubject(this.getSubject().format((Object)report));
        mail.setBody((BEmailPart)new BTextPart("", this.getBody().format((Object)report)));
        BBlobPart att = new BBlobPart();
        att.setFileName(report.getFileName());
        att.setMimeType(report.getMimeType());
        att.setBlob(BBlob.make((byte[])report.getContent()));
        mail.getAttachments().add(null, (BValue)att);
        account.send(mail);
    }

    @Override
    public BIcon getIcon() {
        return icon;
    }

    class EmailContext
    implements Context {
        String lang;

        public EmailContext(String lang) {
            this.lang = lang;
        }

        public Context getBase() {
            return null;
        }

        public BUser getUser() {
            return new BUser();
        }

        public BFacets getFacets() {
            return TIME_FACETS;
        }

        public BObject getFacet(String name) {
            return this.getFacets().get(name);
        }

        public String getLanguage() {
            return this.lang;
        }
    }
}

