/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn.util;

import com.tridium.ccn.BCcnDevice;
import com.tridium.ccn.BCcnNetwork;
import com.tridium.ccn.components.BCcnPointEntry;
import com.tridium.ccn.components.BCcnTableEntry;
import com.tridium.ccn.components.BFidPointConfig;
import com.tridium.ccn.enums.BCcnAlarmStatusEnum;
import com.tridium.ccn.enums.BCcnDataTypeEnum;
import com.tridium.ccn.enums.BCcnDiscreteStateEnum;
import com.tridium.ccn.enums.BCcnForceStatusEnum;
import com.tridium.ccn.enums.BCcnTableGroupTypeEnum;
import com.tridium.ccn.enums.BCcnUnitMappingEnum;
import com.tridium.ccn.exceptions.CcnException;
import com.tridium.ccn.messages.CcnMessageConst;
import com.tridium.ccn.messages.CcnReadTableRequest;
import com.tridium.ccn.messages.CcnResponseMessage;
import com.tridium.ccn.point.BCcnProxyExt;
import com.tridium.ccn.tables.BCcnAHTable;
import com.tridium.ccn.tables.BCcnDataTable;
import com.tridium.ccn.tables.BCcnFidTable;
import com.tridium.ccn.tables.BCcnPicTable;
import com.tridium.ccn.tables.BCcnPocTable;
import com.tridium.ccn.tables.BCcnTable;
import com.tridium.ccn.tables.BCcnTableGroup;
import com.tridium.ccn.util.CcnEnumsUtil;
import com.tridium.ccn.util.CcnRspDataUtil;
import com.tridium.ccn.util.CcnRspFidUtil;
import com.tridium.ccn.util.CcnRspPicPocUtil;
import com.tridium.ccn.util.CcnRspPicUtil;
import com.tridium.ccn.util.CcnRspPocUtil;
import com.tridium.platCcn.CcnTableDef;
import java.util.Vector;
import javax.baja.log.Log;
import javax.baja.sys.BComponent;
import javax.baja.sys.LocalizableRuntimeException;

public class CcnUtil
implements CcnMessageConst {
    public static final int NONE_DATA_TYPE = 0;
    public static final int INT_DATA_TYPE = 1;
    public static final int FLOAT_DATA_TYPE = 2;
    public static final int DATE_DATA_TYPE = 3;
    public static final int TIME_DATA_TYPE = 4;
    public static final int BOOLEAN_DATA_TYPE = 5;
    public static final int STRING_DATA_TYPE = 9;
    public static final int INT_READONLY_DATA_TYPE = 10;
    public static final int FLOAT_READONLY_DATA_TYPE = 11;
    public static final int DATE_READONLY_DATA_TYPE = 12;
    public static final int TIME_READONLY_DATA_TYPE = 13;
    public static final int BOOLEAN_READONLY_DATA_TYPE = 14;
    public static final int STRING_READONLY_DATA_TYPE = 18;
    public static final int SUCCESSFUL_OPERATION = 0;
    public static final int NO_OPERATION_NODE_OOS = 1;
    public static final int UNRESPONSIVE_OPERATION = 2;
    public static final int UNSUCCESSFUL_OPERATION = 3;
    public static final int POLL_ACTION = 0;
    public static final int WRITE_ACTION = 1;
    public static final String NODE_NAME_SPECIAL_CHARS = "_";
    public static BCcnPointEntry pointEntry;
    public static BFidPointConfig pointConfig;
    public static BCcnPicTable ccnPicTable;
    public static BCcnPocTable ccnPocTable;
    static Log ccnMessageLog;

    public static int getControlPointType(BCcnPointEntry pointEntry) {
        if (pointEntry.isDiscrete()) {
            return 5;
        }
        return CcnUtil.getControlPointType(pointEntry.getPointDataType());
    }

    public static int getControlPointType(int pointdataType) {
        switch (pointdataType) {
            case 2: 
            case 10: {
                return 1;
            }
            case 0: 
            case 1: 
            case 9: 
            case 12: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                return 9;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                return 0;
            }
            case 6: {
                return 11;
            }
            case 7: 
            case 17: 
            case 48: 
            case 49: 
            case 50: {
                return 2;
            }
            case 51: {
                return 18;
            }
        }
        return 0;
    }

    public static BCcnTableGroup findCcnTableGroup(BComponent _dev, BCcnTableGroupTypeEnum _groupType) {
        BCcnTableGroup tg1 = null;
        BComponent[] childrenHandles = _dev.getChildComponents();
        boolean isTableGroupExisted = false;
        for (int i = 0; i < childrenHandles.length; ++i) {
            BComponent nextChild = childrenHandles[i];
            if (!(nextChild instanceof BCcnTableGroup)) continue;
            tg1 = (BCcnTableGroup)nextChild;
            if (tg1.getName().equalsIgnoreCase(_groupType.getTag())) {
                isTableGroupExisted = true;
                break;
            }
            BCcnTableGroup tg2 = CcnUtil.findCcnTableGroup(nextChild, _groupType);
            if (tg2 == null) continue;
            return tg2;
        }
        if (isTableGroupExisted) {
            return tg1;
        }
        return null;
    }

    public static BCcnTable findCcnTable(BComponent _tg, BCcnTableEntry _table) {
        BCcnTable tab1 = null;
        boolean isTableExisted = false;
        BComponent[] childrenHandles = _tg.getChildComponents();
        for (int i = 0; i < childrenHandles.length; ++i) {
            BComponent nextChild = childrenHandles[i];
            if (nextChild instanceof BCcnPicTable || nextChild instanceof BCcnPocTable || nextChild instanceof BCcnAHTable || nextChild instanceof BCcnFidTable || nextChild instanceof BCcnDataTable) {
                tab1 = (BCcnTable)nextChild;
                String tName = tab1.getName().trim();
                if (!tName.equalsIgnoreCase(_table.getTableName()) || tab1.getTableNum() != _table.getTableNum()) continue;
                isTableExisted = true;
                break;
            }
            BCcnTable tab2 = CcnUtil.findCcnTable(nextChild, _table);
            if (tab2 == null) continue;
            return tab2;
        }
        if (isTableExisted) {
            return tab1;
        }
        return null;
    }

    public static BCcnDevice findCcnDevice(BComponent _net, int _bus, int _elem) {
        BCcnDevice dev1 = null;
        boolean isDeviceExisted = false;
        BComponent[] childrenHandles = _net.getChildComponents();
        for (int i = 0; i < childrenHandles.length; ++i) {
            BComponent nextChild = childrenHandles[i];
            if (nextChild instanceof BCcnDevice) {
                dev1 = (BCcnDevice)nextChild;
                if (dev1.getBusNo() != _bus || dev1.getElemNo() != _elem) continue;
                isDeviceExisted = true;
                continue;
            }
            BCcnDevice dev2 = CcnUtil.findCcnDevice(nextChild, _bus, _elem);
            if (dev2 == null) continue;
            return dev2;
        }
        if (isDeviceExisted) {
            return dev1;
        }
        return null;
    }

    public static CcnResponseMessage getBlockDataFromTable(BCcnDevice ccnDevice, int curTableType, int curTableInstance, int curBlock) {
        CcnResponseMessage rsp = new CcnResponseMessage();
        BCcnNetwork ccnNetwork = ccnDevice.getCcnNetwork();
        int curBusNo = ccnDevice.getBusNo();
        int curElemNo = ccnDevice.getElemNo();
        for (int i = 0; i < 3; ++i) {
            rsp = new CcnResponseMessage();
            CcnReadTableRequest req = new CcnReadTableRequest(new CcnTableDef((byte)curElemNo, (byte)curBusNo, null, (short)curTableType, (byte)curTableInstance, (byte)curBlock, 0, 0));
            rsp = ccnNetwork.getCcnComm().ccnAsyncRequest().sendAsyncRequest(req);
            if (rsp != null && rsp.getResponseCommand() == 21) {
                return rsp;
            }
            if (rsp == null || rsp.getResponseCommand() != 6 || curBlock != rsp.getBlock() || curTableInstance != rsp.getTableInstance() || curTableType != rsp.getTableType()) continue;
            return rsp;
        }
        if (rsp != null) {
            ccnMessageLog.trace("\n****  createTablesRequest... return from block read, device: " + curBusNo + "," + curElemNo + " for table= " + Integer.toHexString(curTableType) + "," + curTableInstance + " curBlock= " + curBlock + " blockLen= " + rsp.getBlockLen());
        }
        if (rsp == null) {
            ccnMessageLog.trace("\n****  createTablesRequest... getBlockDataFromTable failed to get block from block read, device: " + curBusNo + "," + curElemNo + " for table= " + Integer.toHexString(curTableType) + "," + curTableInstance + " curBlock= " + curBlock);
        }
        return rsp;
    }

    public static boolean isNetworkDeviceStatusOk(BCcnDevice ccnDevice) {
        boolean bStatus = true;
        BCcnNetwork ccnNetwork = null;
        try {
            ccnNetwork = ccnDevice.getCcnNetwork();
        }
        catch (Exception ex) {
            ccnNetwork = null;
        }
        if (ccnNetwork == null) {
            bStatus = false;
        } else if (!CcnUtil.isNetworkStatusOk(ccnNetwork)) {
            bStatus = false;
        } else if (!CcnUtil.isDeviceStatusOk(ccnDevice)) {
            bStatus = false;
        }
        return bStatus;
    }

    public static boolean isNetworkStatusOk(BCcnNetwork ccnNetwork) {
        return !ccnNetwork.isDown() && !ccnNetwork.isDisabled() && !ccnNetwork.isFatalFault();
    }

    public static boolean isDeviceStatusOk(BCcnDevice ccnDevice) {
        return !ccnDevice.isDown() && !ccnDevice.isDisabled() && !ccnDevice.isFatalFault();
    }

    public static String makeValidName(String name) {
        return CcnUtil.makeValidName(name, NODE_NAME_SPECIAL_CHARS, '_');
    }

    public static String makeValidName(String name, String specials, char replacement) {
        char[] buf = name.toCharArray();
        if (!Character.isLetter(buf[0])) {
            buf[0] = 120;
        }
        for (int i = 1; i < buf.length; ++i) {
            char c = buf[i];
            if (Character.isLetterOrDigit(c) || specials.indexOf(c) >= 0) continue;
            buf[i] = replacement;
        }
        return new String(buf);
    }

    public static String massageFloatToTimeString(BCcnProxyExt proxyExt, String _floatValue) throws CcnException {
        String returnValue = "";
        try {
            int tempInt = new Float(_floatValue).intValue();
            if (tempInt < 9999) {
                int hh = tempInt / 100;
                int mm = tempInt % 100;
                returnValue = hh > 24 || hh < 0 || mm > 60 || mm < 0 ? null : "" + CcnRspFidUtil.get2DigString(hh) + ":" + CcnRspFidUtil.get2DigString(mm);
            }
        }
        catch (Exception e) {
            proxyExt.getTable().updateObject(null, 3, 1, proxyExt);
            throw new CcnException(6488174, "Enter time value in hhmm format");
        }
        return returnValue;
    }

    public static String formatTime(String s1) {
        if (s1.indexOf(":") == -1) {
            throw new LocalizableRuntimeException("ccn", "CCNTimeFomat.Error");
        }
        if (s1.substring(0, s1.indexOf(":")).length() == 1) {
            s1 = "0" + s1;
        }
        if (s1.substring(s1.indexOf(":") + 1).length() == 1) {
            s1 = s1.substring(0, s1.indexOf(":") + 1) + "0" + s1.substring(s1.indexOf(":") + 1);
        }
        return s1;
    }

    public static String formatDoubleTime(String s1) {
        String time1 = s1.substring(0, s1.indexOf(" "));
        String time2 = s1.substring(s1.indexOf(" ") + 1);
        s1 = CcnUtil.formatTime(time1) + " " + CcnUtil.formatTime(time2);
        return s1;
    }

    public static CcnResponseMessage[] interrogateTableForPointData(BCcnDevice ccnDevice, int curTableType, int curTableInstance, int curBlockCount) {
        BCcnNetwork ccnNetwork = ccnDevice.getCcnNetwork();
        CcnResponseMessage[] curBlockResponses = new CcnResponseMessage[curBlockCount];
        if (!ccnDevice.isDeviceFID()) {
            for (int j = 2; j <= curBlockCount; ++j) {
                if ((20 <= curTableType && curTableType <= 22 || curTableType == 24) && (j == 5 || j == 9)) continue;
                ccnNetwork.setDiscoveryInProgress(true);
                curBlockResponses[j - 1] = CcnUtil.getBlockDataFromTable(ccnDevice, curTableType, curTableInstance, j);
            }
        } else {
            for (int j = 1; j <= curBlockCount; ++j) {
                if (j == 1 && curTableType != 1281) continue;
                ccnNetwork.setDiscoveryInProgress(true);
                curBlockResponses[j - 1] = CcnUtil.getBlockDataFromTable(ccnDevice, curTableType, curTableInstance, j);
                if (curBlockResponses[j - 1] != null) continue;
                return null;
            }
        }
        return curBlockResponses;
    }

    public static void convertBlockDataToTableData(BCcnDevice ccnDevice, BCcnPointEntry[] pointEntries, BFidPointConfig[] pointConfigs, int tableType, CcnResponseMessage[] curBlockResponses, BCcnTable curTable, int fidPointInstance) {
        block34: {
            block37: {
                block36: {
                    block35: {
                        block33: {
                            int tableFieldCount = pointEntries.length;
                            int tableBlockCount = curBlockResponses.length;
                            int[] blockIndices = new int[tableBlockCount];
                            ccnMessageLog.trace("Inside convertBlockDataToTableData method-->tableFieldCount::" + tableFieldCount + "::tableBlockCount::" + tableBlockCount);
                            ccnMessageLog.trace("blockIndices Array Length is::" + blockIndices.length);
                            int newIndex = 0;
                            if (ccnDevice.isDeviceFID()) break block33;
                            for (int i = 0; i < tableFieldCount; ++i) {
                                pointEntry = new BCcnPointEntry();
                                int blockNum = 2 + i / 20;
                                int blockIndex = blockIndices[blockNum - 1];
                                if (blockIndex != -1) {
                                    blockIndices[blockNum - 1] = newIndex = CcnUtil.getBlock_2_3_4_Data(ccnDevice, pointEntry, tableType, i, curBlockResponses[blockNum - 1], blockIndex);
                                }
                                if ((blockIndex = blockIndices[(blockNum = 5) - 1]) != -1) {
                                    blockIndices[blockNum - 1] = newIndex = CcnUtil.getBlock_5_Data(pointEntry, tableType, i, curBlockResponses[blockNum - 1], blockIndex, blockNum);
                                }
                                if ((blockIndex = blockIndices[(blockNum = 6) - 1]) != -1) {
                                    blockIndices[blockNum - 1] = newIndex = CcnUtil.getBlock_6_Data(curTable, tableType, i, curBlockResponses[blockNum - 1], blockIndex);
                                }
                                if (blockIndices[(blockNum = 7) - 1] >= 240) {
                                    blockNum = 8;
                                }
                                blockIndex = blockIndices[blockNum - 1];
                                ccnMessageLog.trace("BlockIndex::" + blockIndex + "::BlockNumber::" + blockNum);
                                if (blockIndex != -1) {
                                    blockIndices[blockNum - 1] = newIndex = CcnUtil.getFieldLimits(tableType, i, curBlockResponses[blockNum - 1], blockIndex, blockNum);
                                }
                                if ((blockIndex = blockIndices[(blockNum = 9) - 1]) != -1) {
                                    blockIndices[blockNum - 1] = newIndex = CcnUtil.getFieldVariableNo(tableType, i, curBlockResponses[blockNum - 1], blockIndex);
                                }
                                if ((blockIndex = blockIndices[(blockNum = 10 + i / 10) - 1]) != -1) {
                                    blockIndices[blockNum - 1] = newIndex = CcnUtil.getFieldDescription(tableType, i, curBlockResponses[blockNum - 1], blockIndex);
                                }
                                pointEntries[i] = pointEntry;
                            }
                            break block34;
                        }
                        if (tableType != 1281) break block35;
                        pointConfig = new BFidPointConfig();
                        pointEntry = new BCcnPointEntry();
                        try {
                            int blockNum = 1;
                            pointEntry.setFieldIndex(fidPointInstance - 1);
                            pointConfig.setPointIndex(fidPointInstance - 1);
                            String curName = CcnRspFidUtil.getPointName(curBlockResponses[blockNum - 1]).trim();
                            if (curName.equals("IO")) {
                                curName = curName + CcnRspFidUtil.get2DigString(fidPointInstance);
                            }
                            pointEntry.setFieldName(curName);
                            pointEntry.setDisplayType(ccnDevice.getCcnNetwork().getDisplayMetric());
                            pointEntry.setFieldByteCount(2);
                            pointEntry.setConfigFlags(0);
                            pointEntry.setVariableNo(fidPointInstance + 1);
                            pointEntry.setForceableFlag(true);
                            blockNum = 2;
                            if (!CcnRspFidUtil.getInSystem(curBlockResponses[blockNum - 1])) {
                                ccnMessageLog.trace("\n****  convertBlockDataToTableData tt=0x501 fidPointInstance:" + fidPointInstance + " not inSystem, so no point entry will be created");
                                return;
                            }
                            byte deviceType = CcnRspFidUtil.getDeviceType(curBlockResponses[blockNum - 1]);
                            if (0 > deviceType || deviceType > 5) {
                                ccnMessageLog.trace("\n****  convertBlockDataToTableData tt=0x501 fidPointInstance:" + fidPointInstance + " deviceType:" + deviceType + " not in valid 1-4 range, so no point entry will be created");
                                return;
                            }
                            pointConfig.setDeviceType(deviceType);
                            byte ctrlSensType = 0;
                            ctrlSensType = deviceType == 4 ? CcnRspFidUtil.getSensedPulsed(curBlockResponses[blockNum - 1]) : CcnRspFidUtil.getCtrlSensType(curBlockResponses[blockNum - 1]);
                            pointConfig.setCtrlSensType(ctrlSensType);
                            String curEUC = CcnRspFidUtil.getEUC(deviceType, ctrlSensType);
                            pointEntry.setLoLimit(CcnRspFidUtil.getLoLimit(deviceType, ctrlSensType));
                            pointEntry.setHiLimit(CcnRspFidUtil.getHiLimit(deviceType, ctrlSensType));
                            int curUnits = CcnRspFidUtil.getUnitsIndex(curBlockResponses[blockNum - 1]);
                            if (curEUC == null || curEUC.length() < 1) {
                                ccnMessageLog.trace("\n****  convertBlockDataToTableData tt=0x501 fidPointInstance:" + fidPointInstance + " euc:" + curEUC + " not valid euc, so no point entry will be created");
                                return;
                            }
                            if (deviceType == 2 && curUnits != 0) {
                                curEUC = "TINC";
                            }
                            pointConfig.setEUC(curEUC);
                            pointEntry.setEUC(pointConfig.getEUC());
                            if (curEUC.equals("TPER") || curEUC.equals("TNUM") || curEUC.equals("TOFF") || curEUC.length() <= 1) {
                                pointEntry.setPointDataType(2);
                                pointEntry.setDataTypeEnum(CcnEnumsUtil.setProperDataTypeEnum(2));
                                pointEntry.setDisplayDigits(96);
                            } else {
                                pointEntry.setPointDataType(7);
                                pointEntry.setDataTypeEnum(BCcnDataTypeEnum.make(7).getTag());
                                pointEntry.setDisplayDigits(97);
                            }
                            if (deviceType == 1 || deviceType == 4) {
                                pointEntry.setConfigFlags(-128);
                                if (curUnits == 0) {
                                    pointEntry.setDiscreteTextOffset((byte)BCcnDiscreteStateEnum.OnOff_Off.getOrdinal());
                                } else {
                                    pointEntry.setDiscreteTextOffset((byte)curUnits);
                                }
                            } else if (deviceType == 2 || deviceType == 3) {
                                if (curUnits == 0) {
                                    curUnits = CcnRspFidUtil.getPointUnits(deviceType, ctrlSensType);
                                }
                                pointEntry.setUnits(curUnits);
                                pointEntry.setUnitsEnum(CcnEnumsUtil.setProperUnitsMappingEnum(BCcnUnitMappingEnum.parseId(curUnits, ccnDevice.getCcnNetwork().getDisplayMetric())));
                            }
                            pointEntry.setValueBlock(6);
                            pointEntry.setValueBlockOffset((fidPointInstance - 1) * 3);
                            pointEntry.setDescription(CcnRspFidUtil.getPointDesc(deviceType, ctrlSensType));
                        }
                        catch (CcnException e) {
                            ccnMessageLog.error("<CcnCreateTablesRequest: FID table tt=0x501 Point Entry Data ERROR: " + (Object)((Object)e));
                        }
                        if (pointEntry.getLoLimit().trim().length() != 0 && pointEntry.getHiLimit().trim().length() != 0 && pointEntry.getDescription().trim().length() != 0) {
                            pointEntries[0] = pointEntry;
                        }
                        pointConfigs[0] = pointConfig;
                        break block34;
                    }
                    if (tableType != 1284) break block36;
                    try {
                        int blockNum = 2;
                        int setpointType = CcnRspFidUtil.getSetpointType(curBlockResponses[blockNum - 1]);
                        ((BCcnFidTable)curTable).setSetpointType(setpointType);
                        for (int i = 0; i < 4; ++i) {
                            pointEntry = new BCcnPointEntry();
                            pointEntry.setFieldIndex(i);
                            String curName = "SS" + CcnRspFidUtil.get2DigString(i + 2);
                            pointEntry.setFieldName(curName);
                            pointEntry.setPointDataType(1);
                            pointEntry.setDataTypeEnum(BCcnDataTypeEnum.make(1).getTag());
                            pointEntry.setDisplayType(ccnDevice.getCcnNetwork().getDisplayMetric());
                            pointEntry.setFieldByteCount(1);
                            pointEntry.setDisplayDigits(97);
                            int curUnits = CcnRspFidUtil.getSetpointUnits(setpointType);
                            pointEntry.setUnits(curUnits);
                            pointEntry.setUnitsEnum(CcnEnumsUtil.setProperUnitsMappingEnum(BCcnUnitMappingEnum.parseId(curUnits, ccnDevice.getCcnNetwork().getDisplayMetric())));
                            pointEntry.setPointValue(CcnRspFidUtil.getValue(curBlockResponses[blockNum - 1], pointEntry));
                            pointEntry.setValueBlock(2);
                            pointEntry.setValueBlockOffset(i);
                            pointEntry.setLoLimit(CcnRspFidUtil.getSetPointLoLimit(setpointType));
                            pointEntry.setHiLimit(CcnRspFidUtil.getSetPointHiLimit(setpointType));
                            pointEntry.setDescription(CcnRspFidUtil.getSetPointDesc(i));
                            pointEntries[i] = pointEntry;
                        }
                    }
                    catch (CcnException e) {
                        ccnMessageLog.error("<CcnCreateTablesRequest: FID table tt=0x504 Point Entry Data ERROR: " + (Object)((Object)e));
                    }
                    break block34;
                }
                if (tableType != 1283) break block37;
                try {
                    int blockNum = 2;
                    for (int i = 0; i < 7; ++i) {
                        pointEntries[i * 3 + 0].setPointValue(CcnRspFidUtil.getPeriodOccTime(curBlockResponses[blockNum - 1], i + 1));
                        pointEntries[i * 3 + 1].setPointValue(CcnRspFidUtil.getPeriodUnoccTime(curBlockResponses[blockNum - 1], i + 1));
                        pointEntries[i * 3 + 2].setPointValue(CcnRspFidUtil.getDaysFlags(curBlockResponses[blockNum - 1], i + 1));
                    }
                }
                catch (CcnException e) {
                    ccnMessageLog.error("<CcnCreateTablesRequest: FID table tt=0x504 Point Entry Data ERROR: " + (Object)((Object)e));
                }
                break block34;
            }
            if (tableType != 1285) break block34;
            try {
                int blockNum = 2;
                for (int i = 0; i < 30; ++i) {
                    pointEntries[i * 2 + 0].setPointValue(CcnRspFidUtil.getHolidayMonth(curBlockResponses[blockNum - 1], i + 1));
                    pointEntries[i * 2 + 1].setPointValue(CcnRspFidUtil.getHolidayDay(curBlockResponses[blockNum - 1], i + 1));
                }
            }
            catch (CcnException e) {
                ccnMessageLog.error("<CcnCreateTablesRequest: FID table tt=0x505 Point Entry Data ERROR: " + (Object)((Object)e));
            }
        }
    }

    public static int getBlock_2_3_4_Data(BCcnDevice ccnDevice, BCcnPointEntry pointEntry, int tableType, int fieldIndex, CcnResponseMessage response, int index) {
        if (16 <= tableType && tableType <= 24) {
            if (response == null || response.getResponseCommand() != 6) {
                return -1;
            }
            int len = response.getBlockLen() - 3;
            if (index + 12 <= len) {
                pointEntry.setFieldIndex(fieldIndex);
                try {
                    pointEntry.setFieldName(CcnRspPicPocUtil.getFieldName(response, fieldIndex).trim());
                    byte dataType = CcnRspPicPocUtil.getDataType(response, fieldIndex);
                    pointEntry.setPointDataType(dataType);
                    pointEntry.setDataTypeEnum(CcnEnumsUtil.setProperDataTypeEnum(dataType));
                    pointEntry.setDisplayType(ccnDevice.getCcnNetwork().getDisplayMetric());
                    pointEntry.setFieldByteCount(CcnRspPicPocUtil.getFieldByteCount(response, dataType, fieldIndex));
                    byte configFlags = CcnRspPicPocUtil.getConfigFlags(response, fieldIndex);
                    pointEntry.setConfigFlags(configFlags);
                    if ((configFlags & 0x80) != 0) {
                        pointEntry.setDiscreteTextOffset(CcnRspPicPocUtil.getDiscreteTextOffset(response, fieldIndex));
                        pointEntry.setDisplayDigits(16);
                    } else if (dataType == 0 || dataType == 1 || dataType == 2 || dataType == 6 || dataType == 7 || dataType == 9 || dataType == 10 || dataType == 19 || dataType == 30 || dataType == 31 || dataType == 32) {
                        pointEntry.setDisplayDigits(CcnRspPicPocUtil.getDisplayDigits(response, dataType, fieldIndex));
                    }
                    pointEntry.setUnits(CcnRspPicPocUtil.getUnits(response, fieldIndex));
                    pointEntry.setUnitsEnum(CcnEnumsUtil.setProperUnitsMappingEnum(BCcnUnitMappingEnum.parseId(CcnRspPicPocUtil.getUnits(response, fieldIndex), ccnDevice.getCcnNetwork().getDisplayMetric())));
                }
                catch (CcnException e) {
                    ccnMessageLog.error("<CcnCreateTablesRequest: Pic or Poc table getBlock_2_3_4_Data ERROR: " + (Object)((Object)e));
                }
                return index += 12;
            }
        }
        return -1;
    }

    public static int getBlock_5_Data(BCcnPointEntry pointEntry, int tableType, int fieldIndex, CcnResponseMessage response, int index, int block) {
        if (16 <= tableType && tableType <= 19 || tableType == 23) {
            if (response == null || response.getResponseCommand() != 6) {
                return -1;
            }
            int len = response.getBlockLen() - 3;
            int dataLength = pointEntry.getFieldByteCount();
            if (index + dataLength <= len) {
                try {
                    pointEntry.setPointValue(CcnRspPicUtil.getValue(response, index, pointEntry).trim());
                    pointEntry.setValueBlock((byte)block);
                    pointEntry.setValueBlockOffset(index);
                }
                catch (CcnException e) {
                    ccnMessageLog.error("<CcnCreateTablesRequest: Pic table getBlock_5_Data ERROR: " + (Object)((Object)e));
                }
                return index += dataLength;
            }
        }
        return -1;
    }

    public static int getBlock_6_Data(BCcnTable curTable, int tableType, int fieldIndex, CcnResponseMessage response, int index) {
        int len;
        if (curTable instanceof BCcnPicTable) {
            ccnPicTable = (BCcnPicTable)curTable;
        }
        if (curTable instanceof BCcnPocTable) {
            ccnPocTable = (BCcnPocTable)curTable;
        }
        if (17 == tableType || tableType == 18) {
            if (response == null || response.getResponseCommand() != 6) {
                return -1;
            }
            len = response.getBlockLen() - 3;
            if (index + 1 <= len) {
                try {
                    byte statusByte = CcnRspPicUtil.getStatus(response, fieldIndex);
                    int status = statusByte & 7;
                    if (pointEntry.isDiscrete() && status == 3) {
                        status += 2;
                    }
                    int force = statusByte >> 4 & 0xF;
                    if (0 <= status && status <= 5) {
                        pointEntry.setAlrmStatus(BCcnAlarmStatusEnum.make(status));
                    }
                    pointEntry.setForceLevel(BCcnForceStatusEnum.make(force));
                }
                catch (CcnException e) {
                    ccnMessageLog.error("<CcnCreateTablesRequest: Pic table getBlock_6_Data ERROR: " + (Object)((Object)e));
                }
                return ++index;
            }
        }
        if (20 <= tableType && tableType <= 22 || tableType == 24) {
            if (response == null || response.getResponseCommand() != 6) {
                return -1;
            }
            len = response.getBlockLen() - 3;
            if (index + 1 <= len) {
                try {
                    ccnPocTable.setDataTableType(CcnRspPocUtil.getDataTableType(response));
                    int dataTableBlock = CcnRspPocUtil.getDataTableBlock(response);
                    ccnPocTable.setDataTableBlock(dataTableBlock);
                    pointEntry.setValueBlock((byte)(dataTableBlock & 0xFF));
                    if (dataTableBlock == 255) {
                        ccnPocTable.setDataTableStartBlock(CcnRspPocUtil.getDataTableStrBlock(response));
                        ccnPocTable.setDataTableEndBlock(CcnRspPocUtil.getDataTableEndBlock(response));
                    }
                }
                catch (CcnException e) {
                    ccnMessageLog.error("<CcnCreateTablesRequest: Poc table getBlock_6_Data ERROR: " + (Object)((Object)e));
                }
                return ++index;
            }
        }
        return -1;
    }

    public static int getFieldLimits(int tableType, int fieldIndex, CcnResponseMessage response, int index, int block) {
        if (response == null || response.getResponseCommand() != 6) {
            return -1;
        }
        int len = response.getBlockLen() - 3;
        int configFlags = pointEntry.getConfigFlags();
        int dataType = pointEntry.getPointDataType();
        int dataLength = pointEntry.getFieldByteCount();
        boolean loLimitSpecified = false;
        boolean hiLimitSpecified = false;
        if ((configFlags & 1) != 0) {
            loLimitSpecified = true;
        }
        if ((configFlags & 2) != 0) {
            hiLimitSpecified = true;
        }
        if (16 <= tableType && tableType <= 24) {
            if (!loLimitSpecified && !hiLimitSpecified) {
                if (dataType == 0) {
                    pointEntry.setLoLimit(new String("0"));
                    pointEntry.setHiLimit(new String("255"));
                } else if (dataType == 1 || dataType == 25 || dataType == 49 || dataType == 50) {
                    pointEntry.setLoLimit(new String("0"));
                    pointEntry.setHiLimit(new String("255"));
                } else if (dataType == 2) {
                    pointEntry.setLoLimit(new String("0"));
                    pointEntry.setHiLimit(new String("65535"));
                } else if (dataType == 7 || dataType == 48) {
                    pointEntry.setLoLimit(new String("0"));
                    pointEntry.setHiLimit(new String("999999.99"));
                } else if (dataType == 9) {
                    pointEntry.setLoLimit(new String("-128"));
                    pointEntry.setHiLimit(new String("127"));
                } else if (dataType == 10) {
                    pointEntry.setLoLimit(new String("-32768"));
                    pointEntry.setHiLimit(new String("32767"));
                }
            }
            if (loLimitSpecified) {
                if (index + dataLength <= len) {
                    try {
                        pointEntry.setLoLimit(CcnRspPicPocUtil.getLimit(response, index, pointEntry).trim());
                        pointEntry.setLoLimitBlock((byte)block);
                        pointEntry.setLoLimitBlockOffset(index);
                    }
                    catch (CcnException e) {
                        ccnMessageLog.error("<CcnCreateTablesRequest: Pic or Poc table getFieldLimits - lo ERROR: " + (Object)((Object)e));
                    }
                    index += dataLength;
                }
                if (hiLimitSpecified) {
                    if (index + dataLength <= len) {
                        try {
                            pointEntry.setHiLimit(CcnRspPicPocUtil.getLimit(response, index, pointEntry).trim());
                            pointEntry.setHiLimitBlock((byte)block);
                            pointEntry.setHiLimitBlockOffset(index);
                        }
                        catch (CcnException e) {
                            ccnMessageLog.error("<CcnCreateTablesRequest: Pic or Poc table getFieldLimits - hi ERROR: " + (Object)((Object)e));
                        }
                        index += dataLength;
                    }
                } else if (dataType == 0) {
                    pointEntry.setHiLimit(new String("255"));
                } else if (dataType == 1 || dataType == 25 || dataType == 49 || dataType == 50) {
                    pointEntry.setHiLimit(new String("255"));
                } else if (dataType == 2) {
                    pointEntry.setHiLimit(new String("65535"));
                } else if (dataType == 7 || dataType == 48) {
                    pointEntry.setHiLimit(new String("999999.99"));
                } else if (dataType == 9) {
                    pointEntry.setHiLimit(new String("127"));
                } else if (dataType == 10) {
                    pointEntry.setHiLimit(new String("32767"));
                }
            } else {
                if (dataType == 1 || dataType == 25 || dataType == 49 || dataType == 50 || dataType == 2 || dataType == 7 || dataType == 48 || dataType == 9 || dataType == 10 || dataType == 0) {
                    pointEntry.setLoLimit(new String("0"));
                }
                if (hiLimitSpecified && index + dataLength <= len) {
                    try {
                        pointEntry.setHiLimit(CcnRspPicPocUtil.getLimit(response, index, pointEntry).trim());
                        pointEntry.setHiLimitBlock((byte)block);
                        pointEntry.setHiLimitBlockOffset(index);
                    }
                    catch (CcnException e) {
                        ccnMessageLog.error("<CcnCreateTablesRequest: Pic or Poc table getFieldLimits - hi ERROR: " + (Object)((Object)e));
                    }
                    index += dataLength;
                }
            }
            return index;
        }
        return -1;
    }

    public static int getFieldVariableNo(int tableType, int fieldIndex, CcnResponseMessage response, int index) {
        if (17 == tableType || tableType == 18) {
            if (response == null || response.getResponseCommand() != 6) {
                return -1;
            }
            int len = response.getBlockLen() - 3;
            if (index + 2 <= len) {
                try {
                    int variableNum = CcnRspPicUtil.getVariableNum(response, fieldIndex);
                    pointEntry.setVariableNo(variableNum);
                    if (variableNum != 0 && (pointEntry.getConfigFlags() & 2) != 0) {
                        pointEntry.setForceableFlag(true);
                    }
                }
                catch (CcnException e) {
                    ccnMessageLog.error("<CcnCreateTablesRequest: Poc table getFieldVariableNo ERROR: " + (Object)((Object)e));
                }
                return index += 2;
            }
        }
        return -1;
    }

    public static int getFieldDescription(int tableType, int fieldIndex, CcnResponseMessage response, int index) {
        if (response == null || response.getResponseCommand() != 6) {
            return -1;
        }
        int len = response.getBlockLen() - 3;
        if (index + 24 <= len && 16 <= tableType && tableType <= 24) {
            try {
                pointEntry.setDescription(CcnRspPicPocUtil.getDescription(response, fieldIndex).trim());
            }
            catch (CcnException e) {
                ccnMessageLog.error("<CcnCreateTablesRequest: Pic or Poc table getFieldDescription ERROR: " + (Object)((Object)e));
            }
            return index += 24;
        }
        return -1;
    }

    public static CcnResponseMessage interrogateDataTableForPointData(BCcnDevice ccnDevice, int curTableType, int curTableInstance, int dataBlock) {
        ccnDevice.getCcnNetwork().setDiscoveryInProgress(true);
        CcnResponseMessage curBlockResponse = new CcnResponseMessage();
        ccnMessageLog.trace("\n****  CcnCreateDataTablesRequest... pocTable: " + ccnDevice.getBusNo() + "," + ccnDevice.getElemNo() + " for table= " + curTableType + "," + curTableInstance + " curBlock= " + dataBlock);
        curBlockResponse = CcnUtil.getBlockDataFromDeviceDataTable(ccnDevice, curTableType, curTableInstance, dataBlock);
        if (curBlockResponse != null) {
            ccnMessageLog.trace("\n****  CcnCreateDataTablesRequest... interrogateTableForPointData return: " + curBlockResponse.getBlockLen());
        }
        return curBlockResponse;
    }

    public static CcnResponseMessage getBlockDataFromDeviceDataTable(BCcnDevice ccnDevice, int curTableType, int curTableInstance, int curBlock) {
        CcnResponseMessage rsp = null;
        int curBusNo = ccnDevice.getBusNo();
        int curElemNo = ccnDevice.getElemNo();
        BCcnNetwork ccnNetwork = ccnDevice.getCcnNetwork();
        for (int i = 0; i < 3; ++i) {
            CcnReadTableRequest req = new CcnReadTableRequest(new CcnTableDef((byte)curElemNo, (byte)curBusNo, null, (short)curTableType, (byte)curTableInstance, (byte)curBlock, 0, 0));
            rsp = ccnNetwork.getCcnComm().ccnAsyncRequest().sendAsyncRequest(req);
            if (rsp != null) break;
        }
        if (rsp != null) {
            ccnMessageLog.trace("\n****  CcnCreateDataTablesRequest... return from block read, device: " + curBusNo + "," + curElemNo + " for table= " + curTableType + "," + curTableInstance + " curBlock= " + curBlock + " blockLen= " + rsp.getBlockLen());
            return rsp;
        }
        return null;
    }

    public static Vector<BCcnPointEntry> convertBlockDataToDataTableData(Vector<BCcnPointEntry> pointsVector, BCcnPocTable ccnPocTable, BCcnDevice ccnDevice, BCcnPointEntry[] pointEntries, int tableType, CcnResponseMessage dataBlockResponse, int dataBlock) {
        int tableFieldCount = pointEntries.length;
        int dataBlock_FieldIndex = 0;
        ccnMessageLog.trace("\n****  CcnCreateDataTablesRequest... start convertBlockDataToTableData: " + tableType + "|" + tableFieldCount);
        BCcnPointEntry[] pointMasters = (BCcnPointEntry[])ccnPocTable.getLearnedSplPoints().getChildren(BCcnPointEntry.class);
        for (int i = 0; i < tableFieldCount; ++i) {
            pointEntry = new BCcnPointEntry(pointMasters[i]);
            pointEntry.setValueBlock((byte)dataBlock);
            int newIndex = CcnUtil.getDataBlock_Data(tableType, tableFieldCount, pointEntry, dataBlockResponse, dataBlock_FieldIndex);
            if (newIndex == -1) break;
            dataBlock_FieldIndex = newIndex;
            pointsVector.addElement(pointEntry);
        }
        return pointsVector;
    }

    public static int getDataBlock_Data(int tableType, int fieldIndex, BCcnPointEntry entry, CcnResponseMessage response, int index) {
        if (response == null || response.getResponseCommand() != 6) {
            return -1;
        }
        int len = response.getBlockLen() - 3;
        int dataLength = entry.getFieldByteCount();
        if (index + dataLength <= len) {
            try {
                entry.setPointValue(CcnRspDataUtil.getValue(response, index, entry));
                entry.setValueBlockOffset(index);
            }
            catch (CcnException e) {
                ccnMessageLog.error("<CcnCreateDataTablesRequest: Data table getDataBlock_Data ERROR: " + (Object)((Object)e));
            }
            return index += dataLength;
        }
        return -1;
    }

    static {
        ccnMessageLog = Log.getLog((String)"CCNMessagesLog");
    }
}

