/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn.util;

import com.tridium.ccn.enums.BCcnDiscreteStateEnum;
import com.tridium.ccn.enums.BCcnUnitMappingEnum;
import com.tridium.ccn.exceptions.CcnException;
import com.tridium.ccn.messages.CcnResponseMessage;
import com.tridium.ccn.util.CcnEnumsUtil;
import com.tridium.ccn.util.CcnRspPicPocUtil;
import com.tridium.ccn.util.CcnRspTableUtil;
import com.tridium.platCcn.CcnDataWrapper;
import com.tridium.platCcn.CcnUnsolicitedMsg;
import javax.baja.alarm.ext.BAlarmState;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BMonth;
import javax.baja.sys.BTime;
import javax.baja.sys.Clock;

public abstract class CcnAlarmUtil
extends CcnRspTableUtil {
    public static int EXPECT_TBL_TYPE = 67;
    public static int EXPECT_CMD_TYPE = 30;
    public static final int HOST_ALARM_OFFSET = 5;
    public static final int BUILDING_NO_LOCATION = 3;
    public static final int DEV_SYS_NAME_LOCATION = 4;
    public static final int DEV_SYS_NAME_LENGTH_MAX = 8;
    public static final int ALARM_DESC_INDEX_LOCATION = 12;
    public static final int ALARM_CONTROL_LOCATION = 13;
    public static final int ALARM_PRIORITY_LOCATION = 14;
    public static final int VARIABLE_NAME_LOCATION = 15;
    public static final int VARIABLE_NAME_LENGTH_MAX = 8;
    public static final int VARIABLE_VALUE_LOCATION = 23;
    public static final int EXCEED_LIMIT_LOCATION = 27;
    public static final int ALARM_HOUR_LOCATION = 31;
    public static final int ALARM_MINUTE_LOCATION = 32;
    public static final int ALARM_FORMAT_LOCATION = 33;
    public static final int ALARM_FORMAT_LENGTH_MAX = 4;
    public static final int MIN_ALARM_WO_DATE_LENGTH = 38;
    public static final int ALARM_MONTH_LOCATION = 39;
    public static final int ALARM_DAY_LOCATION = 40;
    public static final int ALARM_YEAR_LOCATION = 41;
    public static final int MIN_ALARM_W_DATE_LENGTH = 42;
    public static final int SNAP_SHOT_LOCATION = 42;
    public static final int MIN_EXTENDED_ALARM_LENGTH = 43;
    public static final int TABLE_NAME_LOCATION = 44;
    public static final int TABLE_NAME_LENGTH_MAX = 8;
    public static final int ALARM_TEXT_LOCATION = 52;
    public static final int MIN_EXTENDED_ALARM_TEXT_LENGTH = 53;
    private static final int RETURN_TO_NORMAL = 7;
    private static final int ALARM_PRIORITY_TYPE_MASK = 128;
    private static final int ALARM_PRIORITY_TYPE_SHIFT = 7;
    private static final int ALARM_PRIORITY_SOURCE_MASK = 112;
    private static final int ALARM_PRIORITY_SOURCE_SHIFT = 4;

    private static CcnException wrongUnsolicitedCommandTypeException() {
        return new CcnException(6488170, "Method needs unsolicited message with command " + EXPECT_CMD_TYPE + ".");
    }

    private static CcnException wrongDataWrapperException() {
        return new CcnException(6488173, "Method needs either an unsolicited alarm message or a ccn response to a read alarm table request.");
    }

    private static CcnException wrongTableException() {
        return new CcnException(6488168, "Method needs table " + EXPECT_TBL_TYPE + ".");
    }

    private static void verifyWrapperType(CcnDataWrapper possibleAlarmMsg) throws CcnException {
        if (possibleAlarmMsg instanceof CcnUnsolicitedMsg) {
            CcnAlarmUtil.verifyCommandType((CcnUnsolicitedMsg)possibleAlarmMsg);
        } else if (possibleAlarmMsg instanceof CcnResponseMessage) {
            CcnAlarmUtil.verifyTableType((CcnResponseMessage)possibleAlarmMsg);
        } else {
            throw CcnAlarmUtil.wrongDataWrapperException();
        }
    }

    private static void verifyTableType(CcnResponseMessage rsp) throws CcnException {
        if (rsp.getTableType() != EXPECT_TBL_TYPE) {
            throw CcnAlarmUtil.wrongTableException();
        }
    }

    private static void verifyCommandType(CcnUnsolicitedMsg possibleAlarmMsg) throws CcnException {
        if (possibleAlarmMsg.getCommand() != EXPECT_CMD_TYPE) {
            throw CcnAlarmUtil.wrongUnsolicitedCommandTypeException();
        }
    }

    private static void verifyStandardAlarmWithDate(CcnDataWrapper possibleAlmWithDate) throws CcnException {
        if (possibleAlmWithDate.getData().length < 42) {
            throw new CcnException(6488171, "Cannot proceed because the alarm is not a standard alarm with date.");
        }
    }

    private static void verifyExtendedAlarm(CcnDataWrapper possibleAlmWithDate) throws CcnException {
        if (possibleAlmWithDate.getData().length < 43) {
            throw new CcnException(6488172, "Cannot proceed because the alarm is not an extended alarm.");
        }
    }

    public static int getBuildingNumber(CcnDataWrapper alarmMsg) throws CcnException {
        CcnAlarmUtil.verifyWrapperType(alarmMsg);
        return alarmMsg.getData()[3];
    }

    public static String getDeviceOrSystemName(CcnDataWrapper alarmMsg) throws CcnException {
        CcnAlarmUtil.verifyWrapperType(alarmMsg);
        return new String(alarmMsg.getData(), 4, 8).trim();
    }

    public static int getAlarmDescIndex(CcnDataWrapper alarmMsg) throws CcnException {
        CcnAlarmUtil.verifyWrapperType(alarmMsg);
        return alarmMsg.getData()[12];
    }

    public static int getAlarmControl(CcnDataWrapper alarmMsg) throws CcnException {
        CcnAlarmUtil.verifyWrapperType(alarmMsg);
        return alarmMsg.getData()[13];
    }

    public static int getAlarmPriority(CcnDataWrapper alarmMsg) throws CcnException {
        CcnAlarmUtil.verifyWrapperType(alarmMsg);
        return alarmMsg.getData()[14];
    }

    public static String getVariableName(CcnDataWrapper alarmMsg) throws CcnException {
        CcnAlarmUtil.verifyWrapperType(alarmMsg);
        return new String(alarmMsg.getData(), 15, 8).trim();
    }

    private static int intFrom2Bytes(byte[] byteArray, int startIndex) {
        return ByteArrayUtil.readShort((byte[])byteArray, (int)startIndex);
    }

    public static float getVariableValue(CcnDataWrapper alarmMsg) throws CcnException {
        CcnAlarmUtil.verifyWrapperType(alarmMsg);
        return ByteArrayUtil.readLong((byte[])alarmMsg.getData(), (int)23);
    }

    public static float getExceedLimit(CcnDataWrapper alarmMsg) throws CcnException {
        CcnAlarmUtil.verifyWrapperType(alarmMsg);
        return ByteArrayUtil.readLong((byte[])alarmMsg.getData(), (int)27);
    }

    public static int getAlarmHour(CcnDataWrapper alarmMsg) throws CcnException {
        CcnAlarmUtil.verifyWrapperType(alarmMsg);
        return alarmMsg.getData()[31];
    }

    public static int getAlarmMinute(CcnDataWrapper alarmMsg) throws CcnException {
        CcnAlarmUtil.verifyWrapperType(alarmMsg);
        return alarmMsg.getData()[32];
    }

    public static BTime getAlarmDsTime(CcnDataWrapper alarmMsg) throws CcnException {
        return BTime.make((int)CcnAlarmUtil.getAlarmHour(alarmMsg), (int)CcnAlarmUtil.getAlarmMinute(alarmMsg), (int)0, (int)0);
    }

    public static boolean isValueMetric(CcnDataWrapper alarmMsg) throws CcnException {
        CcnAlarmUtil.verifyWrapperType(alarmMsg);
        byte formatByte = alarmMsg.getData()[33];
        return (formatByte & 0x80) == 128;
    }

    public static boolean isValueDiscrete(CcnDataWrapper alarmMsg) throws CcnException {
        CcnAlarmUtil.verifyWrapperType(alarmMsg);
        byte formatByte = alarmMsg.getData()[35];
        return (formatByte & 0x80) == 128;
    }

    public static String getFormattedValue(CcnDataWrapper alarmMsg, boolean limits, boolean isDisplayMetric) throws CcnException {
        StringBuffer sb = new StringBuffer();
        CcnAlarmUtil.verifyWrapperType(alarmMsg);
        float value = !limits ? CcnAlarmUtil.getVariableValue(alarmMsg) : CcnAlarmUtil.getExceedLimit(alarmMsg);
        if (isDisplayMetric) {
            // empty if block
        }
        byte[] formatBytes = new byte[4];
        for (int i = 0; i < 4; ++i) {
            formatBytes[i] = alarmMsg.getData()[33 + i];
        }
        if (CcnAlarmUtil.isValueDiscrete(alarmMsg)) {
            int stateInt = 0;
            stateInt = (double)value == 0.0 ? 0 : 1;
            String denum = CcnEnumsUtil.setProperDiscreteOffset(BCcnDiscreteStateEnum.parseId(formatBytes[1] & 0x3F, stateInt));
            sb.append(denum);
        } else {
            String unitsEnum;
            int placesAfterDecimal = formatBytes[1] & 0xF;
            int placesBeforeDecimal = formatBytes[1] >>> 4 & 0xF;
            int unitsIndex = formatBytes[3] & 0xFF;
            String valueString = CcnAlarmUtil.formatFloatString(value, placesBeforeDecimal, placesAfterDecimal);
            if (isDisplayMetric) {
                valueString = CcnRspPicPocUtil.toMetric(placesAfterDecimal, unitsIndex, valueString);
            }
            sb.append(valueString);
            sb.append(" ");
            String unitsString = unitsEnum = CcnEnumsUtil.setProperUnitsMappingEnum(BCcnUnitMappingEnum.parseId(unitsIndex, isDisplayMetric));
            if (unitsString.equalsIgnoreCase("none0")) {
                unitsString = "";
            }
            sb.append(unitsString);
        }
        return sb.toString();
    }

    public static String formatFloatString(float floatValue, int placesBefore, int placesAfter) {
        Float value = new Float(floatValue);
        int leftofValue = value.intValue();
        value = new Float(Math.abs(floatValue - (float)leftofValue) * 1.0E7f);
        int rightofValue = value.intValue();
        String leftString = new Integer(leftofValue).toString();
        String rightString = new Integer(rightofValue).toString();
        if (placesAfter == 0) {
            return leftString;
        }
        while (rightString.length() < placesAfter) {
            rightString = rightString + "0";
        }
        rightString = rightString.substring(0, placesAfter);
        return leftString + "." + rightString;
    }

    public static int getAlarmMonth(CcnDataWrapper alarmMsg) throws CcnException {
        CcnAlarmUtil.verifyWrapperType(alarmMsg);
        CcnAlarmUtil.verifyStandardAlarmWithDate(alarmMsg);
        return alarmMsg.getData()[39] - 1;
    }

    public static int getAlarmDay(CcnDataWrapper alarmMsg) throws CcnException {
        CcnAlarmUtil.verifyWrapperType(alarmMsg);
        CcnAlarmUtil.verifyStandardAlarmWithDate(alarmMsg);
        return alarmMsg.getData()[40];
    }

    public static int getAlarmYear(CcnDataWrapper alarmMsg) throws CcnException {
        CcnAlarmUtil.verifyWrapperType(alarmMsg);
        CcnAlarmUtil.verifyStandardAlarmWithDate(alarmMsg);
        return Clock.time().getYear() / 100 * 100 + alarmMsg.getData()[41];
    }

    public static BAbsTime getAlarmDsDate(CcnDataWrapper alarmMsg) throws CcnException {
        int ccnAlarmYear = CcnAlarmUtil.getAlarmYear(alarmMsg);
        int ccnAlarmMonth = CcnAlarmUtil.getAlarmMonth(alarmMsg);
        int ccnAlarmDay = CcnAlarmUtil.getAlarmDay(alarmMsg);
        if (ccnAlarmYear == 2000 && ccnAlarmMonth == -1 && ccnAlarmDay == 0) {
            throw new CcnException(6488171, "Cannot proceed because the alarm is not a standard alarm with date.");
        }
        return BAbsTime.make((int)ccnAlarmYear, (BMonth)BMonth.make((int)ccnAlarmMonth), (int)ccnAlarmDay);
    }

    public static int getSnapShotDataTable(CcnDataWrapper alarmMsg) throws CcnException {
        CcnAlarmUtil.verifyWrapperType(alarmMsg);
        CcnAlarmUtil.verifyExtendedAlarm(alarmMsg);
        return CcnAlarmUtil.intFrom2Bytes(alarmMsg.getData(), 42);
    }

    public static String getTableName(CcnDataWrapper alarmMsg) throws CcnException {
        CcnAlarmUtil.verifyWrapperType(alarmMsg);
        CcnAlarmUtil.verifyExtendedAlarm(alarmMsg);
        return new String(alarmMsg.getData(), 44, 8).trim();
    }

    public static String getAlarmText(CcnDataWrapper alarmMsg) throws CcnException {
        CcnAlarmUtil.verifyWrapperType(alarmMsg);
        CcnAlarmUtil.verifyExtendedAlarm(alarmMsg);
        if (alarmMsg.getData().length < 53) {
            return "";
        }
        return new String(alarmMsg.getData(), 52, alarmMsg.getData().length - 52).trim();
    }

    public static String getCustomAlarmText(CcnDataWrapper alarmMsg, boolean isDisplayMetric) throws CcnException {
        String customText = CcnAlarmUtil.getAlarmText(alarmMsg);
        if (customText.length() != 0) {
            String postText;
            String anteText;
            int substitutionIndex = customText.indexOf("#1");
            while (substitutionIndex != -1) {
                anteText = customText.substring(0, substitutionIndex);
                postText = customText.substring(substitutionIndex + 2);
                customText = anteText + CcnAlarmUtil.getTableName(alarmMsg) + postText;
                substitutionIndex = customText.indexOf("#1");
            }
            substitutionIndex = customText.indexOf("#2");
            while (substitutionIndex != -1) {
                anteText = customText.substring(0, substitutionIndex);
                postText = customText.substring(substitutionIndex + 2);
                customText = anteText + CcnAlarmUtil.getVariableName(alarmMsg) + postText;
                substitutionIndex = customText.indexOf("#2");
            }
            substitutionIndex = customText.indexOf("#3");
            while (substitutionIndex != -1) {
                anteText = customText.substring(0, substitutionIndex);
                postText = customText.substring(substitutionIndex + 2);
                customText = anteText + CcnAlarmUtil.getFormattedValue(alarmMsg, false, isDisplayMetric) + postText;
                substitutionIndex = customText.indexOf("#3");
            }
            substitutionIndex = customText.indexOf("#4");
            while (substitutionIndex != -1) {
                anteText = customText.substring(0, substitutionIndex);
                postText = customText.substring(substitutionIndex + 2);
                customText = anteText + CcnAlarmUtil.getFormattedValue(alarmMsg, true, isDisplayMetric) + postText;
                substitutionIndex = customText.indexOf("#4");
            }
        }
        return customText;
    }

    public static String getIndexedText(CcnDataWrapper alarmMsg, boolean isDisplayMetric) throws CcnException {
        int index = CcnAlarmUtil.getAlarmDescIndex(alarmMsg);
        switch (index) {
            case 0: {
                return "";
            }
            case 1: {
                return "discrete state";
            }
            case 2: {
                return "total time exceeds " + CcnAlarmUtil.getFormattedValue(alarmMsg, true, isDisplayMetric);
            }
            case 3: {
                return "starts, limit is " + CcnAlarmUtil.getFormattedValue(alarmMsg, true, isDisplayMetric);
            }
            case 4: {
                return "commanded state is " + CcnAlarmUtil.getFormattedValue(alarmMsg, true, isDisplayMetric);
            }
            case 5: {
                return "safety chain first out";
            }
            case 6: {
                return "interlock " + CcnAlarmUtil.getFormattedValue(alarmMsg, true, isDisplayMetric);
            }
            case 7: {
                return "outside limit of " + CcnAlarmUtil.getFormattedValue(alarmMsg, true, isDisplayMetric);
            }
            case 8: {
                return "interlocked, exceeds limit of " + CcnAlarmUtil.getFormattedValue(alarmMsg, true, isDisplayMetric);
            }
            case 9: {
                return "IO channel failure";
            }
            case 10: {
                return "has illegal configuration";
            }
            case 11: {
                return "additional cooling capacity required";
            }
            case 12: {
                return "communications error";
            }
            case 13: {
                return "clock error";
            }
            case 14: {
                return "alarm buffer full";
            }
            case 15: {
                return "directory not available";
            }
        }
        return "";
    }

    public static String getAlarmState(CcnDataWrapper alarmMsg) throws CcnException {
        if (CcnAlarmUtil.getSourceInt(alarmMsg) == 7) {
            return "Return to Normal";
        }
        return CcnAlarmUtil.getTypeDesc(alarmMsg);
    }

    public static final BAlarmState getToStateEnum(CcnDataWrapper alarmMsg) throws CcnException {
        return CcnAlarmUtil.isRTN(alarmMsg) ? BAlarmState.normal : BAlarmState.offnormal;
    }

    public static final BAlarmState getFromStateEnum(CcnDataWrapper alarmMsg) throws CcnException {
        return CcnAlarmUtil.isRTN(alarmMsg) ? BAlarmState.offnormal : BAlarmState.normal;
    }

    public static int getTypeInt(CcnDataWrapper alarmMsg) throws CcnException {
        int alarmPriority = CcnAlarmUtil.getAlarmPriority(alarmMsg);
        int alarmTypeInt = (0x80 & alarmPriority) >> 7;
        return alarmTypeInt;
    }

    public static String getTypeDesc(CcnDataWrapper alarmMsg) throws CcnException {
        return CcnAlarmUtil.getTypeInt(alarmMsg) == 0 ? "Alarm" : "Alert";
    }

    public static int getSourceInt(CcnDataWrapper alarmMsg) throws CcnException {
        int alarmPriority = CcnAlarmUtil.getAlarmPriority(alarmMsg);
        int alarmSourceInt = (alarmPriority & 0x70) >> 4;
        return alarmSourceInt;
    }

    public static String getSourceDesc(CcnDataWrapper alarmMsg) throws CcnException {
        int alarmSourceInt = CcnAlarmUtil.getSourceInt(alarmMsg);
        String txt = "";
        switch (alarmSourceInt) {
            case 1: {
                txt = "Critical";
                break;
            }
            case 2: {
                txt = "Service";
                break;
            }
            case 3: {
                txt = "reserved";
                break;
            }
            case 4: {
                txt = "Maintenance";
                break;
            }
            case 5: {
                txt = "reserved";
                break;
            }
            case 6: {
                txt = "Control loop problem";
                break;
            }
            case 7: {
                txt = "Return to Normal";
            }
        }
        return txt;
    }

    public static boolean isRTN(CcnDataWrapper alarmMsg) throws CcnException {
        int alarmPriority = CcnAlarmUtil.getAlarmPriority(alarmMsg);
        return (alarmPriority & 0x70) >> 4 == 7;
    }

    public static boolean isAlarmNotification(CcnDataWrapper alarmMsg) throws CcnException {
        if (CcnAlarmUtil.isRTN(alarmMsg)) {
            return false;
        }
        int alarmPriority = CcnAlarmUtil.getAlarmPriority(alarmMsg);
        return (alarmPriority & 0x80) >> 7 == 0;
    }

    public static boolean isRecurring(CcnDataWrapper alarmMsg) throws CcnException {
        int FROM_NORMAL_MASK = 4;
        int alarmPriority = CcnAlarmUtil.getAlarmPriority(alarmMsg);
        return (alarmPriority & 4) > 0;
    }

    public static boolean isAlertNotification(CcnDataWrapper alarmMsg) throws CcnException {
        if (CcnAlarmUtil.isRTN(alarmMsg)) {
            return false;
        }
        int alarmPriority = CcnAlarmUtil.getAlarmPriority(alarmMsg);
        return (alarmPriority & 0x80) >> 7 == 1;
    }

    public static int getAlarmLevel(CcnDataWrapper alarmMsg) throws CcnException {
        int alarmPriority = CcnAlarmUtil.getAlarmPriority(alarmMsg);
        return (alarmPriority & 0x70) >> 4;
    }

    public static String getAlarmConsoleSummary(CcnUnsolicitedMsg alarmMsg, boolean isDisplayMetric) throws CcnException {
        return CcnAlarmUtil.getAlarmTextSummary((CcnDataWrapper)alarmMsg, alarmMsg.getSrcAddr(), alarmMsg.getSrcBus()) + " " + CcnAlarmUtil.getAlarmTextDetail((CcnDataWrapper)alarmMsg, isDisplayMetric);
    }

    public static String getAlarmTextSummary(CcnDataWrapper alarmMsg, int srcAddr, int srcBus) throws CcnException {
        StringBuffer sb;
        block6: {
            sb = new StringBuffer();
            sb.append(CcnAlarmUtil.getDeviceOrSystemName(alarmMsg) + " ");
            sb.append(srcBus + "," + srcAddr + " ");
            if (CcnAlarmUtil.isRTN(alarmMsg)) {
                sb.append(" RETURN TO NORMAL at ");
            } else if (CcnAlarmUtil.isAlarmNotification(alarmMsg)) {
                sb.append("ALARM - " + CcnAlarmUtil.getAlarmLevel(alarmMsg) + " at ");
            } else {
                sb.append("ALERT - " + CcnAlarmUtil.getAlarmLevel(alarmMsg) + " at ");
            }
            sb.append(CcnAlarmUtil.getAlarmDsTime(alarmMsg) + " ");
            try {
                sb.append(CcnAlarmUtil.getAlarmDsDate(alarmMsg) + " ");
            }
            catch (CcnException ccne) {
                if (ccne.getCode() == 6488171) break block6;
                throw ccne;
            }
        }
        return sb.toString();
    }

    public static String getAlarmTextDetail(CcnDataWrapper alarmMsg, boolean isDisplayMetric) throws CcnException {
        StringBuffer sb = new StringBuffer();
        int indexedTextIndex = CcnAlarmUtil.getAlarmDescIndex(alarmMsg);
        if (0 < indexedTextIndex && indexedTextIndex < 16) {
            sb.append(CcnAlarmUtil.getVariableName(alarmMsg) + " ");
            sb.append(CcnAlarmUtil.getFormattedValue(alarmMsg, false, isDisplayMetric) + " ");
            sb.append(CcnAlarmUtil.getIndexedText(alarmMsg, isDisplayMetric) + " ");
        } else if (indexedTextIndex == 0 || indexedTextIndex > 15) {
            sb.append(CcnAlarmUtil.getCustomAlarmText(alarmMsg, isDisplayMetric));
        }
        return sb.toString();
    }
}

