/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn.tables;

import com.tridium.basicdriver.util.BIBasicPollable;
import com.tridium.ccn.BCcnDevice;
import com.tridium.ccn.BCcnNetwork;
import com.tridium.ccn.components.BCcnByteEntry;
import com.tridium.ccn.components.BCcnByteList;
import com.tridium.ccn.components.BCcnPointEntry;
import com.tridium.ccn.components.BCcnPointList;
import com.tridium.ccn.components.BCcnTableEntry;
import com.tridium.ccn.components.BCcnTimeScheduleEntry;
import com.tridium.ccn.components.BCcnTimeScheduleList;
import com.tridium.ccn.enums.BCcnUnitMappingEnum;
import com.tridium.ccn.exceptions.CcnRuntimeException;
import com.tridium.ccn.messages.CcnChangeTableNameRequest;
import com.tridium.ccn.messages.CcnFetchTableDataRequest;
import com.tridium.ccn.messages.CcnReadTableRequest;
import com.tridium.ccn.messages.CcnResponseMessage;
import com.tridium.ccn.messages.CcnWriteTableRequest;
import com.tridium.ccn.objects.BCcnBaseObject;
import com.tridium.ccn.point.BCcnInputProxy;
import com.tridium.ccn.point.BCcnNumericWritable;
import com.tridium.ccn.point.BCcnProxyExt;
import com.tridium.ccn.tables.BCcnDataTable;
import com.tridium.ccn.tables.BCcnDataTableWithTimeSchedule;
import com.tridium.ccn.tables.BCcnFidTable;
import com.tridium.ccn.tables.BCcnFidTableWithTimeSchedule;
import com.tridium.ccn.tables.BCcnPicTable;
import com.tridium.ccn.tables.BCcnTableGroup;
import com.tridium.ccn.util.CcnEnumsUtil;
import com.tridium.ccn.util.CcnRspDataUtil;
import com.tridium.ccn.util.CcnRspFidUtil;
import com.tridium.ccn.util.CcnRspPicPocUtil;
import com.tridium.ccn.util.CcnRspPicUtil;
import com.tridium.ccn.util.CcnRspTableUtil;
import com.tridium.ccn.util.CcnStringNumberConverter;
import com.tridium.ccn.util.CcnUtil;
import com.tridium.platCcn.CcnTableDef;
import java.util.Vector;
import javax.baja.control.BNumericWritable;
import javax.baja.driver.util.BIPollable;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.log.Log;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BNumber;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.IllegalChildException;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public abstract class BCcnTable
extends BCcnBaseObject
implements BIBasicPollable {
    public static final Property debugOn = BCcnTable.newProperty((int)0, (boolean)false, null);
    public static final Property tableType = BCcnTable.newProperty((int)0, (int)0, null);
    public static final Property tableTypeString = BCcnTable.newProperty((int)0, (String)"", null);
    public static final Property tableInstance = BCcnTable.newProperty((int)0, (int)0, null);
    public static final Property tableNum = BCcnTable.newProperty((int)0, (int)0, null);
    public static final Property tableName = BCcnTable.newProperty((int)0, (String)" ", null);
    public static final Property duplicateTableName = BCcnTable.newProperty((int)4, (String)"", null);
    public static final Property tableBlockCount = BCcnTable.newProperty((int)0, (int)0, null);
    public static final Property disablePoll = BCcnTable.newProperty((int)4, (boolean)false, null);
    public static final Property learnStatus = BCcnTable.newProperty((int)2, (String)"Idle", null);
    public static final Property overwriteExisting = BCcnTable.newProperty((int)4, (boolean)false, null);
    public static final Property preMetricDisplay = BCcnTable.newProperty((int)4, (boolean)false, null);
    public static final Property curMetricDisplay = BCcnTable.newProperty((int)4, (boolean)false, null);
    public static final Property isEnhancedVersion = BCcnTable.newProperty((int)6, (boolean)false, null);
    public static final Property pollFrequency = BCcnTable.newProperty((int)0, (BValue)BPollFrequency.normal, null);
    public static final Action fetch = BCcnTable.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BCcnTable.class);
    BCcnTableGroup tGroup = null;
    BIcon icon = BIcon.make((String)"module://ccn/images/CcnTable.png");
    boolean changingDisplay = false;
    protected BCcnProxyExt[] points = new BCcnProxyExt[64];
    BCcnTableEntry entry;
    protected int createdPointsCount = 0;
    Log ccnTablesLog = Log.getLog((String)"CCNTablesLog");
    Log ccnTimeLog = Log.getLog((String)"CcnPerformanceLog");
    Log ccnSubscribedPointLog = Log.getLog((String)"CcnSubscribedPointsLog");
    final Vector<BCcnProxyExt> vPollAttributeProxyExts = new Vector(0);

    public boolean getDebugOn() {
        return this.getBoolean(debugOn);
    }

    public void setDebugOn(boolean v) {
        this.setBoolean(debugOn, v, null);
    }

    public int getTableType() {
        return this.getInt(tableType);
    }

    public void setTableType(int v) {
        this.setInt(tableType, v, null);
    }

    public String getTableTypeString() {
        return this.getString(tableTypeString);
    }

    public void setTableTypeString(String v) {
        this.setString(tableTypeString, v, null);
    }

    public int getTableInstance() {
        return this.getInt(tableInstance);
    }

    public void setTableInstance(int v) {
        this.setInt(tableInstance, v, null);
    }

    public int getTableNum() {
        return this.getInt(tableNum);
    }

    public void setTableNum(int v) {
        this.setInt(tableNum, v, null);
    }

    public String getTableName() {
        return this.getString(tableName);
    }

    public void setTableName(String v) {
        this.setString(tableName, v, null);
    }

    public String getDuplicateTableName() {
        return this.getString(duplicateTableName);
    }

    public void setDuplicateTableName(String v) {
        this.setString(duplicateTableName, v, null);
    }

    public int getTableBlockCount() {
        return this.getInt(tableBlockCount);
    }

    public void setTableBlockCount(int v) {
        this.setInt(tableBlockCount, v, null);
    }

    public boolean getDisablePoll() {
        return this.getBoolean(disablePoll);
    }

    public void setDisablePoll(boolean v) {
        this.setBoolean(disablePoll, v, null);
    }

    public String getLearnStatus() {
        return this.getString(learnStatus);
    }

    public void setLearnStatus(String v) {
        this.setString(learnStatus, v, null);
    }

    public boolean getOverwriteExisting() {
        return this.getBoolean(overwriteExisting);
    }

    public void setOverwriteExisting(boolean v) {
        this.setBoolean(overwriteExisting, v, null);
    }

    public boolean getPreMetricDisplay() {
        return this.getBoolean(preMetricDisplay);
    }

    public void setPreMetricDisplay(boolean v) {
        this.setBoolean(preMetricDisplay, v, null);
    }

    public boolean getCurMetricDisplay() {
        return this.getBoolean(curMetricDisplay);
    }

    public void setCurMetricDisplay(boolean v) {
        this.setBoolean(curMetricDisplay, v, null);
    }

    public boolean getIsEnhancedVersion() {
        return this.getBoolean(isEnhancedVersion);
    }

    public void setIsEnhancedVersion(boolean v) {
        this.setBoolean(isEnhancedVersion, v, null);
    }

    public BPollFrequency getPollFrequency() {
        return (BPollFrequency)this.get(pollFrequency);
    }

    public void setPollFrequency(BPollFrequency v) {
        this.set(pollFrequency, (BValue)v, null);
    }

    public void fetch() {
        this.invoke(fetch, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BCcnTable() {
    }

    public BCcnTable(BCcnTableEntry entry) {
        this.setDuplicateTableName(entry.getTableName());
    }

    @Override
    public void started() throws Exception {
        this.reviewLicense();
        super.started();
    }

    public void stopped() throws Exception {
        super.stopped();
    }

    public void changed(Property changedProp, Context cx) {
        super.changed(changedProp, cx);
        if (!this.isRunning()) {
            return;
        }
        if (changedProp.getName().equalsIgnoreCase("tablename")) {
            String newValue = this.getTableName();
            String curName = this.getDuplicateTableName();
            if (curName.equalsIgnoreCase("SPSCHPOC")) {
                this.ccnTablesLog.trace(this.getSummaryString() + "<CcnTable: asyncPropertyChange CcnChangeTableNameRequest... change name not allowed for this table: ");
                return;
            }
            if (newValue.trim().length() == 0 || !Character.isLetter(newValue.charAt(0))) {
                newValue = "T";
            }
            if (newValue.length() > 8) {
                newValue = newValue.substring(0, 8);
            }
            if (this.writeTableName(newValue)) {
                this.ccnTablesLog.trace(this.getSummaryString() + "<CcnTable: asyncPropertyChange CcnChangeTableNameRequest name commit : " + newValue);
                this.setDuplicateTableName(newValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerPollProxyExt(BCcnProxyExt proxyExt) {
        Vector<BCcnProxyExt> vector = this.vPollAttributeProxyExts;
        synchronized (vector) {
            this.vPollAttributeProxyExts.addElement(proxyExt);
        }
        if (this.vPollAttributeProxyExts.size() > 0) {
            this.register();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterPollProxyExt(BCcnProxyExt proxyExt) {
        Vector<BCcnProxyExt> vector = this.vPollAttributeProxyExts;
        synchronized (vector) {
            this.vPollAttributeProxyExts.removeElement(proxyExt);
        }
        if (this.vPollAttributeProxyExts.size() == 0) {
            this.unregister();
        }
    }

    protected void register() {
        if (this.registered) {
            return;
        }
        try {
            if (this.vPollAttributeProxyExts.size() > 0) {
                this.getCcnDevice().getCcnNetwork().getPollScheduler().subscribe((BIPollable)this);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.registered = true;
    }

    protected void unregister() {
        this.ccnTablesLog.trace(this.getSummaryString() + ": table:unregister=" + this.registered);
        try {
            this.getCcnDevice().getCcnNetwork().getPollScheduler().unsubscribe((BIPollable)this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.registered = false;
    }

    public boolean isParentLegal(BComponent parent) throws IllegalChildException {
        if (parent instanceof BCcnTableGroup) {
            return true;
        }
        throw new LocalizableRuntimeException("ccn", "CcnTable.Drop");
    }

    public boolean isChildLegal(BComponent child) throws LocalizableRuntimeException {
        if (child instanceof BCcnTable) {
            throw new LocalizableRuntimeException("ccn", "CcnTable nodes may not be under other CcnTable nodes");
        }
        return true;
    }

    public void doFetch() {
        try {
            this.ccnTablesLog.trace(this.getSummaryString() + "CcnTable:doFetch()");
            CcnFetchTableDataRequest req = new CcnFetchTableDataRequest(this, this.getCcnDevice());
            this.getCcnDevice().getCcnNetwork().getCcnComm().ccnAsyncRequest().submitRequest(req);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void reviewLicense() {
        try {
            if (Sys.getLicenseManager().getFeature("Tridium", "ccn").getFeatureName().equalsIgnoreCase("ccn")) {
                this.setIsEnhancedVersion(true);
            }
        }
        catch (FeatureNotLicensedException exp) {
            if (Sys.getLicenseManager().getFeature("Tridium", "ccnl").getFeatureName().equalsIgnoreCase("ccnl")) {
                this.setIsEnhancedVersion(false);
                return;
            }
            this.setIsEnhancedVersion(false);
        }
    }

    public void checkFullAccessPermitted(String operation) {
        if (this.isFullAccessPermittedByLicense()) {
            return;
        }
        String runtimeExceptionText = "Cannot " + operation + " because table not licensed.";
        throw new CcnRuntimeException(6488275, runtimeExceptionText);
    }

    public void recalcCreatedPointsCount() {
        int newPointCount = 0;
        for (int i = 0; i < this.points.length; ++i) {
            if (this.points[i] == null) continue;
            ++newPointCount;
        }
        if (this instanceof BCcnPicTable) {
            ((BCcnPicTable)this).setPointCreateCount(newPointCount);
        } else if (this instanceof BCcnDataTable) {
            ((BCcnDataTable)this).setPointCreateCount(newPointCount);
        } else if (this instanceof BCcnFidTable) {
            ((BCcnFidTable)this).setPointCreateCount(newPointCount);
        }
        this.createdPointsCount = newPointCount;
    }

    public void poll() {
        if (!CcnUtil.isNetworkDeviceStatusOk(this.getCcnDevice())) {
            return;
        }
        if (!this.getCcnDevice().getCcnNetwork().getPollScheduler().getPollEnabled()) {
            return;
        }
        this.pollForData();
    }

    public void pollForData() {
    }

    public boolean writeTableName(String name) {
        this.ccnTablesLog.trace("<CcnTable: asyncPropertyChange CcnChangeTableNameRequest name: " + name);
        byte[] newName = name.getBytes();
        int busNum = this.getCcnDevice().getBusNo();
        int localAddr = this.getCcnDevice().getElemNo();
        int tableType = this.getTableType();
        int tableInstance = this.getTableInstance();
        boolean blockNo = false;
        CcnTableDef tblDef = new CcnTableDef((byte)localAddr, (byte)busNum, newName, (short)((byte)tableType), (byte)tableInstance, (byte)(blockNo ? 1 : 0), 0, 0);
        CcnChangeTableNameRequest req = new CcnChangeTableNameRequest(tblDef);
        CcnResponseMessage rsp = this.getCcnDevice().getCcnNetwork().getCcnComm().ccnAsyncRequest().sendAsyncRequest(req);
        if (rsp == null) {
            return false;
        }
        this.ccnTablesLog.trace("rsp.getResponseCommand()=" + rsp.getResponseCommand() + "rsp.getBlockLen()=" + rsp.getBlockLen());
        if ((rsp.getResponseCommand() & 0xFF) == 21) {
            this.ccnTablesLog.trace("\n****  CcnTable: CcnChangeTableNameRequest name change failed... response command: " + rsp.getResponseCommand() + " len: " + rsp.getBlockLen() + " responseBuffer: " + ByteArrayUtil.toHexString((byte[])rsp.getResponseBuffer().getResponseData()));
            return false;
        }
        return true;
    }

    public boolean writeTable(BCcnProxyExt proxyExt) throws Exception {
        this.ccnTablesLog.trace("Inside write table::" + proxyExt.getFieldValue());
        while (this.getCcnDevice().getCcnNetwork().isChangingDisplay()) {
        }
        BCcnTable table = proxyExt.getTable();
        int writeSuccessCode = 0;
        if (this.getCcnDevice().areYouOutOfService()) {
            writeSuccessCode = 1;
        } else {
            if (!CcnRspPicPocUtil.checkRange(proxyExt.getFieldValue(), proxyExt)) {
                writeSuccessCode = 3;
                if (proxyExt.getPointDataType() == 12 || proxyExt.getPointDataType() == 51) {
                    throw new Exception("User value " + proxyExt.getFieldValue() + " out of limits, write aborted.\nThe limits for hour are 00 to 23; The limits for minute are 00 to 59.");
                }
                throw new Exception("User value " + proxyExt.getFieldValue() + " out of limits, write aborted.\nThe limits are " + proxyExt.getLoLimit() + " to " + proxyExt.getHiLimit());
            }
            proxyExt.setDisplayType(this.getCurMetricDisplay());
            byte tableValueBlock = (byte)proxyExt.getValueBlock();
            int accessRight = 0;
            BCcnByteList exactBytelist = !this.getCcnDevice().isDeviceFID() ? (BCcnByteList)this.getCcnDevice().getTableAccessRights().get(SlotPath.escape((String)table.getTableName()) + table.getTableNum()) : (BCcnByteList)this.getCcnDevice().getTableAccessRights().get(SlotPath.escape((String)table.getTableName()) + table.getTableType());
            BCcnByteEntry[] byteArray = null;
            if (exactBytelist != null) {
                byteArray = (BCcnByteEntry[])exactBytelist.getChildren(BCcnByteEntry.class);
            }
            if (byteArray == null) {
                return false;
            }
            for (int j = 0; j < this.getTableBlockCount(); ++j) {
                if (byteArray[j].getIndex() != tableValueBlock) continue;
                accessRight = (byte)byteArray[j].getValue();
                break;
            }
            if ((accessRight & 2) != 2) {
                writeSuccessCode = 3;
                throw new LocalizableRuntimeException("ccn", "CcnTable.Write");
            }
            String newValue = CcnRspPicPocUtil.convertToImperial(proxyExt);
            String errorMessage = null;
            int dataType = proxyExt.getPointDataType();
            byte blockNo = (byte)proxyExt.getValueBlock();
            this.ccnTablesLog.trace(this.getSummaryString() + "CcnTable:writeTable... \nthe setValue we want to write ptName|block|newValue " + proxyExt.getFieldName() + "|" + blockNo + "|" + newValue);
            CcnResponseMessage rsp = this.getReadTableResponse(blockNo);
            if (rsp != null) {
                this.ccnTablesLog.trace(this.getSummaryString() + "CcnTable:writeTable... \nfirst read the current block rspCmd|blockLen " + rsp.getResponseCommand() + "|" + rsp.getBlockLen());
            }
            if (rsp == null) {
                errorMessage = "Unknown error. Read table block " + blockNo + " is unsuccessful. The read response is null or Ack code is not 0x06.";
                writeSuccessCode = 2;
            } else if (rsp.getResponseCommand() != 6) {
                errorMessage = "Unknown error. Read table block " + blockNo + " is unsuccessful. The read response is null or Ack code is not 0x06.";
                writeSuccessCode = 3;
            } else {
                byte[] data = rsp.getData();
                if (this instanceof BCcnPicTable || this instanceof BCcnDataTable) {
                    data = CcnRspPicPocUtil.mergeNewValue(data, proxyExt.getValueBlockOffset(), proxyExt.getPointDataType(), proxyExt.getFieldByteCount(), newValue, null, proxyExt);
                } else if (this instanceof BCcnFidTable) {
                    data = CcnRspFidUtil.mergeNewValue(data, newValue, proxyExt, this.getTableType());
                }
                byte[] newData = new byte[data.length - 3];
                for (int i = 0; i < newData.length; ++i) {
                    newData[i] = data[i + 3];
                }
                this.ccnTablesLog.trace(this.getSummaryString() + "CcnTable:writeTable... \nwrite this block ptName|blkNo|newValue " + proxyExt.getFieldName() + "|" + blockNo + "|" + newValue);
                CcnResponseMessage writeRsp = this.writeTable(newData, blockNo);
                if (writeRsp != null) {
                    this.ccnTablesLog.trace(this.getSummaryString() + "CcnTable:writeTable... \nresponse from the write cmd|len " + writeRsp.getResponseCommand() + ":" + writeRsp.getBlockLen());
                }
                if (writeRsp != null) {
                    if (writeRsp.getResponseCommand() == 6) {
                        if (!this.getCcnDevice().isDeviceFID()) {
                            CcnResponseMessage rspBack = this.getReadTableResponse(blockNo);
                            if (rspBack != null) {
                                this.ccnTablesLog.trace(this.getSummaryString() + "CcnTable:writeTable \nthe confirmation ptName|blkNo|newValue " + proxyExt.getFieldName() + "|" + blockNo + "|" + newValue);
                            }
                            if (rspBack == null) {
                                errorMessage = "Unknown error. Response from write table command is 0x06, but the response from read table to confirm the write command is null or Ack code is not 0x06.";
                                writeSuccessCode = 2;
                            } else if (rspBack.getResponseCommand() != 6) {
                                errorMessage = "Unknown error. Response from write table command is 0x06, but the response from read table to confirm the write command is null or Ack code is not 0x06.";
                                writeSuccessCode = 3;
                            } else {
                                String updatedValue = null;
                                try {
                                    if (this instanceof BCcnPicTable) {
                                        updatedValue = CcnRspPicUtil.getValue(rspBack, proxyExt.getValueBlockOffset(), proxyExt);
                                    } else if (this instanceof BCcnDataTable) {
                                        updatedValue = CcnRspDataUtil.getValue(rspBack, proxyExt.getValueBlockOffset(), proxyExt);
                                    }
                                    this.ccnTablesLog.trace(this.getSummaryString() + "CcnTable:writeTable... \nthe confirmation ptName|sentValue|newValue " + proxyExt.getFieldName() + "|" + newValue + "|" + updatedValue);
                                    if (dataType == 0 || dataType == 1 || dataType == 2 || dataType == 6 || dataType == 7 || dataType == 9 || dataType == 10 || dataType == 17 || dataType == 25 || dataType == 48 || dataType == 49 || dataType == 50) {
                                        this.ccnTablesLog.trace(this.getSummaryString() + "CcnTable:compareFloatValues( latest|sent " + CcnStringNumberConverter.getFloat(updatedValue) + ":" + CcnStringNumberConverter.getFloat(proxyExt.getFieldValue()));
                                        if (!CcnRspTableUtil.compareFloatValues(CcnStringNumberConverter.getFloat(updatedValue), CcnStringNumberConverter.getFloat(proxyExt.getFieldValue()))) {
                                            errorMessage = "Unknown error. Response from write command is 0x06, but the value in controller is not updated.";
                                            writeSuccessCode = 3;
                                        }
                                    } else if (!updatedValue.trim().equals(proxyExt.getFieldValue().trim())) {
                                        errorMessage = "Unknown error. Response from write command is 0x06, but the value in controller is not updated.";
                                        writeSuccessCode = 3;
                                    }
                                    if (errorMessage == null) {
                                        this.ccnTablesLog.trace("Error message is null...");
                                        ((BCcnInputProxy)proxyExt).setValue(updatedValue);
                                        if (!(this instanceof BCcnPicTable) && this instanceof BCcnDataTable) {
                                            BCcnPointEntry[] pointList = this.getPointList().getPointList();
                                            if (this.getTableType() == 1556 && pointList[0].getValueBlock() == 2) {
                                                for (int ip = 0; ip < pointList.length; ++ip) {
                                                    if (pointList[ip].getFieldIndex() != proxyExt.getFieldIndex()) continue;
                                                    pointList[ip].setPointValue(updatedValue);
                                                    break;
                                                }
                                                BCcnTimeScheduleEntry[] timeScheduleEntries = CcnRspDataUtil.buildTimeSchedules(pointList);
                                                ((BCcnDataTableWithTimeSchedule)this).setTimeScheduleList(new BCcnTimeScheduleList(timeScheduleEntries));
                                            }
                                        }
                                    }
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    this.ccnTablesLog.error(this.getSummaryString() + "<CcnTable: Ccn table get No." + proxyExt.getFieldIndex() + " field from block " + blockNo + " ERROR: " + e);
                                }
                            }
                        } else {
                            CcnResponseMessage rspBack = this.getReadTableResponse(blockNo);
                            String updatedValue = CcnRspFidUtil.getValue(rspBack, proxyExt);
                            ((BCcnInputProxy)proxyExt).setValue(updatedValue);
                            if (this.getTableType() == 1283) {
                                BCcnPointEntry tempPoint = proxyExt.makePointEntry();
                                tempPoint.setPointValue(proxyExt.getFieldValue());
                                BCcnPointEntry[] pointList = ((BCcnFidTable)this).getPointList().getPointList();
                                BCcnTimeScheduleEntry[] timeScheduleEntries = CcnRspFidUtil.buildTimeSchedules(pointList);
                                ((BCcnFidTableWithTimeSchedule)this).setTimeScheduleList(new BCcnTimeScheduleList(timeScheduleEntries));
                            }
                        }
                    } else if (writeRsp.getResponseCommand() == 21) {
                        writeSuccessCode = 3;
                        switch (writeRsp.getResponseCode()) {
                            case 1: {
                                errorMessage = "Command not implemented.";
                                break;
                            }
                            case 4: {
                                errorMessage = "Table not defined.";
                                break;
                            }
                            case 9: {
                                errorMessage = "POC function does not exist.";
                                break;
                            }
                            case 10: {
                                errorMessage = "Block not defined.";
                                break;
                            }
                            case 16: {
                                errorMessage = "Access denied.";
                                break;
                            }
                            case 18: {
                                errorMessage = "Invalid configuration parameter.";
                                break;
                            }
                            default: {
                                errorMessage = "Unknown error.";
                                break;
                            }
                        }
                    } else {
                        errorMessage = "Unknown error. Response from write table command is neither 0x15 nor 0x06.";
                        writeSuccessCode = 3;
                    }
                } else {
                    errorMessage = "Unknown error. Response from write table command is null.";
                    writeSuccessCode = 2;
                }
            }
            if (errorMessage != null) {
                this.ccnTablesLog.trace("Write " + this.getCcnDevice().getDeviceName() + "|" + this.getTableName() + "|" + proxyExt.getName() + "(" + proxyExt.getVariableNo() + ") with value " + proxyExt.getFieldValue() + " is unsuccessful.\n" + errorMessage);
            }
        }
        return writeSuccessCode == 0;
    }

    public BCcnTableGroup getGroup() {
        BCcnTableGroup tGroup = null;
        for (BComplex parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof BCcnTableGroup)) continue;
            tGroup = (BCcnTableGroup)parent;
            break;
        }
        return tGroup;
    }

    public void addToPointArrays(BCcnProxyExt object, int index) {
        if (object != null && object.getFieldName().length() > 0) {
            this.points[index] = object;
            this.recalcCreatedPointsCount();
        }
    }

    public void removeFromPointArrays(int index) {
        this.points[index] = null;
        this.recalcCreatedPointsCount();
    }

    public void updateObject(BCcnPointEntry curPointEntry, int newState, int action) {
    }

    public void updateObject(BCcnPointEntry curPointEntry, int newState, int action, BCcnProxyExt curInput) {
    }

    public void forcePoint(BCcnDevice device, BCcnNetwork network, BCcnPointEntry pointEntry, BCcnProxyExt proxyExt) throws Exception {
    }

    public void autoPoint(BCcnDevice device, BCcnNetwork network, BCcnPointEntry pointEntry) {
    }

    public boolean isConfigurationType() {
        int tableType = this.getTableType();
        return tableType == 16 || tableType == 19 || tableType == 20 || tableType == 22 || tableType == 1283 || tableType == 1284 || tableType == 1285;
    }

    public boolean isSetpointType() {
        int tableType = this.getTableType();
        return tableType == 23 || tableType == 24;
    }

    public void getExistingObjectArray(BComponent n, Vector<BCcnProxyExt> pointsVector) {
        BComponent[] children = n.getChildComponents();
        for (int i = 0; i < children.length; ++i) {
            BCcnProxyExt child;
            if (children[i] instanceof BCcnProxyExt && !pointsVector.contains(child = (BCcnProxyExt)children[i])) {
                pointsVector.addElement(child);
            }
            this.getExistingObjectArray(children[i], pointsVector);
        }
    }

    public BCcnProxyExt[] getCreatedPoints() {
        return this.points;
    }

    public void updatePointList(BCcnTable ccnTable, BCcnPointEntry pointEntry) {
        int fieldIndex = pointEntry.getFieldIndex();
        Vector<BCcnPointEntry> vNewPEs = new Vector<BCcnPointEntry>();
        BCcnPointEntry[] pointList = null;
        if (ccnTable instanceof BCcnPicTable) {
            BCcnPicTable picTable = (BCcnPicTable)ccnTable;
            pointList = picTable.getPointList().getPointList();
        } else if (ccnTable instanceof BCcnDataTable) {
            BCcnDataTable dataTable = (BCcnDataTable)ccnTable;
            pointList = dataTable.getPointList().getPointList();
        } else if (ccnTable instanceof BCcnFidTable) {
            BCcnFidTable fidTable = (BCcnFidTable)ccnTable;
            pointList = fidTable.getPointList().getPointList();
        }
        if (pointList == null) {
            return;
        }
        for (int j = 0; j < pointList.length; ++j) {
            if (pointList[j].getFieldIndex() < fieldIndex) {
                vNewPEs.addElement(pointList[j]);
                continue;
            }
            if (pointList[j].getFieldIndex() == fieldIndex) {
                vNewPEs.addElement(pointEntry);
                continue;
            }
            vNewPEs.addElement(pointList[j]);
        }
        BCcnPointEntry[] newPEs = new BCcnPointEntry[vNewPEs.size()];
        vNewPEs.copyInto((Object[])newPEs);
        this.getPointList().setPointList(newPEs);
    }

    public CcnResponseMessage getReadTableResponse(int blockNo) {
        int busNum = this.getCcnDevice().getBusNo();
        int localAddr = this.getCcnDevice().getElemNo();
        int tableType = this.getTableType();
        int tableInstance = this.getTableInstance();
        CcnTableDef tableDef = new CcnTableDef((byte)localAddr, (byte)busNum, null, (short)tableType, (byte)tableInstance, (byte)blockNo, 0, 0);
        CcnReadTableRequest req = new CcnReadTableRequest(tableDef);
        CcnResponseMessage rsp = this.getCcnDevice().getCcnNetwork().getCcnComm().ccnAsyncRequest().sendAsyncRequest(req);
        return rsp;
    }

    public CcnResponseMessage writeTable(byte[] newData, byte blockNo) {
        int busNum = this.getCcnDevice().getBusNo();
        int localAddr = this.getCcnDevice().getElemNo();
        int tableType = this.getTableType();
        int tableInstance = this.getTableInstance();
        CcnTableDef tableDef = new CcnTableDef((byte)localAddr, (byte)busNum, null, (short)tableType, (byte)tableInstance, blockNo, (byte)newData.length, 0);
        CcnWriteTableRequest req = new CcnWriteTableRequest(tableDef, newData);
        CcnResponseMessage rsp = this.getCcnDevice().getCcnNetwork().getCcnComm().ccnAsyncRequest().sendAsyncRequest(req);
        return rsp;
    }

    public boolean isFullAccessPermittedByLicense() {
        if (this.isTableTypeRestricted()) {
            return this.getIsEnhancedVersion();
        }
        return true;
    }

    protected boolean isTableTypeRestricted() {
        int tableType = this.getTableType();
        return tableType == 16 || tableType == 18 || tableType == 19 || tableType == 21 || tableType == 22;
    }

    public BCcnPointList getPointList() {
        return null;
    }

    public void setPointList(BCcnPointList newList) {
    }

    public void setPointLearnCount(int count) {
    }

    public String getSummaryString() {
        return this.getType() + "`" + this.getCcnDevice().getName() + "`" + this.getName() + "`";
    }

    public void changePointsDisplay(BCcnProxyExt[] pointList) {
        this.ccnTablesLog.trace(this.getSummaryString() + "changePointsDisplay: pointList[" + pointList.length + "]" + this.getCurMetricDisplay());
        for (int i = 0; i < pointList.length; ++i) {
            if (pointList[i] == null) continue;
            pointList[i].setDisplayType(this.getCurMetricDisplay());
            int dataType = pointList[i].getPointDataType();
            if (dataType != 1 && dataType != 2 && dataType != 6 && dataType != 7 && dataType != 9 && dataType != 10 && dataType != 17 && dataType != 48 || pointList[i].isDiscrete()) continue;
            int newUnitEnum = BCcnUnitMappingEnum.parseId(pointList[i].getUnits(), this.getCurMetricDisplay());
            pointList[i].setUnitsEnum(CcnEnumsUtil.setProperUnitsMappingEnum(newUnitEnum));
            if (this.getCurMetricDisplay()) {
                pointList[i].setFieldValue(CcnRspPicPocUtil.toMetric(pointList[i].getDisplayDigits(), pointList[i].getUnits(), pointList[i].getFieldValue()));
            } else {
                pointList[i].setFieldValue(CcnRspPicPocUtil.toImperial(pointList[i].getDisplayDigits(), pointList[i].getUnits(), pointList[i].getFieldValue()));
            }
            String loLimit = pointList[i].getLoLimit();
            String hiLimit = pointList[i].getHiLimit();
            switch (dataType) {
                case 1: {
                    if (loLimit != null && !loLimit.trim().equals("") && !loLimit.equals("0")) {
                        loLimit = this.getCurMetricDisplay() ? CcnRspPicPocUtil.toMetric(pointList[i].getDisplayDigits(), pointList[i].getUnits(), loLimit) : CcnRspPicPocUtil.toImperial(pointList[i].getDisplayDigits(), pointList[i].getUnits(), loLimit);
                    }
                    if (hiLimit == null || hiLimit.trim().equals("") || hiLimit.equals("255")) break;
                    if (this.getCurMetricDisplay()) {
                        hiLimit = CcnRspPicPocUtil.toMetric(pointList[i].getDisplayDigits(), pointList[i].getUnits(), hiLimit);
                        break;
                    }
                    hiLimit = CcnRspPicPocUtil.toImperial(pointList[i].getDisplayDigits(), pointList[i].getUnits(), hiLimit);
                    break;
                }
                case 2: {
                    if (loLimit != null && !loLimit.trim().equals("") && !loLimit.equals("0")) {
                        loLimit = this.getCurMetricDisplay() ? CcnRspPicPocUtil.toMetric(pointList[i].getDisplayDigits(), pointList[i].getUnits(), loLimit) : CcnRspPicPocUtil.toImperial(pointList[i].getDisplayDigits(), pointList[i].getUnits(), loLimit);
                    }
                    if (hiLimit == null || hiLimit.trim().equals("") || hiLimit.equals("65535")) break;
                    if (this.getCurMetricDisplay()) {
                        hiLimit = CcnRspPicPocUtil.toMetric(pointList[i].getDisplayDigits(), pointList[i].getUnits(), hiLimit);
                        break;
                    }
                    hiLimit = CcnRspPicPocUtil.toImperial(pointList[i].getDisplayDigits(), pointList[i].getUnits(), hiLimit);
                    break;
                }
                case 6: 
                case 7: 
                case 48: {
                    if (loLimit != null && !loLimit.trim().equals("") && !loLimit.equals("0")) {
                        loLimit = this.getCurMetricDisplay() ? CcnRspPicPocUtil.toMetric(pointList[i].getDisplayDigits(), pointList[i].getUnits(), loLimit) : CcnRspPicPocUtil.toImperial(pointList[i].getDisplayDigits(), pointList[i].getUnits(), loLimit);
                    }
                    if (hiLimit == null || hiLimit.trim().equals("") || hiLimit.equals("999999.99")) break;
                    if (this.getCurMetricDisplay()) {
                        hiLimit = CcnRspPicPocUtil.toMetric(pointList[i].getDisplayDigits(), pointList[i].getUnits(), hiLimit);
                        break;
                    }
                    hiLimit = CcnRspPicPocUtil.toImperial(pointList[i].getDisplayDigits(), pointList[i].getUnits(), hiLimit);
                    break;
                }
                case 9: {
                    if (loLimit != null && !loLimit.trim().equals("") && !loLimit.equals("-128")) {
                        loLimit = this.getCurMetricDisplay() ? CcnRspPicPocUtil.toMetric(pointList[i].getDisplayDigits(), pointList[i].getUnits(), loLimit) : CcnRspPicPocUtil.toImperial(pointList[i].getDisplayDigits(), pointList[i].getUnits(), loLimit);
                    }
                    if (hiLimit == null || hiLimit.trim().equals("") || hiLimit.equals("127")) break;
                    if (this.getCurMetricDisplay()) {
                        hiLimit = CcnRspPicPocUtil.toMetric(pointList[i].getDisplayDigits(), pointList[i].getUnits(), hiLimit);
                        break;
                    }
                    hiLimit = CcnRspPicPocUtil.toImperial(pointList[i].getDisplayDigits(), pointList[i].getUnits(), hiLimit);
                    break;
                }
                case 10: {
                    if (loLimit != null && !loLimit.trim().equals("") && !loLimit.equals("-32768")) {
                        loLimit = this.getCurMetricDisplay() ? CcnRspPicPocUtil.toMetric(pointList[i].getDisplayDigits(), pointList[i].getUnits(), loLimit) : CcnRspPicPocUtil.toImperial(pointList[i].getDisplayDigits(), pointList[i].getUnits(), loLimit);
                    }
                    if (hiLimit == null || hiLimit.trim().equals("") || hiLimit.equals("32767")) break;
                    if (this.getCurMetricDisplay()) {
                        hiLimit = CcnRspPicPocUtil.toMetric(pointList[i].getDisplayDigits(), pointList[i].getUnits(), hiLimit);
                        break;
                    }
                    hiLimit = CcnRspPicPocUtil.toImperial(pointList[i].getDisplayDigits(), pointList[i].getUnits(), hiLimit);
                    break;
                }
                case 17: {
                    if (loLimit != null && !loLimit.trim().equals("")) {
                        loLimit = this.getCurMetricDisplay() ? CcnRspPicPocUtil.toMetric(pointList[i].getDisplayDigits(), pointList[i].getUnits(), loLimit) : CcnRspPicPocUtil.toImperial(pointList[i].getDisplayDigits(), pointList[i].getUnits(), loLimit);
                    }
                    if (hiLimit == null || hiLimit.trim().equals("")) break;
                    if (this.getCurMetricDisplay()) {
                        hiLimit = CcnRspPicPocUtil.toMetric(pointList[i].getDisplayDigits(), pointList[i].getUnits(), hiLimit);
                        break;
                    }
                    hiLimit = CcnRspPicPocUtil.toImperial(pointList[i].getDisplayDigits(), pointList[i].getUnits(), hiLimit);
                    break;
                }
            }
            pointList[i].setLoLimit(loLimit);
            pointList[i].setHiLimit(hiLimit);
            this.updateFacetInfo(pointList[i], loLimit, hiLimit);
        }
    }

    public BCcnPointEntry[] changePointsDisplayForFID(BCcnPointEntry[] pointList) {
        this.ccnTablesLog.trace(this.getSummaryString() + "changePointsDisplay: pointList[" + pointList.length + "]" + this.getCurMetricDisplay());
        for (int i = 0; i < pointList.length; ++i) {
            if (pointList[i] == null) continue;
            pointList[i].setDisplayType(this.getCurMetricDisplay());
            int dataType = pointList[i].getPointDataType();
            if (!(dataType != 1 && dataType != 2 && dataType != 6 && dataType != 7 && dataType != 9 && dataType != 10 && dataType != 17 && dataType != 48 || pointList[i].isDiscrete())) {
                int newUnitEnum = BCcnUnitMappingEnum.parseId(pointList[i].getUnits(), this.getCurMetricDisplay());
                pointList[i].setUnitsEnum(CcnEnumsUtil.setProperUnitsMappingEnum(newUnitEnum));
                if (this.getCurMetricDisplay()) {
                    pointList[i].setPointValue(CcnRspPicPocUtil.toMetric(pointList[i].getDisplayDigits(), pointList[i].getUnits(), pointList[i].getPointValue()));
                } else {
                    pointList[i].setPointValue(CcnRspPicPocUtil.toImperial(pointList[i].getDisplayDigits(), pointList[i].getUnits(), pointList[i].getPointValue()));
                }
                String loLimit = pointList[i].getLoLimit();
                String hiLimit = pointList[i].getHiLimit();
                switch (dataType) {
                    case 1: {
                        if (loLimit != null && !loLimit.trim().equals("") && !loLimit.equals("0")) {
                            loLimit = this.getCurMetricDisplay() ? CcnRspPicPocUtil.toMetric(pointList[i].getDisplayDigits(), pointList[i].getUnits(), loLimit) : CcnRspPicPocUtil.toImperial(pointList[i].getDisplayDigits(), pointList[i].getUnits(), loLimit);
                        }
                        if (hiLimit == null || hiLimit.trim().equals("") || hiLimit.equals("255")) break;
                        if (this.getCurMetricDisplay()) {
                            hiLimit = CcnRspPicPocUtil.toMetric(pointList[i].getDisplayDigits(), pointList[i].getUnits(), hiLimit);
                            break;
                        }
                        hiLimit = CcnRspPicPocUtil.toImperial(pointList[i].getDisplayDigits(), pointList[i].getUnits(), hiLimit);
                        break;
                    }
                    case 2: {
                        if (loLimit != null && !loLimit.trim().equals("") && !loLimit.equals("0")) {
                            loLimit = this.getCurMetricDisplay() ? CcnRspPicPocUtil.toMetric(pointList[i].getDisplayDigits(), pointList[i].getUnits(), loLimit) : CcnRspPicPocUtil.toImperial(pointList[i].getDisplayDigits(), pointList[i].getUnits(), loLimit);
                        }
                        if (hiLimit == null || hiLimit.trim().equals("") || hiLimit.equals("65535")) break;
                        if (this.getCurMetricDisplay()) {
                            hiLimit = CcnRspPicPocUtil.toMetric(pointList[i].getDisplayDigits(), pointList[i].getUnits(), hiLimit);
                            break;
                        }
                        hiLimit = CcnRspPicPocUtil.toImperial(pointList[i].getDisplayDigits(), pointList[i].getUnits(), hiLimit);
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 48: {
                        if (loLimit != null && !loLimit.trim().equals("") && !loLimit.equals("0")) {
                            loLimit = this.getCurMetricDisplay() ? CcnRspPicPocUtil.toMetric(pointList[i].getDisplayDigits(), pointList[i].getUnits(), loLimit) : CcnRspPicPocUtil.toImperial(pointList[i].getDisplayDigits(), pointList[i].getUnits(), loLimit);
                        }
                        if (hiLimit == null || hiLimit.trim().equals("") || hiLimit.equals("999999.99")) break;
                        if (this.getCurMetricDisplay()) {
                            hiLimit = CcnRspPicPocUtil.toMetric(pointList[i].getDisplayDigits(), pointList[i].getUnits(), hiLimit);
                            break;
                        }
                        hiLimit = CcnRspPicPocUtil.toImperial(pointList[i].getDisplayDigits(), pointList[i].getUnits(), hiLimit);
                        break;
                    }
                    case 9: {
                        if (loLimit != null && !loLimit.trim().equals("") && !loLimit.equals("-128")) {
                            loLimit = this.getCurMetricDisplay() ? CcnRspPicPocUtil.toMetric(pointList[i].getDisplayDigits(), pointList[i].getUnits(), loLimit) : CcnRspPicPocUtil.toImperial(pointList[i].getDisplayDigits(), pointList[i].getUnits(), loLimit);
                        }
                        if (hiLimit == null || hiLimit.trim().equals("") || hiLimit.equals("127")) break;
                        if (this.getCurMetricDisplay()) {
                            hiLimit = CcnRspPicPocUtil.toMetric(pointList[i].getDisplayDigits(), pointList[i].getUnits(), hiLimit);
                            break;
                        }
                        hiLimit = CcnRspPicPocUtil.toImperial(pointList[i].getDisplayDigits(), pointList[i].getUnits(), hiLimit);
                        break;
                    }
                    case 10: {
                        if (loLimit != null && !loLimit.trim().equals("") && !loLimit.equals("-32768")) {
                            loLimit = this.getCurMetricDisplay() ? CcnRspPicPocUtil.toMetric(pointList[i].getDisplayDigits(), pointList[i].getUnits(), loLimit) : CcnRspPicPocUtil.toImperial(pointList[i].getDisplayDigits(), pointList[i].getUnits(), loLimit);
                        }
                        if (hiLimit == null || hiLimit.trim().equals("") || hiLimit.equals("32767")) break;
                        if (this.getCurMetricDisplay()) {
                            hiLimit = CcnRspPicPocUtil.toMetric(pointList[i].getDisplayDigits(), pointList[i].getUnits(), hiLimit);
                            break;
                        }
                        hiLimit = CcnRspPicPocUtil.toImperial(pointList[i].getDisplayDigits(), pointList[i].getUnits(), hiLimit);
                        break;
                    }
                    case 17: {
                        if (loLimit != null && !loLimit.trim().equals("")) {
                            loLimit = this.getCurMetricDisplay() ? CcnRspPicPocUtil.toMetric(pointList[i].getDisplayDigits(), pointList[i].getUnits(), loLimit) : CcnRspPicPocUtil.toImperial(pointList[i].getDisplayDigits(), pointList[i].getUnits(), loLimit);
                        }
                        if (hiLimit == null || hiLimit.trim().equals("")) break;
                        if (this.getCurMetricDisplay()) {
                            hiLimit = CcnRspPicPocUtil.toMetric(pointList[i].getDisplayDigits(), pointList[i].getUnits(), hiLimit);
                            break;
                        }
                        hiLimit = CcnRspPicPocUtil.toImperial(pointList[i].getDisplayDigits(), pointList[i].getUnits(), hiLimit);
                        break;
                    }
                }
                pointList[i].setLoLimit(loLimit);
                pointList[i].setHiLimit(hiLimit);
                this.updateFacetInfo(pointList[i], loLimit, hiLimit);
            }
            System.out.println("update points from change display::" + pointList[i].getPointValue());
        }
        return pointList;
    }

    public void updateFacetInfo(BCcnProxyExt curInput, String loLimit, String hiLimit) {
        if (curInput.getParentPoint() instanceof BNumericWritable) {
            ((BCcnNumericWritable)curInput.getParentPoint()).setFacets(BFacets.makeNumeric(null, (BInteger)BInteger.make((int)2), (BNumber)BDouble.make((String)loLimit), (BNumber)BDouble.make((String)hiLimit)));
        }
    }

    public void updateFacetInfo(BCcnPointEntry pointEntry, String loLimit, String hiLimit) {
        int curFieldIndex;
        BCcnInputProxy curInput = null;
        BCcnProxyExt[] createdPoints = this.getCreatedPoints();
        if (createdPoints[curFieldIndex = pointEntry.getFieldIndex()] != null && createdPoints[curFieldIndex] instanceof BCcnInputProxy) {
            curInput = (BCcnInputProxy)createdPoints[curFieldIndex];
            if (curInput.getParentPoint() instanceof BNumericWritable) {
                ((BCcnNumericWritable)curInput.getParentPoint()).setFacets(BFacets.makeNumeric(null, (BInteger)BInteger.make((int)2), (BNumber)BDouble.make((String)loLimit), (BNumber)BDouble.make((String)hiLimit)));
            }
            curInput.setValue(pointEntry.getPointValue());
            curInput.setUnitsEnum(pointEntry.getUnitsEnum());
        }
    }

    public BIcon getIcon() {
        return this.icon;
    }
}

