/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn.messages;

import com.tridium.ccn.BCcnDevice;
import com.tridium.ccn.BCcnNetwork;
import com.tridium.ccn.components.BCcnByteEntry;
import com.tridium.ccn.components.BCcnByteList;
import com.tridium.ccn.components.BCcnTableEntry;
import com.tridium.ccn.exceptions.CcnException;
import com.tridium.ccn.job.BCcnLearnTablesJob;
import com.tridium.ccn.messages.CcnMessageConst;
import com.tridium.ccn.messages.CcnReadTableRequest;
import com.tridium.ccn.messages.CcnResponseMessage;
import com.tridium.ccn.util.AsynchronousRequest;
import com.tridium.ccn.util.CcnRspPicPocUtil;
import com.tridium.ccn.util.CcnRspPocUtil;
import com.tridium.ccn.util.CcnRspTableUtil;
import com.tridium.platCcn.CcnTableDef;
import java.util.Vector;
import javax.baja.job.BJobState;
import javax.baja.log.Log;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.sys.BValue;
import javax.baja.sys.LocalizableRuntimeException;

public class CcnLearnDeviceRequest
implements AsynchronousRequest,
CcnMessageConst {
    int table_type;
    String table_typeString;
    int table_instance;
    int table_num;
    String table_name;
    int table_blockCnt;
    int table_parentTable;
    byte[] table_blkAR;
    int table_pointCnt;
    private final BCcnNetwork ccnNetwork;
    private final BCcnDevice ccnDevice;
    private BCcnLearnTablesJob job;
    private int maxTableNum;
    private Vector<BCcnTableEntry> discoveredTables;
    private static final Log ccnMessageLog = Log.getLog((String)"CCNMessagesLog");

    public CcnLearnDeviceRequest(BCcnDevice device, BCcnLearnTablesJob learnJob) {
        this.ccnDevice = device;
        this.ccnNetwork = device.getCcnNetwork();
        this.job = learnJob;
    }

    public CcnLearnDeviceRequest(BCcnDevice device) {
        this.ccnDevice = device;
        this.ccnNetwork = device.getCcnNetwork();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void execute() {
        block60: {
            String picType;
            int lastTableType;
            int elemNo;
            int busNo;
            block59: {
                if (!this.ccnDevice.isDeviceStatusOk()) {
                    throw new LocalizableRuntimeException("ccn", "CcnLearnTable.add");
                }
                this.ccnDevice.setLearnStatus("Learn-> Start discovery process...");
                if (this.job != null) {
                    this.job.log().message("Learn-> Start discovery process...");
                }
                if (ccnMessageLog.isTraceOn()) {
                    ccnMessageLog.trace("CcnLearnDeviceRequest: Learn-> Start discovery process...");
                }
                this.discoveredTables = new Vector();
                this.ccnDevice.setTableLearnCount(0);
                try {
                    int firstTableType;
                    busNo = this.ccnDevice.getBusNo();
                    elemNo = this.ccnDevice.getElemNo();
                    this.ccnDevice.setLearnStatus("Learn-> Interrogate device at busNo=" + busNo + ", elemNo=" + elemNo);
                    if (this.job != null) {
                        this.job.log().message("Learn-> Interrogate device at busNo=" + busNo + ", elemNo=" + elemNo);
                    }
                    if (ccnMessageLog.isTraceOn()) {
                        ccnMessageLog.trace("CcnLearnDeviceRequest: Learn-> Interrogate device at busNo=" + busNo + ", elemNo=" + elemNo);
                    }
                    this.maxTableNum = this.ccnDevice.getMaxTableNumber();
                    if (this.maxTableNum == 0) {
                        if (!this.ccnDevice.isDeviceFID()) {
                            CcnResponseMessage readTableResponse = this.getBlockDataFromDeviceTable(busNo, elemNo, 65535, 1, 1);
                            if (readTableResponse != null && readTableResponse.getResponseCommand() == 6) {
                                this.maxTableNum = readTableResponse.getTableNumber();
                            }
                            if (this.maxTableNum == 0 && (readTableResponse = this.getBlockDataFromDeviceTable(busNo, elemNo, 255, 1, 1)) != null && readTableResponse.getResponseCommand() == 6) {
                                this.maxTableNum = readTableResponse.getTableNumber();
                            }
                        }
                        if (this.maxTableNum == 0) {
                            this.maxTableNum = 65535;
                        }
                        this.ccnDevice.setMaxTableNumber(this.maxTableNum);
                        this.ccnDevice.setLearnStatus("Learn-> Before starting learn, find maxTableNum for " + busNo + "," + elemNo + ", maxTableNum set to " + this.maxTableNum);
                        if (this.job != null) {
                            this.job.log().message("Learn-> Before starting learn, find maxTableNum for " + busNo + "," + elemNo + ", maxTableNum set to " + this.maxTableNum);
                        }
                        if (ccnMessageLog.isTraceOn()) {
                            ccnMessageLog.trace("CcnLearnDeviceRequest: Learn-> Before starting learn, find maxTableNum for " + busNo + "," + elemNo + ", maxTableNum set to " + this.maxTableNum);
                        }
                    }
                    if (!this.ccnDevice.isDeviceFID()) {
                        firstTableType = 16;
                        lastTableType = 67;
                        picType = this.ccnDevice.getPicType();
                        break block59;
                    }
                    firstTableType = 1281;
                    lastTableType = 1285;
                    block25: for (int i = firstTableType; i <= lastTableType; ++i) {
                        if (this.job != null) {
                            this.job.progress(100 * i / lastTableType);
                        }
                        boolean learnFlag = false;
                        switch (i) {
                            case 1281: {
                                learnFlag = this.ccnDevice.getLrnStaDspTT500();
                                break;
                            }
                            case 1282: {
                                continue block25;
                            }
                            case 1283: {
                                learnFlag = this.ccnDevice.getLrnTimSchTT503();
                                break;
                            }
                            case 1284: {
                                learnFlag = this.ccnDevice.getLrnSetPtsTT504();
                                break;
                            }
                            case 1285: {
                                learnFlag = this.ccnDevice.getLrnHolSchTT505();
                            }
                        }
                        if (learnFlag) {
                            this.ccnDevice.setLearnStatus("Learn-> Process table type " + Integer.toHexString(i));
                            if (this.job != null) {
                                this.job.log().message("Learn-> Process table type " + Integer.toHexString(i));
                            }
                            if (ccnMessageLog.isTraceOn()) {
                                ccnMessageLog.trace("CcnLearnDeviceRequest: Learn-> Process table type " + Integer.toHexString(i));
                            }
                            this.interrogateDeviceForTableType(busNo, elemNo, i);
                        }
                        if (this.job == null || this.job.isAlive() && this.job.getJobState() != BJobState.canceled) continue;
                        this.ccnDevice.setLearnStatus("Cancelled-> Cancellation requested by user during device learn tabletype:" + Integer.toHexString(i));
                        this.job.log().message("Cancelled-> Cancellation requested by user during device learn tabletype:" + Integer.toHexString(i));
                        if (ccnMessageLog.isTraceOn()) {
                            ccnMessageLog.trace("CcnLearnDeviceRequest: Cancelled-> Cancellation requested by user during device learn tabletype:" + Integer.toHexString(i));
                        }
                        this.ccnDevice.setAbort(false);
                        break block60;
                    }
                    break block60;
                }
                catch (Exception e) {
                    ccnMessageLog.error("Exception occurred during CcnLearnDeviceRequest", (Throwable)e);
                    return;
                }
            }
            for (int i = firstTableType; i <= lastTableType; ++i) {
                if (this.job != null) {
                    this.job.progress(100 * i / lastTableType);
                }
                boolean learnFlag = false;
                switch (i) {
                    case 16: {
                        learnFlag = this.ccnDevice.getLrnUsrCfgPic10();
                        break;
                    }
                    case 17: {
                        learnFlag = this.ccnDevice.getLrnStaDspPic11();
                        break;
                    }
                    case 18: {
                        learnFlag = this.ccnDevice.getLrnMaintPic12();
                        break;
                    }
                    case 19: {
                        if (picType.equalsIgnoreCase("64CC") || picType.equalsIgnoreCase("125PM")) break;
                        learnFlag = this.ccnDevice.getLrnSvcCfgPic13();
                        break;
                    }
                    case 20: {
                        learnFlag = this.ccnDevice.getLrnUsrCfgPoc14() || this.ccnDevice.getLrnTimSchDTT614();
                        break;
                    }
                    case 21: {
                        learnFlag = this.ccnDevice.getLrnMaintPoc15();
                        break;
                    }
                    case 22: {
                        if (picType.equalsIgnoreCase("64CC") || picType.equalsIgnoreCase("125PM")) break;
                        learnFlag = this.ccnDevice.getLrnSvcCfgPoc16();
                        break;
                    }
                    case 23: {
                        learnFlag = this.ccnDevice.getLrnSetPtsPic17();
                        break;
                    }
                    case 24: {
                        learnFlag = this.ccnDevice.getLrnSetPtsPoc18();
                        break;
                    }
                    case 67: {
                        learnFlag = this.ccnDevice.getLrnAlmHstPic43();
                        break;
                    }
                }
                if (learnFlag) {
                    this.ccnDevice.setLearnStatus("Learn-> Process table type " + Integer.toHexString(i));
                    if (this.job != null) {
                        this.job.log().message("Learn-> Process table type " + Integer.toHexString(i));
                    }
                    if (ccnMessageLog.isTraceOn()) {
                        ccnMessageLog.trace("CcnLearnDeviceRequest: Learn-> Process table type " + Integer.toHexString(i));
                    }
                    this.interrogateDeviceForTableType(busNo, elemNo, i);
                }
                if (this.job == null || this.job.isAlive() && this.job.getJobState() != BJobState.canceled) continue;
                this.ccnDevice.setLearnStatus("Cancelled-> Cancellation requested by user during device learn tabletype:" + Integer.toHexString(i));
                this.job.log().message("Cancelled-> Cancellation requested by user during device learn tabletype:" + Integer.toHexString(i));
                if (ccnMessageLog.isTraceOn()) {
                    ccnMessageLog.trace("CcnLearnDeviceRequest: Cancelled-> Cancellation requested by user during device learn tabletype:" + Integer.toHexString(i));
                }
                this.ccnDevice.setAbort(false);
                break;
            }
        }
        if (ccnMessageLog.isTraceOn()) {
            ccnMessageLog.trace("CcnLearnDeviceRequest: Closing out learn, result count = " + this.discoveredTables.size());
        }
        if (!(this.job == null || this.job.isAlive() && this.job.getJobState() != BJobState.canceled)) {
            this.ccnDevice.setLearnStatus("Cancelled-> Cancellation in process while assembling table list");
            this.job.log().message("Cancelled-> Cancellation in process while assembling table list");
            if (ccnMessageLog.isTraceOn()) {
                ccnMessageLog.trace("CcnLearnDeviceRequest: Cancelled-> Cancellation in process while assembling table list");
            }
            this.ccnDevice.setAbort(false);
            return;
        }
        if (this.discoveredTables.size() == 0) {
            this.ccnDevice.setLearnStatus("Learn-> Assembling table list, no tables found");
            if (this.job != null) {
                this.job.log().message("Learn-> Assembling table list, no tables found");
            }
            if (ccnMessageLog.isTraceOn()) {
                ccnMessageLog.trace("CcnLearnDeviceRequest: Learn-> Assembling table list, no tables found");
            }
            this.ccnDevice.setTableLearnCount(0);
            return;
        }
        this.ccnDevice.getLearnedTables().removeAll();
        BCcnTableEntry[] panelList = new BCcnTableEntry[this.discoveredTables.size()];
        this.discoveredTables.copyInto((Object[])panelList);
        int iPanelCount = 0;
        while (iPanelCount < panelList.length) {
            this.addLearnedTable(panelList[iPanelCount]);
            ++iPanelCount;
        }
        return;
        finally {
            this.ccnDevice.setLearnStatus("Learn-> Complete");
            if (this.job != null) {
                this.job.log().message("Learn-> Complete");
            }
            if (ccnMessageLog.isTraceOn()) {
                ccnMessageLog.trace("CcnLearnDeviceRequest: Learn-> Complete");
            }
            this.ccnDevice.setLearnStatus("Idle");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void interrogateDeviceForTableType(int curBusNo, int curElemNo, int curTableType) {
        if (ccnMessageLog.isTraceOn()) {
            ccnMessageLog.trace("CcnLearnDeviceRequest: Interrogate device at bus=" + curBusNo + " element=" + curElemNo + " abort=" + this.ccnNetwork.isAbort() + " for table type=" + Integer.toHexString(curTableType));
        }
        CcnResponseMessage readTableResponse = null;
        int tableInstance = 1;
        if (!this.ccnDevice.isDeviceFID()) {
            boolean done = false;
            boolean found0x14 = false;
            boolean found0x14With0x614 = false;
            while (!done) {
                this.ccnDevice.setLearnStatus("Learn-> Process table type " + Integer.toHexString(curTableType) + " tableInstance " + tableInstance);
                if (this.job != null) {
                    this.job.log().message("Learn-> Process table type " + Integer.toHexString(curTableType) + " tableInstance " + tableInstance);
                }
                if (ccnMessageLog.isTraceOn()) {
                    ccnMessageLog.trace("CcnLearnDeviceRequest: Learn-> Process table type " + Integer.toHexString(curTableType) + " tableInstance " + tableInstance);
                }
                if ((readTableResponse = this.getBlockDataFromDeviceTable(curBusNo, curElemNo, curTableType, tableInstance, 1)) != null && ccnMessageLog.isTraceOn()) {
                    ccnMessageLog.trace("CcnLearnDeviceRequest: readTableResponse: " + (Object)((Object)readTableResponse) + " | " + readTableResponse.getResponseCommand());
                }
                if (readTableResponse == null || readTableResponse.getResponseCommand() != 6) {
                    this.checkFor0x614DataTable(curBusNo, curElemNo, found0x14, found0x14With0x614);
                    done = true;
                    continue;
                }
                if (readTableResponse.getResponseCommand() == 6 && this.maxTableNum != 0 && readTableResponse.getTableNumber() > this.maxTableNum) {
                    if (ccnMessageLog.isTraceOn()) {
                        ccnMessageLog.trace("CcnLearnDeviceRequest: maxTableNum= " + this.maxTableNum + " exceeded: bus | elem | tt | ti: " + curBusNo + " | " + curElemNo + " | " + Integer.toHexString(curTableType) + " | " + tableInstance);
                    }
                    this.checkFor0x614DataTable(curBusNo, curElemNo, found0x14, found0x14With0x614);
                    done = true;
                    continue;
                }
                boolean is0x14TimeSchedule = false;
                if (curTableType == 20) {
                    found0x14 = true;
                    boolean needsToContinue = false;
                    try {
                        CcnResponseMessage readTimeTableResponse = this.getBlockDataFromDeviceTable(curBusNo, curElemNo, 20, tableInstance, 6);
                        if (readTimeTableResponse != null && readTimeTableResponse.getResponseCommand() == 6 && CcnRspPocUtil.getDataTableType(readTimeTableResponse) == 1556) {
                            found0x14With0x614 = true;
                            is0x14TimeSchedule = true;
                        } else if (!this.ccnDevice.getIsEnhancedVersion()) {
                            needsToContinue = true;
                        }
                    }
                    catch (CcnException e) {
                        ccnMessageLog.error("Exception occurred while reading table data in CcnLearnDeviceRequest", (Throwable)((Object)e));
                        needsToContinue = true;
                    }
                    finally {
                        if (!is0x14TimeSchedule && !this.ccnDevice.getLrnUsrCfgPoc14()) {
                            needsToContinue = true;
                        }
                    }
                    if (needsToContinue) {
                        ++tableInstance;
                        continue;
                    }
                }
                BCcnTableEntry newEntry = this.convertBlockDataToTableData(readTableResponse, curTableType, tableInstance);
                if (is0x14TimeSchedule) {
                    newEntry.setTableTypeString("Time_Schedules");
                }
                if (newEntry != null) {
                    this.discoveredTables.addElement(new BCcnTableEntry(newEntry));
                }
                ++tableInstance;
            }
            this.ccnDevice.setTableLearnCount(this.discoveredTables.size());
        } else {
            int tableInstanceEnd = 1;
            int blockNum = 1;
            switch (curTableType) {
                case 1281: {
                    break;
                }
                case 1283: {
                    tableInstanceEnd = 16;
                    blockNum = 2;
                    break;
                }
                case 1284: {
                    tableInstanceEnd = 12;
                    blockNum = 2;
                    break;
                }
                case 1285: {
                    blockNum = 2;
                    break;
                }
                default: {
                    return;
                }
            }
            for (int i = tableInstance; i <= tableInstanceEnd; ++i) {
                this.ccnDevice.setLearnStatus("Learn-> Process FID table type " + Integer.toHexString(curTableType) + " tableInstance " + tableInstance);
                if (this.job != null) {
                    this.job.log().message("Learn-> Process FID table type " + Integer.toHexString(curTableType) + " tableInstance " + tableInstance);
                }
                if (ccnMessageLog.isTraceOn()) {
                    ccnMessageLog.trace("CcnLearnDeviceRequest: Learn-> Process FID table type " + Integer.toHexString(curTableType) + " tableInstance " + tableInstance);
                }
                if ((readTableResponse = this.getBlockDataFromDeviceTable(curBusNo, curElemNo, curTableType, i, blockNum)) != null && ccnMessageLog.isTraceOn()) {
                    ccnMessageLog.trace("CcnLearnDeviceRequest: FID: readTableResponse: " + (Object)((Object)readTableResponse) + " | " + readTableResponse.getResponseCommand());
                }
                if (readTableResponse == null || readTableResponse.getResponseCommand() != 6) {
                    if (!ccnMessageLog.isTraceOn()) break;
                    ccnMessageLog.trace("CcnLearnDeviceRequest: FID: responseCommand: " + readTableResponse.getResponseCommand() + " responseBuffer: " + ByteArrayUtil.toHexString((byte[])readTableResponse.getResponseBuffer().getResponseData()));
                    break;
                }
                BCcnTableEntry newEntry = this.convertBlockDataToTableData(readTableResponse, curTableType, i);
                if (ccnMessageLog.isTraceOn()) {
                    ccnMessageLog.trace("CcnLearnDeviceRequest: FID: newEntry: " + (Object)((Object)newEntry));
                }
                if (newEntry == null) continue;
                this.discoveredTables.addElement(new BCcnTableEntry(newEntry));
            }
            this.ccnDevice.setTableLearnCount(this.discoveredTables.size());
        }
    }

    void addLearnedTable(BCcnTableEntry panel) {
        boolean isTableAlreadyLearned = false;
        BCcnTableEntry[] learnedTables = (BCcnTableEntry[])this.ccnDevice.getLearnedTables().getChildren(BCcnTableEntry.class);
        for (int i = 0; i < learnedTables.length; ++i) {
            if (!learnedTables[i].getTableName().equalsIgnoreCase(panel.getTableName()) || learnedTables[i].getTableNum() != panel.getTableNum() || learnedTables[i].getTableInstance() != panel.getTableInstance() || learnedTables[i].getTableType() != panel.getTableType() || !learnedTables[i].getTableTypeString().equalsIgnoreCase(panel.getTableTypeString())) continue;
            isTableAlreadyLearned = true;
            break;
        }
        if (!isTableAlreadyLearned) {
            this.ccnDevice.getLearnedTables().add(SlotPath.escape((String)(panel.getTableName().trim() + "_" + panel.getTableType() + "_" + panel.getTableNum() + "_" + panel.getTableInstance())), (BValue)panel);
        }
    }

    void addByteArray(String tableName, BCcnByteEntry panel) {
        boolean isByteArrayPresent = false;
        BCcnByteEntry[] learnedTables = (BCcnByteEntry[])this.ccnDevice.getLearnedTables().getChildren(BCcnByteEntry.class);
        for (int i = 0; i < learnedTables.length; ++i) {
            if (learnedTables[i].getIndex() != panel.getIndex()) continue;
            isByteArrayPresent = true;
            break;
        }
        if (!isByteArrayPresent) {
            this.ccnDevice.getLearnedTables().add(tableName + panel.getIndex(), (BValue)panel);
        }
    }

    private void checkFor0x614DataTable(int busNo, int elemNo, boolean found0x14, boolean found0x14With0x614) {
        if (found0x14 && !found0x14With0x614) {
            CcnResponseMessage readTableResponse = this.getBlockDataFromDeviceTable(busNo, elemNo, 1556, 1, 1);
            if (readTableResponse == null) {
                if (ccnMessageLog.isTraceOn()) {
                    ccnMessageLog.trace("CcnLearnDeviceRequest: test for 0x614... dtrsp: " + (Object)((Object)readTableResponse));
                }
            } else if (ccnMessageLog.isTraceOn()) {
                ccnMessageLog.trace("CcnLearnDeviceRequest: test for 0x614... responseCommand: " + readTableResponse.getResponseCommand() + " responseBuffer: " + ByteArrayUtil.toHexString((byte[])readTableResponse.getResponseBuffer().getResponseData()));
            }
            if (readTableResponse != null && readTableResponse.getResponseCommand() == 6) {
                BCcnTableEntry specialEntry = new BCcnTableEntry(20, "Time_Schedules", 1, 0, "SPSCHPOC", 2, 0, null, 25);
                if (ccnMessageLog.isTraceOn()) {
                    ccnMessageLog.trace("CcnLearnDeviceRequest: specialEntry: " + (Object)((Object)specialEntry));
                }
                this.discoveredTables.addElement(new BCcnTableEntry(specialEntry));
            }
        }
    }

    private BCcnTableEntry convertBlockDataToTableData(CcnResponseMessage curBlockResponse, int curTableType, int curTableInstance) {
        if (ccnMessageLog.isTraceOn()) {
            ccnMessageLog.trace("CcnLearnDeviceRequest: convertBlockDataToTableData: tt | ti: " + Integer.toHexString(curTableType) + " | " + curTableInstance);
        }
        if (!this.ccnDevice.isDeviceFID()) {
            BCcnTableEntry curTableEntry = new BCcnTableEntry();
            try {
                int pointCount;
                curTableEntry.setTableType(CcnRspTableUtil.getTableType(curBlockResponse));
                curTableEntry.setTableTypeString(CcnRspPicPocUtil.getTableTypeString(curTableEntry.getTableType()));
                curTableEntry.setTableInstance(curTableInstance);
                int curTableNum = curBlockResponse.getTableNumber();
                curTableEntry.setTableNum(curTableNum);
                String tableName = CcnRspTableUtil.getTableName(curBlockResponse).trim();
                curTableEntry.setTableName(tableName);
                int blockCount = CcnRspTableUtil.getBlockCount(curBlockResponse);
                curTableEntry.setBlockCount(blockCount);
                BCcnByteEntry[] blockAR = new BCcnByteEntry[blockCount];
                BCcnByteList byteList = new BCcnByteList();
                for (int i = 0; i < blockCount; ++i) {
                    blockAR[i] = new BCcnByteEntry();
                    blockAR[i].setIndex(i + 1);
                    blockAR[i].setValue(CcnRspTableUtil.getBlockAccessRights(curBlockResponse, i + 1));
                    if (byteList.get("index" + curTableNum + blockAR[i].getIndex()) != null) continue;
                    byteList.add("index" + curTableNum + blockAR[i].getIndex(), (BValue)blockAR[i]);
                }
                if (this.ccnDevice.getTableAccessRights().get(SlotPath.escape((String)tableName) + curTableNum) == null) {
                    this.ccnDevice.getTableAccessRights().add(SlotPath.escape((String)tableName) + curTableNum, (BValue)byteList);
                }
                if ((pointCount = CcnRspTableUtil.getPointCount(curBlockResponse)) == 0) {
                    return null;
                }
                curTableEntry.setPointCount(pointCount);
            }
            catch (CcnException e) {
                ccnMessageLog.error("Exception occurred while converting data block in CcnLearnDeviceRequest", (Throwable)((Object)e));
            }
            return curTableEntry;
        }
        BCcnTableEntry curTableEntry = new BCcnTableEntry();
        try {
            curTableEntry.setTableType(curTableType);
            curTableEntry.setTableTypeString(CcnRspTableUtil.getTableTypeString(curTableType));
            curTableEntry.setTableInstance(curTableInstance);
            curTableEntry.setTableNum(0);
            switch (curTableType) {
                case 1281: {
                    curTableEntry.setTableName("IO_Points");
                    curTableEntry.setBlockCount(6);
                    byte[] ba501 = new byte[]{1, 1, 2, 3, 3, 1, 4, 1, 5, 1, 6, 3};
                    this.setBlockAccessRightsForFIDTable(ba501, 6, curTableType, curTableEntry.getTableName());
                    curTableEntry.setPointCount(64);
                    break;
                }
                case 1283: {
                    curTableEntry.setTableName("TST" + curTableInstance);
                    curTableEntry.setBlockCount(3);
                    byte[] ba503 = new byte[]{1, 0, 2, 3, 3, 1};
                    this.setBlockAccessRightsForFIDTable(ba503, 3, curTableType, curTableEntry.getTableName());
                    curTableEntry.setPointCount(21);
                    break;
                }
                case 1284: {
                    curTableEntry.setTableName("SP" + curTableInstance);
                    curTableEntry.setBlockCount(2);
                    byte[] ba504 = new byte[]{1, 0, 2, 3};
                    this.setBlockAccessRightsForFIDTable(ba504, 2, curTableType, curTableEntry.getTableName());
                    curTableEntry.setPointCount(4);
                    break;
                }
                case 1285: {
                    curTableEntry.setTableName("HO" + curTableInstance);
                    curTableEntry.setBlockCount(2);
                    byte[] ba505 = new byte[]{1, 0, 2, 3};
                    this.setBlockAccessRightsForFIDTable(ba505, 2, curTableType, curTableEntry.getTableName());
                    curTableEntry.setPointCount(60);
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        catch (Exception e) {
            ccnMessageLog.error("Exception occurred while converting data block in CcnLearnDeviceRequest", (Throwable)e);
        }
        return curTableEntry;
    }

    private void setBlockAccessRightsForFIDTable(byte[] byteArray, int blockCount, int currentTableType, String tableName) {
        BCcnByteEntry[] blockAR = new BCcnByteEntry[blockCount];
        BCcnByteList byteList = new BCcnByteList();
        for (int i = 0; i < blockCount; ++i) {
            blockAR[i] = new BCcnByteEntry();
            blockAR[i].setIndex(i + 1);
            blockAR[i].setValue(byteArray[(i + 1) * 2 - 1]);
            if (byteList.get("index" + currentTableType + blockAR[i].getIndex()) != null) continue;
            byteList.add("index" + currentTableType + blockAR[i].getIndex(), (BValue)blockAR[i]);
        }
        if (this.ccnDevice.getTableAccessRights().get(SlotPath.escape((String)tableName) + currentTableType) == null) {
            this.ccnDevice.getTableAccessRights().add(SlotPath.escape((String)tableName) + currentTableType, (BValue)byteList);
        }
    }

    private CcnResponseMessage getBlockDataFromDeviceTable(int curBusNo, int curElemNo, int curTableType, int curTableInstance, int curBlock) {
        if (ccnMessageLog.isTraceOn()) {
            ccnMessageLog.trace("CcnLearnDeviceRequest: getBlockDataFromDeviceTable: bus | elem | tt | ti | blk: " + curBusNo + " | " + curElemNo + " | " + Integer.toHexString(curTableType) + " | " + curTableInstance + " | " + curBlock);
        }
        CcnReadTableRequest readTableRequest = null;
        CcnResponseMessage readTableResponse = null;
        for (int i = 0; i < 3; ++i) {
            readTableRequest = new CcnReadTableRequest(new CcnTableDef((byte)curElemNo, (byte)curBusNo, null, (short)curTableType, (byte)curTableInstance, (byte)curBlock, 0, 0));
            readTableResponse = this.ccnNetwork.getCcnComm().ccnAsyncRequest().sendAsyncRequest(readTableRequest);
            if (readTableResponse != null) break;
        }
        if (readTableResponse != null && ccnMessageLog.isTraceOn()) {
            ccnMessageLog.trace("CcnLearnDeviceRequest: learnDeviceTablesRequest returns device:" + curBusNo + "," + curElemNo + " for table=" + Integer.toHexString(curTableType) + "," + curTableInstance + " curBlock=" + curBlock + " blockLen=" + readTableResponse.getBlockLen());
        }
        return readTableResponse;
    }
}

