/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.remoteVideo.nd.ui;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.point.BNiagaraPointDeviceExt;
import com.tridium.nd.point.BNiagaraProxyExt;
import com.tridium.nd.point.BPointChannel;
import com.tridium.nd.ui.BNiagaraPointManager;
import com.tridium.nd.ui.NiagaraLearn;
import com.tridium.nv.BSlotInfo;
import com.tridium.remoteVideo.nd.BNiagaraCameraPoint;
import java.util.ArrayList;
import javax.baja.collection.BITable;
import javax.baja.control.BControlPoint;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDeviceExt;
import javax.baja.driver.point.BIPointFolder;
import javax.baja.driver.ui.point.BPointManager;
import javax.baja.driver.ui.point.PointController;
import javax.baja.driver.ui.point.PointModel;
import javax.baja.driver.ui.point.PointState;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.TextUtil;
import javax.baja.space.Mark;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.BFormat;
import javax.baja.util.BNameMap;
import javax.baja.util.BTypeSpec;
import javax.baja.util.BWsAnnotation;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrState;
import javax.baja.workbench.mgr.MgrTypeInfo;

public class BNiagaraCameraMgr
extends BPointManager {
    public static final Type TYPE = Sys.loadType(BNiagaraCameraMgr.class);
    public static final MgrTypeInfo CAMERA_POINT = MgrTypeInfo.make((BComponent)new BNiagaraCameraPoint());
    final Lexicon driverLex = Lexicon.make((String)"driver");
    final String lexOut = this.driverLex.getText("out");
    final String lexSlotPath = UiLexicon.bajaui().getText("slotPath");
    final String lexHandle = UiLexicon.bajaui().getText("handle");
    final String lexType = UiLexicon.bajaui().getText("type");
    final String lexDisplayNames = UiLexicon.bajaui().getText("displayNames");
    final String lexDisplayName = UiLexicon.bajaui().getText("displayName");
    MgrColumn colName = new MgrColumn.Name();
    MgrColumn colPointId = new PointIdColumn(new Property[]{BControlPoint.proxyExt, BNiagaraProxyExt.pointId}, 1);
    MgrColumn colString = new MgrColumn.ToString(this.lexOut, 0);
    MgrColumn colSubStatus = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BNiagaraProxyExt.subscriptionStatus}, 0);
    MgrColumn[] cols = new MgrColumn[]{this.colName, this.colPointId, this.colString, this.colSubStatus};
    MgrColumn dcolPath = new BNiagaraPointManager.DiscoveredPathColumn(this.lexSlotPath, "toPathString");
    MgrColumn dcolHandle = new NiagaraLearn.Column(this.lexHandle, "handle", 2);
    MgrColumn dcolType = new NiagaraLearn.Column(this.lexType, "type");
    MgrColumn[] dcols = new MgrColumn[]{this.dcolPath, this.dcolHandle, this.dcolType};
    BIPointFolder folder;
    BNiagaraStation station;
    BNiagaraPointDeviceExt points;
    BOrd bqlQuery;

    public Type getType() {
        return TYPE;
    }

    protected MgrModel makeModel() {
        return new Model(this);
    }

    protected MgrController makeController() {
        return new Controller(this);
    }

    protected MgrLearn makeLearn() {
        return new Learn(this);
    }

    protected MgrState makeState() {
        return new State();
    }

    void loadNodes(LearnNode[] nodes) {
        for (int i = 0; i < nodes.length; ++i) {
            LearnNode node = nodes[i];
            if (node.mySlotInfo != null) continue;
            String ord = "slot:" + node.get(this.dcolPath).toString();
            BFoxSession session = (BFoxSession)this.station.getSession();
            BSlotInfo[] infos = null;
            BPointChannel channel = (BPointChannel)session.getConnection().getChannels().get("point", BPointChannel.TYPE);
            try {
                infos = channel.discoverSlots(this.station.getStationName(), BOrd.make((String)("station:|" + ord)));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            node.mySlotInfo = infos[0];
            node.childSlotInfos = new BSlotInfo[infos.length - 1];
            System.arraycopy(infos, 1, node.childSlotInfos, 0, node.childSlotInfos.length);
            node.name = node.mySlotInfo.getSlotName();
            node.path = BNiagaraPointManager.toSlotPathString((String)node.mySlotInfo.getSlotOrd().relativizeToSession().toString());
            BNiagaraPointManager.computeFacets((BSlotInfo)node.mySlotInfo, (BSlotInfo[])node.childSlotInfos);
            node.facets = node.mySlotInfo.getFacets();
            node.displayName = node.mySlotInfo.getSlotDisplayName();
        }
    }

    public void doLoadValue(BObject value, Context cx) {
        this.folder = (BIPointFolder)value;
        try {
            this.points = (BNiagaraPointDeviceExt)this.folder.getDeviceExt();
            this.station = (BNiagaraStation)this.points.getDevice();
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.doLoadValue(value, cx);
    }

    static class DisplayNameColumn
    extends MgrColumn {
        DisplayNameColumn(String colName, int flags) {
            super(colName, flags);
        }

        public Object get(Object row) {
            BFormat format;
            BNameMap map;
            if (row instanceof LearnNode) {
                LearnNode node = (LearnNode)((Object)row);
                return node.displayName;
            }
            BComplex c = (BComplex)row;
            BComplex parent = c.getParent();
            if (parent != null && (map = (BNameMap)parent.get("displayNames")) != null && (format = map.get(c.getName())) != null) {
                return format;
            }
            return BFormat.DEFAULT;
        }

        public BValue load(MgrEditRow row) {
            BFormat format;
            BNameMap map;
            LearnNode node = (LearnNode)((Object)row.getDiscovery());
            if (node != null) {
                return node.displayName;
            }
            BComponent c = row.getTarget();
            BComplex parent = c.getParent();
            if (parent != null && (map = (BNameMap)parent.get("displayNames")) != null && (format = map.get(c.getName())) != null) {
                return format;
            }
            return BFormat.DEFAULT;
        }

        public void save(MgrEditRow row, BValue value, Context cx) {
            if (value == null) {
                return;
            }
            LearnNode node = (LearnNode)((Object)row.getDiscovery());
            if (node != null) {
                node.displayName = (BFormat)value;
            } else {
                BComponent c = row.getTarget();
                BComponent parent = (BComponent)c.getParent();
                if (parent != null) {
                    BNameMap map = (BNameMap)parent.get("displayNames");
                    if (map == null) {
                        if (!value.equals((Object)BFormat.DEFAULT)) {
                            map = BNameMap.make((BNameMap)BNameMap.DEFAULT, (String)c.getName(), (BFormat)((BFormat)value));
                            parent.add("displayNames", (BValue)map);
                        }
                    } else {
                        map = !value.equals((Object)BFormat.DEFAULT) ? BNameMap.make((BNameMap)map, (String)c.getName(), (BFormat)((BFormat)value)) : BNameMap.remove((BNameMap)map, (String)c.getName());
                        parent.set("displayNames", (BValue)map);
                    }
                }
            }
        }

        public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor currentEditor) {
            if (rows.length != 1) {
                return null;
            }
            BFormat displayName = (BFormat)rows[0].getCell(colIndex);
            BWbFieldEditor editor = (BWbFieldEditor)currentEditor;
            if (editor == null) {
                editor = BWbFieldEditor.makeFor((BObject)displayName);
            }
            BFacets facets = BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)30));
            editor.loadValue((BObject)displayName, (Context)facets);
            return editor;
        }

        public void fromEditor(MgrEditRow[] rows, int colIndex, BWbEditor widget) throws Exception {
            BWbFieldEditor editor = (BWbFieldEditor)widget;
            BFormat displayName = BFormat.make((String)editor.saveValue().toString());
            for (int i = 0; i < rows.length; ++i) {
                rows[i].setCell(colIndex, (BValue)displayName);
                ((LearnNode)((Object)rows[i].getDiscovery())).displayName = displayName;
            }
        }
    }

    static class DisplayNamesColumn
    extends MgrColumn {
        DisplayNamesColumn(String colName, int flags) {
            super(colName, flags);
        }

        public Object get(Object row) {
            BValue val;
            if (row instanceof BComplex && (val = ((BComplex)row).get("displayNames")) instanceof BNameMap) {
                return val;
            }
            return null;
        }

        public BValue load(MgrEditRow row) {
            BValue result = row.getTarget().get("displayNames");
            if (result != null) {
                result = result.newCopy();
            }
            return result;
        }

        public void save(MgrEditRow row, BValue value, Context cx) {
            BValue old;
            if (value == null) {
                return;
            }
            BComponent target = row.getTarget();
            BNameMap names = (BNameMap)value;
            String[] propNames = names.list();
            if (propNames != null) {
                for (int i = 0; i < propNames.length; ++i) {
                    if (target.get(propNames[i]) != null) continue;
                    names = BNameMap.remove((BNameMap)names, (String)propNames[i]);
                }
            }
            if ((old = target.get("displayNames")) == null) {
                target.add("displayNames", (BValue)names, 261, cx);
            } else if (!old.equivalent((Object)names)) {
                target.set(target.getProperty("displayNames"), (BValue)names, cx);
            }
        }

        public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor currentEditor) {
            if (rows.length != 1) {
                return null;
            }
            BValue val = rows[0].getCell(colIndex);
            if (val == null) {
                return null;
            }
            Context cx = rows[0].getManager().getCurrentContext();
            BWbFieldEditor editor = BWbFieldEditor.makeFor((BObject)val, (Context)cx);
            if (currentEditor != null && currentEditor.getClass() == editor.getClass()) {
                editor = (BWbFieldEditor)currentEditor;
            }
            editor.loadValue((BObject)val, cx);
            return editor;
        }

        public void fromEditor(MgrEditRow[] rows, int colIndex, BWbEditor editor) throws Exception {
            BWbFieldEditor fe = (BWbFieldEditor)editor;
            BValue val = (BValue)fe.saveValue();
            for (int i = 0; i < rows.length; ++i) {
                rows[i].setCell(colIndex, val);
            }
        }
    }

    static class PointIdColumn
    extends MgrColumn.PropPath {
        PointIdColumn(Property[] path, int flags) {
            super(path, flags);
        }

        public String toDisplayString(Object row, Object value, Context cx) {
            return SlotPath.unescape((String)value.toString());
        }
    }

    class Controller
    extends PointController {
        Controller(BNiagaraCameraMgr mgr) {
            super((BPointManager)mgr);
            this.cancel.setFlags(0);
        }

        public CommandArtifact doDiscover(Context cx) throws Exception {
            super.doDiscover(cx);
            Learn learn = (Learn)BNiagaraCameraMgr.this.getLearn();
            learn.bqlDiscover(BNiagaraCameraMgr.this.station, BTypeSpec.make((String)"videoDriver:IVideoCamera"));
            return null;
        }

        protected CommandArtifact doAdd(Object[] discovery, Context cx) throws Exception {
            LearnNode[] nodes = new LearnNode[discovery.length];
            System.arraycopy(discovery, 0, nodes, 0, discovery.length);
            BNiagaraCameraMgr.this.loadNodes(nodes);
            return super.doAdd(discovery, cx);
        }
    }

    class State
    extends PointState {
        BITable<?> lastLearn;

        State() {
        }

        protected void saveForOrd(BAbstractManager m) {
            super.saveForOrd(m);
        }

        protected void restoreForOrd(BAbstractManager m) {
            super.restoreForOrd(m);
            BNiagaraCameraMgr manager = (BNiagaraCameraMgr)m;
            Learn learn = (Learn)manager.getLearn();
            if (this.lastLearn != null) {
                learn.updateTable(this.lastLearn);
            }
        }
    }

    class LearnNode
    extends NiagaraLearn.Node {
        LearnNode parent;
        String name;
        BFormat displayName;
        String path;
        BSlotInfo mySlotInfo;
        BSlotInfo[] childSlotInfos;
        BFacets facets;

        public LearnNode() {
            this.displayName = BFormat.DEFAULT;
        }

        public LearnNode(LearnNode parent, BSlotInfo mySlotInfo, BSlotInfo[] childSlotInfos) {
            BFormat displayString;
            BTypeSpec typeSpec;
            String ord;
            block11: {
                this.displayName = BFormat.DEFAULT;
                this.parent = parent;
                this.mySlotInfo = mySlotInfo;
                this.childSlotInfos = childSlotInfos;
                this.name = mySlotInfo.getSlotName();
                this.path = parent.path + "/" + this.name;
                BNiagaraPointManager.computeFacets((BSlotInfo)this.mySlotInfo, (BSlotInfo[])this.childSlotInfos);
                this.facets = this.mySlotInfo.getFacets();
                ord = "";
                if (mySlotInfo.getIsComponent()) {
                    ord = "" + mySlotInfo.getSlotOrd().relativizeToSession().toString();
                }
                typeSpec = null;
                try {
                    typeSpec = BTypeSpec.make((String)mySlotInfo.getTypeSpec());
                }
                catch (Exception e) {
                    typeSpec = BValue.TYPE.getTypeSpec();
                }
                try {
                    this.icon = BImage.make((BIcon)typeSpec.getInstance().getIcon());
                }
                catch (Exception e) {
                    this.icon = BImage.make((BIcon)BIcon.std((String)"object.png"));
                }
                displayString = this.displayName = mySlotInfo.getSlotDisplayName();
                if (displayString.equals((Object)BFormat.DEFAULT)) {
                    if (mySlotInfo.getIsFrozen()) {
                        try {
                            BTypeSpec parentTypeSpec = null;
                            BObject obj = parent.cells[2];
                            parentTypeSpec = obj instanceof BTypeSpec ? (BTypeSpec)obj : BTypeSpec.make((String)obj.toString());
                            if (parentTypeSpec.equals((Object)BValue.TYPE.getTypeSpec())) {
                                displayString = BString.make((String)TextUtil.toFriendly((String)SlotPath.unescape((String)mySlotInfo.getSlotName())));
                                break block11;
                            }
                            BComplex complex = parentTypeSpec.getInstance().asComplex();
                            Property prop = complex.getProperty(mySlotInfo.getSlotName());
                            displayString = BString.make((String)prop.getDefaultDisplayName(BNiagaraCameraMgr.this.getCurrentContext()));
                        }
                        catch (Exception e) {
                            displayString = BString.make((String)TextUtil.toFriendly((String)SlotPath.unescape((String)mySlotInfo.getSlotName())));
                        }
                    } else {
                        displayString = BString.make((String)SlotPath.unescape((String)mySlotInfo.getSlotName()));
                    }
                }
            }
            this.cells = new BObject[]{displayString, BString.make((String)ord), typeSpec};
        }

        public boolean hasChildren() {
            return false;
        }

        public NiagaraLearn.Node[] getChildren() {
            this.loadNode();
            if (!this.mySlotInfo.getIsComponent()) {
                return new LearnNode[0];
            }
            ArrayList<LearnNode> kids = new ArrayList<LearnNode>(this.childSlotInfos.length);
            for (int i = 0; i < this.childSlotInfos.length; ++i) {
                String typeInfo;
                if ((this.childSlotInfos[i].getSlotFlags() & 4) != 0 || (typeInfo = this.childSlotInfos[i].getTypeSpec()).equals(BLink.TYPE.getTypeSpec().toString()) || typeInfo.equals(BWsAnnotation.TYPE.getTypeSpec().toString())) continue;
                BSlotInfo[] infos = null;
                BFoxSession session = (BFoxSession)BNiagaraCameraMgr.this.station.getSession();
                BPointChannel channel = (BPointChannel)session.getConnection().getChannels().get("point", BPointChannel.TYPE);
                try {
                    infos = channel.discoverSlots(BNiagaraCameraMgr.this.station.getStationName(), BOrd.make((String)("station:|" + this.childSlotInfos[i].getSlotOrd().relativizeToSession().toString())));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                BSlotInfo[] cInfos = new BSlotInfo[infos.length - 1];
                System.arraycopy(infos, 1, cInfos, 0, cInfos.length);
                kids.add(new LearnNode(this, this.childSlotInfos[i], cInfos));
            }
            return kids.toArray(new LearnNode[kids.size()]);
        }

        void loadNode() {
            BNiagaraCameraMgr.this.loadNodes(new LearnNode[]{this});
        }

        public String toPointId() {
            if (this.path == null) {
                this.path = BNiagaraPointManager.toSlotPathString((String)this.cells[0].toString());
            }
            return this.path;
        }
    }

    class Learn
    extends NiagaraLearn {
        Learn(BNiagaraCameraMgr mgr) {
            super((BAbstractManager)mgr);
        }

        protected MgrColumn[] makeColumns() {
            return BNiagaraCameraMgr.this.dcols;
        }

        public boolean isDepthExpandable(int depth) {
            return true;
        }

        public MgrTypeInfo[] toTypes(Object dis) {
            return new MgrTypeInfo[]{CAMERA_POINT};
        }

        public void bqlDiscover(BNiagaraStation station, BTypeSpec filterType) throws Exception {
            String stationName = station.getStationName();
            BFoxSession session = (BFoxSession)station.getSession();
            if (BNiagaraCameraMgr.this.bqlQuery == null) {
                String projection = this.getBqlProjection();
                BNiagaraCameraMgr.this.bqlQuery = BOrd.make((String)("station:|slot:/|bql:select " + projection + " from " + filterType + " where type!='remoteVideo:NiagaraCameraPoint'"));
            }
            BPointChannel channel = (BPointChannel)session.getConnection().getChannels().get("point", BPointChannel.TYPE);
            BITable table = (BITable)channel.discover((BDeviceExt)BNiagaraCameraMgr.this.points, BNiagaraCameraMgr.this.bqlQuery);
            this.updateTable(table);
        }

        public void toRow(Object discovery, MgrEditRow row) throws Exception {
            LearnNode node = (LearnNode)((Object)discovery);
            node.loadNode();
            row.setDefaultName(node.name);
            row.setCell(BNiagaraCameraMgr.this.colPointId, (BValue)BString.make((String)node.toPointId()));
        }

        protected NiagaraLearn.Node makeNode() {
            return new LearnNode();
        }

        public boolean isExisting(Object dis, BComponent comp) {
            LearnNode node = (LearnNode)((Object)dis);
            if (comp instanceof BControlPoint) {
                BControlPoint pt = (BControlPoint)comp;
                BNiagaraProxyExt ext = (BNiagaraProxyExt)pt.getProxyExt();
                return ext.getPointId().equals(node.toPointId());
            }
            return false;
        }
    }

    class Model
    extends PointModel {
        Model(BNiagaraCameraMgr mgr) {
            super((BPointManager)mgr);
        }

        protected MgrColumn[] makeColumns() {
            return BNiagaraCameraMgr.this.cols;
        }

        public MgrTypeInfo[] getNewTypes() {
            return MgrTypeInfo.makeArray((Type)BNiagaraCameraPoint.TYPE);
        }

        public CommandArtifact addInstances(MgrEditRow[] rows, Context cx) throws Exception {
            String[] names = new String[rows.length];
            BComponent[] values = new BComponent[rows.length];
            for (int i = 0; i < rows.length; ++i) {
                names[i] = rows[i].getName();
                values[i] = rows[i].getTarget();
            }
            Mark mark = new Mark((BObject[])values, names);
            BComponent container = rows[0].getEdit().getAddContainer();
            mark.moveTo((BObject)container, null);
            BNameMap map = (BNameMap)container.get("displayNames");
            for (int i = 0; i < rows.length; ++i) {
                Object discoveredPoint = rows[i].getDiscovery();
                BFormat displayName = null;
                if (discoveredPoint != null) {
                    displayName = ((LearnNode)((Object)discoveredPoint)).displayName;
                }
                if (displayName == null || displayName.equals((Object)BFormat.DEFAULT)) continue;
                if (map == null) {
                    map = BNameMap.NULL;
                    container.add("displayNames", (BValue)map);
                }
                map = BNameMap.make((BNameMap)map, (String)names[i], (BFormat)displayName);
            }
            if (map != null) {
                container.set("displayNames", (BValue)map);
            }
            return null;
        }
    }
}

