/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumeurope.httpClient.driver.ui;

import com.tridium.ui.UiEnv;
import com.tridium.workbench.logging.BAutocompleteTextField;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.list.BList;
import javax.baja.ui.list.ListController;
import javax.baja.ui.text.TextController;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType
public abstract class BAutoCompleteFieldEditor
extends BWbFieldEditor {
    public static final Type TYPE = Sys.loadType(BAutoCompleteFieldEditor.class);
    private static final Map<String, TreeSet<String>> registered = new HashMap<String, TreeSet<String>>();
    private static final Logger log = Logger.getLogger(BAutoCompleteFieldEditor.class.getSimpleName());
    private final BList searchResults = new BList();
    private final BAutocompleteTextField textField = new BAutocompleteTextField("", 30);

    public Type getType() {
        return TYPE;
    }

    protected BAutoCompleteFieldEditor() {
        this.textField.setController((TextController)new CompletionController());
        this.setContent((BWidget)this.textField);
        BAutoCompleteFieldEditor.loadCandidates(this.getCandidatesPath());
        this.searchResults.setController((ListController)new ResultController());
        this.searchResults.setMultipleSelection(false);
    }

    protected void doLoadValue(BObject value, Context context) {
        if (value != null) {
            this.textField.setText(value.toString());
        }
    }

    protected BObject doSaveValue(BObject value, Context cx) {
        if (!this.textField.getText().isEmpty()) {
            this.getCandidates().add(this.textField.getText());
        }
        return BString.make((String)this.textField.getText());
    }

    private static void loadCandidates(String candidatesFilePath) {
        TreeSet<String> candidates = BAutoCompleteFieldEditor.getCandidates(candidatesFilePath);
        if (candidates.isEmpty()) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(BAutoCompleteFieldEditor.class.getResourceAsStream(candidatesFilePath), StandardCharsets.UTF_8));){
                String line;
                while ((line = reader.readLine()) != null) {
                    BAutoCompleteFieldEditor.getCandidates(candidatesFilePath).add(line);
                }
            }
            catch (IOException e) {
                log.warning("Failed to load candidates for autocomplete " + e.getMessage());
            }
        }
    }

    protected abstract String getCandidatesPath();

    private TreeSet<String> getCandidates() {
        return BAutoCompleteFieldEditor.getCandidates(this.getCandidatesPath());
    }

    private static TreeSet<String> getCandidates(String candidatesPath) {
        return registered.computeIfAbsent(candidatesPath, x -> new TreeSet(String.CASE_INSENSITIVE_ORDER));
    }

    class ResultController
    extends ListController {
        ResultController() {
        }

        public void keyPressed(BKeyEvent event) {
            int code = event.getKeyCode();
            if (38 == code) {
                if (this.getSelection().getItem() == 0) {
                    BAutoCompleteFieldEditor.this.textField.requestFocus();
                }
                super.keyPressed(event);
            } else if (10 == code || 9 == code) {
                this.autoCompleteTextSelect();
                event.consume();
            } else if (27 == code) {
                BAutoCompleteFieldEditor.this.textField.requestFocus();
                BAutoCompleteFieldEditor.this.textField.moveCaretPosition(BAutoCompleteFieldEditor.this.textField.getModel().getEndPosition());
                event.consume();
            } else {
                super.keyPressed(event);
            }
        }

        protected void itemPressed(BMouseEvent event, int index) {
            super.itemPressed(event, index);
            if (event.getClickCount() == 2) {
                this.autoCompleteTextSelect();
                event.consume();
            }
        }

        private void autoCompleteTextSelect() {
            Object selectedItem;
            if (UiEnv.get().isPopupOpen((BWidget)BAutoCompleteFieldEditor.this.searchResults)) {
                UiEnv.get().closePopup((BWidget)BAutoCompleteFieldEditor.this.searchResults);
            }
            if ((selectedItem = BAutoCompleteFieldEditor.this.searchResults.getSelectedItem()) != null) {
                BAutoCompleteFieldEditor.this.textField.setText(selectedItem.toString());
                BAutoCompleteFieldEditor.this.textField.moveCaretPosition(BAutoCompleteFieldEditor.this.textField.getModel().getEndPosition());
                BAutoCompleteFieldEditor.this.textField.getSelection().deselect();
                BAutoCompleteFieldEditor.this.requestFocus();
                ((CompletionController)BAutoCompleteFieldEditor.this.textField.getController()).updateCandidates();
            }
        }
    }

    class CompletionController
    extends TextController {
        CompletionController() {
        }

        public void focusGained(BFocusEvent event) {
            this.getEditor().setCaretBlinking(true);
        }

        public void focusLost(BFocusEvent event) {
            this.getEditor().setCaretBlinking(false);
        }

        public void keyPressed(BKeyEvent event) {
            BAutoCompleteFieldEditor.this.setModified();
            int code = event.getKeyCode();
            if (40 == code) {
                if (UiEnv.get().isPopupOpen((BWidget)BAutoCompleteFieldEditor.this.searchResults)) {
                    BAutoCompleteFieldEditor.this.searchResults.setSelectedIndex(0);
                    BAutoCompleteFieldEditor.this.searchResults.requestFocus();
                    event.consume();
                }
            } else if (9 == code) {
                this.doTab();
                event.consume();
            } else {
                super.keyPressed(event);
            }
        }

        public void keyTyped(BKeyEvent event) {
            super.keyTyped(event);
            this.updateCandidates();
        }

        void doTab() {
            if (BAutoCompleteFieldEditor.this.searchResults.getItemCount() == 0) {
                return;
            }
            BAutoCompleteFieldEditor.this.textField.setText(BAutoCompleteFieldEditor.this.searchResults.getItem(0).toString());
            BAutoCompleteFieldEditor.this.textField.moveCaretPosition(this.getModel().getEndPosition());
            this.updateCandidates();
        }

        void updateCandidates() {
            boolean isOpen = UiEnv.get().isPopupOpen((BWidget)BAutoCompleteFieldEditor.this.searchResults);
            BAutoCompleteFieldEditor.this.searchResults.removeAllItems();
            String text = BAutoCompleteFieldEditor.this.textField.getText();
            if (!text.isEmpty()) {
                String limit = text.substring(0, text.length() - 1);
                limit = limit + (char)(text.charAt(text.length() - 1) + '\u0001');
                for (String item : BAutoCompleteFieldEditor.this.getCandidates().subSet(text, true, limit, false)) {
                    if (item.equals(text)) continue;
                    BAutoCompleteFieldEditor.this.searchResults.addItem((Object)item);
                }
            }
            if (BAutoCompleteFieldEditor.this.searchResults.getItemCount() == 0) {
                if (isOpen) {
                    UiEnv.get().closePopup((BWidget)BAutoCompleteFieldEditor.this.searchResults);
                }
                BAutoCompleteFieldEditor.this.searchResults.getSelection().deselectAll();
                return;
            }
            BAutoCompleteFieldEditor.this.searchResults.computePreferredSize();
            double x = BAutoCompleteFieldEditor.this.textField.getX();
            double y = BAutoCompleteFieldEditor.this.textField.getY() + BAutoCompleteFieldEditor.this.textField.getHeight();
            if (!isOpen) {
                double fixedHeight = 15.0 * BAutoCompleteFieldEditor.this.textField.getHeight();
                UiEnv.get().openPopup((BWidget)BAutoCompleteFieldEditor.this.searchResults, BAutoCompleteFieldEditor.this.getContent(), x, y, BAutoCompleteFieldEditor.this.textField.getWidth(), fixedHeight);
                BAutoCompleteFieldEditor.this.textField.requestFocus();
            }
        }
    }
}

