/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.hierarchy;

import com.tridium.hierarchy.HierarchyUtil;
import com.tridium.hierarchy.MakeElemUtil;
import com.tridium.hierarchy.QueryUtil;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import javax.baja.hierarchy.BHierarchyService;
import javax.baja.hierarchy.BIEntityLevelDef;
import javax.baja.hierarchy.BLevelDef;
import javax.baja.hierarchy.BLevelElem;
import javax.baja.hierarchy.BLevelSort;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Entity;
import javax.baja.user.BUser;
import javax.baja.util.CloseableIterator;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="query", type="String", defaultValue=""), @NiagaraProperty(name="includeGroupingQueries", type="boolean", defaultValue="true"), @NiagaraProperty(name="sort", type="BLevelSort", defaultValue="BLevelSort.ascending")})
public class BQueryLevelDef
extends BLevelDef
implements BIEntityLevelDef {
    public static final Property query = BQueryLevelDef.newProperty((int)0, (String)"", null);
    public static final Property includeGroupingQueries = BQueryLevelDef.newProperty((int)0, (boolean)true, null);
    public static final Property sort = BQueryLevelDef.newProperty((int)0, (BValue)BLevelSort.ascending, null);
    public static final Type TYPE = Sys.loadType(BQueryLevelDef.class);

    public String getQuery() {
        return this.getString(query);
    }

    public void setQuery(String v) {
        this.setString(query, v, null);
    }

    public boolean getIncludeGroupingQueries() {
        return this.getBoolean(includeGroupingQueries);
    }

    public void setIncludeGroupingQueries(boolean v) {
        this.setBoolean(includeGroupingQueries, v, null);
    }

    public BLevelSort getSort() {
        return (BLevelSort)this.get(sort);
    }

    public void setSort(BLevelSort v) {
        this.set(sort, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public BLevelElem[] getElements(BLevelElem parent, Context cx) {
        try {
            String groupingBase = HierarchyUtil.getGroupingBase(this, this.getIncludeGroupingQueries(), parent);
            String neql = "neql: " + groupingBase + '(' + this.getQuery() + ')';
            BHierarchyService.log.fine(() -> "BQueryLevelDef(" + this.getName() + ").getElements: " + neql);
            BUser user = HierarchyUtil.getUser();
            Context queryContext = HierarchyUtil.createQueryContext(user, cx, parent, new Map.Entry[0]);
            BHierarchyService.log.fine(() -> "  context=" + queryContext.getFacets());
            ArrayList<BLevelElem> levelElems = new ArrayList<BLevelElem>();
            ConcurrentHashMap<String, BIcon> iconCache = new ConcurrentHashMap<String, BIcon>();
            try (CloseableIterator<Entity> queryResults = QueryUtil.resolveQueryOnScopes(this, BOrd.make((String)neql), null, this.getHierarchyService().getHierarchyTimeout(), queryContext);){
                while (queryResults.hasNext()) {
                    levelElems.add(MakeElemUtil.makeEntityElem((Entity)queryResults.next(), this, parent, iconCache, queryContext));
                }
            }
            BLevelElem[] elems = levelElems.toArray(new BLevelElem[levelElems.size()]);
            BQueryLevelDef.sortElems(elems, this.getSort());
            return elems;
        }
        catch (Exception e) {
            BHierarchyService.log.log(Level.SEVERE, e, () -> "Could not resolve elements for " + this.getName());
            return BLevelDef.EMPTY_LEVEL_ELEMS;
        }
    }

    public String toString(Context cx) {
        return "Query Level Def: " + this.getQuery();
    }
}

