/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.hierarchy;

import com.tridium.hierarchy.HierarchyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.data.BIDataValue;
import javax.baja.hierarchy.BHierarchyService;
import javax.baja.hierarchy.BHierarchySpace;
import javax.baja.hierarchy.BLevelDef;
import javax.baja.hierarchy.BLevelSort;
import javax.baja.hierarchy.BListLevelDef;
import javax.baja.hierarchy.BNamedGroupDef;
import javax.baja.naming.BHost;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.naming.UnresolvedException;
import javax.baja.nav.BIIndirectNavNode;
import javax.baja.nav.BINavContainer;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Id;
import javax.baja.tag.Tag;
import javax.baja.tag.Tags;
import javax.baja.user.BUser;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="elemName", type="String", defaultValue=""), @NiagaraProperty(name="elemIcon", type="BIcon", defaultValue="BIcon.DEFAULT"), @NiagaraProperty(name="contextParams", type="BFacets", defaultValue="BFacets.DEFAULT", flags=5), @NiagaraProperty(name="elemTags", type="BFacets", defaultValue="BFacets.DEFAULT", flags=5)})
public class BLevelElem
extends BComponent
implements Comparable<Object>,
BINavContainer,
BIIndirectNavNode {
    public static final Property elemName = BLevelElem.newProperty((int)0, (String)"", null);
    public static final Property elemIcon = BLevelElem.newProperty((int)0, (BValue)BIcon.DEFAULT, null);
    public static final Property contextParams = BLevelElem.newProperty((int)5, (BValue)BFacets.DEFAULT, null);
    public static final Property elemTags = BLevelElem.newProperty((int)5, (BValue)BFacets.DEFAULT, null);
    public static final Type TYPE = Sys.loadType(BLevelElem.class);
    private BHierarchySpace space;
    private BLevelDef levelDef;
    protected BLevelElem parent;
    private BINavNode[] navChildCache;
    private boolean isCachedOnServer;
    private ArrayList<BLevelElem> serverCacheChildren;
    private static final BLevelElem[] EMPTY_LEVEL_ELEM_ARR = new BLevelElem[0];

    public String getElemName() {
        return this.getString(elemName);
    }

    public void setElemName(String v) {
        this.setString(elemName, v, null);
    }

    public BIcon getElemIcon() {
        return (BIcon)this.get(elemIcon);
    }

    public void setElemIcon(BIcon v) {
        this.set(elemIcon, (BValue)v, null);
    }

    public BFacets getContextParams() {
        return (BFacets)this.get(contextParams);
    }

    public void setContextParams(BFacets v) {
        this.set(contextParams, (BValue)v, null);
    }

    public BFacets getElemTags() {
        return (BFacets)this.get(elemTags);
    }

    public void setElemTags(BFacets v) {
        this.set(elemTags, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BLevelElem() {
    }

    public BLevelElem(BLevelDef levelDef, BLevelElem parent, String name, BIcon icon, BFacets contextParams) {
        this(levelDef, parent, name, icon, contextParams, BFacets.DEFAULT);
    }

    public BLevelElem(BLevelDef levelDef, BLevelElem parent, String name, BIcon icon, BFacets contextParams, BFacets elemTags) {
        this.levelDef = levelDef;
        this.parent = parent;
        if (name != null) {
            this.setElemName(name);
        }
        if (icon != null) {
            this.setElemIcon(icon);
        }
        if (contextParams != null) {
            this.setContextParams(contextParams);
        }
        if (elemTags != null) {
            this.setElemTags(elemTags);
        }
    }

    protected BLevelDef getLevelDef() {
        return this.levelDef;
    }

    public void setHierarchySpace(BHierarchySpace space) {
        this.space = space;
    }

    public BHierarchySpace getHierarchySpace() {
        return this.space;
    }

    public BINavNode[] getNavChildren() {
        if (this.navChildCache == null) {
            this.navChildCache = BHierarchyService.getHierarchyElems(this, (BObject)this.space, null);
        }
        return this.navChildCache;
    }

    public String getNavName() {
        return SlotPath.escape((String)this.getElemName());
    }

    public String getNavDisplayName(Context cx) {
        String displayName = this.getElemTags().gets(BLevelDef.DISPLAY_NAME_TAG_NAME, null);
        if (displayName == null) {
            displayName = this.getElemName();
        }
        return displayName;
    }

    public BINavNode getNavChild(String navName) {
        if (this.navChildCache == null) {
            this.getNavChildren();
        }
        if (this.navChildCache != null) {
            for (BINavNode navChild : this.navChildCache) {
                if (!navChild.getNavName().equals(navName)) continue;
                return navChild;
            }
        }
        return null;
    }

    public BINavNode resolveNavChild(String navName) {
        BINavNode child = this.getNavChild(navName);
        if (child != null) {
            return child;
        }
        throw new UnresolvedException(navName);
    }

    public boolean hasNavChildren() {
        return true;
    }

    public String toString(Context cx) {
        try {
            return "levelDef: " + this.levelDef.getName() + ", parent: " + (this.parent == null ? "null" : this.parent.getElemName()) + ", elemName: " + this.getElemName();
        }
        catch (Exception ignored) {
            return super.toString(cx);
        }
    }

    public BIcon getNavIcon() {
        return this.getElemIcon();
    }

    public BHost getHost() {
        return this.space != null ? this.space.getHost() : null;
    }

    public BISession getSession() {
        return this.space != null ? this.space.getSession() : null;
    }

    public BOrd getNavOrd() {
        if (this.space == null) {
            return (BOrd)this.getContextParams().get("hierarchyOrd");
        }
        return BOrd.make((BOrd)this.space.getSession().getNavOrd(), (BOrd)((BOrd)this.getContextParams().get("hierarchyOrd")));
    }

    public BOrd getTargetOrd() {
        BComponent target = this.getTargetComponent();
        return target != null ? target.getNavOrd() : null;
    }

    public String getChildPredicate() {
        return this.getContextParams().gets("childPredicate", "");
    }

    public String getLevelDefPath() {
        return this.getContextParams().gets("levelDefPath", "");
    }

    public BOrd getEntityOrd() {
        return (BOrd)this.getContextParams().get("entityOrd", (BObject)BOrd.NULL);
    }

    public BOrd getHierarchyOrd() {
        return (BOrd)this.getContextParams().get("hierarchyOrd", (BObject)BOrd.NULL);
    }

    public BComponent getTargetComponent() {
        return this.doGetTargetComponent(true);
    }

    BComponent doGetTargetComponent(boolean lease) {
        if (this.getEntityOrd().isNull()) {
            return null;
        }
        String entityOrdStr = this.getEntityOrd().toString();
        BOrd eOrd = BOrd.make((String)(entityOrdStr.startsWith("station:|") ? entityOrdStr : "station:|" + entityOrdStr));
        try {
            return eOrd.resolve().get().asComponent();
        }
        catch (Exception exception) {
            if (this.getHierarchySpace() != null) {
                String absOrdStr = this.getHierarchySpace().getAbsoluteOrd().toString();
                String stationAbsOrdStr = TextUtil.replace((String)absOrdStr, (String)"hierarchy:", (String)"station:");
                BOrd targetOrd = BOrd.make((String)(stationAbsOrdStr + '|' + this.getEntityOrd()));
                try {
                    BComponent target = targetOrd.resolve().get().asComponent();
                    if (lease) {
                        target.lease();
                    }
                    return target;
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    @Override
    public int compareTo(Object other) {
        if (other instanceof BLevelElem) {
            BLevelElem otherElem = (BLevelElem)other;
            int displayNameOrder = this.getNavDisplayName(null).compareTo(otherElem.getNavDisplayName(null));
            if (displayNameOrder == 0) {
                return this.getNavOrd().compareTo((Object)otherElem.getNavOrd());
            }
            return displayNameOrder;
        }
        return this.toString().compareTo(other.toString());
    }

    public AgentList getAgents(Context cx) {
        AgentInfo[] agentInfos;
        AgentList agents = super.getAgents(cx);
        for (AgentInfo agentInfo : agentInfos = agents.list()) {
            String agentId = agentInfo.getAgentId();
            if (!"workbench:WbComponentView".equals(agentId) && !"pxEditor:PxEditor".equals(agentId)) continue;
            agents.remove(agentInfo);
        }
        agents.add("workbench:NavContainerView");
        return agents;
    }

    public String getNavDescription(Context cx) {
        BComponent target = this.doGetTargetComponent(false);
        if (target != null) {
            return target.toString(cx);
        }
        return this.getType().toString();
    }

    public BINavNode getNavParent() {
        if (this.parent != null) {
            return this.parent;
        }
        return this.getHierarchySpace();
    }

    public Tags tags() {
        BComponent target = this.getTargetComponent();
        return target != null ? target.tags() : new LevelElemTags(this.getElemTags());
    }

    protected void spyTags(SpyWriter out) {
        out.trTitle((Object)"Tags", 2);
        Tags tags = this.tags();
        for (Tag tag : tags) {
            out.prop((Object)tag.getId(), (Object)tag.getValue());
        }
    }

    public void addNavChild(BINavNode child) {
    }

    public void removeNavChild(BINavNode child) {
    }

    public void reorderNavChildren(BINavNode[] children) {
    }

    public final Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 1300: {
                return this.isCachedOnServer;
            }
            case 1301: {
                if (a == null) {
                    this.isCachedOnServer = true;
                    return null;
                }
                BLevelElem child = (BLevelElem)a;
                if (this.serverCacheChildren == null) {
                    this.serverCacheChildren = new ArrayList();
                }
                this.serverCacheChildren.add(child);
                child.isCachedOnServer = true;
                BLevelDef childDef = child.levelDef;
                BLevelSort sort = HierarchyUtil.getDefSort(childDef);
                switch (sort.getOrdinal()) {
                    case 1: {
                        this.serverCacheChildren.sort(Comparator.naturalOrder());
                        break;
                    }
                    case 2: {
                        this.serverCacheChildren.sort(Comparator.reverseOrder());
                        break;
                    }
                    default: {
                        if (!(childDef instanceof BListLevelDef)) break;
                        this.noneSortListDef((BListLevelDef)childDef);
                    }
                }
                return null;
            }
            case 1302: {
                if (!this.isCachedOnServer || this.serverCacheChildren == null) {
                    return BLevelDef.EMPTY_LEVEL_ELEMS;
                }
                BUser user = HierarchyUtil.getUser();
                if (user == null || user.getPermissions().isSuperUser()) {
                    return this.serverCacheChildren.toArray(EMPTY_LEVEL_ELEM_ARR);
                }
                return this.serverCacheChildren.stream().filter(elem -> elem.getPermissions((Context)user).hasOperatorRead()).toArray(BLevelElem[]::new);
            }
            case 1303: {
                return this.levelDef;
            }
        }
        return super.fw(x, a, b, c, d);
    }

    private void noneSortListDef(BListLevelDef listDef) {
        if (this.serverCacheChildren.size() <= 1) {
            return;
        }
        ArrayList<BLevelElem> newOrder = new ArrayList<BLevelElem>(this.serverCacheChildren.size());
        block0: for (BNamedGroupDef namedGroupDef : (BNamedGroupDef[])listDef.getChildren(BNamedGroupDef.class)) {
            String namedGroupName = namedGroupDef.getName();
            for (int i = 0; i < this.serverCacheChildren.size(); ++i) {
                BLevelElem child = this.serverCacheChildren.get(i);
                if (!child.getElemName().equals(namedGroupName)) continue;
                newOrder.add(child);
                this.serverCacheChildren.remove(i);
                continue block0;
            }
        }
        if (!this.serverCacheChildren.isEmpty()) {
            throw new IllegalStateException("At least one child in the server cache not found in the named group def of the list def.");
        }
        this.serverCacheChildren = newOrder;
    }

    private static class LevelElemTags
    implements Tags {
        private final BFacets tags;

        public LevelElemTags(BFacets tags) {
            this.tags = tags;
        }

        public boolean isEmpty() {
            return this.tags.size() <= 0;
        }

        public boolean contains(Id id) {
            return this.tags.get(Id.idToFacetKey((Id)id)) != null;
        }

        public boolean isMulti(Id id) {
            return false;
        }

        public boolean set(Tag tag) {
            throw new UnsupportedOperationException("The tag set is readonly.");
        }

        public boolean set(Id id, BIDataValue value) {
            throw new UnsupportedOperationException("The tag set is readonly.");
        }

        public boolean setMulti(Id id, Collection<? extends BIDataValue> values) {
            throw new UnsupportedOperationException("The tag set is readonly.");
        }

        public boolean addMulti(Id id, Collection<? extends BIDataValue> values) {
            throw new UnsupportedOperationException("The tag set is readonly.");
        }

        public boolean addMulti(Tag tag) {
            throw new UnsupportedOperationException("The tag set is readonly.");
        }

        public boolean addMulti(Id id, BIDataValue value) {
            throw new UnsupportedOperationException("The tag set is readonly.");
        }

        public boolean merge(Collection<Tag> tags) {
            throw new UnsupportedOperationException("The tag set is readonly.");
        }

        public boolean remove(Id id, BIDataValue value) {
            throw new UnsupportedOperationException("The tag set is readonly.");
        }

        public boolean removeAll(Id id) {
            throw new UnsupportedOperationException("The tag set is readonly.");
        }

        public boolean remove(Tag tag) {
            throw new UnsupportedOperationException("The tag set is readonly.");
        }

        public Collection<Tag> filter(Predicate<Tag> condition) {
            return this.getAll().stream().filter(condition).collect(Collectors.toCollection(ArrayList::new));
        }

        public Collection<Tag> getAll() {
            HashMap<Id, Tag> map = new HashMap<Id, Tag>();
            if (!this.tags.isEmpty()) {
                for (String key : this.tags.list()) {
                    Id tagId = Id.facetKeyToId((String)key);
                    map.put(tagId, new Tag(tagId, (BIDataValue)this.tags.get(key)));
                }
            }
            return map.values();
        }

        public Optional<BIDataValue> get(Id id) {
            BIDataValue value;
            if (!this.tags.isEmpty() && (value = (BIDataValue)this.tags.get(Id.idToFacetKey((Id)id))) != null) {
                return Optional.of(value);
            }
            return Optional.empty();
        }

        public Collection<BIDataValue> getValues(Id id) {
            throw new UnsupportedOperationException("Not implemented.");
        }
    }
}

