/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.hierarchy;

import java.util.ArrayList;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BHierarchyTags
extends BVector {
    public static final Type TYPE = Sys.loadType(BHierarchyTags.class);
    private static final BIcon ICON = BIcon.std((String)"tag.png");

    public Type getType() {
        return TYPE;
    }

    public void checkAdd(String name, BValue value, int flags, BFacets facets, Context context) {
        if (!(value instanceof BIDataValue)) {
            throw new LocalizableRuntimeException("hierarchy", "hierarchy.tagsMustBeDataValues");
        }
    }

    public BIcon getIcon() {
        return ICON;
    }

    public void addOrSet(String name, BValue value) {
        if (this.get(name) == null) {
            this.add(name, value);
        } else {
            this.set(name, value);
        }
    }

    public void merge(BHierarchyTags toAdd) {
        this.merge(toAdd, true);
    }

    public void merge(BHierarchyTags toAdd, boolean replace) {
        try (SlotCursor c = toAdd.getProperties();){
            while (c.next()) {
                Property p = c.property();
                BValue tagToAdd = toAdd.get(p).newCopy();
                if (this.get(p.getName()) == null) {
                    this.add(p.getName(), tagToAdd);
                    continue;
                }
                if (!replace) continue;
                this.set(p.getName(), tagToAdd);
            }
        }
    }

    public void merge(BFacets toAdd) {
        this.merge(toAdd, true);
    }

    public void merge(BFacets toAdd, boolean replace) {
        String[] keys;
        for (String key : keys = toAdd.list()) {
            if (this.get(key) == null) {
                this.add(key, (BValue)toAdd.get(key));
                continue;
            }
            if (!replace) continue;
            this.set(key, (BValue)toAdd.get(key));
        }
    }

    public BFacets toFacets() {
        ArrayList<String> keys = new ArrayList<String>();
        ArrayList<BIDataValue> values = new ArrayList<BIDataValue>();
        try (SlotCursor c = this.getProperties();){
            while (c.next()) {
                Property p = c.property();
                keys.add(p.getName());
                values.add((BIDataValue)this.get(p));
            }
        }
        return BFacets.make((String[])keys.toArray(new String[keys.size()]), (BIDataValue[])values.toArray(new BIDataValue[values.size()]));
    }
}

