/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.hierarchy;

import com.tridium.nre.util.NreForkJoinWorkerThreadFactory;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.collection.CompoundIterator;
import javax.baja.hierarchy.BHierarchyScope;
import javax.baja.hierarchy.BLevelDef;
import javax.baja.naming.BOrd;
import javax.baja.naming.InvalidOrdBaseException;
import javax.baja.query.BQueryResult;
import javax.baja.registry.TypeInfo;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BFacets;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.tag.Entity;
import javax.baja.util.BNotification;
import javax.baja.util.CloseableIterator;
import javax.baja.util.CloseableIteratorWrapper;
import javax.baja.util.Lexicon;

public final class QueryUtil {
    private static final Logger LOGGER = Logger.getLogger("hierarchy");
    private static final int THREADS_PER_CPU = Integer.parseInt(AccessController.doPrivileged(() -> System.getProperty("niagara.hierarchy.threadsPerCPU", String.valueOf(8))));
    private static final int THREAD_COUNT_OVERRIDE = Integer.parseInt(AccessController.doPrivileged(() -> System.getProperty("niagara.hierarchy.threads", String.valueOf(0))));
    private static final BOrd SYS_ORD = BOrd.make((String)"sys:");
    private static final CloseableIterator<Entity> EMPTY_ITERATOR = new CloseableIteratorWrapper(Collections.emptyIterator());
    private static final Iterator[] EMPTY_ITERATOR_ARRAY = new Iterator[0];
    private static final BFacets LIGHTWEIGHT_RESULTS = BFacets.make((String)"lightweightSystemDbQueryResults", (boolean)true);
    private static ForkJoinPool queryExecutor;

    private QueryUtil() {
    }

    public static void spyExecutor(SpyWriter out) {
        if (queryExecutor != null) {
            out.w((Object)"<p>");
            out.startTable(true);
            out.trTitle((Object)"Thread Pool", 7);
            out.w((Object)"<tr>").th((Object)"Current Pool Size").th((Object)"Max Pool Size").th((Object)"Active").th((Object)"Running").th((Object)"Submitted").th((Object)"Queued").th((Object)"Steals").w((Object)"</tr>").nl();
            out.tr((Object)queryExecutor.getPoolSize(), (Object)queryExecutor.getParallelism(), (Object)queryExecutor.getActiveThreadCount(), (Object)queryExecutor.getRunningThreadCount(), (Object)queryExecutor.getQueuedSubmissionCount(), (Object)queryExecutor.getQueuedTaskCount(), (Object)queryExecutor.getStealCount());
            out.endTable();
        }
    }

    public static void init() {
        int multiplier = THREADS_PER_CPU > 0 ? THREADS_PER_CPU : 8;
        int parallelism = THREAD_COUNT_OVERRIDE > 0 ? THREAD_COUNT_OVERRIDE : Runtime.getRuntime().availableProcessors() * multiplier;
        queryExecutor = new ForkJoinPool(parallelism, NreForkJoinWorkerThreadFactory.DEFAULT_INSTANCE, new UncaughtHierarchyExceptionHandler(), true);
    }

    public static void cleanup() {
        if (queryExecutor != null) {
            try {
                queryExecutor.shutdownNow();
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Unable to shutdown the hierarchy Executor", e);
            }
            queryExecutor = null;
        }
    }

    public static CloseableIterator<Entity> resolveQueryOnScopes(BLevelDef def, BOrd query, BOrd traverseBaseOrd, BRelTime timeout, Context cx) throws ExecutionException, InterruptedException {
        BHierarchyScope[] scopes = def.getHierarchy().getScope().getHierarchyScopes();
        if (scopes == null || scopes.length < 1) {
            return EMPTY_ITERATOR;
        }
        BasicContext lightweightCx = new BasicContext(cx, LIGHTWEIGHT_RESULTS);
        ArrayList results = new ArrayList();
        CompletableFuture[] futures = new CompletableFuture[scopes.length];
        long start = LOGGER.isLoggable(Level.FINE) ? Clock.ticks() : -1L;
        for (int i = 0; i < scopes.length; ++i) {
            BOrd scopeOrd = scopes[i].getScopeOrd();
            if (start > 0L) {
                LOGGER.fine("  scope=" + scopeOrd);
            }
            try {
                BOrd newScopeOrd;
                Executor executor;
                BObject scopeObj = scopeOrd.get();
                Executor executor2 = executor = scopeObj instanceof Executor ? (Executor)scopeObj : queryExecutor;
                if (traverseBaseOrd != null) {
                    newScopeOrd = scopeObj.getType().is(SystemDbTypeHolder.SYSTEM_DB_TYPE) ? BOrd.make((BOrd)traverseBaseOrd, (BOrd)SYS_ORD) : traverseBaseOrd;
                    if (start > 0L) {
                        LOGGER.fine("  replaced scope " + scopeOrd + " with traverse base ord " + newScopeOrd);
                    }
                } else {
                    newScopeOrd = scopeOrd;
                }
                futures[i] = CompletableFuture.runAsync(() -> QueryUtil.lambda$resolveQueryOnScopes$2(newScopeOrd, query, scopeObj, (Context)lightweightCx, def, results, start, scopeOrd), executor);
                continue;
            }
            catch (InvalidOrdBaseException iobe) {
                LOGGER.info(() -> "Could not resolve elements for " + def.getName() + " - " + scopeOrd + " not found");
                throw iobe;
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, e, () -> "Could not resolve elements for " + def.getName() + " / " + scopeOrd);
                throw e;
            }
        }
        CompletableFuture<Void> allDoneFuture = CompletableFuture.allOf(futures);
        try {
            allDoneFuture.get(timeout.getMillis(), TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException te) {
            try {
                Lexicon lex = Lexicon.make((BModule)BLevelDef.TYPE.getModule(), (Context)cx);
                BNotification notify = new BNotification();
                notify.add("title", (BValue)BString.make((String)lex.get("hierarchy.timeout.title")));
                notify.add("message", (BValue)BString.make((String)lex.get("hierarchy.timeout.message")));
                notify.raise(false);
            }
            catch (Exception exception) {}
        }
        catch (InterruptedException | ExecutionException e) {
            LOGGER.log(Level.WARNING, e, () -> "Error during query resolution on multiple hierarchy scopes");
            throw e;
        }
        if (start > 0L) {
            LOGGER.fine("resolve query completed in " + (Clock.ticks() - start) + "ms for query=" + query);
        }
        CompoundIterator result = new CompoundIterator(results.toArray(EMPTY_ITERATOR_ARRAY));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runQuery(BOrd scopeOrd, BOrd query, BObject scopeObj, Context cx, BLevelDef def, List<CloseableIterator<Entity>> results) {
        try {
            BOrd ord = BOrd.make((BOrd)scopeOrd, (BOrd)query);
            BQueryResult queryResult = (BQueryResult)ord.get(scopeObj, cx);
            CloseableIterator result = queryResult.getResults();
            List<CloseableIterator<Entity>> list = results;
            synchronized (list) {
                results.add((CloseableIterator<Entity>)result);
            }
        }
        catch (InvalidOrdBaseException iobe) {
            LOGGER.info(() -> "Could not resolve elements for " + def.getName() + " - " + scopeOrd + " not found");
            throw iobe;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, e, () -> "Could not resolve elements for " + def.getName() + " / " + scopeOrd);
            throw e;
        }
    }

    public static TypeInfo getSystemDbType() {
        return SystemDbTypeHolder.SYSTEM_DB_TYPE;
    }

    private static /* synthetic */ void lambda$resolveQueryOnScopes$2(BOrd newScopeOrd, BOrd query, BObject scopeObj, Context lightweightCx, BLevelDef def, List results, long start, BOrd scopeOrd) {
        QueryUtil.runQuery(newScopeOrd, query, scopeObj, lightweightCx, def, results);
        if (start > 0L) {
            LOGGER.fine("  query completed in " + (Clock.ticks() - start) + "ms for scope=" + scopeOrd);
        }
    }

    private static class UncaughtHierarchyExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private UncaughtHierarchyExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            LOGGER.severe(() -> "Uncaught exception from thread " + t + '\n' + e);
        }
    }

    private static final class SystemDbTypeHolder {
        public static final TypeInfo SYSTEM_DB_TYPE;

        private SystemDbTypeHolder() {
        }

        static {
            TypeInfo typeInfo;
            try {
                typeInfo = Sys.getType((String)"systemDb:SystemDb").getTypeInfo();
            }
            catch (Exception e) {
                typeInfo = null;
            }
            SYSTEM_DB_TYPE = typeInfo;
        }
    }
}

