/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.hierarchy;

import com.tridium.box.BBoxChannel;
import com.tridium.box.BoxOp;
import com.tridium.box.json.AllPermissionsContext;
import com.tridium.box.json.BoxString;
import com.tridium.box.json.BoxWriter;
import com.tridium.box.json.BsonEncoderPlugin;
import com.tridium.hierarchy.HierarchyServlet;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONUtil;
import javax.baja.hierarchy.BHierarchyScheme;
import javax.baja.hierarchy.BHierarchyService;
import javax.baja.hierarchy.BLevelElem;
import javax.baja.hierarchy.HierarchyQuery;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public final class BHierarchyBoxChannel
extends BBoxChannel {
    public static final Type TYPE = Sys.loadType(BHierarchyBoxChannel.class);

    public Type getType() {
        return TYPE;
    }

    public String getChannelName() {
        return "hierarchy";
    }

    public boolean service(String key, Object body, BoxWriter out, BoxOp op) throws Exception {
        switch (key) {
            case "load": {
                BHierarchyBoxChannel.load((JSONObject)body, out, (Context)op);
                return true;
            }
            case "resolve": {
                BHierarchyBoxChannel.resolve((JSONObject)body, out);
                return true;
            }
        }
        return false;
    }

    private static void load(JSONObject data, BoxWriter out, Context cx) throws Exception {
        HierarchyServlet.load(out, data.has("path") ? JSONUtil.getString((JSONObject)data, (String)"path") : "", data.has("contextParams") ? JSONUtil.getString((JSONObject)data, (String)"contextParams") : "", data.has("tags") ? JSONUtil.getString((JSONObject)data, (String)"tags") : "", cx);
    }

    private static void resolve(JSONObject data, BoxWriter out) throws Exception {
        if (!data.has("ord")) {
            throw new Exception("Hierarchy box channel resolve command missing 'ord' to resolve.");
        }
        String ordStr = JSONUtil.getString((JSONObject)data, (String)"ord");
        BOrd ord = BOrd.make((String)ordStr);
        OrdQuery[] queries = ord.parse();
        if (queries.length != 1 || !queries[0].getScheme().equalsIgnoreCase(BHierarchyScheme.INSTANCE.getId())) {
            throw new Exception("Ord to resolve through the hierarchy box channel (" + ord + ") is not a hierarchy ord");
        }
        BHierarchyService service = (BHierarchyService)Sys.getService((Type)BHierarchyService.TYPE);
        BLevelElem elem = service.resolveHierarchyLevelElem(new HierarchyQuery(queries[0].getBody()));
        out.object();
        out.key("o").value((Object)new BoxString(BsonEncoderPlugin.marshal((BValue)elem, (Context)new AllPermissionsContext(null))));
        out.endObject();
    }
}

