/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.seriestransform.schema.ui;

import com.tridium.seriestransform.graph.ui.BConfigEditor;
import com.tridium.seriestransform.graph.ui.BSchemaConfigItem;
import com.tridium.seriestransform.schema.ui.BSchemaFacetsFE;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.TreeSet;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.ModuleInfo;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDropDown;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.list.BList;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.text.BTextEditor;
import javax.baja.util.BTypeSpec;
import javax.baja.workbench.BWbPlugin;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="mboxChanged"), @NiagaraAction(name="tboxChanged"), @NiagaraAction(name="facetsChanged")})
public class BSchemaElement
extends BSchemaConfigItem {
    public static final Action mboxChanged = BSchemaElement.newAction((int)0, null);
    public static final Action tboxChanged = BSchemaElement.newAction((int)0, null);
    public static final Action facetsChanged = BSchemaElement.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BSchemaElement.class);
    private static final String DEF_MODULE = "baja";
    private static final String DEF_TYPE = "String";
    private static final String PROP_FACETS_FE = "facetsFE";
    private final BCheckBox isNull = new BCheckBox("null");
    private final BListDropDown mbox = new BListDropDown();
    private final BListDropDown tbox = new BListDropDown();
    private final BSchemaFacetsFE facetsFE = new BSchemaFacetsFE();
    private final BLabel facetsDisplay;
    private String selModule = "baja";
    private String selType = "String";
    private final TypeInfo baseType = BObject.TYPE.getTypeInfo();
    private boolean allowNull = false;
    private boolean showAbstract = false;
    private BGridPane pane;

    public void mboxChanged() {
        this.invoke(mboxChanged, null, null);
    }

    public void tboxChanged() {
        this.invoke(tboxChanged, null, null);
    }

    public void facetsChanged() {
        this.invoke(facetsChanged, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BSchemaElement() {
        this(DEF_MODULE, DEF_TYPE, null);
    }

    public BSchemaElement(String moduleName, String typeName) {
        this(moduleName, typeName, null);
    }

    public BSchemaElement(String moduleName, String typeName, String elemName) {
        this(moduleName, typeName, elemName, BFacets.NULL);
    }

    public BSchemaElement(String moduleName, String typeName, String elemName, BFacets fieldFacets) {
        this.linkTo("lk1", (BComponent)this.mbox, (Slot)BDropDown.valueModified, (Slot)mboxChanged);
        this.linkTo("lk2", (BComponent)this.tbox, (Slot)BDropDown.valueModified, (Slot)tboxChanged);
        this.linkTo("lk3", (BComponent)this.outputField, (Slot)BTextEditor.textModified, (Slot)modified);
        this.linkTo("lk4", (BComponent)this.facetsFE, (Slot)BWbPlugin.setModified, (Slot)facetsChanged);
        if (null != elemName) {
            this.outputField.setText(SlotPath.unescape((String)elemName));
        }
        if (null != fieldFacets) {
            this.facetsFE.loadValue((BObject)fieldFacets);
        }
        this.facetsDisplay = BConfigEditor.makeNoteLabel(this.facetsFE.getFacetString());
        this.loadType(BTypeSpec.make((String)moduleName, (String)typeName));
    }

    private void loadType(BTypeSpec typeSpec) {
        this.mbox.getList().removeAllItems();
        TreeSet<String> moduleNames = new TreeSet<String>();
        for (ModuleInfo mi : Sys.getRegistry().getModules()) {
            if (mi.getTypes().length <= 0) continue;
            moduleNames.add(mi.getModuleName());
        }
        moduleNames.forEach(arg_0 -> ((BList)this.mbox.getList()).addItem(arg_0));
        this.isNull.setSelected(typeSpec.isNull());
        String m = this.selModule = typeSpec.getModuleName();
        String t = this.selType = typeSpec.getTypeName();
        if (m == null) {
            this.selModule = DEF_MODULE;
            this.selType = DEF_TYPE;
            this.toNull();
        } else {
            this.fromNull();
            this.mbox.getList().setSelectedItem((Object)m);
            this.loadTypes(m);
            this.tbox.getList().setSelectedItem((Object)t);
            if (this.tbox.getList().getItemCount() > 0 && this.tbox.getList().getSelectedIndex() == -1) {
                this.tbox.getList().setSelectedIndex(0);
                this.selType = (String)this.tbox.getList().getSelectedItem();
            }
        }
        if (this.pane != null) {
            if (this.pane.get("isNull") != null) {
                this.pane.remove("isNull");
            }
            this.pane.remove("mbox");
            this.pane.remove("tbox");
            this.pane.remove("element");
        }
        if (this.mbox.getList().getSelectedIndex() == -1) {
            this.mbox.getList().setSelectedIndex(0);
        }
        if (this.tbox.getList().getSelectedIndex() == -1) {
            this.loadTypes((String)this.mbox.getList().getSelectedItem());
            this.tbox.getList().setSelectedIndex(0);
        }
        this.pane = new BGridPane(this.allowNull ? 5 : 4);
        this.pane.setHalign(BHalign.left);
        BGridPane elementGrid = new BGridPane(2);
        elementGrid.add(null, (BValue)this.statusIcon);
        elementGrid.add(null, (BValue)this.outputField);
        this.pane.add("element", (BValue)elementGrid);
        this.pane.add("mbox", (BValue)this.mbox);
        this.pane.add("tbox", (BValue)this.tbox);
        this.pane.add(PROP_FACETS_FE, (BValue)this.facetsFE);
        BGridPane facetsDisplayPane = new BGridPane(2);
        facetsDisplayPane.add(null, (BValue)new BLabel(BConfigEditor.IMG_BLANK));
        facetsDisplayPane.add(null, (BValue)this.facetsDisplay);
        BGridPane content = new BGridPane(1);
        content.add(null, (BValue)this.pane);
        content.add(null, (BValue)facetsDisplayPane);
        this.setCenter((BWidget)content);
        this.repaint();
    }

    private void toNull() {
        BList mlist = this.mbox.getList();
        if (mlist.getItemCount() > 0 && "".equals(mlist.getItem(0))) {
            return;
        }
        BList tlist = this.tbox.getList();
        this.selModule = (String)mlist.getSelectedItem();
        this.selType = (String)tlist.getSelectedItem();
        mlist.insertItem(0, (Object)"");
        mlist.setSelectedIndex(0);
        tlist.insertItem(0, (Object)"");
        tlist.setSelectedIndex(0);
    }

    private void fromNull() {
        BList mlist = this.mbox.getList();
        if (mlist.getItemCount() > 0 && "".equals(mlist.getItem(0))) {
            BList tlist = this.tbox.getList();
            mlist.removeItem(0);
            tlist.removeItem(0);
        }
        mlist.setSelectedItem((Object)this.selModule);
        this.tbox.getList().setSelectedItem((Object)this.selType);
    }

    public void setEnabled(boolean v) {
        this.mbox.setEnabled(v);
        this.tbox.setEnabled(v);
        this.outputField.setEnabled(v);
        this.pane.relayout();
    }

    public BTypeSpec getTypeSpec() {
        if (this.isNull.isSelected()) {
            return BTypeSpec.NULL;
        }
        String module = (String)this.mbox.getSelectedItem();
        String type = (String)this.tbox.getSelectedItem();
        if (module == null || type == null) {
            return BTypeSpec.NULL;
        }
        BTypeSpec newSpec = BTypeSpec.make((String)module, (String)type);
        return newSpec;
    }

    public String getElementName() {
        return SlotPath.escape((String)this.outputField.getText());
    }

    public BFacets getFieldFacets() throws Exception {
        return (BFacets)this.facetsFE.saveValue();
    }

    public void setFieldFacets(BFacets facets) {
        if (null == facets) {
            facets = BFacets.NULL;
        }
        this.facetsFE.loadValue((BObject)facets);
        this.facetsFE.setModified();
    }

    public void doMboxChanged() {
        this.isNull.setSelected(false);
        String moduleName = (String)this.mbox.getSelectedItem();
        this.loadTypes(moduleName);
    }

    public void doTboxChanged() {
        this.isNull.setSelected(false);
    }

    public void doFacetsChanged() {
        String facetString = this.facetsFE.getFacetString();
        this.facetsDisplay.setText(facetString);
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTypes(String moduleName) {
        this.enterBusy();
        try {
            this.tbox.getList().removeAllItems();
            ArrayList<String> v = new ArrayList<String>();
            for (ModuleInfo mi : Sys.getRegistry().getModules(moduleName)) {
                for (TypeInfo type : mi.getTypes()) {
                    if (type.isAbstract() && !this.showAbstract || !type.isInterface() && !type.is(this.baseType)) continue;
                    v.add(type.getTypeName());
                }
            }
            v.sort(Comparator.naturalOrder());
            if (v.isEmpty()) {
                this.tbox.setSelectedIndex(-1);
            } else {
                v.forEach(arg_0 -> ((BList)this.tbox.getList()).addItem(arg_0));
                this.tbox.setSelectedIndex(0);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            this.exitBusy();
        }
    }
}

